import { Token, TokenFactory, TokenValidationError } from './token';
export declare class Bls12381frValidationError extends TokenValidationError {
    value: any;
    token: Bls12381frToken;
    name: string;
    constructor(value: any, token: Bls12381frToken, message: string);
}
export declare class Bls12381frToken extends Token {
    protected val: {
        prim: string;
        args: any[];
        annots: any[];
    };
    protected idx: number;
    protected fac: TokenFactory;
    static prim: string;
    constructor(val: {
        prim: string;
        args: any[];
        annots: any[];
    }, idx: number, fac: TokenFactory);
    private isValid;
    private convertUint8ArrayToHexString;
    Encode(args: any[]): {
        int: string;
        bytes?: undefined;
    } | {
        bytes: any;
        int?: undefined;
    };
    EncodeObject(val: string | Uint8Array | number): {
        int: string;
        bytes?: undefined;
    } | {
        bytes: string | number | Uint8Array;
        int?: undefined;
    };
    Execute(val: any): string;
    ExtractSchema(): string;
}
