"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.NeverToken = exports.NeverTokenError = void 0;
var token_1 = require("./token");
var NeverTokenError = /** @class */ (function (_super) {
    __extends(NeverTokenError, _super);
    function NeverTokenError(value, token, message) {
        var _this = _super.call(this, value, token, message) || this;
        _this.value = value;
        _this.token = token;
        _this.name = 'NeverTokenError';
        return _this;
    }
    return NeverTokenError;
}(token_1.TokenValidationError));
exports.NeverTokenError = NeverTokenError;
var NeverToken = /** @class */ (function (_super) {
    __extends(NeverToken, _super);
    function NeverToken(val, idx, fac) {
        var _this = _super.call(this, val, idx, fac) || this;
        _this.val = val;
        _this.idx = idx;
        _this.fac = fac;
        return _this;
    }
    NeverToken.prototype.Encode = function (args) {
        var val = args.pop();
        throw new NeverTokenError(val, this, 'Assigning a value to the type never is forbidden.');
    };
    NeverToken.prototype.EncodeObject = function (val) {
        throw new NeverTokenError(val, this, 'Assigning a value to the type never is forbidden.');
    };
    NeverToken.prototype.Execute = function (val) {
        throw new NeverTokenError(val, this, 'There is no literal value for the type never.');
    };
    NeverToken.prototype.ExtractSchema = function () {
        return NeverToken.prim;
    };
    NeverToken.prim = 'never';
    return NeverToken;
}(token_1.Token));
exports.NeverToken = NeverToken;
//# sourceMappingURL=never.js.map