"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.Bls12381frToken = exports.Bls12381frValidationError = void 0;
var token_1 = require("./token");
var Bls12381frValidationError = /** @class */ (function (_super) {
    __extends(Bls12381frValidationError, _super);
    function Bls12381frValidationError(value, token, message) {
        var _this = _super.call(this, value, token, message) || this;
        _this.value = value;
        _this.token = token;
        _this.name = 'Bls12381frValidationError';
        return _this;
    }
    return Bls12381frValidationError;
}(token_1.TokenValidationError));
exports.Bls12381frValidationError = Bls12381frValidationError;
var Bls12381frToken = /** @class */ (function (_super) {
    __extends(Bls12381frToken, _super);
    function Bls12381frToken(val, idx, fac) {
        var _this = _super.call(this, val, idx, fac) || this;
        _this.val = val;
        _this.idx = idx;
        _this.fac = fac;
        return _this;
    }
    Bls12381frToken.prototype.isValid = function (val) {
        if (/^[0-9a-fA-F]*$/.test(val) && val.length % 2 === 0) {
            return null;
        }
        else {
            return new Bls12381frValidationError(val, this, "Invalid bytes: " + val);
        }
    };
    Bls12381frToken.prototype.convertUint8ArrayToHexString = function (val) {
        return val.constructor === Uint8Array ? Buffer.from(val).toString('hex') : val;
    };
    Bls12381frToken.prototype.Encode = function (args) {
        var val = args.pop();
        if (typeof val === 'number') {
            return { int: val.toString() };
        }
        else {
            val = this.convertUint8ArrayToHexString(val);
            var err = this.isValid(val);
            if (err) {
                throw err;
            }
            return { bytes: val };
        }
    };
    Bls12381frToken.prototype.EncodeObject = function (val) {
        if (typeof val === 'number') {
            return { int: val.toString() };
        }
        else {
            val = this.convertUint8ArrayToHexString(val);
            var err = this.isValid(val);
            if (err) {
                throw err;
            }
            return { bytes: val };
        }
    };
    Bls12381frToken.prototype.Execute = function (val) {
        return val.bytes;
    };
    Bls12381frToken.prototype.ExtractSchema = function () {
        return Bls12381frToken.prim;
    };
    // An element of the BLS12-381 scalar field Fr
    // see https://tezos.gitlab.io/michelson-reference/#type-bls12_381_fr
    Bls12381frToken.prim = 'bls12_381_fr';
    return Bls12381frToken;
}(token_1.Token));
exports.Bls12381frToken = Bls12381frToken;
//# sourceMappingURL=bls12-381-fr.js.map