"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.dummyContract = exports.Contract = void 0;
var michelson_typecheck_1 = require("./michelson-typecheck");
var micheline_parser_1 = require("./micheline-parser");
var michelson_validator_1 = require("./michelson-validator");
var Contract = /** @class */ (function () {
    function Contract(contract, opt) {
        this.contract = contract;
        this.ctx = __assign({ contract: contract }, opt);
        this.output = michelson_typecheck_1.assertContractValid(contract, this.ctx);
    }
    Contract.parse = function (src, opt) {
        var p = new micheline_parser_1.Parser(opt);
        var expr = typeof src === "string" ? p.parseScript(src) : p.parseJSON(src);
        if (expr === null) {
            throw new Error("empty contract");
        }
        if (michelson_validator_1.assertMichelsonContract(expr)) {
            return new Contract(expr, opt);
        }
        throw undefined;
    };
    Contract.parseTypeExpression = function (src, opt) {
        var p = new micheline_parser_1.Parser(opt);
        var expr = typeof src === "string" ? p.parseScript(src) : p.parseJSON(src);
        if (expr === null) {
            throw new Error("empty type expression");
        }
        if (michelson_validator_1.assertMichelsonType(expr) && michelson_typecheck_1.assertTypeAnnotationsValid(expr)) {
            return expr;
        }
        throw undefined;
    };
    Contract.parseDataExpression = function (src, opt) {
        var p = new micheline_parser_1.Parser(opt);
        var expr = typeof src === "string" ? p.parseScript(src) : p.parseJSON(src);
        if (expr === null) {
            throw new Error("empty data expression");
        }
        if (michelson_validator_1.assertMichelsonData(expr)) {
            return expr;
        }
        throw undefined;
    };
    Contract.prototype.section = function (section) {
        return michelson_typecheck_1.contractSection(this.contract, section);
    };
    Contract.prototype.entryPoints = function () {
        return michelson_typecheck_1.contractEntryPoints(this.contract);
    };
    Contract.prototype.entryPoint = function (ep) {
        return michelson_typecheck_1.contractEntryPoint(this.contract, ep);
    };
    Contract.prototype.assertDataValid = function (d, t) {
        michelson_typecheck_1.assertDataValid(d, t, this.ctx);
    };
    Contract.prototype.isDataValid = function (d, t) {
        return michelson_typecheck_1.isDataValid(d, t, this.ctx);
    };
    Contract.prototype.assertParameterValid = function (ep, d) {
        var t = this.entryPoint(ep || undefined);
        if (t === null) {
            throw new Error("contract has no entrypoint named " + ep);
        }
        this.assertDataValid(d, t);
    };
    Contract.prototype.isParameterValid = function (ep, d) {
        try {
            this.assertParameterValid(ep, d);
            return true;
        }
        catch (_a) {
            return false;
        }
    };
    Contract.prototype.functionType = function (inst, stack) {
        return michelson_typecheck_1.functionType(inst, stack, this.ctx);
    };
    return Contract;
}());
exports.Contract = Contract;
exports.dummyContract = new Contract([
    { prim: "parameter", args: [{ prim: "unit" }] },
    { prim: "storage", args: [{ prim: "unit" }] },
    {
        prim: "code", args: [
            [
                { prim: "CAR" },
                { prim: "NIL", args: [{ prim: "operation" }] },
                { prim: "PAIR" },
            ]
        ]
    },
]);
//# sourceMappingURL=michelson-contract.js.map