"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.formatError = exports.traceDumpFunc = exports.formatStack = void 0;
var micheline_1 = require("./micheline");
var michelson_typecheck_1 = require("./michelson-typecheck");
var micheline_emitter_1 = require("./micheline-emitter");
var utils_1 = require("./utils");
function formatStack(s) {
    if ("failed" in s) {
        return "[FAILED: " + micheline_emitter_1.emitMicheline(s.failed) + "]";
    }
    return s.map(function (v, i) {
        var ann = utils_1.unpackAnnotations(v);
        return "[" + i + (ann.v ? "/" + ann.v[0] : "") + "]: " + micheline_emitter_1.emitMicheline(v);
    }).join("\n");
}
exports.formatStack = formatStack;
function traceDumpFunc(blocks, cb) {
    return function (v) {
        var _a;
        if (Array.isArray(v) && !blocks) {
            return;
        }
        var macro = (_a = v.op[micheline_1.sourceReference]) === null || _a === void 0 ? void 0 : _a.macro;
        var msg = (macro ? "Macro" : "Op") + ": " + (macro ? micheline_emitter_1.emitMicheline(macro, undefined, true) + " / " : "") + micheline_emitter_1.emitMicheline(v.op) + "\nInput:\n" + formatStack(v.in) + "\nOutput:\n" + formatStack(v.out) + "\n";
        cb(msg);
    };
}
exports.traceDumpFunc = traceDumpFunc;
function formatError(err) {
    var _a;
    if (err instanceof michelson_typecheck_1.MichelsonInstructionError) {
        var macro = (_a = err.val[micheline_1.sourceReference]) === null || _a === void 0 ? void 0 : _a.macro;
        return (macro ? "Macro" : "Op") + ": " + (macro ? micheline_emitter_1.emitMicheline(macro, undefined, true) + " / " : "") + micheline_emitter_1.emitMicheline(err.val) + "\nStack:\n" + formatStack(err.stackState) + "\n";
    }
    else if (err instanceof utils_1.MichelsonTypeError) {
        var type = Array.isArray(err.val) ?
            "[" + err.val.map(function (v, i) { return "[" + i + "]: " + micheline_emitter_1.emitMicheline(v); }).join("; ") + "]" :
            micheline_emitter_1.emitMicheline(err.val);
        return "Type: " + type + "\n" + (err.data ? "Data: " + micheline_emitter_1.emitMicheline(err.data) + "\n" : "") + "\n";
    }
    else {
        return "Value: " + micheline_emitter_1.emitMicheline(err.val);
    }
}
exports.formatError = formatError;
//# sourceMappingURL=formatters.js.map