[![DOI](https://zenodo.org/badge/DOI/10.5281/zenodo.1172001.svg)](https://doi.org/10.5281/zenodo.1172001)
# pynams
Interpret [FTIR](https://en.wikipedia.org/wiki/Fourier_transform_infrared_spectroscopy) profiles with emphasis on water in nominally anhydrous minerals (NAMs)

* Create consistent baselines for groups of FTIR spectra
* Determine and plot integrated areas across profiles
* Estimate water concentrations
* Handle peak-specific data
* Model diffusion in 1D and 3D

Install latest version with `pip install pynams`
 
## Several usage examples are provided in Jupyter notebookes in the EXAMPLES folder

Please cite this code as  
Elizabeth Ferriss. (2018) Pynams: a Python package for interpreting FTIR spectra of nominally anhydrous minerals (NAMs), v0.2.0; Zenodo. http://doi.org/10.5281/zenodo.1172001

A note on versions:  
pynams v0.2.0 was used to interpret data on [H diffusion in olivine](https://github.com/EFerriss/olivine)  
pynams v0.1.0 was used to interpret data on [H diffusion in clinopyroxene](https://github.com/EFerriss/HydrogenCpx)

This material is based upon work supported by the National Science Foundation under Grant Number 1449699. Any opinions, findings, and conclusions or recommendations expressed in this material are those of the author(s) and do not necessarily reflect the views of the National Science Foundation.

