# -*- coding: utf-8 -*-

"""
firstlanguage

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""

import json
import dateutil.parser
import jsonpickle

from tests.controllers.controller_test_base import ControllerTestBase
from tests.test_helper import TestHelper
from tests.http_response_catcher import HttpResponseCatcher
from firstlanguage_python.api_helper import APIHelper
from firstlanguage_python.controllers.advanced_api_controller import AdvancedAPIsController


class AdvancedAPIsControllerTests(ControllerTestBase):

    @classmethod
    def setUpClass(cls):
        super(AdvancedAPIsControllerTests, cls).setUpClass()
        cls.response_catcher = HttpResponseCatcher()
        cls.controller = AdvancedAPIsController(cls.config, cls.response_catcher)

    # # Stemmer : Defintion and it's usage
    #
    ## Languages covered:
    def test_get_qa(self):
        # Parameters for the API call
        body = AdvancedAPIs.deserialize_getQA('{"input":{"question":"எவை மூன்றும் எப்போதும் ஒன்றாகவே இருக்கும்?",'
            '"lang":"ta","context":"உப்பு, புளி, மிளகாய் மூன்றும் எப்போதும் ஒன்'
            'றாகவே இருக்கும். ஒருநாள், “குழம்பிற்கு யார் முக்கியம்? நீயா! நானா!'
            '” என்று சண்டை போட்டன. மூன்று பேரும் தனிதனியாகச் சென்று குழம்பில் ச'
            'ேரலாம் என்று முடிவு செய்தன. முதல் நாள், உப்பு மட்டும் குழம்பில் சே'
            'ர்ந்து கொண்டது. “ஆ! ஒரே உப்பு! வாயில் வைக்க முடியவில்லை!” என்று எல'
            '்லோரும் கத்தினார்கள்"}}')

        # Perform the API call through the SDK function
        result = self.controller.get_qa(body)

        # Test response code
        self.assertEquals(self.response_catcher.response.status_code, 200)

        # Test headers
        expected_headers = {}
        expected_headers['content-type'] = 'application/json'

        self.assertTrue(TestHelper.match_headers(expected_headers, self.response_catcher.response.headers))

        
        # Test whether the captured response is as we expected
        self.assertIsNotNone(result)
        expected_body = APIHelper.json_deserialize('{"score":0.028566665947437286,"start":0,"end":20,"answer":"உப்பு, '
            'புளி, மிளகாய்"}')
        received_body = APIHelper.json_deserialize(self.response_catcher.response.text)
        self.assertTrue(TestHelper.match_body(expected_body, received_body))

    # # TableQA : Defintion and it's usage
    #
    #Table QA uses TAPAS based model to get answers from table input. The table can be parsed into a JSON object or it can be a link to a CSV file. Currently only Plain CSV file is supported. 
    #
    #This API works only for English language currently
    #
    #Example for flattend table in JSON Format:<br/>
    #{"Cities": ["Paris, France", "London, England", "Lyon, France"], "Inhabitants": ["2.161", "8.982", "0.513"]}
    #
    #The API can return the original table rows from which the answer was extracted based on the flag 'sendBackRows'
    def test_get_table_qa(self):
        # Parameters for the API call
        body = AdvancedAPIs.deserialize_getTableQA('{"input":{"flattable":{"Cities":["Paris, France","London, England"'
            ',"Lyon, France"],"Inhabitants":["2.161","8.982","0.513"]},"sendBac'
            'kRows":false,"questions":["How many inhabitants in France","How Ma'
            'ny inhabitants in England"]}}')

        # Perform the API call through the SDK function
        result = self.controller.get_table_qa(body)

        # Test response code
        self.assertEquals(self.response_catcher.response.status_code, 200)

        # Test headers
        expected_headers = {}
        expected_headers['content-type'] = 'application/json'

        self.assertTrue(TestHelper.match_headers(expected_headers, self.response_catcher.response.headers))

        
        # Test whether the captured response is as we expected
        self.assertIsNotNone(result)
        expected_body = APIHelper.json_deserialize('[{"query":"How many inhabitants in France","answer":["SUM > 2.674"'
            '],"rows":["Paris, France,2.161","Lyon, France,0.513"]},{"query":"H'
            'ow Many inhabitants in England","answer":["SUM > 8.982"],"rows":["'
            'London, England,8.982"]}]')
        received_body = APIHelper.json_deserialize(self.response_catcher.response.text)
        self.assertTrue(TestHelper.match_body(expected_body, received_body))

    # # Named Entity Recognition : Defintion and it's usage
    #Named Entity Recognitiion  (NER) is extracting the specific Nouns such as, Person Names, Location names, Organization Names, Currency , Dates. It is a classification task. NER can be used as a sub-task in applications such as Search Systems, Chatbots, Question Answering systems, Text Summarization etc. 
    #
    ## Languages covered:
    #
    #| Languages          | ISO Code |
    #|--------------------|----------|
    #| Arabic             | ar       |
    #| Chinese            | zh       |
    #| Dutch              | nl       |
    #| English            | en       |
    #| French             | fr       |
    #| German             | de       |
    #| Italian            | it       |
    #| Latvian            | lv       |
    #| Portuguese         | pt       |
    #| Spanish            | es       |
    #
    #For other languages we cannot guarantee results but you can try with ISO code. 
    #For ISO code reference, please check the link https://www.loc.gov/standards/iso639-2/php/code_list.php
    #
    #
    #
    def test_get_ner(self):
        # Parameters for the API call
        body = AdvancedAPIs.deserialize_getNER('{"input":{"lang":"ar","text":"إسمي محمد وأسكن في برلين"}}')

        # Perform the API call through the SDK function
        result = self.controller.get_ner(body)

        # Test response code
        self.assertEquals(self.response_catcher.response.status_code, 200)

        # Test headers
        expected_headers = {}
        expected_headers['content-type'] = 'application/json'

        self.assertTrue(TestHelper.match_headers(expected_headers, self.response_catcher.response.headers))

        
        # Test whether the captured response is as we expected
        self.assertIsNotNone(result)
        expected_body = APIHelper.json_deserialize('[{"entity_group":"PER","word":"محمد","start":"4","end":"9"},{"enti'
            'ty_group":"LOC","word":"برلين","start":"18","end":"24"}]')
        received_body = APIHelper.json_deserialize(self.response_catcher.response.text)
        self.assertTrue(TestHelper.match_body(expected_body, received_body))

    # # Summarization : Defintion and it's usage
    #Summarization generates a crisp content of the large input text which is highly coherent. 
    #
    #
    #| Languages               | ISO Code |
    #|-------------------------|----------|
    #| Amharic                 | am       |
    #| Arabic                  |  ar      |
    #| Azerbaijani             |  az      |
    #| Bengali                 |  bn      |
    #| Burmese                 |  my      |
    #| Chinese                 |  zh      |
    #| English                 |  en      |
    #| French                  |  fr      |
    #| Gaelic; Scottish Gaelic | gd       |
    #| Gujarati                |  gu      |
    #| Hausa                   |  ha      |
    #| Hindi                   |  hi      |
    #| Igbo                    |  ig      |
    #| Indonesian              |  id      |
    #| Japanese                |  ja      |
    #| Kirghiz; Kyrgyz         | ky       |
    #| Korean                  |  ko      |
    #| Marathi                 |  mr      |
    #| Nepali                  |  ne      |
    #| Oromo                   | om       |
    #| Persian                 | fa       |
    #| Portuguese              |  pt      |
    #| Punjabi                 |  pa      |
    #| Pushto; Pashto          | ps       |
    #| Rundi                   | rn       |
    #| Russian                 | ru       |
    #| Serbian                 |  sr      |
    #| Sinhala; Sinhalese      |  si      |
    #| Somali                  |  so      |
    #| Spanish; Castilian      |  es      |
    #| Swahili                 |  sw      |
    #| Tamil                   |  ta      |
    #| Telugu                  |  te      |
    #| Thai                    |  th      |
    #| Tigrinya                |  ti      |
    #| Turkish                 |  tr      |
    #| Ukrainian               |  uk      |
    #| Urdu                    |  ur      |
    #| Uzbek                   |  uz      |
    #| Vietnamese              |  vi      |
    #| Welsh                   |  cy      |
    #| Yoruba                  |  yo      |
    #
    #
    #
    def test_get_summary(self):
        # Parameters for the API call
        body = AdvancedAPIs.deserialize_getSummary('{"input":{"lang":"en","text":"Videos that say approved vaccines ar'
            'e dangerous and cause autism, cancer or infertility are among thos'
            'e that will be taken down, the company said. The policy includes t'
            'he termination of accounts of anti-vaccine influencers. Tech giant'
            's have been criticised for not doing more to counter false health '
            'information on their sites. In July, US President Joe Biden said s'
            'ocial media platforms were largely responsible for people\'s scept'
            'icism in getting vaccinated by spreading misinformation, and appea'
            'led for them to address the issue. YouTube, which is owned by Goog'
            'le, said 130,000 videos were removed from its platform since last '
            'year, when it implemented a ban on content spreading misinformatio'
            'n about Covid vaccines. In a blog post, the company said it had se'
            'en false claims about Covid jabs spill over into misinformation ab'
            'out vaccines in general. The new policy covers long-approved vacci'
            'nes, such as those against measles or hepatitis B. We\'re expandin'
            'g our medical misinformation policies on YouTube with new guidelin'
            'es on currently administered vaccines that are approved and confir'
            'med to be safe and effective by local health authorities and the W'
            'HO, the post said, referring to the World Health Organization."}}')

        # Perform the API call through the SDK function
        result = self.controller.get_summary(body)

        # Test response code
        self.assertEquals(self.response_catcher.response.status_code, 200)

        # Test headers
        expected_headers = {}
        expected_headers['content-type'] = 'application/json'

        self.assertTrue(TestHelper.match_headers(expected_headers, self.response_catcher.response.headers))

        
        # Test whether the captured response is as we expected
        self.assertIsNotNone(result)
        expected_body = APIHelper.json_deserialize('{"summary":"YouTube has announced a ban on videos spreading misinf'
            'ormation about Covid vaccines."}')
        received_body = APIHelper.json_deserialize(self.response_catcher.response.text)
        self.assertTrue(TestHelper.match_body(expected_body, received_body))

    # # Translation : Defintion and it's usage
    #Machine Translation is translating the text automatically from  one language to another langauge.
    #
    ## Languages covered:
    #
    #| Languages                             | ISO Code   |
    #|---------------------------------------|------------|
    #|  Abkhazian                            |   ab       |
    #|  Afrikaans                            |   af       |
    #|  Amharic                              |   am       |
    #|  Bashkir                              |   ba       |
    #|  Catalan; Valencian                   |   ca       |
    #|  Chechen                              |   ce       |
    #|  Corsican                             |   co       |
    #|  Chuvash                              |   cv       |
    #|  Ewe                                  |   ee       |
    #|  English                              |   en       |
    #|  Basque                               |   eu       |
    #|  Fijian                               |   fj       |
    #|  French                               |   fr       |
    #|  Galician                             |   gl       |
    #|  Gujarati                             |   gu       |
    #|  Manx                                 |   gv       |
    #|  Hebrew                               |   he       |
    #|  Haitian; Haitian Creole              |   ht       |
    #|  Armenian                             |   hy       |
    #|  Indonesian                           |   id       |
    #|  Igbo                                 |   ig       |
    #|  Icelandic                            |   is       |
    #|  Japanese                             |   ja       |
    #|  Kalaallisut; Greenlandic             |   kl       |
    #|  Ganda                                |   lg       |
    #|  Lingala                              |   ln       |
    #|  Malagasy                             |   mg       |
    #|  Marshallese                          |   mh       |
    #|  Macedonian                           |   mk       |
    #|  Mongolian                            |   mn       |
    #|  Nauru                                |   na       |
    #|  Bokmål, Norwegian; Norwegian Bokmål  |   nb       |
    #|  Chichewa; Chewa; Nyanja              |   ny       |
    #|  Ossetian; Ossetic                    |   os       |
    #|  Pushto; Pashto                       |   ps       |
    #|  Romansh                              |   rm       |
    #|  Rundi                                |   rn       |
    #|  Sango                                |   sg       |
    #|  Samoan                               |   sm       |
    #|  Shona                                |   sn       |
    #|  Somali                               |   so       |
    #|  Albanian                             |   sq       |
    #|  Tamil                                |   ta       |
    #|  Tigrinya                             |   ti       |
    #|  Turkmen                              |   tk       |
    #|  Tonga                                |   to       |
    #|  Turkish                              |   tr       |
    #|  Tsonga                               |   ts       |
    #|  Tatar                                |   tt       |
    #|  Tahitian                             |   ty       |
    #|  Ukrainian                            |   uk       |
    #|  Vietnamese                           |   vi       |
    #|  Walloon                              |   wa       |
    #|  Xhosa                                |   xh       |
    #|  Yoruba                               |   yo       |
    #|  Zulu                                 |   zu       |
    #
    #
    #
    def test_get_translate(self):
        # Parameters for the API call
        body = AdvancedAPIs.deserialize_getTranslate('{"input":{"lang":"ta","text":"Today is a good day"}}')

        # Perform the API call through the SDK function
        result = self.controller.get_translate(body)

        # Test response code
        self.assertEquals(self.response_catcher.response.status_code, 200)

        # Test headers
        expected_headers = {}
        expected_headers['content-type'] = 'application/json'

        self.assertTrue(TestHelper.match_headers(expected_headers, self.response_catcher.response.headers))

        
        # Test whether the captured response is as we expected
        self.assertIsNotNone(result)
        expected_body = APIHelper.json_deserialize('{"generated_text":"இன்று நல்ல நாள்."}')
        received_body = APIHelper.json_deserialize(self.response_catcher.response.text)
        self.assertTrue(TestHelper.match_body(expected_body, received_body))

