# -*- coding: utf-8 -*-

import slicerio
import unittest


class TestSegmentationRoundtrip(unittest.TestCase):
    """
    Test segmentation writing/reading roundtrip.
    """

    def setUp(self):
        pass

    def tearDown(self):
        pass

    def test_segmentation_read(self):
        """Test segmentation reading"""

        input_segmentation_filepath = slicerio.get_testdata_file('Segmentation.seg.nrrd')

        segmentation_info = slicerio.read_segmentation_info(input_segmentation_filepath)

        number_of_segments = len(segmentation_info["segments"])
        self.assertEqual(number_of_segments, 7)

        segment_names = slicerio.segment_names(segmentation_info)
        self.assertEqual(segment_names[0], 'ribs')
        self.assertEqual(segment_names[1], 'cervical vertebral column')
        self.assertEqual(segment_names[2], 'thoracic vertebral column')
        self.assertEqual(segment_names[3], 'lumbar vertebral column')
        self.assertEqual(segment_names[4], 'right lung')
        self.assertEqual(segment_names[5], 'left lung')
        self.assertEqual(segment_names[6], 'tissue')

        segment = slicerio.segment_from_name(segmentation_info, segment_names[4])
        self.assertEqual(segment['id'], 'Segment_5')
        self.assertEqual(segment['name'], 'right lung')
        self.assertEqual(segment['nameAutoGenerated'], True)
        self.assertEqual(segment['color'], [0.0862745, 0.772549, 0.278431])
        self.assertEqual(segment['colorAutoGenerated'], False)
        self.assertEqual(segment['labelValue'], 5)
        self.assertEqual(segment['layer'], 0)
        self.assertEqual(segment['extent'], [0, 124, 0, 127, 0, 33])
        self.assertEqual(segment['status'], 'inprogress')

        terminology = segment["terminology"]
        self.assertEqual(terminology['contextName'], 'Segmentation category and type - 3D Slicer General Anatomy list')
        self.assertEqual(terminology['category'], ['SCT', '123037004', 'Anatomical Structure'])
        self.assertEqual(terminology['type'], ['SCT', '39607008', 'Lung'])
        self.assertEqual(terminology['typeModifier'], ['SCT', '24028007', 'Right'])
        self.assertEqual('anatomicContextName' in terminology, False)
        self.assertEqual('anatomicRegion' in terminology, False)
        self.assertEqual('anatomicRegionModifier' in terminology, False)


if __name__ == '__main__':
    unittest.main()
