# API Reference <a name="API Reference"></a>

## Constructs <a name="Constructs"></a>

### CompliantDynamoDb <a name="compliantdynamodb.CompliantDynamoDb"></a>

#### Initializers <a name="compliantdynamodb.CompliantDynamoDb.Initializer"></a>

```typescript
import { CompliantDynamoDb } from 'compliantdynamodb'

new CompliantDynamoDb(scope: Construct, id: string, props?: CompliantDynamoDbProps)
```

##### `scope`<sup>Required</sup> <a name="compliantdynamodb.CompliantDynamoDb.parameter.scope"></a>

- *Type:* [`@aws-cdk/core.Construct`](#@aws-cdk/core.Construct)

---

##### `id`<sup>Required</sup> <a name="compliantdynamodb.CompliantDynamoDb.parameter.id"></a>

- *Type:* `string`

---

##### `props`<sup>Optional</sup> <a name="compliantdynamodb.CompliantDynamoDb.parameter.props"></a>

- *Type:* [`compliantdynamodb.CompliantDynamoDbProps`](#compliantdynamodb.CompliantDynamoDbProps)

---





## Structs <a name="Structs"></a>

### CompliantDynamoDbProps <a name="compliantdynamodb.CompliantDynamoDbProps"></a>

#### Initializer <a name="[object Object].Initializer"></a>

```typescript
import { CompliantDynamoDbProps } from 'compliantdynamodb'

const compliantDynamoDbProps: CompliantDynamoDbProps = { ... }
```

##### `backupVaultName`<sup>Optional</sup> <a name="compliantdynamodb.CompliantDynamoDbProps.property.backupVaultName"></a>

```typescript
public readonly backupVaultName: string;
```

- *Type:* `string`

---

##### `partitionKey`<sup>Optional</sup> <a name="compliantdynamodb.CompliantDynamoDbProps.property.partitionKey"></a>

```typescript
public readonly partitionKey: Attribute;
```

- *Type:* [`@aws-cdk/aws-dynamodb.Attribute`](#@aws-cdk/aws-dynamodb.Attribute)

---

##### `tableName`<sup>Optional</sup> <a name="compliantdynamodb.CompliantDynamoDbProps.property.tableName"></a>

```typescript
public readonly tableName: string;
```

- *Type:* `string`

---



