# Automated BCDC API Testing 

Intention is to test the CKAN API after deployment.

Current tests include:
 - verification of preconfigured orgs required for testing
 - CRUD tests for packages.
 
# OC Build for BCDC-TEST

pulls package from https://pypi.org/project/bcdc-apitests/
new OC build triggered by github actions on commit to master branch

how to create new build from build config
  
```
oc create -f https://raw.githubusercontent.com/bcgov/bcdc-test/master/k8s/bcdc-test-buildconfig.yaml
```

start build 

```
oc start-build bcdc-test -n databcdc
```

# OC Jobs for BCDC-TEST

each environment will have its own defined .yaml file within the k8s dir. 

* test-dwelf-job-template.yaml
* test-toyger-job-template.yaml

how to run job from yaml as template, so we can change the name using a generated value appended to name
* CADI
```
oc process -f https://raw.githubusercontent.com/bcgov/bcdc-test/master/k8s/test-dwelf-job-template.yaml | oc create -f -
```
* CATI
```
oc process -f https://raw.githubusercontent.com/bcgov/bcdc-test/master/k8s/test-toyger-job-template.yaml | oc create -f -
```


# OC Development Build for BCDC-TEST-DEV

pulls from https://pypi.org/project/bcdc-apitests-dev/
new OC build triggered by github actions on push to dev branch

```
oc create -f https://raw.githubusercontent.com/bcgov/bcdc-test/master/k8s/bcdc-test-buildconfig-dev.yaml
```

# OC Developmnet Jobs for BCDC-TEST-DEV
* CADI
```
oc process -f https://raw.githubusercontent.com/bcgov/bcdc-test/master/k8s/test-dwelf-job-template-dev.yaml | oc create -f -
```
* CATI
```
oc process -f https://raw.githubusercontent.com/bcgov/bcdc-test/master/k8s/test-toyger-job-template-dev.yaml | oc create -f -
```

# OC Job Cleanup 
* to be performed on a regular basis to cleanup old pods created by jobs

to view all jobs
```
oc get job
```
to delete all jobs by label
```
oc delete job -l name=bcdc-api-test
```
# Run Tests locally

```
pip install pypandoc 
pip install bcdc_apitests
export BCDC_API_KEY=<api-key>
export BCDC_URL=<url-to-ckan>
pytest --pyargs bcdc_apitests
```
  
# Packaging

### disable teardown
`--df` Include this switch if you want to disable teardown that deletes the test 
data that gets generated by the test suite.  The various options basically tell the 
test suite not to delete a particular type of data that are generated by the tests.

Options include:
* *orgs*
* *groups*
* *packages*
* *resources*
* *users*
* *other*
* *ALL*

# Packaging

Packaging is currently configured to be built automatically by github actions when 
a pull request on master has been successfully merged.  

## packaging version numbers

When a new package is built it will automatically check what the last version 
is in PYPI for the package and increment that number.  

Example if the version in pypi is 7.3.45, the next time the github action triggers
it will be 7.3.46.  If you want the change either the major or the minor number
set the number in packages __init__.py file, for example to increment the major
version number to 8.

```
...
version=8.0.0
...
```


