Alternatives
------------
The thing with backtesting is, unless you dug into the dirty details yourself,
you can't rely on execution correctness, and you risk losing your house.
In addition, everyone has their own preconveived ideas about how a mechanical
trading strategy should be conducted, so everyone (and their brother)
just rolls their own backtesting frameworks.

If after reviewing the docs and examples perchance you find
[_Backtesting.py_](https://kernc.github.io/backtesting.py) not your cup of tea,
kindly have a look at some similar alternative Python backtesting frameworks:

- [bt](http://pmorissette.github.io/bt/) -
  a framework based on reusable and flexible blocks of
  strategy logic that support multiple instruments and
  output detailed statistics and useful charts.
- [vectorbt](https://polakowo.io/vectorbt/) -
  a pandas-based library for quickly analyzing trading strategies at scale.
- [Backtrader](https://www.backtrader.com/) -
  a pure-python feature-rich framework for backtesting
  and live algotrading with a few brokers.
- [PyAlgoTrade](https://gbeced.github.io/pyalgotrade/) -
  event-driven algorithmic trading library with focus on
  backtesting and support for live trading.
- [Pinkfish](http://fja05680.github.io/pinkfish/) -
  a lightweight backtester for intraday strategies on daily data.
- [finmarketpy](https://github.com/cuemacro/finmarketpy) -
  a library for analyzing financial market data.
- [QuantStart QSTrader](https://github.com/mhallsmoore/qstrader/) -
  a modular schedule-driven backtesting framework for long-short equities
  and ETF-based systematic trading strategies.
- [pysystemtrade](https://github.com/robcarver17/pysystemtrade) -
  the open-source version of Robert Carver's backtesting engine that
  implements systems according to his book _Systematic Trading:
  A unique new method for designing trading and investing systems_.
- [QTPyLib](https://github.com/ranaroussi/qtpylib) -
  a versatile, event-driven algorithmic trading library.
- [Gemini](https://github.com/anfederico/Gemini) -
  a backtester namely focusing on cryptocurrency markets.
- [Quantdom](https://github.com/constverum/Quantdom) -
  a Qt-based framework that lets you focus on modeling financial strategies,
  portfolio management, and analyzing backtests.
- [Clairvoyant](https://github.com/anfederico/Clairvoyant) -
  software for identifying and monitoring social / historical cues
  for short-term stock movement.
- [optopsy](https://github.com/michaelchu/optopsy) -
  a nimble backtesting library for options trading.
- [RQalpha](https://github.com/ricequant/rqalpha) -
  a complete solution for programmatic traders from data acquisition,
  algorithmic trading, backtesting, real-time simulation, live trading
  to mere data analysis. Documentation in Chinese.
- [zvt](https://github.com/zvtvz/zvt) -
  a quant trading platform which includes data recorder, factor calculation,
  stock picking, backtesting, and unified visualization. Documentation in Chinese.
- [AwesomeQuant](https://github.com/wilsonfreitas/awesome-quant#trading--backtesting) -
  A somewhat curated list of libraries, packages, and resources for quants.

#### Obsolete / Unmaintained

The following projects are mainly old, stale, incomplete, incompatible,
abandoned, and here for posterity reference only:

- [Zipline](https://www.zipline.io/) -
  the backtesting and live-trading engine powering Quantopian — the
  community-centered, hosted platform for building and executing strategies.
- [AlephNull](https://github.com/CarterBain/AlephNull) -
  extends the features of Zipline, for use within an institutional environment.
- [ProfitPy](https://code.google.com/p/profitpy/) -
  a set of libraries and tools for the development, testing, and execution of
  automated stock trading systems.
- [prophet](https://github.com/Emsu/prophet) -
  a microframework for financial markets, focusing on modeling
  strategies and portfolio management.
- [pybacktest](https://github.com/ematvey/pybacktest) -
  a vectorized pandas-based backtesting framework,
  designed to make backtesting compact, simple and fast.
- [quant](https://github.com/maihde/quant) -
  a technical analysis tool for trading strategies with a particularily
  simplistic view of the market.
- [QuantSoftware Toolkit](https://github.com/QuantSoftware/QuantSoftwareToolkit) -
  a toolkit by the guys that soon after went to form Lucena Research.
- [QuantStart QSForex](https://github.com/mhallsmoore/qsforex) -
  an event-driven backtesting and live-trading platform for use in
  the foreign exchange markets,
- [tia: Toolkit for integration and analysis](https://github.com/PaulMest/tia/) -
  a toolkit providing Bloomberg data access, PDF generation,
  technical analysis and backtesting functionality.
- [TradingWithPython](https://github.com/sjev/trading-with-python) -
  boiler-plate code for the (no longer active) course _Trading With Python_.
- [Ultra-Finance](https://github.com/panpanpandas/ultrafinance) -
  real-time financial data collection, analyzing and backtesting trading strategies.
- [visualize-wealth](https://github.com/benjaminmgross/visualize-wealth) -
  a library to construct, backtest, analyze, and evaluate portfolios
  and their benchmarks, with comprehensive documentation illustrating
  all underlying methodologies and statistics.
