#!/usr/bin/python3
"""An ASCII 5x9 (proportional) pattern."""
from pyxstitch.font import BaseFontFactory


class FiveByNineProp(BaseFontFactory):
    """Font factory definition."""

    def _display(self):
        """Display name."""
        return self._proportional_ascii()

    def _height_width(self):
        """Font height and width."""
        return (9, 5)

    def _initialize_characters(self):
        """Initialize default characters."""
        self._can_strip = True
        objs = {}
        objs['A'] = self._build_character("""
|    |1.00|    |    |    |
|1.00|    |1.00|    |    |
|1.00|    |1.00|    |    |
|1.00|1.00|1.00|    |    |
|1.00|    |1.00|    |    |
|1.00|    |1.00|    |    |
|1.00|    |1.00|    |    |
|    |    |    |    |    |
|    |    |    |    |    |
""")
        objs['B'] = self._build_character("""
|1.00|1.00|    |    |    |
|1.00|    |1.00|    |    |
|1.00|    |1.00|    |    |
|1.00|1.00|    |    |    |
|1.00|    |1.00|    |    |
|1.00|    |1.00|    |    |
|1.00|1.00|    |    |    |
|    |    |    |    |    |
|    |    |    |    |    |
""")
        objs['C'] = self._build_character("""
|    |1.00|    |    |    |
|1.00|    |1.00|    |    |
|1.00|    |    |    |    |
|1.00|    |    |    |    |
|1.00|    |    |    |    |
|1.00|    |1.00|    |    |
|    |1.00|    |    |    |
|    |    |    |    |    |
|    |    |    |    |    |
""")
        objs['D'] = self._build_character("""
|1.00|1.00|    |    |    |
|1.00|    |1.00|    |    |
|1.00|    |1.00|    |    |
|1.00|    |1.00|    |    |
|1.00|    |1.00|    |    |
|1.00|    |1.00|    |    |
|1.00|1.00|    |    |    |
|    |    |    |    |    |
|    |    |    |    |    |
""")
        objs['E'] = self._build_character("""
|1.00|1.00|1.00|    |    |
|1.00|    |    |    |    |
|1.00|    |    |    |    |
|1.00|1.00|1.00|    |    |
|1.00|    |    |    |    |
|1.00|    |    |    |    |
|1.00|1.00|1.00|    |    |
|    |    |    |    |    |
|    |    |    |    |    |
""")
        objs['F'] = self._build_character("""
|1.00|1.00|1.00|    |    |
|1.00|    |    |    |    |
|1.00|    |    |    |    |
|1.00|1.00|1.00|    |    |
|1.00|    |    |    |    |
|1.00|    |    |    |    |
|1.00|    |    |    |    |
|    |    |    |    |    |
|    |    |    |    |    |
""")
        objs['G'] = self._build_character("""
|    |1.00|1.00|    |    |
|1.00|    |    |    |    |
|1.00|    |    |    |    |
|1.00|    |1.00|    |    |
|1.00|    |1.00|    |    |
|1.00|    |1.00|    |    |
|    |1.00|    |    |    |
|    |    |    |    |    |
|    |    |    |    |    |
""")
        objs['H'] = self._build_character("""
|1.00|    |1.00|    |    |
|1.00|    |1.00|    |    |
|1.00|    |1.00|    |    |
|1.00|1.00|1.00|    |    |
|1.00|    |1.00|    |    |
|1.00|    |1.00|    |    |
|1.00|    |1.00|    |    |
|    |    |    |    |    |
|    |    |    |    |    |
""")
        objs['I'] = self._build_character("""
|1.00|1.00|1.00|    |    |
|    |1.00|    |    |    |
|    |1.00|    |    |    |
|    |1.00|    |    |    |
|    |1.00|    |    |    |
|    |1.00|    |    |    |
|1.00|1.00|1.00|    |    |
|    |    |    |    |    |
|    |    |    |    |    |
""")
        objs['J'] = self._build_character("""
|    |    |1.00|    |    |
|    |    |1.00|    |    |
|    |    |1.00|    |    |
|    |    |1.00|    |    |
|    |    |1.00|    |    |
|1.00|    |1.00|    |    |
|    |1.00|    |    |    |
|    |    |    |    |    |
|    |    |    |    |    |
""")
        objs['K'] = self._build_character("""
|1.00|    |    |1.00|    |
|1.00|    |    |1.00|    |
|1.00|    |1.00|    |    |
|1.00|1.00|    |    |    |
|1.00|    |1.00|    |    |
|1.00|    |    |1.00|    |
|1.00|    |    |1.00|    |
|    |    |    |    |    |
|    |    |    |    |    |
""")
        objs['L'] = self._build_character("""
|1.00|    |    |    |    |
|1.00|    |    |    |    |
|1.00|    |    |    |    |
|1.00|    |    |    |    |
|1.00|    |    |    |    |
|1.00|    |    |    |    |
|1.00|1.00|1.00|    |    |
|    |    |    |    |    |
|    |    |    |    |    |
""")
        objs['M'] = self._build_character("""
|1.00|    |    |    |1.00|
|1.00|1.00|    |1.00|1.00|
|1.00|    |1.00|    |1.00|
|1.00|    |1.00|    |1.00|
|1.00|    |    |    |1.00|
|1.00|    |    |    |1.00|
|1.00|    |    |    |1.00|
|    |    |    |    |    |
|    |    |    |    |    |
""")
        objs['N'] = self._build_character("""
|1.00|    |    |    |1.00|
|1.00|    |    |    |1.00|
|1.00|1.00|    |    |1.00|
|1.00|    |1.00|    |1.00|
|1.00|    |    |1.00|1.00|
|1.00|    |    |    |1.00|
|1.00|    |    |    |1.00|
|    |    |    |    |    |
|    |    |    |    |    |
""")
        objs['O'] = self._build_character("""
|    |1.00|    |    |    |
|1.00|    |1.00|    |    |
|1.00|    |1.00|    |    |
|1.00|    |1.00|    |    |
|1.00|    |1.00|    |    |
|1.00|    |1.00|    |    |
|    |1.00|    |    |    |
|    |    |    |    |    |
|    |    |    |    |    |
""")
        objs['P'] = self._build_character("""
|1.00|1.00|    |    |    |
|1.00|    |1.00|    |    |
|1.00|    |1.00|    |    |
|1.00|1.00|    |    |    |
|1.00|    |    |    |    |
|1.00|    |    |    |    |
|1.00|    |    |    |    |
|    |    |    |    |    |
|    |    |    |    |    |
""")
        objs['Q'] = self._build_character("""
|    |1.00|1.00|    |    |
|1.00|    |    |1.00|    |
|1.00|    |    |1.00|    |
|1.00|    |    |1.00|    |
|1.00|    |    |1.00|    |
|1.00|    |1.00|    |    |
|    |1.00|    |1.00|    |
|    |    |    |    |    |
|    |    |    |    |    |
""")
        objs['R'] = self._build_character("""
|1.00|1.00|    |    |    |
|1.00|    |1.00|    |    |
|1.00|    |1.00|    |    |
|1.00|1.00|    |    |    |
|1.00|    |1.00|    |    |
|1.00|    |1.00|    |    |
|1.00|    |1.00|    |    |
|    |    |    |    |    |
|    |    |    |    |    |
""")
        objs['S'] = self._build_character("""
|    |1.00|    |    |    |
|1.00|    |1.00|    |    |
|1.00|    |    |    |    |
|    |1.00|    |    |    |
|    |    |1.00|    |    |
|1.00|    |1.00|    |    |
|    |1.00|    |    |    |
|    |    |    |    |    |
|    |    |    |    |    |
""")
        objs['T'] = self._build_character("""
|1.00|1.00|1.00|    |    |
|    |1.00|    |    |    |
|    |1.00|    |    |    |
|    |1.00|    |    |    |
|    |1.00|    |    |    |
|    |1.00|    |    |    |
|    |1.00|    |    |    |
|    |    |    |    |    |
|    |    |    |    |    |
""")
        objs['U'] = self._build_character("""
|1.00|    |1.00|    |    |
|1.00|    |1.00|    |    |
|1.00|    |1.00|    |    |
|1.00|    |1.00|    |    |
|1.00|    |1.00|    |    |
|1.00|    |1.00|    |    |
|1.00|1.00|    |1.00|    |
|    |    |    |    |    |
|    |    |    |    |    |
""")
        objs['V'] = self._build_character("""
|1.00|    |1.00|    |    |
|1.00|    |1.00|    |    |
|1.00|    |1.00|    |    |
|1.00|    |1.00|    |    |
|1.00|    |1.00|    |    |
|1.00|    |1.00|    |    |
|    |1.00|    |    |    |
|    |    |    |    |    |
|    |    |    |    |    |
""")
        objs['W'] = self._build_character("""
|1.00|    |    |    |1.00|
|1.00|    |    |    |1.00|
|1.00|    |    |    |1.00|
|1.00|    |1.00|    |1.00|
|1.00|    |1.00|    |1.00|
|1.00|1.00|    |1.00|1.00|
|1.00|    |    |    |1.00|
|    |    |    |    |    |
|    |    |    |    |    |
""")
        objs['X'] = self._build_character("""
|1.00|    |1.00|    |    |
|1.00|    |1.00|    |    |
|1.00|    |1.00|    |    |
|    |1.00|    |    |    |
|1.00|    |1.00|    |    |
|1.00|    |1.00|    |    |
|1.00|    |1.00|    |    |
|    |    |    |    |    |
|    |    |    |    |    |
""")
        objs['Y'] = self._build_character("""
|1.00|    |1.00|    |    |
|1.00|    |1.00|    |    |
|1.00|    |1.00|    |    |
|    |1.00|    |    |    |
|    |1.00|    |    |    |
|    |1.00|    |    |    |
|    |1.00|    |    |    |
|    |    |    |    |    |
|    |    |    |    |    |
""")
        objs['0'] = self._build_character("""
|    |1.00|    |    |    |
|1.00|    |1.00|    |    |
|1.00|    |1.00|    |    |
|1.00|1.00|1.00|    |    |
|1.00|    |1.00|    |    |
|1.00|    |1.00|    |    |
|    |1.00|    |    |    |
|    |    |    |    |    |
|    |    |    |    |    |
""")
        objs['1'] = self._build_character("""
|    |1.00|    |    |    |
|1.00|1.00|    |    |    |
|    |1.00|    |    |    |
|    |1.00|    |    |    |
|    |1.00|    |    |    |
|    |1.00|    |    |    |
|1.00|1.00|1.00|    |    |
|    |    |    |    |    |
|    |    |    |    |    |
""")
        objs['2'] = self._build_character("""
|    |1.00|    |    |    |
|1.00|    |1.00|    |    |
|    |    |1.00|    |    |
|    |1.00|    |    |    |
|1.00|    |    |    |    |
|1.00|    |    |    |    |
|1.00|1.00|1.00|    |    |
|    |    |    |    |    |
|    |    |    |    |    |
""")
        objs['5'] = self._build_character("""
|1.00|1.00|1.00|    |    |
|1.00|    |    |    |    |
|1.00|    |    |    |    |
|1.00|1.00|    |    |    |
|    |    |1.00|    |    |
|1.00|    |1.00|    |    |
|    |1.00|    |    |    |
|    |    |    |    |    |
|    |    |    |    |    |
""")
        objs['u'] = self._build_character("""
|    |    |    |    |    |
|    |    |    |    |    |
|    |    |    |    |    |
|1.00|    |1.00|    |    |
|1.00|    |1.00|    |    |
|1.00|    |1.00|    |    |
|1.00|1.00|    |1.00|    |
|    |    |    |    |    |
|    |    |    |    |    |
""")
        objs['a'] = self._build_character("""
|    |    |    |    |    |
|    |    |    |    |    |
|    |    |    |    |    |
|    |1.00|1.00|    |    |
|1.00|    |1.00|    |    |
|1.00|    |1.00|    |    |
|1.00|1.00|    |1.00|    |
|    |    |    |    |    |
|    |    |    |    |    |
""")
        objs['c'] = self._build_character("""
|    |    |    |    |    |
|    |    |    |    |    |
|    |    |    |    |    |
|    |1.00|1.00|    |    |
|1.00|    |    |    |    |
|1.00|    |    |    |    |
|    |1.00|1.00|    |    |
|    |    |    |    |    |
|    |    |    |    |    |
""")
        objs['k'] = self._build_character("""
|1.00|    |    |    |    |
|1.00|    |    |    |    |
|1.00|    |    |    |    |
|1.00|    |1.00|    |    |
|1.00|1.00|    |    |    |
|1.00|    |1.00|    |    |
|1.00|    |1.00|    |    |
|    |    |    |    |    |
|    |    |    |    |    |
""")
        objs['h'] = self._build_character("""
|1.00|    |    |    |    |
|1.00|    |    |    |    |
|1.00|    |    |    |    |
|1.00|1.00|    |    |    |
|1.00|    |1.00|    |    |
|1.00|    |1.00|    |    |
|1.00|    |1.00|    |    |
|    |    |    |    |    |
|    |    |    |    |    |
""")
        objs['d'] = self._build_character("""
|    |    |1.00|    |    |
|    |    |1.00|    |    |
|    |    |1.00|    |    |
|    |1.00|1.00|    |    |
|1.00|    |1.00|    |    |
|1.00|    |1.00|    |    |
|    |1.00|1.00|    |    |
|    |    |    |    |    |
|    |    |    |    |    |
""")
        objs['e'] = self._build_character("""
|    |    |    |    |    |
|    |    |    |    |    |
|    |    |    |    |    |
|    |1.00|1.00|    |    |
|1.00|0.02|0.02|1.00|    |
|1.00|    |    |    |    |
|    |1.00|1.00|    |    |
|    |    |    |    |    |
|    |    |    |    |    |
""")
        objs['f'] = self._build_character("""
|    |1.00|1.00|    |    |
|    |1.00|    |    |    |
|    |1.00|    |    |    |
|1.00|1.00|1.00|    |    |
|    |1.00|    |    |    |
|    |1.00|    |    |    |
|    |1.00|    |    |    |
|    |    |    |    |    |
|    |    |    |    |    |
""")
        objs['t'] = self._build_character("""
|    |1.00|    |    |    |
|    |1.00|    |    |    |
|    |1.00|    |    |    |
|1.00|1.00|1.00|    |    |
|    |1.00|    |    |    |
|    |1.00|    |    |    |
|    |1.00|    |    |    |
|    |    |    |    |    |
|    |    |    |    |    |
""")
        objs['#'] = self._build_character("""
|    |    |1.00|    |1.00|
|    |0.16|0.16|0.16|0.16|
|1.00|1.00|1.00|1.00|1.00|
|    |1.00|    |1.00|    |
|1.00|1.00|1.00|1.00|1.00|
|0.16|0.16|0.16|0.16|    |
|1.00|    |1.00|    |    |
|    |    |    |    |    |
|    |    |    |    |    |
""")
        objs['"'] = self._build_character("""
|1.00|    |1.00|    |    |
|1.00|    |1.00|    |    |
|0.40|    |0.40|    |    |
|    |    |    |    |    |
|    |    |    |    |    |
|    |    |    |    |    |
|    |    |    |    |    |
|    |    |    |    |    |
|    |    |    |    |    |
""")
        objs["'"] = self._build_character("""
|1.00|    |    |    |    |
|1.00|    |    |    |    |
|0.40|    |    |    |    |
|    |    |    |    |    |
|    |    |    |    |    |
|    |    |    |    |    |
|    |    |    |    |    |
|    |    |    |    |    |
|    |    |    |    |    |
""")
        objs['g'] = self._build_character("""
|    |    |    |    |    |
|    |    |    |    |    |
|    |    |    |    |    |
|    |1.00|1.00|    |    |
|1.00|    |1.00|    |    |
|1.00|    |1.00|    |    |
|    |1.00|1.00|    |    |
|    |    |1.00|    |    |
|1.00|1.00|    |    |    |
""")
        objs['l'] = self._build_character("""
|    |1.00|    |    |    |
|    |1.00|    |    |    |
|    |1.00|    |    |    |
|    |1.00|    |    |    |
|    |1.00|    |    |    |
|    |1.00|    |    |    |
|1.00|1.00|1.00|    |    |
|    |    |    |    |    |
|    |    |    |    |    |
""")
        objs['i'] = self._build_character("""
|    |    |    |    |    |
|1.00|    |    |    |    |
|    |    |    |    |    |
|1.00|    |    |    |    |
|1.00|    |    |    |    |
|1.00|    |    |    |    |
|1.00|    |    |    |    |
|    |    |    |    |    |
|    |    |    |    |    |
""")
        objs['n'] = self._build_character("""
|    |    |    |    |    |
|    |    |    |    |    |
|    |    |    |    |    |
|1.00|1.00|    |    |    |
|1.00|    |1.00|    |    |
|1.00|    |1.00|    |    |
|1.00|    |1.00|    |    |
|    |    |    |    |    |
|    |    |    |    |    |
""")
        objs['m'] = self._build_character("""
|    |    |    |    |    |
|    |    |    |    |    |
|    |    |    |    |    |
|1.00|1.00|    |1.00|    |
|1.00|    |1.00|    |1.00|
|1.00|    |1.00|    |1.00|
|1.00|    |    |    |1.00|
|    |    |    |    |    |
|    |    |    |    |    |
""")
        objs['w'] = self._build_character("""
|    |    |    |    |    |
|    |    |    |    |    |
|    |    |    |    |    |
|1.00|    |    |    |1.00|
|1.00|    |1.00|    |1.00|
|1.00|    |1.00|    |1.00|
|    |1.00|    |1.00|    |
|    |    |    |    |    |
|    |    |    |    |    |
""")
        objs['o'] = self._build_character("""
|    |    |    |    |    |
|    |    |    |    |    |
|    |    |    |    |    |
|    |1.00|    |    |    |
|1.00|    |1.00|    |    |
|1.00|    |1.00|    |    |
|    |1.00|    |    |    |
|    |    |    |    |    |
|    |    |    |    |    |
""")
        objs['p'] = self._build_character("""
|    |    |    |    |    |
|    |    |    |    |    |
|    |    |    |    |    |
|1.00|1.00|    |    |    |
|1.00|    |1.00|    |    |
|1.00|    |1.00|    |    |
|1.00|1.00|    |    |    |
|1.00|    |    |    |    |
|1.00|    |    |    |    |
""")

        objs[':'] = self._build_character("""
|    |    |    |    |    |
|    |    |    |    |    |
|1.00|    |    |    |    |
|    |    |    |    |    |
|1.00|    |    |    |    |
|    |    |    |    |    |
|    |    |    |    |    |
|    |    |    |    |    |
|    |    |    |    |    |
""")
        objs[';'] = self._build_character("""
|    |    |    |    |    |
|    |    |    |    |    |
|1.00|    |    |    |    |
|    |    |    |    |    |
|1.00|    |    |    |    |
|0.20|    |    |    |    |
|    |    |    |    |    |
|    |    |    |    |    |
|    |    |    |    |    |
""")
        objs['}'] = self._build_character("""
|1.00|1.00|    |    |    |
|    |1.00|    |    |    |
|    |1.00|    |    |    |
|    |    |1.00|    |    |
|    |1.00|    |    |    |
|    |1.00|    |    |    |
|1.00|1.00|    |    |    |
|    |    |    |    |    |
|    |    |    |    |    |
""")
        objs[')'] = self._build_character("""
|1.00|    |    |    |    |
|    |1.00|    |    |    |
|    |1.00|    |    |    |
|    |1.00|    |    |    |
|    |1.00|    |    |    |
|    |1.00|    |    |    |
|1.00|    |    |    |    |
|    |    |    |    |    |
|    |    |    |    |    |
""")
        objs['s'] = self._build_character("""
|    |    |    |    |    |
|    |    |    |    |    |
|    |    |    |    |    |
|    |1.00|1.00|    |    |
|1.00|0.02|    |    |    |
|    |    |1.00|    |    |
|1.00|1.00|    |    |    |
|    |    |    |    |    |
|    |    |    |    |    |
""")
        objs['>'] = self._build_character("""
|    |    |    |    |    |
|1.00|    |    |    |    |
|    |1.00|    |    |    |
|    |    |1.00|    |    |
|    |1.00|    |    |    |
|1.00|    |    |    |    |
|    |    |    |    |    |
|    |    |    |    |    |
|    |    |    |    |    |
""")
        objs['<'] = self._build_character("""
|    |    |    |    |    |
|    |    |1.00|    |    |
|    |1.00|    |    |    |
|1.00|    |    |    |    |
|    |1.00|    |    |    |
|    |    |1.00|    |    |
|    |    |    |    |    |
|    |    |    |    |    |
|    |    |    |    |    |
""")
        objs['{'] = self._build_character("""
|    |1.00|1.00|    |    |
|    |1.00|    |    |    |
|    |1.00|    |    |    |
|1.00|    |    |    |    |
|    |1.00|    |    |    |
|    |1.00|    |    |    |
|    |1.00|1.00|    |    |
|    |    |    |    |    |
|    |    |    |    |    |
""")
        objs['('] = self._build_character("""
|    |1.00|    |    |    |
|1.00|    |    |    |    |
|1.00|    |    |    |    |
|1.00|    |    |    |    |
|1.00|    |    |    |    |
|1.00|    |    |    |    |
|    |1.00|    |    |    |
|    |    |    |    |    |
|    |    |    |    |    |
""")
        objs['r'] = self._build_character("""
|    |    |    |    |    |
|    |    |    |    |    |
|    |    |    |    |    |
|1.00|    |1.00|    |    |
|1.00|1.00|    |    |    |
|1.00|    |    |    |    |
|1.00|    |    |    |    |
|    |    |    |    |    |
|    |    |    |    |    |
""")
        objs['!'] = self._build_character("""
|1.00|    |    |    |    |
|1.00|    |    |    |    |
|1.00|    |    |    |    |
|1.00|    |    |    |    |
|1.00|    |    |    |    |
|    |    |    |    |    |
|1.00|    |    |    |    |
|    |    |    |    |    |
|    |    |    |    |    |
""")
        objs['.'] = self._build_character("""
|    |    |    |    |    |
|    |    |    |    |    |
|    |    |    |    |    |
|    |    |    |    |    |
|    |    |    |    |    |
|    |    |    |    |    |
|1.00|    |    |    |    |
|    |    |    |    |    |
|    |    |    |    |    |
""")
        objs[','] = self._build_character("""
|    |    |    |    |    |
|    |    |    |    |    |
|    |    |    |    |    |
|    |    |    |    |    |
|    |    |    |    |    |
|    |    |    |    |    |
|1.00|    |    |    |    |
|0.20|    |    |    |    |
|    |    |    |    |    |
""")
        objs['_'] = self._build_character("""
|    |    |    |    |    |
|    |    |    |    |    |
|    |    |    |    |    |
|    |    |    |    |    |
|    |    |    |    |    |
|    |    |    |    |    |
|1.00|1.00|1.00|    |    |
|    |    |    |    |    |
|    |    |    |    |    |
""")
        objs['='] = self._build_character("""
|    |    |    |    |    |
|    |    |    |    |    |
|1.00|1.00|1.00|    |    |
|    |    |    |    |    |
|1.00|1.00|1.00|    |    |
|    |    |    |    |    |
|    |    |    |    |    |
|    |    |    |    |    |
|    |    |    |    |    |
""")
        objs[' '] = self._build_character("""
|    |    |    |    |    |
|    |    |    |    |    |
|    |    |    |    |    |
|    |    |    |    |    |
|    |    |    |    |    |
|    |    |    |    |    |
|    |    |    |    |    |
|    |    |    |    |    |
|    |    |    |    |    |
""")
        objs[']'] = self._build_character("""
|1.00|1.00|    |    |    |
|    |1.00|    |    |    |
|    |1.00|    |    |    |
|    |1.00|    |    |    |
|    |1.00|    |    |    |
|    |1.00|    |    |    |
|1.00|1.00|    |    |    |
|    |    |    |    |    |
|    |    |    |    |    |
""")
        objs['['] = self._build_character("""
|1.00|1.00|    |    |    |
|1.00|    |    |    |    |
|1.00|    |    |    |    |
|1.00|    |    |    |    |
|1.00|    |    |    |    |
|1.00|    |    |    |    |
|1.00|1.00|    |    |    |
|    |    |    |    |    |
|    |    |    |    |    |
""")
        objs['3'] = self._build_character("""
|1.00|1.00|    |    |    |
|    |    |1.00|    |    |
|    |    |1.00|    |    |
|    |1.00|    |    |    |
|    |    |1.00|    |    |
|    |    |1.00|    |    |
|1.00|1.00|    |    |    |
|    |    |    |    |    |
|    |    |    |    |    |
""")
        objs['4'] = self._build_character("""
|1.00|    |1.00|    |    |
|1.00|    |1.00|    |    |
|1.00|    |1.00|    |    |
|1.00|1.00|1.00|    |    |
|    |    |1.00|    |    |
|    |    |1.00|    |    |
|    |    |1.00|    |    |
|    |    |    |    |    |
|    |    |    |    |    |
""")
        objs['9'] = self._build_character("""
|    |1.00|    |    |    |
|1.00|    |1.00|    |    |
|1.00|    |1.00|    |    |
|    |1.00|1.00|    |    |
|    |    |1.00|    |    |
|1.00|    |1.00|    |    |
|    |1.00|    |    |    |
|    |    |    |    |    |
|    |    |    |    |    |
""")
        objs['6'] = self._build_character("""
|    |1.00|    |    |    |
|1.00|    |1.00|    |    |
|1.00|    |    |    |    |
|1.00|1.00|    |    |    |
|1.00|    |1.00|    |    |
|1.00|    |1.00|    |    |
|    |1.00|    |    |    |
|    |    |    |    |    |
|    |    |    |    |    |
""")
        objs['7'] = self._build_character("""
|1.00|1.00|1.00|    |    |
|    |    |1.00|    |    |
|    |    |1.00|    |    |
|    |1.00|    |    |    |
|    |1.00|    |    |    |
|    |1.00|    |    |    |
|    |1.00|    |    |    ||
|    |    |    |    |    |
|    |    |    |    |    |
""")
        objs['8'] = self._build_character("""
|    |1.00|    |    |    |
|1.00|    |1.00|    |    |
|1.00|    |1.00|    |    |
|    |1.00|    |    |    |
|1.00|    |1.00|    |    |
|1.00|    |1.00|    |    |
|    |1.00|    |    |    |
|    |    |    |    |    |
|    |    |    |    |    |
""")
        objs['q'] = self._build_character("""
|    |    |    |    |    |
|    |    |    |    |    |
|    |    |    |    |    |
|    |1.00|1.00|    |    |
|1.00|    |1.00|    |    |
|1.00|    |1.00|    |    |
|    |1.00|1.00|    |    |
|    |    |1.00|    |    |
|    |    |    |1.00|    |
""")
        objs['j'] = self._build_character("""
|    |    |    |    |    |
|    |    |1.00|    |    |
|    |    |    |    |    |
|    |    |1.00|    |    |
|    |    |1.00|    |    |
|    |    |1.00|    |    |
|    |    |1.00|    |    |
|1.00|    |1.00|    |    |
|    |1.00|    |    |    |
""")
        objs['v'] = self._build_character("""
|    |    |    |    |    |
|    |    |    |    |    |
|    |    |    |    |    |
|1.00|    |1.00|    |    |
|1.00|    |1.00|    |    |
|1.00|    |1.00|    |    |
|    |1.00|    |    |    |
|    |    |    |    |    |
|    |    |    |    |    |
""")
        objs['x'] = self._build_character("""
|    |    |    |    |    |
|    |    |    |    |    |
|    |    |    |    |    |
|1.00|    |1.00|    |    |
|    |1.00|    |    |    |
|    |1.00|    |    |    |
|1.00|    |1.00|    |    |
|    |    |    |    |    |
|    |    |    |    |    |
""")
        objs['y'] = self._build_character("""
|    |    |    |    |    |
|    |    |    |    |    |
|    |    |    |    |    |
|1.00|    |1.00|    |    |
|1.00|    |1.00|    |    |
|1.00|    |1.00|    |    |
|    |1.00|1.00|    |    |
|    |    |1.00|    |    |
|1.00|1.00|    |    |    |
""")
        objs['Z'] = self._build_character("""
|1.00|1.00|1.00|    |    |
|    |    |1.00|    |    |
|    |0.16|0.16|    |    |
|1.00|1.00|1.00|    |    |
|0.16|0.16|    |    |    |
|1.00|    |    |    |    |
|1.00|1.00|1.00|    |    |
|    |    |    |    |    |
|    |    |    |    |    |
""")
        objs['z'] = self._build_character("""
|    |    |    |    |    |
|    |    |    |    |    |
|    |    |    |    |    |
|1.00|1.00|1.00|    |    |
|0.02|0.18|0.18|    |    |
|0.16|0.16|    |    |    |
|1.00|1.00|1.00|    |    |
|    |    |    |    |    |
|    |    |    |    |    |
""")
        objs['b'] = self._build_character("""
|1.00|    |    |    |    |
|1.00|    |    |    |    |
|1.00|    |    |    |    |
|1.00|1.00|    |    |    |
|1.00|    |1.00|    |    |
|1.00|    |1.00|    |    |
|1.00|1.00|    |    |    |
|    |    |    |    |    |
|    |    |    |    |    |
""")
        objs['%'] = self._build_character("""
|    |    |    |    |    |
|1.00|    |    |    |    |
|    |    |1.00|    |    |
|    |1.00|    |    |    |
|1.00|    |    |    |    |
|    |    |1.00|    |    |
|    |    |    |    |    |
|    |    |    |    |    |
|    |    |    |    |    |
""")
        objs['$'] = self._build_character("""
|    |1.00|    |    |    |
|    |1.00|1.00|    |    |
|1.00|    |    |    |    |
|    |1.00|    |    |    |
|    |    |1.00|    |    |
|1.00|1.00|    |    |    |
|    |1.00|    |    |    |
|    |    |    |    |    |
|    |    |    |    |    |
""")
        objs['@'] = self._build_character("""
|    |1.00|1.00|1.00|    |
|1.00|    |    |    |1.00|
|1.00|    |    |    |1.00|
|1.00|    |1.00|    |1.00|
|1.00|    |    |1.00|    |
|1.00|    |    |    |    |
|    |1.00|1.00|    |    |
|    |    |    |    |    |
|    |    |    |    |    |
""")
        objs['*'] = self._build_character("""
|    |    |    |    |    |
|    |    |    |    |    |
|0.32|1.00|0.16|    |    |
|1.00|1.00|1.00|    |    |
|0.16|1.00|0.32|    |    |
|    |    |    |    |    |
|    |    |    |    |    |
|    |    |    |    |    |
|    |    |    |    |    |
""")
        objs['&'] = self._build_character("""
|    |1.00|1.00|    |    |
|1.00|    |    |1.00|    |
|1.00|    |1.00|    |    |
|    |1.00|    |    |    |
|1.00|    |1.00|    |1.00|
|1.00|    |    |1.00|    |
|    |1.00|1.00|    |1.00|
|    |    |    |    |    |
|    |    |    |    |    |
""")
        objs['+'] = self._build_character("""
|    |    |    |    |    |
|    |    |    |    |    |
|    |1.00|    |    |    |
|1.00|1.00|1.00|    |    |
|    |1.00|    |    |    |
|    |    |    |    |    |
|    |    |    |    |    |
|    |    |    |    |    |
|    |    |    |    |    |
""")
        objs['-'] = self._build_character("""
|    |    |    |    |    |
|    |    |    |    |    |
|    |    |    |    |    |
|1.00|1.00|1.00|    |    |
|    |    |    |    |    |
|    |    |    |    |    |
|    |    |    |    |    |
|    |    |    |    |    |
|    |    |    |    |    |
""")
        objs['^'] = self._build_character("""
|    |1.00|    |    |    |
|1.00|    |1.00|    |    |
|    |    |    |    |    |
|    |    |    |    |    |
|    |    |    |    |    |
|    |    |    |    |    |
|    |    |    |    |    |
|    |    |    |    |    |
|    |    |    |    |    |
""")
        objs['?'] = self._build_character("""
|    |1.00|    |    |    |
|1.00|    |1.00|    |    |
|    |    |1.00|    |    |
|    |1.00|    |    |    |
|    |1.00|    |    |    |
|    |    |    |    |    |
|    |1.00|    |    |    |
|    |    |    |    |    |
|    |    |    |    |    |
""")
        objs['\\'] = self._build_character("""
|    |    |    |    |    |
|1.00|    |    |    |    |
|    |1.00|    |    |    |
|    |    |1.00|    |    |
|    |    |    |1.00|    |
|    |    |    |    |1.00|
|    |    |    |    |    |
|    |    |    |    |    |
|    |    |    |    |    |
""")
        objs['/'] = self._build_character("""
|    |    |    |    |    |
|    |    |    |    |1.00|
|    |    |    |1.00|    |
|    |    |1.00|    |    |
|    |1.00|    |    |    |
|1.00|    |    |    |    |
|    |    |    |    |    |
|    |    |    |    |    |
|    |    |    |    |    |
""")
        objs['|'] = self._build_character("""
|1.00|    |    |    |    |
|1.00|    |    |    |    |
|1.00|    |    |    |    |
|1.00|    |    |    |    |
|1.00|    |    |    |    |
|1.00|    |    |    |    |
|1.00|    |    |    |    |
|    |    |    |    |    |
|    |    |    |    |    |
""")
        objs['~'] = self._build_character("""
|    |    |    |    |    |
|    |    |    |    |    |
|    |1.00|    |    |    |
|1.00|    |1.00|    |1.00|
|    |    |    |1.00|    |
|    |    |    |    |    |
|    |    |    |    |    |
|    |    |    |    |    |
|    |    |    |    |    |
""")
        objs['`'] = self._build_character("""
|1.00|    |    |    |    |
|    |1.00|    |    |    |
|    |    |1.00|    |    |
|    |    |    |    |    |
|    |    |    |    |    |
|    |    |    |    |    |
|    |    |    |    |    |
|    |    |    |    |    |
|    |    |    |    |    |
""")
        return objs
