/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.owlxml.parser;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.io.OWLParserException;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAnonymousIndividualByIdProvider;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyLoaderConfiguration;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.owlxml.parser.OWLElementHandler;
import org.semanticweb.owlapi.owlxml.parser.OWLXMLParserException;
import org.semanticweb.owlapi.owlxml.parser.PARSER_OWLXMLVocabulary;
import org.semanticweb.owlapi.util.RemappingIndividualProvider;
import org.semanticweb.owlapi.vocab.Namespaces;
import org.semanticweb.owlapi.vocab.OWLXMLVocabulary;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class OWLXMLParserHandler
extends DefaultHandler
implements OWLAnonymousIndividualByIdProvider {
    private final OWLOntologyManager owlOntologyManager;
    @Nonnull
    private final OWLOntology ontology;
    private final List<OWLElementHandler<?>> handlerStack;
    @Nonnull
    private final Map<String, PARSER_OWLXMLVocabulary> handlerMap = new HashMap<String, PARSER_OWLXMLVocabulary>();
    @Nonnull
    private final Map<String, String> prefixName2PrefixMap = new HashMap<String, String>();
    private Locator locator;
    private final Stack<URI> bases;
    @Nonnull
    private final OWLOntologyLoaderConfiguration configuration;
    private final RemappingIndividualProvider anonProvider;
    private boolean atLeastOneValidTagFound = false;
    private final Map<String, IRI> iriMap = new HashMap<String, IRI>();

    public OWLXMLParserHandler(@Nonnull OWLOntology ontology) {
        this(ontology, null, ontology.getOWLOntologyManager().getOntologyLoaderConfiguration());
    }

    public OWLXMLParserHandler(@Nonnull OWLOntology ontology, @Nonnull OWLOntologyLoaderConfiguration configuration) {
        this(ontology, null, configuration);
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        super.setDocumentLocator(locator);
        this.locator = locator;
        URI base = null;
        try {
            String systemId = locator.getSystemId();
            if (systemId != null) {
                base = new URI(systemId);
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        this.bases.push(base);
    }

    public OWLXMLParserHandler(OWLOntology ontology, OWLElementHandler<?> topHandler) {
        this(ontology, topHandler, ontology.getOWLOntologyManager().getOntologyLoaderConfiguration());
    }

    public OWLXMLParserHandler(OWLOntology ontology, @Nullable OWLElementHandler<?> topHandler, @Nonnull OWLOntologyLoaderConfiguration configuration) {
        this.owlOntologyManager = ontology.getOWLOntologyManager();
        this.ontology = ontology;
        this.bases = new Stack();
        this.configuration = configuration;
        this.handlerStack = new ArrayList();
        this.anonProvider = new RemappingIndividualProvider(this.owlOntologyManager.getOWLDataFactory());
        this.prefixName2PrefixMap.put("owl:", Namespaces.OWL.toString());
        this.prefixName2PrefixMap.put("xsd:", Namespaces.XSD.toString());
        if (topHandler != null) {
            this.handlerStack.add(0, topHandler);
        }
        this.addFactory(PARSER_OWLXMLVocabulary.PARSER_ONTOLOGY, new String[0]);
        this.addFactory(PARSER_OWLXMLVocabulary.PARSER_ANNOTATION, new String[0]);
        this.addFactory(PARSER_OWLXMLVocabulary.PARSER_LITERAL, "Constant");
        this.addFactory(PARSER_OWLXMLVocabulary.PARSER_IMPORT, "Imports");
        this.addFactory(PARSER_OWLXMLVocabulary.PARSER_CLASS, "OWLClass");
        this.addFactory(PARSER_OWLXMLVocabulary.PARSER_ANNOTATION_PROPERTY, new String[0]);
        this.addFactory(PARSER_OWLXMLVocabulary.PARSER_ANNOTATION_PROPERTY_DOMAIN, new String[0]);
        this.addFactory(PARSER_OWLXMLVocabulary.PARSER_ANNOTATION_PROPERTY_RANGE, new String[0]);
        this.addFactory(PARSER_OWLXMLVocabulary.PARSER_SUB_ANNOTATION_PROPERTY_OF, new String[0]);
        this.addFactory(PARSER_OWLXMLVocabulary.PARSER_OBJECT_PROPERTY, new String[0]);
        this.addFactory(PARSER_OWLXMLVocabulary.PARSER_OBJECT_INVERSE_OF, new String[0]);
        this.addFactory(PARSER_OWLXMLVocabulary.PARSER_DATA_PROPERTY, new String[0]);
        this.addFactory(PARSER_OWLXMLVocabulary.PARSER_NAMED_INDIVIDUAL, "Individual");
        this.addFactory(PARSER_OWLXMLVocabulary.PARSER_DATA_COMPLEMENT_OF, new String[0]);
        this.addFactory(PARSER_OWLXMLVocabulary.PARSER_DATA_ONE_OF, new String[0]);
        this.addFactory(PARSER_OWLXMLVocabulary.PARSER_DATATYPE, new String[0]);
        this.addFactory(PARSER_OWLXMLVocabulary.PARSER_DATATYPE_RESTRICTION, new String[0]);
        this.addFactory(PARSER_OWLXMLVocabulary.PARSER_DATA_INTERSECTION_OF, new String[0]);
        this.addFactory(PARSER_OWLXMLVocabulary.PARSER_DATA_UNION_OF, new String[0]);
        this.addFactory(PARSER_OWLXMLVocabulary.PARSER_FACET_RESTRICTION, new String[0]);
        this.addFactory(PARSER_OWLXMLVocabulary.PARSER_OBJECT_INTERSECTION_OF, new String[0]);
        this.addFactory(PARSER_OWLXMLVocabulary.PARSER_OBJECT_UNION_OF, new String[0]);
        this.addFactory(PARSER_OWLXMLVocabulary.PARSER_OBJECT_COMPLEMENT_OF, new String[0]);
        this.addFactory(PARSER_OWLXMLVocabulary.PARSER_OBJECT_ONE_OF, new String[0]);
        this.addFactory(PARSER_OWLXMLVocabulary.PARSER_OBJECT_SOME_VALUES_FROM, new String[0]);
        this.addFactory(PARSER_OWLXMLVocabulary.PARSER_OBJECT_ALL_VALUES_FROM, new String[0]);
        this.addFactory(PARSER_OWLXMLVocabulary.PARSER_OBJECT_HAS_SELF, "ObjectExistsSelf");
        this.addFactory(PARSER_OWLXMLVocabulary.PARSER_OBJECT_HAS_VALUE, new String[0]);
        this.addFactory(PARSER_OWLXMLVocabulary.PARSER_OBJECT_MIN_CARDINALITY, new String[0]);
        this.addFactory(PARSER_OWLXMLVocabulary.PARSER_OBJECT_EXACT_CARDINALITY, new String[0]);
        this.addFactory(PARSER_OWLXMLVocabulary.PARSER_OBJECT_MAX_CARDINALITY, new String[0]);
        this.addFactory(PARSER_OWLXMLVocabulary.PARSER_DATA_SOME_VALUES_FROM, new String[0]);
        this.addFactory(PARSER_OWLXMLVocabulary.PARSER_DATA_ALL_VALUES_FROM, new String[0]);
        this.addFactory(PARSER_OWLXMLVocabulary.PARSER_DATA_HAS_VALUE, new String[0]);
        this.addFactory(PARSER_OWLXMLVocabulary.PARSER_DATA_MIN_CARDINALITY, new String[0]);
        this.addFactory(PARSER_OWLXMLVocabulary.PARSER_DATA_EXACT_CARDINALITY, new String[0]);
        this.addFactory(PARSER_OWLXMLVocabulary.PARSER_DATA_MAX_CARDINALITY, new String[0]);
        this.addFactory(PARSER_OWLXMLVocabulary.PARSER_SUB_CLASS_OF, new String[0]);
        this.addFactory(PARSER_OWLXMLVocabulary.PARSER_EQUIVALENT_CLASSES, new String[0]);
        this.addFactory(PARSER_OWLXMLVocabulary.PARSER_DISJOINT_CLASSES, new String[0]);
        this.addFactory(PARSER_OWLXMLVocabulary.PARSER_DISJOINT_UNION, new String[0]);
        this.addFactory(PARSER_OWLXMLVocabulary.PARSER_UNION_OF, new String[0]);
        this.addFactory(PARSER_OWLXMLVocabulary.PARSER_SUB_OBJECT_PROPERTY_OF, new String[0]);
        this.addFactory(PARSER_OWLXMLVocabulary.PARSER_OBJECT_PROPERTY_CHAIN, "SubObjectPropertyChain");
        this.addFactory(PARSER_OWLXMLVocabulary.PARSER_OBJECT_PROPERTY_CHAIN, new String[0]);
        this.addFactory(PARSER_OWLXMLVocabulary.PARSER_EQUIVALENT_OBJECT_PROPERTIES, new String[0]);
        this.addFactory(PARSER_OWLXMLVocabulary.PARSER_DISJOINT_OBJECT_PROPERTIES, new String[0]);
        this.addFactory(PARSER_OWLXMLVocabulary.PARSER_OBJECT_PROPERTY_DOMAIN, new String[0]);
        this.addFactory(PARSER_OWLXMLVocabulary.PARSER_OBJECT_PROPERTY_RANGE, new String[0]);
        this.addFactory(PARSER_OWLXMLVocabulary.PARSER_INVERSE_OBJECT_PROPERTIES, new String[0]);
        this.addFactory(PARSER_OWLXMLVocabulary.PARSER_FUNCTIONAL_OBJECT_PROPERTY, new String[0]);
        this.addFactory(PARSER_OWLXMLVocabulary.PARSER_INVERSE_FUNCTIONAL_OBJECT_PROPERTY, new String[0]);
        this.addFactory(PARSER_OWLXMLVocabulary.PARSER_SYMMETRIC_OBJECT_PROPERTY, new String[0]);
        this.addFactory(PARSER_OWLXMLVocabulary.PARSER_ASYMMETRIC_OBJECT_PROPERTY, new String[0]);
        this.addFactory(PARSER_OWLXMLVocabulary.PARSER_REFLEXIVE_OBJECT_PROPERTY, new String[0]);
        this.addFactory(PARSER_OWLXMLVocabulary.PARSER_IRREFLEXIVE_OBJECT_PROPERTY, new String[0]);
        this.addFactory(PARSER_OWLXMLVocabulary.PARSER_TRANSITIVE_OBJECT_PROPERTY, new String[0]);
        this.addFactory(PARSER_OWLXMLVocabulary.PARSER_SUB_DATA_PROPERTY_OF, new String[0]);
        this.addFactory(PARSER_OWLXMLVocabulary.PARSER_EQUIVALENT_DATA_PROPERTIES, new String[0]);
        this.addFactory(PARSER_OWLXMLVocabulary.PARSER_DISJOINT_DATA_PROPERTIES, new String[0]);
        this.addFactory(PARSER_OWLXMLVocabulary.PARSER_DATA_PROPERTY_DOMAIN, new String[0]);
        this.addFactory(PARSER_OWLXMLVocabulary.PARSER_DATA_PROPERTY_RANGE, new String[0]);
        this.addFactory(PARSER_OWLXMLVocabulary.PARSER_FUNCTIONAL_DATA_PROPERTY, new String[0]);
        this.addFactory(PARSER_OWLXMLVocabulary.PARSER_SAME_INDIVIDUAL, "SameIndividuals");
        this.addFactory(PARSER_OWLXMLVocabulary.PARSER_DIFFERENT_INDIVIDUALS, new String[0]);
        this.addFactory(PARSER_OWLXMLVocabulary.PARSER_CLASS_ASSERTION, new String[0]);
        this.addFactory(PARSER_OWLXMLVocabulary.PARSER_OBJECT_PROPERTY_ASSERTION, new String[0]);
        this.addFactory(PARSER_OWLXMLVocabulary.PARSER_NEGATIVE_OBJECT_PROPERTY_ASSERTION, new String[0]);
        this.addFactory(PARSER_OWLXMLVocabulary.PARSER_NEGATIVE_DATA_PROPERTY_ASSERTION, new String[0]);
        this.addFactory(PARSER_OWLXMLVocabulary.PARSER_DATA_PROPERTY_ASSERTION, new String[0]);
        this.addFactory(PARSER_OWLXMLVocabulary.PARSER_ANNOTATION_ASSERTION, new String[0]);
        this.addFactory(PARSER_OWLXMLVocabulary.PARSER_ENTITY_ANNOTATION, new String[0]);
        this.addFactory(PARSER_OWLXMLVocabulary.PARSER_DECLARATION, new String[0]);
        this.addFactory(PARSER_OWLXMLVocabulary.PARSER_IRI_ELEMENT, new String[0]);
        this.addFactory(PARSER_OWLXMLVocabulary.PARSER_ABBREVIATED_IRI_ELEMENT, new String[0]);
        this.addFactory(PARSER_OWLXMLVocabulary.PARSER_ANONYMOUS_INDIVIDUAL, new String[0]);
        this.addFactory(PARSER_OWLXMLVocabulary.PARSER_HAS_KEY, new String[0]);
        this.addFactory(PARSER_OWLXMLVocabulary.PARSER_DATATYPE_DEFINITION, new String[0]);
        this.addFactory(PARSER_OWLXMLVocabulary.PARSER_DL_SAFE_RULE, new String[0]);
        this.addFactory(PARSER_OWLXMLVocabulary.PARSER_BODY, new String[0]);
        this.addFactory(PARSER_OWLXMLVocabulary.PARSER_HEAD, new String[0]);
        this.addFactory(PARSER_OWLXMLVocabulary.PARSER_VARIABLE, new String[0]);
        this.addFactory(PARSER_OWLXMLVocabulary.PARSER_CLASS_ATOM, new String[0]);
        this.addFactory(PARSER_OWLXMLVocabulary.PARSER_OBJECT_PROPERTY_ATOM, new String[0]);
        this.addFactory(PARSER_OWLXMLVocabulary.PARSER_DATA_PROPERTY_ATOM, new String[0]);
        this.addFactory(PARSER_OWLXMLVocabulary.PARSER_DATA_RANGE_ATOM, new String[0]);
        this.addFactory(PARSER_OWLXMLVocabulary.PARSER_BUILT_IN_ATOM, new String[0]);
        this.addFactory(PARSER_OWLXMLVocabulary.PARSER_DIFFERENT_INDIVIDUALS_ATOM, new String[0]);
        this.addFactory(PARSER_OWLXMLVocabulary.PARSER_SAME_INDIVIDUAL_ATOM, new String[0]);
    }

    public OWLAnonymousIndividual getOWLAnonymousIndividual(String nodeId) {
        return this.anonProvider.getOWLAnonymousIndividual(nodeId);
    }

    @Nonnull
    public OWLOntologyLoaderConfiguration getConfiguration() {
        return this.configuration;
    }

    public int getLineNumber() {
        if (this.locator != null) {
            return this.locator.getLineNumber();
        }
        return -1;
    }

    public int getColumnNumber() {
        if (this.locator != null) {
            return this.locator.getColumnNumber();
        }
        return -1;
    }

    @Nonnull
    public IRI getIRI(String iriStr) {
        try {
            IRI iri = this.iriMap.get(iriStr);
            if (iri == null) {
                URI uri = new URI(iriStr);
                if (!uri.isAbsolute()) {
                    URI base = this.getBase();
                    if (base == null) {
                        throw new OWLXMLParserException(this, "Unable to resolve relative URI");
                    }
                    iri = IRI.create((String)(base + iriStr));
                } else {
                    iri = IRI.create((URI)uri);
                }
                this.iriMap.put(iriStr, iri);
            }
            return iri;
        }
        catch (URISyntaxException e) {
            throw new OWLParserException((Throwable)e, this.getLineNumber(), this.getColumnNumber());
        }
    }

    private static String getNormalisedAbbreviatedIRI(String input) {
        if (input.indexOf(58) != -1) {
            return input;
        }
        return ':' + input;
    }

    @Nonnull
    public IRI getAbbreviatedIRI(String abbreviatedIRI) {
        int sepIndex;
        String normalisedAbbreviatedIRI = OWLXMLParserHandler.getNormalisedAbbreviatedIRI(abbreviatedIRI);
        String prefixName = normalisedAbbreviatedIRI.substring(0, (sepIndex = normalisedAbbreviatedIRI.indexOf(58)) + 1);
        String base = this.prefixName2PrefixMap.get(prefixName);
        if (base == null) {
            throw new OWLXMLParserException(this, "Prefix name not defined: " + prefixName);
        }
        String localName = normalisedAbbreviatedIRI.substring(sepIndex + 1);
        return this.getIRI(base + localName);
    }

    @Nonnull
    public Map<String, String> getPrefixName2PrefixMap() {
        return this.prefixName2PrefixMap;
    }

    private void addFactory(PARSER_OWLXMLVocabulary factory, String ... legacyElementNames) {
        this.handlerMap.put(factory.getShortName(), factory);
        for (String elementName : legacyElementNames) {
            this.handlerMap.put(elementName, factory);
        }
    }

    @Nonnull
    public OWLOntology getOntology() {
        return this.ontology;
    }

    @Nonnull
    public OWLDataFactory getDataFactory() {
        return this.getOWLOntologyManager().getOWLDataFactory();
    }

    @Override
    public void startDocument() {
    }

    @Override
    public void endDocument() {
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (!this.handlerStack.isEmpty()) {
            try {
                OWLElementHandler<?> handler = this.handlerStack.get(0);
                if (handler.isTextContentPossible()) {
                    handler.handleChars(ch, start, length);
                }
            }
            catch (OWLRuntimeException e) {
                throw new SAXException((Exception)((Object)e));
            }
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        this.processXMLBase(attributes);
        if (localName.equals(OWLXMLVocabulary.PREFIX.getShortForm())) {
            String name = attributes.getValue(OWLXMLVocabulary.NAME_ATTRIBUTE.getShortForm());
            String iriString = attributes.getValue(OWLXMLVocabulary.IRI_ATTRIBUTE.getShortForm());
            if (name != null && iriString != null) {
                if (name.endsWith(":")) {
                    this.prefixName2PrefixMap.put(name, iriString);
                } else {
                    this.prefixName2PrefixMap.put(name + ':', iriString);
                }
            }
            return;
        }
        PARSER_OWLXMLVocabulary handlerFactory = this.handlerMap.get(localName);
        if (handlerFactory != null) {
            this.atLeastOneValidTagFound = true;
            OWLElementHandler<?> handler = handlerFactory.createHandler(this);
            if (!this.handlerStack.isEmpty()) {
                handler.setParentHandler(this.handlerStack.get(0));
            }
            this.handlerStack.add(0, handler);
            for (int i = 0; i < attributes.getLength(); ++i) {
                handler.attribute(attributes.getLocalName(i), attributes.getValue(i));
            }
            handler.startElement(localName);
        }
    }

    protected void processXMLBase(Attributes attributes) {
        String base = attributes.getValue(Namespaces.XML.toString(), "base");
        if (base != null) {
            this.bases.push(URI.create(base));
        } else {
            this.bases.push(this.bases.peek());
        }
    }

    public URI getBase() {
        return this.bases.peek();
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        if (localName.equals(OWLXMLVocabulary.PREFIX.getShortForm())) {
            return;
        }
        if (!this.handlerStack.isEmpty()) {
            OWLElementHandler<?> handler = this.handlerStack.remove(0);
            handler.endElement();
        }
        this.bases.pop();
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) {
        this.prefixName2PrefixMap.put(prefix, uri);
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws IOException, SAXException {
        return super.resolveEntity(publicId, systemId);
    }

    public OWLOntologyManager getOWLOntologyManager() {
        return this.owlOntologyManager;
    }

    public boolean atLeastOneTagFound() {
        return this.atLeastOneValidTagFound;
    }
}

