/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppcrt.lists;

import com.carrotsearch.hppcrt.AbstractDoubleCollection;
import com.carrotsearch.hppcrt.AbstractIterator;
import com.carrotsearch.hppcrt.ArraySizingStrategy;
import com.carrotsearch.hppcrt.BoundedProportionalArraySizingStrategy;
import com.carrotsearch.hppcrt.BufferAllocationException;
import com.carrotsearch.hppcrt.DoubleContainer;
import com.carrotsearch.hppcrt.DoubleDeque;
import com.carrotsearch.hppcrt.DoubleIndexedContainer;
import com.carrotsearch.hppcrt.IteratorPool;
import com.carrotsearch.hppcrt.ObjectFactory;
import com.carrotsearch.hppcrt.cursors.DoubleCursor;
import com.carrotsearch.hppcrt.hash.BitMixer;
import com.carrotsearch.hppcrt.predicates.DoublePredicate;
import com.carrotsearch.hppcrt.procedures.DoubleProcedure;
import com.carrotsearch.hppcrt.sorting.DoubleSort;
import com.carrotsearch.hppcrt.strategies.DoubleComparator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoubleLinkedList
extends AbstractDoubleCollection
implements DoubleIndexedContainer,
DoubleDeque,
Cloneable {
    public double[] buffer;
    protected long[] beforeAfterPointers;
    protected static final int HEAD_POSITION = 0;
    protected static final int TAIL_POSITION = 1;
    protected int elementsCount = 2;
    protected final ArraySizingStrategy resizer;
    protected final IteratorPool<DoubleCursor, ValueIterator> valueIteratorPool;
    protected final IteratorPool<DoubleCursor, DescendingValueIterator> descendingValueIteratorPool;

    public DoubleLinkedList() {
        this(8);
    }

    public DoubleLinkedList(int initialCapacity) {
        this(initialCapacity, new BoundedProportionalArraySizingStrategy());
    }

    public DoubleLinkedList(int initialCapacity, ArraySizingStrategy resizer) {
        assert (resizer != null);
        this.resizer = resizer;
        this.ensureBufferSpace(Math.max(8, initialCapacity));
        this.elementsCount = 2;
        this.beforeAfterPointers[0] = 1L;
        this.beforeAfterPointers[1] = 1L;
        this.valueIteratorPool = new IteratorPool(new ObjectFactory<ValueIterator>(){

            @Override
            public ValueIterator create() {
                return new ValueIterator();
            }

            @Override
            public void initialize(ValueIterator obj) {
                obj.cursor.index = -1;
                obj.buffer = DoubleLinkedList.this.buffer;
                obj.pointers = DoubleLinkedList.this.beforeAfterPointers;
                obj.internalPos = 0;
            }

            @Override
            public void reset(ValueIterator obj) {
                obj.buffer = null;
                obj.pointers = null;
            }
        });
        this.descendingValueIteratorPool = new IteratorPool(new ObjectFactory<DescendingValueIterator>(){

            @Override
            public DescendingValueIterator create() {
                return new DescendingValueIterator();
            }

            @Override
            public void initialize(DescendingValueIterator obj) {
                obj.cursor.index = DoubleLinkedList.this.size();
                obj.buffer = DoubleLinkedList.this.buffer;
                obj.pointers = DoubleLinkedList.this.beforeAfterPointers;
                obj.internalPos = 1;
            }

            @Override
            public void reset(DescendingValueIterator obj) {
                obj.buffer = null;
                obj.pointers = null;
            }
        });
    }

    public DoubleLinkedList(DoubleContainer container) {
        this(container.size());
        this.addAll(container);
    }

    @Override
    public void add(double e1) {
        this.addLast(e1);
    }

    public void add(double e1, double e2) {
        this.ensureBufferSpace(2);
        this.insertAfterPosNoCheck(e1, (int)(this.beforeAfterPointers[1] >> 32));
        this.insertAfterPosNoCheck(e2, (int)(this.beforeAfterPointers[1] >> 32));
    }

    public void addLast(double ... elements) {
        this.addLast(elements, 0, elements.length);
    }

    public void addLast(double[] elements, int start, int length) {
        assert (length + start <= elements.length) : "Length is smaller than required";
        this.ensureBufferSpace(length);
        long[] beforeAfterPointers = this.beforeAfterPointers;
        for (int i = 0; i < length; ++i) {
            this.insertAfterPosNoCheck(elements[start + i], (int)(beforeAfterPointers[1] >> 32));
        }
    }

    public void add(double[] elements, int start, int length) {
        this.addLast(elements, start, length);
    }

    public void add(double ... elements) {
        this.addLast(elements, 0, elements.length);
    }

    public int addAll(DoubleContainer container) {
        return this.addLast(container);
    }

    public int addAll(Iterable<? extends DoubleCursor> iterable) {
        return this.addLast(iterable);
    }

    @Override
    public void insert(int index, double e1) {
        assert (index >= 0 && index <= this.size()) : "Index " + index + " out of bounds [" + 0 + ", " + this.size() + "].";
        this.ensureBufferSpace(1);
        if (index == 0) {
            this.insertAfterPosNoCheck(e1, 0);
        } else {
            this.insertAfterPosNoCheck(e1, this.gotoIndex(index - 1));
        }
    }

    @Override
    public double get(int index) {
        return this.buffer[this.gotoIndex(index)];
    }

    @Override
    public double set(int index, double e1) {
        int pos = this.gotoIndex(index);
        double elem = this.buffer[pos];
        this.buffer[pos] = e1;
        return elem;
    }

    @Override
    public double remove(int index) {
        int currentPos = this.gotoIndex(index);
        double elem = this.buffer[currentPos];
        this.removeAtPosNoCheck(currentPos);
        return elem;
    }

    @Override
    public void removeRange(int fromIndex, int toIndex) {
        this.checkRangeBounds(fromIndex, toIndex);
        if (fromIndex == toIndex) {
            return;
        }
        int currentPos = this.gotoIndex(fromIndex);
        int size = toIndex - fromIndex;
        for (int count = 0; count < size; ++count) {
            currentPos = this.removeAtPosNoCheck(currentPos);
        }
    }

    @Override
    public int removeFirst(double e1) {
        long[] pointers = this.beforeAfterPointers;
        double[] buffer = this.buffer;
        int currentPos = (int)(pointers[0] & 0xFFFFFFFFL);
        int count = 0;
        while (currentPos != 1) {
            if (Double.doubleToLongBits(e1) == Double.doubleToLongBits(buffer[currentPos])) {
                this.removeAtPosNoCheck(currentPos);
                return count;
            }
            currentPos = (int)(pointers[currentPos] & 0xFFFFFFFFL);
            ++count;
        }
        return -1;
    }

    @Override
    public int removeLast(double e1) {
        long[] pointers = this.beforeAfterPointers;
        double[] buffer = this.buffer;
        int size = this.size();
        int currentPos = (int)(pointers[1] >> 32);
        int count = 0;
        while (currentPos != 0) {
            if (Double.doubleToLongBits(e1) == Double.doubleToLongBits(buffer[currentPos])) {
                this.removeAtPosNoCheck(currentPos);
                return size - count - 1;
            }
            currentPos = (int)(pointers[currentPos] >> 32);
            ++count;
        }
        return -1;
    }

    @Override
    public int removeAll(double e1) {
        double[] buffer = this.buffer;
        int deleted = 0;
        int pos = 2;
        while (pos < this.elementsCount) {
            if (Double.doubleToLongBits(e1) == Double.doubleToLongBits(buffer[pos])) {
                this.removeAtPosNoCheck(pos);
                ++deleted;
                continue;
            }
            ++pos;
        }
        return deleted;
    }

    @Override
    public boolean contains(double e1) {
        return this.indexOf(e1) >= 0;
    }

    @Override
    public int indexOf(double e1) {
        long[] pointers = this.beforeAfterPointers;
        double[] buffer = this.buffer;
        int currentPos = (int)(pointers[0] & 0xFFFFFFFFL);
        int count = 0;
        while (currentPos != 1) {
            if (Double.doubleToLongBits(e1) == Double.doubleToLongBits(buffer[currentPos])) {
                return count;
            }
            currentPos = (int)(pointers[currentPos] & 0xFFFFFFFFL);
            ++count;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(double e1) {
        long[] pointers = this.beforeAfterPointers;
        double[] buffer = this.buffer;
        int currentPos = (int)(pointers[1] >> 32);
        int count = 0;
        while (currentPos != 0) {
            if (Double.doubleToLongBits(e1) == Double.doubleToLongBits(buffer[currentPos])) {
                return this.size() - count - 1;
            }
            currentPos = (int)(pointers[currentPos] >> 32);
            ++count;
        }
        return -1;
    }

    public void ensureCapacity(int minCapacity) {
        if (minCapacity > this.buffer.length) {
            this.ensureBufferSpace(minCapacity - this.size());
        }
    }

    protected boolean ensureBufferSpace(int expectedAdditions) {
        int bufferLen;
        int n = bufferLen = this.buffer == null ? 0 : this.buffer.length;
        if (this.elementsCount > bufferLen - expectedAdditions) {
            int newSize = this.resizer.grow(bufferLen, this.elementsCount, expectedAdditions);
            if (this.buffer == null) {
                newSize += 2;
            }
            try {
                double[] newBuffer = new double[newSize];
                long[] newPointers = new long[newSize];
                if (bufferLen > 0) {
                    System.arraycopy(this.buffer, 0, newBuffer, 0, this.buffer.length);
                    System.arraycopy(this.beforeAfterPointers, 0, newPointers, 0, this.beforeAfterPointers.length);
                }
                this.buffer = newBuffer;
                this.beforeAfterPointers = newPointers;
            }
            catch (OutOfMemoryError e) {
                throw new BufferAllocationException("Not enough memory to allocate buffers to grow from %d -> %d elements", (Throwable)e, bufferLen, newSize);
            }
            return true;
        }
        return false;
    }

    @Override
    public int size() {
        return this.elementsCount - 2;
    }

    @Override
    public int capacity() {
        return this.buffer.length - 2;
    }

    @Override
    public void clear() {
        this.elementsCount = 2;
        this.beforeAfterPointers[0] = 1L;
        this.beforeAfterPointers[1] = 1L;
    }

    @Override
    public double[] toArray(double[] target) {
        long[] pointers = this.beforeAfterPointers;
        double[] buffer = this.buffer;
        int index = 0;
        int currentPos = (int)(pointers[0] & 0xFFFFFFFFL);
        while (currentPos != 1) {
            target[index] = buffer[currentPos];
            currentPos = (int)(pointers[currentPos] & 0xFFFFFFFFL);
            ++index;
        }
        return target;
    }

    public DoubleLinkedList clone() {
        DoubleLinkedList cloned = new DoubleLinkedList(8, this.resizer);
        cloned.buffer = (double[])this.buffer.clone();
        cloned.beforeAfterPointers = (long[])this.beforeAfterPointers.clone();
        cloned.elementsCount = this.elementsCount;
        return cloned;
    }

    public int hashCode() {
        long[] pointers = this.beforeAfterPointers;
        double[] buffer = this.buffer;
        int h = 1;
        int currentPos = (int)(pointers[0] & 0xFFFFFFFFL);
        while (currentPos != 1) {
            h = 31 * h + BitMixer.mix(buffer[currentPos]);
            currentPos = (int)(pointers[currentPos] & 0xFFFFFFFFL);
        }
        return h;
    }

    public boolean equals(Object obj) {
        if (obj != null) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof DoubleDeque) && !(obj instanceof DoubleIndexedContainer)) {
                return false;
            }
            DoubleContainer other = (DoubleContainer)obj;
            if (other.size() != this.size()) {
                return false;
            }
            ValueIterator it = this.iterator();
            AbstractIterator itOther = (AbstractIterator)other.iterator();
            while (it.hasNext()) {
                double myVal = ((DoubleCursor)it.next()).value;
                double otherVal = ((DoubleCursor)itOther.next()).value;
                if (Double.doubleToLongBits(myVal) == Double.doubleToLongBits(otherVal)) continue;
                it.release();
                itOther.release();
                return false;
            }
            itOther.release();
            return true;
        }
        return false;
    }

    protected int gotoIndex(int index) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException("Index " + index + " out of bounds [" + 0 + ", size=" + this.size() + "[.");
        }
        int currentPos = 1;
        int currentIndex = -1;
        long[] pointers = this.beforeAfterPointers;
        if ((double)index <= (double)this.elementsCount / 2.0) {
            currentPos = (int)(pointers[0] & 0xFFFFFFFFL);
            for (currentIndex = 0; currentIndex < index && currentPos != 1; ++currentIndex) {
                currentPos = (int)(pointers[currentPos] & 0xFFFFFFFFL);
            }
        } else {
            currentPos = (int)(pointers[1] >> 32);
            for (currentIndex = this.size() - 1; currentIndex > index && currentPos != 0; --currentIndex) {
                currentPos = (int)(pointers[currentPos] >> 32);
            }
        }
        assert (currentIndex == index);
        return currentPos;
    }

    private void insertAfterPosNoCheck(double e1, int insertionPos) {
        long[] pointers = this.beforeAfterPointers;
        int nextAfterInsertionPos = (int)(pointers[insertionPos] & 0xFFFFFFFFL);
        pointers[this.elementsCount] = (long)insertionPos << 32 | (long)nextAfterInsertionPos;
        pointers[insertionPos] = (long)this.elementsCount | pointers[insertionPos] & 0xFFFFFFFF00000000L;
        pointers[nextAfterInsertionPos] = (long)this.elementsCount << 32 | pointers[nextAfterInsertionPos] & 0xFFFFFFFFL;
        this.buffer[this.elementsCount] = e1;
        ++this.elementsCount;
    }

    private int removeAtPosNoCheck(int removalPos) {
        long[] pointers = this.beforeAfterPointers;
        int beforeRemovalPos = (int)(pointers[removalPos] >> 32);
        int afterRemovalPos = (int)(pointers[removalPos] & 0xFFFFFFFFL);
        pointers[beforeRemovalPos] = (long)afterRemovalPos | pointers[beforeRemovalPos] & 0xFFFFFFFF00000000L;
        pointers[afterRemovalPos] = (long)beforeRemovalPos << 32 | pointers[afterRemovalPos] & 0xFFFFFFFFL;
        if (removalPos != this.elementsCount - 1) {
            int beforeLastElementPos = (int)(pointers[this.elementsCount - 1] >> 32);
            int afterLastElementPos = (int)(pointers[this.elementsCount - 1] & 0xFFFFFFFFL);
            this.buffer[removalPos] = this.buffer[this.elementsCount - 1];
            pointers[removalPos] = pointers[this.elementsCount - 1];
            pointers[beforeLastElementPos] = (long)removalPos | pointers[beforeLastElementPos] & 0xFFFFFFFF00000000L;
            pointers[afterLastElementPos] = (long)removalPos << 32 | pointers[afterLastElementPos] & 0xFFFFFFFFL;
        }
        --this.elementsCount;
        return (int)(pointers[beforeRemovalPos] & 0xFFFFFFFFL);
    }

    public ValueIterator iterator() {
        return (ValueIterator)this.valueIteratorPool.borrow();
    }

    public DescendingValueIterator descendingIterator() {
        return (DescendingValueIterator)this.descendingValueIteratorPool.borrow();
    }

    @Override
    public <T extends DoubleProcedure> T forEach(T procedure) {
        this.forEach(procedure, 0, this.size());
        return procedure;
    }

    @Override
    public <T extends DoubleProcedure> T forEach(T procedure, int fromIndex, int toIndex) {
        this.internalForEach(procedure, fromIndex, toIndex);
        return procedure;
    }

    private void internalForEach(DoubleProcedure procedure, int fromIndex, int toIndex) {
        this.checkRangeBounds(fromIndex, toIndex);
        if (fromIndex == toIndex) {
            return;
        }
        int currentPos = this.gotoIndex(fromIndex);
        long[] pointers = this.beforeAfterPointers;
        double[] buffer = this.buffer;
        int size = toIndex - fromIndex;
        for (int count = 0; count < size; ++count) {
            procedure.apply(buffer[currentPos]);
            currentPos = (int)(pointers[currentPos] & 0xFFFFFFFFL);
        }
    }

    @Override
    public <T extends DoublePredicate> T forEach(T predicate) {
        this.forEach(predicate, 0, this.size());
        return predicate;
    }

    @Override
    public <T extends DoublePredicate> T forEach(T predicate, int fromIndex, int toIndex) {
        this.internalForEach(predicate, fromIndex, toIndex);
        return predicate;
    }

    private void internalForEach(DoublePredicate predicate, int fromIndex, int toIndex) {
        this.checkRangeBounds(fromIndex, toIndex);
        if (fromIndex == toIndex) {
            return;
        }
        int currentPos = this.gotoIndex(fromIndex);
        long[] pointers = this.beforeAfterPointers;
        double[] buffer = this.buffer;
        int size = toIndex - fromIndex;
        for (int count = 0; count < size && predicate.apply(buffer[currentPos]); ++count) {
            currentPos = (int)(pointers[currentPos] & 0xFFFFFFFFL);
        }
    }

    @Override
    public <T extends DoubleProcedure> T descendingForEach(T procedure) {
        long[] pointers = this.beforeAfterPointers;
        double[] buffer = this.buffer;
        int currentPos = (int)(pointers[1] >> 32);
        while (currentPos != 0) {
            procedure.apply(buffer[currentPos]);
            currentPos = (int)(pointers[currentPos] >> 32);
        }
        return procedure;
    }

    @Override
    public <T extends DoublePredicate> T descendingForEach(T predicate) {
        long[] pointers = this.beforeAfterPointers;
        double[] buffer = this.buffer;
        int currentPos = (int)(pointers[1] >> 32);
        while (currentPos != 0 && predicate.apply(buffer[currentPos])) {
            currentPos = (int)(pointers[currentPos] >> 32);
        }
        return predicate;
    }

    @Override
    public int removeAll(DoublePredicate predicate) {
        double[] buffer = this.buffer;
        int deleted = 0;
        int pos = 2;
        while (pos < this.elementsCount) {
            if (predicate.apply(buffer[pos])) {
                this.removeAtPosNoCheck(pos);
                ++deleted;
                continue;
            }
            ++pos;
        }
        return deleted;
    }

    public static DoubleLinkedList newInstance() {
        return new DoubleLinkedList();
    }

    public static DoubleLinkedList newInstance(int initialCapacity) {
        return new DoubleLinkedList(initialCapacity);
    }

    public static DoubleLinkedList from(double ... elements) {
        DoubleLinkedList list = new DoubleLinkedList(elements.length);
        list.add(elements);
        return list;
    }

    public static DoubleLinkedList from(DoubleContainer container) {
        return new DoubleLinkedList(container);
    }

    public void sort(int beginIndex, int endIndex) {
        DoubleSort.quicksort(this, beginIndex, endIndex);
    }

    public void sort(int beginIndex, int endIndex, DoubleComparator comp) {
        DoubleSort.quicksort(this, beginIndex, endIndex, comp);
    }

    public void sort() {
        if (this.elementsCount > 3) {
            int elementsCount = this.elementsCount;
            long[] pointers = this.beforeAfterPointers;
            DoubleSort.quicksort(this.buffer, 2, elementsCount);
            pointers[0] = 2L;
            pointers[2] = 3L;
            for (int pos = 3; pos < elementsCount - 1; ++pos) {
                pointers[pos] = (long)(pos - 1) << 32 | (long)(pos + 1);
            }
            pointers[elementsCount - 1] = (long)(elementsCount - 2) << 32 | 1L;
            pointers[1] = (long)(elementsCount - 1) << 32 | 1L;
        }
    }

    public void sort(DoubleComparator comp) {
        if (this.elementsCount > 3) {
            int elementsCount = this.elementsCount;
            long[] pointers = this.beforeAfterPointers;
            DoubleSort.quicksort(this.buffer, 2, elementsCount, comp);
            pointers[0] = 2L;
            pointers[2] = 3L;
            for (int pos = 3; pos < elementsCount - 1; ++pos) {
                pointers[pos] = (long)(pos - 1) << 32 | (long)(pos + 1);
            }
            pointers[elementsCount - 1] = (long)(elementsCount - 2) << 32 | 1L;
            pointers[1] = (long)(elementsCount - 1) << 32 | 1L;
        }
    }

    @Override
    public void addFirst(double e1) {
        this.ensureBufferSpace(1);
        this.insertAfterPosNoCheck(e1, 0);
    }

    public int addFirst(DoubleContainer container) {
        return this.addFirst((Iterable<? extends DoubleCursor>)container);
    }

    public void addFirst(double ... elements) {
        this.ensureBufferSpace(elements.length);
        for (int i = 0; i < elements.length; ++i) {
            this.insertAfterPosNoCheck(elements[i], 0);
        }
    }

    public int addFirst(Iterable<? extends DoubleCursor> iterable) {
        int size = 0;
        for (DoubleCursor doubleCursor : iterable) {
            this.ensureBufferSpace(1);
            this.insertAfterPosNoCheck(doubleCursor.value, 0);
            ++size;
        }
        return size;
    }

    @Override
    public void addLast(double e1) {
        this.ensureBufferSpace(1);
        this.insertAfterPosNoCheck(e1, (int)(this.beforeAfterPointers[1] >> 32));
    }

    public int addLast(DoubleContainer container) {
        return this.addLast((Iterable<? extends DoubleCursor>)container);
    }

    public int addLast(Iterable<? extends DoubleCursor> iterable) {
        int size = 0;
        for (DoubleCursor doubleCursor : iterable) {
            this.ensureBufferSpace(1);
            this.insertAfterPosNoCheck(doubleCursor.value, (int)(this.beforeAfterPointers[1] >> 32));
            ++size;
        }
        return size;
    }

    @Override
    public double removeFirst() {
        assert (this.size() > 0);
        int removedPos = (int)(this.beforeAfterPointers[0] & 0xFFFFFFFFL);
        double elem = this.buffer[removedPos];
        this.removeAtPosNoCheck(removedPos);
        return elem;
    }

    @Override
    public double removeLast() {
        assert (this.size() > 0);
        int removedPos = (int)(this.beforeAfterPointers[1] >> 32);
        double elem = this.buffer[removedPos];
        this.removeAtPosNoCheck(removedPos);
        return elem;
    }

    @Override
    public double getFirst() {
        assert (this.size() > 0);
        return this.buffer[(int)(this.beforeAfterPointers[0] & 0xFFFFFFFFL)];
    }

    @Override
    public double getLast() {
        assert (this.size() > 0);
        return this.buffer[(int)(this.beforeAfterPointers[1] >> 32)];
    }

    private void checkRangeBounds(int beginIndex, int endIndex) {
        if (beginIndex > endIndex) {
            throw new IllegalArgumentException("Index beginIndex " + beginIndex + " is > endIndex " + endIndex);
        }
        if (beginIndex < 0) {
            throw new IndexOutOfBoundsException("Index beginIndex < 0");
        }
        if (endIndex > this.size()) {
            throw new IndexOutOfBoundsException("Index endIndex " + endIndex + " out of bounds [" + 0 + ", " + this.size() + "].");
        }
    }

    public final class DescendingValueIterator
    extends ValueIterator {
        public DescendingValueIterator() {
            this.cursor.index = DoubleLinkedList.this.size();
            this.buffer = DoubleLinkedList.this.buffer;
            this.pointers = DoubleLinkedList.this.beforeAfterPointers;
            this.internalPos = 1;
        }

        protected DoubleCursor fetch() {
            int previousPos;
            if (this.cursor.index == 0) {
                return (DoubleCursor)this.done();
            }
            this.internalPos = previousPos = (int)(this.pointers[this.internalPos] >> 32);
            --this.cursor.index;
            this.cursor.value = this.buffer[previousPos];
            return this.cursor;
        }

        public boolean hasAfter() {
            return super.hasBefore();
        }

        public boolean hasBefore() {
            return super.hasAfter();
        }

        public ValueIterator gotoHead() {
            return super.gotoTail();
        }

        public DescendingValueIterator gotoTail() {
            return (DescendingValueIterator)super.gotoHead();
        }

        public DescendingValueIterator gotoNext() {
            return (DescendingValueIterator)super.gotoPrevious();
        }

        public DescendingValueIterator gotoPrevious() {
            return (DescendingValueIterator)super.gotoNext();
        }

        public double getNext() {
            return super.getPrevious();
        }

        public double getPrevious() {
            return super.getNext();
        }

        public double removeNext() {
            return super.removePrevious();
        }

        public double removePrevious() {
            return super.removeNext();
        }

        public void insertBefore(double e1) {
            super.insertAfter(e1);
        }

        public void insertAfter(double e1) {
            super.insertBefore(e1);
        }

        public DescendingValueIterator delete() {
            if (this.internalPos == 0 || this.internalPos == 1) {
                throw new IndexOutOfBoundsException("Cannot delete while pointing at head or tail");
            }
            int nextPos = DoubleLinkedList.this.removeAtPosNoCheck(this.internalPos);
            this.internalPos = (int)(this.pointers[nextPos] >> 32);
            this.cursor.value = this.buffer[this.internalPos];
            --this.cursor.index;
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ValueIterator
    extends AbstractIterator<DoubleCursor> {
        public final DoubleCursor cursor = new DoubleCursor();
        double[] buffer;
        int internalPos;
        long[] pointers;

        public ValueIterator() {
            this.cursor.index = -1;
            this.buffer = DoubleLinkedList.this.buffer;
            this.pointers = DoubleLinkedList.this.beforeAfterPointers;
            this.internalPos = 0;
        }

        @Override
        protected DoubleCursor fetch() {
            int nextPos;
            if (this.cursor.index + 1 == DoubleLinkedList.this.size()) {
                return (DoubleCursor)this.done();
            }
            this.internalPos = nextPos = (int)(this.pointers[this.internalPos] & 0xFFFFFFFFL);
            ++this.cursor.index;
            this.cursor.value = this.buffer[nextPos];
            return this.cursor;
        }

        public boolean hasAfter() {
            int nextPos = (int)(this.pointers[this.internalPos] & 0xFFFFFFFFL);
            return nextPos != 1;
        }

        public boolean hasBefore() {
            int beforePos = (int)(this.pointers[this.internalPos] >> 32);
            return beforePos != 0;
        }

        public ValueIterator gotoHead() {
            this.internalPos = 0;
            this.cursor.index = -1;
            return this;
        }

        public ValueIterator gotoTail() {
            this.internalPos = 1;
            this.cursor.index = DoubleLinkedList.this.size();
            return this;
        }

        public ValueIterator gotoNext() {
            this.internalPos = (int)(this.pointers[this.internalPos] & 0xFFFFFFFFL);
            if (this.internalPos == 1) {
                this.cursor.index = DoubleLinkedList.this.size();
            } else {
                ++this.cursor.index;
                this.cursor.value = this.buffer[this.internalPos];
            }
            return this;
        }

        public ValueIterator gotoPrevious() {
            this.internalPos = (int)(this.pointers[this.internalPos] >> 32);
            if (this.internalPos == 0) {
                this.cursor.index = -1;
            } else {
                --this.cursor.index;
                this.cursor.value = this.buffer[this.internalPos];
            }
            return this;
        }

        public double getNext() {
            int nextPos = (int)(this.pointers[this.internalPos] & 0xFFFFFFFFL);
            if (nextPos == 1) {
                throw new NoSuchElementException("Either no next element (forward iterator) or previous element (backward iterator)");
            }
            return this.buffer[nextPos];
        }

        public double getPrevious() {
            int beforePos = (int)(this.pointers[this.internalPos] >> 32);
            if (beforePos == 0) {
                throw new NoSuchElementException("Either no previous element (forward iterator) or next element (backward iterator)");
            }
            return this.buffer[beforePos];
        }

        public double removeNext() {
            int nextPos = (int)(this.pointers[this.internalPos] & 0xFFFFFFFFL);
            if (nextPos == 1) {
                throw new NoSuchElementException("Either no next element to remove (forward iterator) or previous element to remove (backward iterator)");
            }
            double value = this.buffer[nextPos];
            DoubleLinkedList.this.removeAtPosNoCheck(nextPos);
            return value;
        }

        public double removePrevious() {
            int previousPos = (int)(this.pointers[this.internalPos] >> 32);
            if (previousPos == 0) {
                throw new NoSuchElementException("Either no previous element to remove (forward iterator) or next element to remove (backward iterator)");
            }
            double value = this.buffer[previousPos];
            this.internalPos = DoubleLinkedList.this.removeAtPosNoCheck(previousPos);
            --this.cursor.index;
            return value;
        }

        public void insertBefore(double e1) {
            if (this.internalPos == 0) {
                throw new IndexOutOfBoundsException("Either cannot insert before (forward iterator) or insert after (backward iterator)");
            }
            if (DoubleLinkedList.this.ensureBufferSpace(1)) {
                this.pointers = DoubleLinkedList.this.beforeAfterPointers;
                this.buffer = DoubleLinkedList.this.buffer;
            }
            int beforePos = (int)(this.pointers[this.internalPos] >> 32);
            DoubleLinkedList.this.insertAfterPosNoCheck(e1, beforePos);
            ++this.cursor.index;
        }

        public void insertAfter(double e1) {
            if (this.internalPos == 1) {
                throw new IndexOutOfBoundsException("Either cannot insert after (forward iterator) or insert before (backward iterator)");
            }
            if (DoubleLinkedList.this.ensureBufferSpace(1)) {
                this.pointers = DoubleLinkedList.this.beforeAfterPointers;
                this.buffer = DoubleLinkedList.this.buffer;
            }
            DoubleLinkedList.this.insertAfterPosNoCheck(e1, this.internalPos);
        }

        public void set(double e1) {
            if (this.internalPos == 0 || this.internalPos == 1) {
                throw new IndexOutOfBoundsException("Cannot set while pointing at head or tail");
            }
            this.buffer[this.internalPos] = e1;
            this.cursor.value = e1;
        }

        public ValueIterator delete() {
            if (this.internalPos == 0 || this.internalPos == 1) {
                throw new IndexOutOfBoundsException("Cannot delete while pointing at head or tail");
            }
            this.internalPos = DoubleLinkedList.this.removeAtPosNoCheck(this.internalPos);
            this.cursor.value = this.buffer[this.internalPos];
            return this;
        }
    }
}

