/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.obo12.parser;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.coode.owlapi.obo12.parser.AbstractTagValueHandler;
import org.coode.owlapi.obo12.parser.OBOConsumer;
import org.coode.owlapi.obo12.parser.OBOVocabulary;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;

class RelationshipTagValueHandler
extends AbstractTagValueHandler {
    private Pattern tagValuePattern = Pattern.compile("([^\\s]*)\\s*([^\\s]*)\\s*(\\{([^\\}]*)\\})?");

    public RelationshipTagValueHandler(@Nonnull OBOConsumer consumer) {
        super(OBOVocabulary.RELATIONSHIP.getName(), consumer);
    }

    @Override
    public void handle(String currentId, String value, String qualifierBlock, String comment) {
        Matcher matcher = this.tagValuePattern.matcher(value);
        if (matcher.matches()) {
            IRI propIRI = this.getConsumer().getRelationIRIFromSymbolicIdOrOBOId(matcher.group(1));
            IRI fillerIRI = this.getIRIFromOBOId(matcher.group(2));
            OWLObjectProperty prop = this.getDataFactory().getOWLObjectProperty(propIRI);
            OWLClass filler = this.getDataFactory().getOWLClass(fillerIRI);
            OWLObjectSomeValuesFrom restriction = this.getDataFactory().getOWLObjectSomeValuesFrom(prop, filler);
            OWLClass subCls = this.getDataFactory().getOWLClass(this.getIRIFromOBOId(currentId));
            this.applyChange(new AddAxiom(this.getOntology(), this.getDataFactory().getOWLSubClassOfAxiom(subCls, restriction)));
            this.applyChange(new AddAxiom(this.getOntology(), this.getDataFactory().getOWLDeclarationAxiom(prop)));
        }
    }
}

