# Generated by Django 5.1.1 on 2024-10-02 17:51

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):
    initial = True

    dependencies = []

    def insert_utc_timezone(apps, schema_editor):
        Timezone = apps.get_model("recurring", "Timezone")
        Timezone.objects.create(id=1, name="UTC")

    operations = [
        migrations.CreateModel(
            name="CalendarEntry",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "name",
                    models.CharField(
                        blank=True,
                        help_text="The name of the calendar entry. Will be used as the ical summary",
                        max_length=255,
                        null=True,
                    ),
                ),
                (
                    "description",
                    models.TextField(
                        blank=True, help_text="A description of the calendar entry"
                    ),
                ),
                (
                    "next_occurrence",
                    models.DateTimeField(
                        blank=True,
                        help_text="The next occurrence of this calendar entry",
                        null=True,
                    ),
                ),
                (
                    "previous_occurrence",
                    models.DateTimeField(
                        blank=True,
                        help_text="The previous occurrence of this calendar entry",
                        null=True,
                    ),
                ),
            ],
            options={
                "verbose_name_plural": "Calendar entries",
            },
        ),
        migrations.CreateModel(
            name="RecurrenceRule",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "frequency",
                    models.IntegerField(
                        choices=[
                            (0, "YEARLY"),
                            (1, "MONTHLY"),
                            (2, "WEEKLY"),
                            (3, "DAILY"),
                            (4, "HOURLY"),
                            (5, "MINUTELY"),
                            (6, "SECONDLY"),
                        ],
                        help_text="The frequency of the recurrence",
                    ),
                ),
                (
                    "interval",
                    models.IntegerField(
                        default=1, help_text="The interval between each freq iteration"
                    ),
                ),
                (
                    "wkst",
                    models.IntegerField(
                        blank=True,
                        choices=[
                            (0, "MO"),
                            (1, "TU"),
                            (2, "WE"),
                            (3, "TH"),
                            (4, "FR"),
                            (5, "SA"),
                            (6, "SU"),
                        ],
                        help_text="The week start day",
                        null=True,
                    ),
                ),
                (
                    "count",
                    models.IntegerField(
                        blank=True,
                        help_text="How many occurrences will be generated",
                        null=True,
                    ),
                ),
                (
                    "until",
                    models.DateTimeField(
                        blank=True,
                        help_text="The date and time until which occurrences will be generated",
                        null=True,
                    ),
                ),
                (
                    "bysetpos",
                    models.JSONField(
                        blank=True, help_text="By position (BYSETPOS)", null=True
                    ),
                ),
                (
                    "bymonth",
                    models.JSONField(
                        blank=True, help_text="By month (BYMONTH)", null=True
                    ),
                ),
                (
                    "bymonthday",
                    models.JSONField(
                        blank=True, help_text="By month day (BYMONTHDAY)", null=True
                    ),
                ),
                (
                    "byyearday",
                    models.JSONField(
                        blank=True, help_text="By year day (BYYEARDAY)", null=True
                    ),
                ),
                (
                    "byweekno",
                    models.JSONField(
                        blank=True, help_text="By week number (BYWEEKNO)", null=True
                    ),
                ),
                (
                    "byweekday",
                    models.JSONField(
                        blank=True, help_text="By weekday (BYDAY)", null=True
                    ),
                ),
                (
                    "byhour",
                    models.JSONField(
                        blank=True, help_text="By hour (BYHOUR)", null=True
                    ),
                ),
                (
                    "byminute",
                    models.JSONField(
                        blank=True, help_text="By minute (BYMINUTE)", null=True
                    ),
                ),
                (
                    "bysecond",
                    models.JSONField(
                        blank=True, help_text="By second (BYSECOND)", null=True
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="Timezone",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "name",
                    models.CharField(
                        help_text="The name of the timezone", max_length=64, unique=True
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="Event",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("start_time", models.DateTimeField()),
                ("end_time", models.DateTimeField(blank=True, null=True)),
                ("is_full_day", models.BooleanField(default=False)),
                (
                    "calendar_entry",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="events",
                        to="recurring.calendarentry",
                    ),
                ),
                (
                    "recurrence_rule",
                    models.OneToOneField(
                        blank=True,
                        help_text="The recurrence rule",
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="recurring.recurrencerule",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="ExclusionDateRange",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "start_date",
                    models.DateTimeField(
                        help_text="The start date of the exclusion range"
                    ),
                ),
                (
                    "end_date",
                    models.DateTimeField(
                        help_text="The end date of the exclusion range"
                    ),
                ),
                (
                    "event",
                    models.ForeignKey(
                        help_text="The event this exclusion date range belongs to",
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="exclusions",
                        to="recurring.event",
                    ),
                ),
            ],
        ),
        migrations.AddField(
            model_name="calendarentry",
            name="timezone",
            field=models.ForeignKey(
                default=1,
                help_text="The timezone for this calendar entry",
                on_delete=django.db.models.deletion.SET_DEFAULT,
                to="recurring.timezone",
            ),
        ),
        migrations.RunPython(insert_utc_timezone),
    ]
