import * as cdk from '@aws-cdk/core';
import * as cfn_parse from '@aws-cdk/core/lib/cfn-parse';
/**
 * Properties for defining a `AWS::Cloud9::EnvironmentEC2`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloud9-environmentec2.html
 * @external
 */
export interface CfnEnvironmentEC2Props {
    /**
     * `AWS::Cloud9::EnvironmentEC2.InstanceType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloud9-environmentec2.html#cfn-cloud9-environmentec2-instancetype
     * @external
     */
    readonly instanceType: string;
    /**
     * `AWS::Cloud9::EnvironmentEC2.AutomaticStopTimeMinutes`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloud9-environmentec2.html#cfn-cloud9-environmentec2-automaticstoptimeminutes
     * @external
     */
    readonly automaticStopTimeMinutes?: number;
    /**
     * `AWS::Cloud9::EnvironmentEC2.ConnectionType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloud9-environmentec2.html#cfn-cloud9-environmentec2-connectiontype
     * @external
     */
    readonly connectionType?: string;
    /**
     * `AWS::Cloud9::EnvironmentEC2.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloud9-environmentec2.html#cfn-cloud9-environmentec2-description
     * @external
     */
    readonly description?: string;
    /**
     * `AWS::Cloud9::EnvironmentEC2.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloud9-environmentec2.html#cfn-cloud9-environmentec2-name
     * @external
     */
    readonly name?: string;
    /**
     * `AWS::Cloud9::EnvironmentEC2.OwnerArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloud9-environmentec2.html#cfn-cloud9-environmentec2-ownerarn
     * @external
     */
    readonly ownerArn?: string;
    /**
     * `AWS::Cloud9::EnvironmentEC2.Repositories`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloud9-environmentec2.html#cfn-cloud9-environmentec2-repositories
     * @external
     */
    readonly repositories?: Array<CfnEnvironmentEC2.RepositoryProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::Cloud9::EnvironmentEC2.SubnetId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloud9-environmentec2.html#cfn-cloud9-environmentec2-subnetid
     * @external
     */
    readonly subnetId?: string;
    /**
     * `AWS::Cloud9::EnvironmentEC2.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloud9-environmentec2.html#cfn-cloud9-environmentec2-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::Cloud9::EnvironmentEC2`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloud9-environmentec2.html
 * @external
 * @cloudformationResource AWS::Cloud9::EnvironmentEC2
 */
export declare class CfnEnvironmentEC2 extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Cloud9::EnvironmentEC2";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnEnvironmentEC2;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute Name
     */
    readonly attrName: string;
    /**
     * `AWS::Cloud9::EnvironmentEC2.InstanceType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloud9-environmentec2.html#cfn-cloud9-environmentec2-instancetype
     * @external
     */
    instanceType: string;
    /**
     * `AWS::Cloud9::EnvironmentEC2.AutomaticStopTimeMinutes`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloud9-environmentec2.html#cfn-cloud9-environmentec2-automaticstoptimeminutes
     * @external
     */
    automaticStopTimeMinutes: number | undefined;
    /**
     * `AWS::Cloud9::EnvironmentEC2.ConnectionType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloud9-environmentec2.html#cfn-cloud9-environmentec2-connectiontype
     * @external
     */
    connectionType: string | undefined;
    /**
     * `AWS::Cloud9::EnvironmentEC2.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloud9-environmentec2.html#cfn-cloud9-environmentec2-description
     * @external
     */
    description: string | undefined;
    /**
     * `AWS::Cloud9::EnvironmentEC2.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloud9-environmentec2.html#cfn-cloud9-environmentec2-name
     * @external
     */
    name: string | undefined;
    /**
     * `AWS::Cloud9::EnvironmentEC2.OwnerArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloud9-environmentec2.html#cfn-cloud9-environmentec2-ownerarn
     * @external
     */
    ownerArn: string | undefined;
    /**
     * `AWS::Cloud9::EnvironmentEC2.Repositories`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloud9-environmentec2.html#cfn-cloud9-environmentec2-repositories
     * @external
     */
    repositories: Array<CfnEnvironmentEC2.RepositoryProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::Cloud9::EnvironmentEC2.SubnetId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloud9-environmentec2.html#cfn-cloud9-environmentec2-subnetid
     * @external
     */
    subnetId: string | undefined;
    /**
     * `AWS::Cloud9::EnvironmentEC2.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloud9-environmentec2.html#cfn-cloud9-environmentec2-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::Cloud9::EnvironmentEC2`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnEnvironmentEC2Props);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Cloud9::EnvironmentEC2`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloud9-environmentec2.html
 * @external
 * @cloudformationResource AWS::Cloud9::EnvironmentEC2
 */
export declare namespace CfnEnvironmentEC2 {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloud9-environmentec2-repository.html
     * @external
     */
    interface RepositoryProperty {
        /**
         * `CfnEnvironmentEC2.RepositoryProperty.PathComponent`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloud9-environmentec2-repository.html#cfn-cloud9-environmentec2-repository-pathcomponent
         * @external
         */
        readonly pathComponent: string;
        /**
         * `CfnEnvironmentEC2.RepositoryProperty.RepositoryUrl`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloud9-environmentec2-repository.html#cfn-cloud9-environmentec2-repository-repositoryurl
         * @external
         */
        readonly repositoryUrl: string;
    }
}
