"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DynamoDBSeeder = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const aws_iam_1 = require("@aws-cdk/aws-iam");
const aws_lambda_1 = require("@aws-cdk/aws-lambda");
const aws_s3_1 = require("@aws-cdk/aws-s3");
const core_1 = require("@aws-cdk/core");
class DynamoDBSeeder extends core_1.Construct {
    constructor(scope, id, props) {
        var _b, _c, _d, _e;
        super(scope, id);
        const seeds = props.seeds.bind(this);
        const seedsBucket = ((_b = seeds.s3Location) === null || _b === void 0 ? void 0 : _b.bucketName) ? aws_s3_1.Bucket.fromBucketName(this, 'SeedsBucket', seeds.s3Location.bucketName) : undefined;
        const handler = new aws_lambda_1.SingletonFunction(this, 'CustomResourceHandler', {
            uuid: 'Custom::DynamodbSeeder',
            runtime: aws_lambda_1.Runtime.NODEJS_12_X,
            code: aws_lambda_1.Code.fromAsset(path.join(__dirname, 'lambdas', 'dynamodb-seeder')),
            handler: 'index.handler',
            lambdaPurpose: 'Custom::DynamodbSeeder',
            timeout: (_c = props.timeout) !== null && _c !== void 0 ? _c : core_1.Duration.minutes(15),
        });
        handler.addToRolePolicy(new aws_iam_1.PolicyStatement({
            effect: aws_iam_1.Effect.ALLOW,
            actions: ['dynamodb:BatchWriteItem'],
            resources: [props.table.tableArn],
        }));
        if (props.table.encryptionKey) {
            handler.addToRolePolicy(new aws_iam_1.PolicyStatement({
                effect: aws_iam_1.Effect.ALLOW,
                actions: ['kms:Encrypt', 'kms:Decrypt', 'kms:ReEncrypt*', 'kms:GenerateDataKey*', 'kms:DescribeKey', 'kms:CreateGrant'],
                resources: [props.table.encryptionKey.keyArn],
            }));
        }
        if (seedsBucket) {
            const objectKey = (_e = (_d = seeds.s3Location) === null || _d === void 0 ? void 0 : _d.objectKey) !== null && _e !== void 0 ? _e : '*';
            handler.addToRolePolicy(new aws_iam_1.PolicyStatement({
                effect: aws_iam_1.Effect.ALLOW,
                actions: ['s3:GetObject'],
                resources: [seedsBucket.arnForObjects(objectKey)],
            }));
        }
        new core_1.CustomResource(this, 'CustomResource', {
            serviceToken: handler.functionArn,
            resourceType: 'Custom::DynamodbSeeder',
            properties: {
                TableName: props.table.tableName,
                Seeds: {
                    InlineSeeds: seeds.inlineSeeds,
                    S3Bucket: seeds.s3Location && seeds.s3Location.bucketName,
                    S3Key: seeds.s3Location && seeds.s3Location.objectKey,
                    S3ObjectVersion: seeds.s3Location && seeds.s3Location.objectVersion,
                },
            },
        });
    }
}
exports.DynamoDBSeeder = DynamoDBSeeder;
_a = JSII_RTTI_SYMBOL_1;
DynamoDBSeeder[_a] = { fqn: "@cloudcomponents/cdk-dynamodb-seeder.DynamoDBSeeder", version: "1.50.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZHluYW1vZGItc2VlZGVyLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vc3JjL2R5bmFtb2RiLXNlZWRlci50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQUFBLDZCQUE2QjtBQUU3Qiw4Q0FBMkQ7QUFDM0Qsb0RBQXVFO0FBQ3ZFLDRDQUF5QztBQUN6Qyx3Q0FBb0U7QUFZcEUsTUFBYSxjQUFlLFNBQVEsZ0JBQVM7SUFDM0MsWUFBWSxLQUFnQixFQUFFLEVBQVUsRUFBRSxLQUEwQjs7UUFDbEUsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQztRQUVqQixNQUFNLEtBQUssR0FBRyxLQUFLLENBQUMsS0FBSyxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsQ0FBQztRQUNyQyxNQUFNLFdBQVcsR0FBRyxPQUFBLEtBQUssQ0FBQyxVQUFVLDBDQUFFLFVBQVUsRUFBQyxDQUFDLENBQUMsZUFBTSxDQUFDLGNBQWMsQ0FBQyxJQUFJLEVBQUUsYUFBYSxFQUFFLEtBQUssQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQztRQUV2SSxNQUFNLE9BQU8sR0FBRyxJQUFJLDhCQUFpQixDQUFDLElBQUksRUFBRSx1QkFBdUIsRUFBRTtZQUNuRSxJQUFJLEVBQUUsd0JBQXdCO1lBQzlCLE9BQU8sRUFBRSxvQkFBTyxDQUFDLFdBQVc7WUFDNUIsSUFBSSxFQUFFLGlCQUFJLENBQUMsU0FBUyxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsU0FBUyxFQUFFLFNBQVMsRUFBRSxpQkFBaUIsQ0FBQyxDQUFDO1lBQ3hFLE9BQU8sRUFBRSxlQUFlO1lBQ3hCLGFBQWEsRUFBRSx3QkFBd0I7WUFDdkMsT0FBTyxRQUFFLEtBQUssQ0FBQyxPQUFPLG1DQUFJLGVBQVEsQ0FBQyxPQUFPLENBQUMsRUFBRSxDQUFDO1NBQy9DLENBQUMsQ0FBQztRQUVILE9BQU8sQ0FBQyxlQUFlLENBQ3JCLElBQUkseUJBQWUsQ0FBQztZQUNsQixNQUFNLEVBQUUsZ0JBQU0sQ0FBQyxLQUFLO1lBQ3BCLE9BQU8sRUFBRSxDQUFDLHlCQUF5QixDQUFDO1lBQ3BDLFNBQVMsRUFBRSxDQUFDLEtBQUssQ0FBQyxLQUFLLENBQUMsUUFBUSxDQUFDO1NBQ2xDLENBQUMsQ0FDSCxDQUFDO1FBRUYsSUFBSSxLQUFLLENBQUMsS0FBSyxDQUFDLGFBQWEsRUFBRTtZQUM3QixPQUFPLENBQUMsZUFBZSxDQUNyQixJQUFJLHlCQUFlLENBQUM7Z0JBQ2xCLE1BQU0sRUFBRSxnQkFBTSxDQUFDLEtBQUs7Z0JBQ3BCLE9BQU8sRUFBRSxDQUFDLGFBQWEsRUFBRSxhQUFhLEVBQUUsZ0JBQWdCLEVBQUUsc0JBQXNCLEVBQUUsaUJBQWlCLEVBQUUsaUJBQWlCLENBQUM7Z0JBQ3ZILFNBQVMsRUFBRSxDQUFDLEtBQUssQ0FBQyxLQUFLLENBQUMsYUFBYSxDQUFDLE1BQU0sQ0FBQzthQUM5QyxDQUFDLENBQ0gsQ0FBQztTQUNIO1FBRUQsSUFBSSxXQUFXLEVBQUU7WUFDZixNQUFNLFNBQVMsZUFBRyxLQUFLLENBQUMsVUFBVSwwQ0FBRSxTQUFTLG1DQUFJLEdBQUcsQ0FBQztZQUVyRCxPQUFPLENBQUMsZUFBZSxDQUNyQixJQUFJLHlCQUFlLENBQUM7Z0JBQ2xCLE1BQU0sRUFBRSxnQkFBTSxDQUFDLEtBQUs7Z0JBQ3BCLE9BQU8sRUFBRSxDQUFDLGNBQWMsQ0FBQztnQkFDekIsU0FBUyxFQUFFLENBQUMsV0FBVyxDQUFDLGFBQWEsQ0FBQyxTQUFTLENBQUMsQ0FBQzthQUNsRCxDQUFDLENBQ0gsQ0FBQztTQUNIO1FBRUQsSUFBSSxxQkFBYyxDQUFDLElBQUksRUFBRSxnQkFBZ0IsRUFBRTtZQUN6QyxZQUFZLEVBQUUsT0FBTyxDQUFDLFdBQVc7WUFDakMsWUFBWSxFQUFFLHdCQUF3QjtZQUN0QyxVQUFVLEVBQUU7Z0JBQ1YsU0FBUyxFQUFFLEtBQUssQ0FBQyxLQUFLLENBQUMsU0FBUztnQkFDaEMsS0FBSyxFQUFFO29CQUNMLFdBQVcsRUFBRSxLQUFLLENBQUMsV0FBVztvQkFDOUIsUUFBUSxFQUFFLEtBQUssQ0FBQyxVQUFVLElBQUksS0FBSyxDQUFDLFVBQVUsQ0FBQyxVQUFVO29CQUN6RCxLQUFLLEVBQUUsS0FBSyxDQUFDLFVBQVUsSUFBSSxLQUFLLENBQUMsVUFBVSxDQUFDLFNBQVM7b0JBQ3JELGVBQWUsRUFBRSxLQUFLLENBQUMsVUFBVSxJQUFJLEtBQUssQ0FBQyxVQUFVLENBQUMsYUFBYTtpQkFDcEU7YUFDRjtTQUNGLENBQUMsQ0FBQztJQUNMLENBQUM7O0FBM0RILHdDQTREQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIHBhdGggZnJvbSAncGF0aCc7XG5pbXBvcnQgeyBJVGFibGUgfSBmcm9tICdAYXdzLWNkay9hd3MtZHluYW1vZGInO1xuaW1wb3J0IHsgRWZmZWN0LCBQb2xpY3lTdGF0ZW1lbnQgfSBmcm9tICdAYXdzLWNkay9hd3MtaWFtJztcbmltcG9ydCB7IFNpbmdsZXRvbkZ1bmN0aW9uLCBSdW50aW1lLCBDb2RlIH0gZnJvbSAnQGF3cy1jZGsvYXdzLWxhbWJkYSc7XG5pbXBvcnQgeyBCdWNrZXQgfSBmcm9tICdAYXdzLWNkay9hd3MtczMnO1xuaW1wb3J0IHsgQ29uc3RydWN0LCBDdXN0b21SZXNvdXJjZSwgRHVyYXRpb24gfSBmcm9tICdAYXdzLWNkay9jb3JlJztcblxuaW1wb3J0IHsgU2VlZHMgfSBmcm9tICcuL3NlZWRzJztcblxuZXhwb3J0IGludGVyZmFjZSBEeW5hbW9EQlNlZWRlclByb3BzIHtcbiAgcmVhZG9ubHkgdGFibGU6IElUYWJsZTtcbiAgcmVhZG9ubHkgc2VlZHM6IFNlZWRzO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IHRpbWVvdXQ/OiBEdXJhdGlvbjtcbn1cblxuZXhwb3J0IGNsYXNzIER5bmFtb0RCU2VlZGVyIGV4dGVuZHMgQ29uc3RydWN0IHtcbiAgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IER5bmFtb0RCU2VlZGVyUHJvcHMpIHtcbiAgICBzdXBlcihzY29wZSwgaWQpO1xuXG4gICAgY29uc3Qgc2VlZHMgPSBwcm9wcy5zZWVkcy5iaW5kKHRoaXMpO1xuICAgIGNvbnN0IHNlZWRzQnVja2V0ID0gc2VlZHMuczNMb2NhdGlvbj8uYnVja2V0TmFtZSA/IEJ1Y2tldC5mcm9tQnVja2V0TmFtZSh0aGlzLCAnU2VlZHNCdWNrZXQnLCBzZWVkcy5zM0xvY2F0aW9uLmJ1Y2tldE5hbWUpIDogdW5kZWZpbmVkO1xuXG4gICAgY29uc3QgaGFuZGxlciA9IG5ldyBTaW5nbGV0b25GdW5jdGlvbih0aGlzLCAnQ3VzdG9tUmVzb3VyY2VIYW5kbGVyJywge1xuICAgICAgdXVpZDogJ0N1c3RvbTo6RHluYW1vZGJTZWVkZXInLFxuICAgICAgcnVudGltZTogUnVudGltZS5OT0RFSlNfMTJfWCxcbiAgICAgIGNvZGU6IENvZGUuZnJvbUFzc2V0KHBhdGguam9pbihfX2Rpcm5hbWUsICdsYW1iZGFzJywgJ2R5bmFtb2RiLXNlZWRlcicpKSxcbiAgICAgIGhhbmRsZXI6ICdpbmRleC5oYW5kbGVyJyxcbiAgICAgIGxhbWJkYVB1cnBvc2U6ICdDdXN0b206OkR5bmFtb2RiU2VlZGVyJyxcbiAgICAgIHRpbWVvdXQ6IHByb3BzLnRpbWVvdXQgPz8gRHVyYXRpb24ubWludXRlcygxNSksXG4gICAgfSk7XG5cbiAgICBoYW5kbGVyLmFkZFRvUm9sZVBvbGljeShcbiAgICAgIG5ldyBQb2xpY3lTdGF0ZW1lbnQoe1xuICAgICAgICBlZmZlY3Q6IEVmZmVjdC5BTExPVyxcbiAgICAgICAgYWN0aW9uczogWydkeW5hbW9kYjpCYXRjaFdyaXRlSXRlbSddLFxuICAgICAgICByZXNvdXJjZXM6IFtwcm9wcy50YWJsZS50YWJsZUFybl0sXG4gICAgICB9KSxcbiAgICApO1xuXG4gICAgaWYgKHByb3BzLnRhYmxlLmVuY3J5cHRpb25LZXkpIHtcbiAgICAgIGhhbmRsZXIuYWRkVG9Sb2xlUG9saWN5KFxuICAgICAgICBuZXcgUG9saWN5U3RhdGVtZW50KHtcbiAgICAgICAgICBlZmZlY3Q6IEVmZmVjdC5BTExPVyxcbiAgICAgICAgICBhY3Rpb25zOiBbJ2ttczpFbmNyeXB0JywgJ2ttczpEZWNyeXB0JywgJ2ttczpSZUVuY3J5cHQqJywgJ2ttczpHZW5lcmF0ZURhdGFLZXkqJywgJ2ttczpEZXNjcmliZUtleScsICdrbXM6Q3JlYXRlR3JhbnQnXSxcbiAgICAgICAgICByZXNvdXJjZXM6IFtwcm9wcy50YWJsZS5lbmNyeXB0aW9uS2V5LmtleUFybl0sXG4gICAgICAgIH0pLFxuICAgICAgKTtcbiAgICB9XG5cbiAgICBpZiAoc2VlZHNCdWNrZXQpIHtcbiAgICAgIGNvbnN0IG9iamVjdEtleSA9IHNlZWRzLnMzTG9jYXRpb24/Lm9iamVjdEtleSA/PyAnKic7XG5cbiAgICAgIGhhbmRsZXIuYWRkVG9Sb2xlUG9saWN5KFxuICAgICAgICBuZXcgUG9saWN5U3RhdGVtZW50KHtcbiAgICAgICAgICBlZmZlY3Q6IEVmZmVjdC5BTExPVyxcbiAgICAgICAgICBhY3Rpb25zOiBbJ3MzOkdldE9iamVjdCddLFxuICAgICAgICAgIHJlc291cmNlczogW3NlZWRzQnVja2V0LmFybkZvck9iamVjdHMob2JqZWN0S2V5KV0sXG4gICAgICAgIH0pLFxuICAgICAgKTtcbiAgICB9XG5cbiAgICBuZXcgQ3VzdG9tUmVzb3VyY2UodGhpcywgJ0N1c3RvbVJlc291cmNlJywge1xuICAgICAgc2VydmljZVRva2VuOiBoYW5kbGVyLmZ1bmN0aW9uQXJuLFxuICAgICAgcmVzb3VyY2VUeXBlOiAnQ3VzdG9tOjpEeW5hbW9kYlNlZWRlcicsXG4gICAgICBwcm9wZXJ0aWVzOiB7XG4gICAgICAgIFRhYmxlTmFtZTogcHJvcHMudGFibGUudGFibGVOYW1lLFxuICAgICAgICBTZWVkczoge1xuICAgICAgICAgIElubGluZVNlZWRzOiBzZWVkcy5pbmxpbmVTZWVkcyxcbiAgICAgICAgICBTM0J1Y2tldDogc2VlZHMuczNMb2NhdGlvbiAmJiBzZWVkcy5zM0xvY2F0aW9uLmJ1Y2tldE5hbWUsXG4gICAgICAgICAgUzNLZXk6IHNlZWRzLnMzTG9jYXRpb24gJiYgc2VlZHMuczNMb2NhdGlvbi5vYmplY3RLZXksXG4gICAgICAgICAgUzNPYmplY3RWZXJzaW9uOiBzZWVkcy5zM0xvY2F0aW9uICYmIHNlZWRzLnMzTG9jYXRpb24ub2JqZWN0VmVyc2lvbixcbiAgICAgICAgfSxcbiAgICAgIH0sXG4gICAgfSk7XG4gIH1cbn1cbiJdfQ==