# Generated by Django 1.10.4 on 2016-12-27 11:37
import django.db.models.deletion
from django.db import (
    migrations,
    models,
)

import educommon.m3.extensions.listeners.delete_check.mixins
import educommon.report.constructor.validators


class Migration(migrations.Migration):
    initial = True

    dependencies = []

    operations = [
        migrations.CreateModel(
            name='ReportColumn',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=300, verbose_name='Имя столбца в источнике данных')),
                ('index', models.PositiveSmallIntegerField(verbose_name='Порядковый номер')),
                ('title', models.CharField(blank=True, max_length=300, null=True, verbose_name='Отображаемое имя')),
            ],
            options={
                'ordering': ('index',),
                'verbose_name': 'Столбец отчета',
                'verbose_name_plural': 'Столбцы отчетов',
            },
        ),
        migrations.CreateModel(
            name='ReportTemplate',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=1000, unique=True, verbose_name='Наименование шаблона отчета')),
                (
                    'data_source_name',
                    models.CharField(
                        max_length=500,
                        validators=[educommon.report.constructor.validators.validate_data_source_name],
                        verbose_name='Имя источника данных',
                    ),
                ),
                (
                    'format',
                    models.PositiveSmallIntegerField(
                        choices=[
                            (0, 'Спрашивать перед сборкой'),
                            (1, 'Excel (без объединения ячеек)'),
                            (2, 'Excel (с объединением ячеек)'),
                        ],
                        default=0,
                        verbose_name='Формат сборки',
                    ),
                ),
            ],
            options={
                'verbose_name': 'Отчет',
                'verbose_name_plural': 'Отчеты',
            },
            bases=(educommon.m3.extensions.listeners.delete_check.mixins.CascadeDeleteMixin, models.Model),
        ),
        migrations.AddField(
            model_name='reportcolumn',
            name='report_template',
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name='columns',
                to='report_constructor.ReportTemplate',
                verbose_name='Отчет',
            ),
        ),
        migrations.AlterUniqueTogether(
            name='reportcolumn',
            unique_together=set([('report_template', 'name')]),
        ),
    ]
