# Generated by Django 2.2.28 on 2023-12-22 07:33
# flake8: noqa
import django.contrib.postgres.fields.jsonb
import django.db.models.deletion
from django.db import (
    migrations,
    models,
)


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        ('contenttypes', '0002_remove_content_type_name'),
    ]

    operations = [
        migrations.CreateModel(
            name='AsyncTaskStatus',
            fields=[
                ('title', models.TextField(verbose_name='расшифровка значения')),
                (
                    'key',
                    models.CharField(
                        db_index=True, max_length=512, primary_key=True, serialize=False, verbose_name='ключ'
                    ),
                ),
                ('order_number', models.PositiveIntegerField(default=100000, verbose_name='Порядковый номер')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='AsyncTaskType',
            fields=[
                ('title', models.TextField(verbose_name='расшифровка значения')),
                (
                    'key',
                    models.CharField(
                        db_index=True, max_length=512, primary_key=True, serialize=False, verbose_name='ключ'
                    ),
                ),
                ('order_number', models.PositiveIntegerField(default=100000, verbose_name='Порядковый номер')),
            ],
            options={
                'verbose_name': 'Тип асинхронных задач',
                'verbose_name_plural': 'Типы асинхронных задач',
            },
        ),
        migrations.CreateModel(
            name='RunningTask',
            fields=[
                ('id', models.UUIDField(primary_key=True, serialize=False, verbose_name='ID задачи')),
                ('name', models.CharField(blank=True, max_length=512, verbose_name='Наименование задачи')),
                ('profile_id', models.PositiveIntegerField(blank=True, null=True)),
                ('description', models.CharField(blank=True, max_length=512, verbose_name='Описание задачи')),
                (
                    'options',
                    django.contrib.postgres.fields.jsonb.JSONField(
                        blank=True, null=True, verbose_name='Дополнительные опции задачи'
                    ),
                ),
                (
                    'queued_at',
                    models.DateTimeField(
                        blank=True, db_index=True, null=True, verbose_name='Дата и время помещения в очередь'
                    ),
                ),
                ('started_at', models.DateTimeField(blank=True, null=True, verbose_name='Дата и время запуска задачи')),
                (
                    'finished_at',
                    models.DateTimeField(blank=True, null=True, verbose_name='Дата и время завершения задачи'),
                ),
                (
                    'profile_type',
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to='contenttypes.ContentType',
                    ),
                ),
                (
                    'status',
                    models.ForeignKey(
                        default='PENDING',
                        on_delete=django.db.models.deletion.PROTECT,
                        to='async_task.AsyncTaskStatus',
                        verbose_name='Состояние задачи',
                    ),
                ),
                (
                    'task_type',
                    models.ForeignKey(
                        default='UNKNOWN',
                        on_delete=django.db.models.deletion.PROTECT,
                        to='async_task.AsyncTaskType',
                        verbose_name='Тип задачи',
                    ),
                ),
            ],
            options={
                'verbose_name': 'Асинхронная задача',
                'verbose_name_plural': 'Асинхронные задачи',
            },
        ),
        migrations.AddIndex(
            model_name='runningtask',
            index=models.Index(fields=['profile_type', 'profile_id'], name='async_task__profile_c97023_idx'),
        ),
    ]
