# Участие в проекте

Любой вклад в проект приветствуется и очень ценится вне зависимости от важности и объема!

## Виды участия

### Сообщения об ошибках

Если Вы сообщаете об ошибке, пожалуйста, включите в свое сообщение:

* Название и версия вашей операционной системы
* Любые сведения о вашем локальном окружении, которые могут быть полезны при устранении неполадок
* Подробные шаги для воспроизведения ошибки

### Исправление ошибок

Проверьте таск-трекер на наличие открытых задач. Все не назначенные задачи с типом "Ошибка" доступны для выполнения.

### Реализация новых функций

Проверьте таск-трекер на наличие открытых задач. Все не назначенные задачи с типом "Новая разработка" и "Улучшение" 
доступны для выполнения.

### Написание документации

Документации никогда не бывает достаточно! Пожалуйста, не стесняйтесь вносить свой вклад в любую часть документации, 
например, в основные документы, docstring или иные источники (статьи, заметки и т.д.).

### Предложения

Если Вы предлагаете новую функцию или улучшение:

* Объясните подробно, как это будет работать
* Оставляйте область изменений как можно более узкой, чтобы упростить реализацию

## Как начать

Готовы начать? Ниже описана краткая инструкция по развороту `educommon` для локальной разработки.

1. Скачайте локальную копию `educommon` из репозитория
2. Установите `educommon` используя `poetry`:

    ```console
    $ poetry install
    ```

3. Используя `git`, создайте ветку для локальной разработки и внесите свои изменения:

    ```console
    $ git checkout -b name-of-your-bugfix-or-feature
    ```

4. Когда Вы закончите вносить изменения убедитесь, что изменения соответствуют всем требованиям к форматированию кода, 
и все тесты проходят.

5. Зафиксируйте свои изменения и откройте pull request (PR).

## Руководство по PR

Прежде чем отправлять PR на ревью убедитесь, что он соответствует этим правилам:

1. PR должен включать дополнительные тесты, если это необходимо
2. Если PR добавляет новую функциональность - должна быть обновлена документация 
3. Изменения в PR должны работать для всех поддерживаемых в настоящее время операционных систем и версий Python

## Кодекс поведения

Обратите внимание, что в проекте `educommon` есть Кодекс поведения. Внося свой вклад в этот 
проект, Вы соглашаетесь соблюдать его условия.
