# История изменений

Все изменения проекта должны быть отражены в этом файле.

Формат основан на [Keep a Changelog](http://keepachangelog.com/)
и проект следует [Семантическому версионированию](http://semver.org/).

## [x.y.z] - гггг-мм-дд

Здесь должно быть расширенное описание того, что было сделано, какие есть планы у команды по дальнейшему развитию.
Желательно будущие цели привязывать к конкретным задачам. Т.е. на каждую цель нужно поставить отдельную задачу и отразить ее номер здесь.

### Добавлено

- [ПРОЕКТ-ZZZZ](https://jira.bars.group/browse/ПРОЕКТ-ZZZZ)
  PATCH Название задачи или изменения.

- [ПРОЕКТ-YYYY](https://jira.bars.group/browse/ПРОЕКТ-YYYY)
  MINOR Название задачи или изменения.

- [ПРОЕКТ-XXXX](https://jira.bars.group/browse/ПРОЕКТ-XXXX)
  MAJOR Название задачи или изменения.

### Изменено

### Исправлено

### Удалено



# [3.21.0] - 2025-07-04

Добавлено поле id в дата-класс BaseEntity

### Добавлено

- [EDUSCHL-23347](https://jira.bars.group/browse/EDUSCHL-23347)
 MINOR Добавлено поле id в дата-класс BaseEntity


# [3.20.0] - 2025-06-23

Добавлена manage-команда удаления ложных логов в таблицах audit_log_auditlog и state_log_all.

### Добавлено

- [EDUDEVOPS-90](https://jira.bars.group/browse/EDUDEVOPS-90)
  MINOR Добавлена manage-команда удаления ложных логов в таблицах audit_log_auditlog и state_log_all. 


## [3.19.1] - 2025-06-20

Добавлен базовый класс для внутренних справочников `NamedIntEnum`.

### Добавлено

- PATCH Добавлен базовый класс для внутренних справочников `NamedIntEnum`


# [3.19.0] - 2025-06-10

После поднятия версии, необходимо пересоздать функции журнала изменений в БД `django-admin reinstall_audit_log`.

### Добавлено

- [EDUDEVOPS-89](https://jira.bars.group/browse/EDUDEVOPS-89)
  PATCH Добавлена функция get_auto_now_fields_by_model для получения словаря с полями, имеющими auto_now=True.

### Изменено

- [EDUDEVOPS-89](https://jira.bars.group/browse/EDUDEVOPS-89)
  MINOR Изменена функция audit.on_modify в install_audit_log.sql.
  Логирование изменений игнорируется, если при обновлении записи изменились только поля с auto_now=True.


# [3.18.0] - 2025-06-05

### Добавлено

- [EDUSCHL-23442](https://jira.bars.group/browse/EDUSCHL-23442)
  MINOR Добавлена manage-команда переноса логов из локальных приложений в educommon.audit_log

### Изменено

- [EDUSCHL-23442](https://jira.bars.group/browse/EDUSCHL-23442)
  PATCH В поле AuditLog.time auto_now_add заменен на default


# [3.17.0] - 2025-05-28

Добавлена проверка конфликтующих таблиц которые должны логироваться, но находятся в сервисных приложениях.

### Добавлено

- [EDUSCHL-23590](https://jira.bars.group/browse/EDUSCHL-23590)
  MINOR Добавлена функция get_table_names_for_app_labels для получения множества с именами таблиц для указанных приложений.
  Добавлена проверка конфликтующих таблиц которые должны логироваться, но находятся в сервисных приложениях.


# [3.16.0] - 2025-05-15

Добавлена настройка передачи дополнительных SQL файлов для выполнения в МК reinstall_audit_log.

### Добавлено

- [EDUSCHL-23389](https://jira.bars.group/browse/EDUSCHL-23389)
  MINOR Добавлена настройка AUDIT_LOG_EXTENSION_SCRIPTS для хранения путей к дополнительным SQL файлам,
  которые будут выполнены в МК reinstall_audit_log.
  Явное указание настройки в продукте не обязательно. Пример заполнения указан в audit_log/README.rst.

### Удалено

- [EDUSCHL-23389](https://jira.bars.group/browse/EDUSCHL-23389)
  MINOR Удален столбец имитации в AuditLogPack


## [3.15.0] - 2025-04-29

Добавлен фильтр, позволяющий работать с датой в формате d.m.Y, m.Y, Y.

### Добавлено

- [EDUKNDG-15399](https://jira.bars.group/browse/EDUKNDG-15399)
  MINOR Добавлен фильтр FilterByDateStr, позволяющий работать с датой в формате d.m.Y, m.Y, Y.

### Изменено

- [EDUKNDG-15399](https://jira.bars.group/browse/EDUKNDG-15399)
  MINOR Повышена минимальная версия m3-ui с 2.2.40 до 2.2.116, для корректной работы даты в формате d.m.Y, m.Y, Y.


## [3.14.0] - 2025-04-09

Доработки журнала изменений до состояния старого журнала в ЭШ

### Добавлено

- [EDUSCHL-23386](https://jira.bars.group/browse/EDUSCHL-23386)
  PATCH Столбец имитация (без функциональности, для доработки работоспособности в последующих задачах).

### Изменено

- [EDUSCHL-23386](https://jira.bars.group/browse/EDUSCHL-23386)
  MINOR Классы LogProxy, AuditLogPack преобразованы в абстрактные с добавлением абстрактных методов для
  извлечения исходных данных необходимых при: отображении ФИО пользователя в журнале изменений; фильтрации по ФИО;
  отображении ФИО, организации в окне редактирования записи журнала изменений.
  Подробнее о необходимых настройках в audit_log/README.rst.


## [3.13.2] - 2024-04-09

Небольшой рефакторинг для корректной сборки пакета.

### Изменено

  - MINOR Удалены ненужные файлы, актуализирована сборка пакета.


## [3.13.1] - 2025-04-08

Выполнен дополнительный рефакторинг кода.
Убраны остаточные упоминания Python2. Произведён переход на f-строки и `.format()`.
Добавлены атрибуты минимальной и максимальной даты для DatetimeFilterCreator.
Исправлена минимальная дата для валидатора поля RangedDateField и BirthDateField.
Изменён тип сообщения о предотвращении доступа к БД, по которой не проводистя миграция.

## Добавлено

- [EDUKNDG-15346](https://jira.bars.group/browse/EDUKNDG-15346)
  PATCH Добавлены атрибуты минимальной и максимальной даты для DatetimeFilterCreator.

### Изменено

- [EDUDEVOPS-28](https://jira.bars.group/browse/EDUDEVOPS-28)
  PATCH Заменено устаревшее строковое форматирование `%` на f-строки и `.format()`.
  PATCH Проведён широкий рефакторинг кода с использованием `ruff`: улучшена читаемость, устранены потенциальные ошибки и упрощена структура модулей.
- [EDUKNDG-15346](https://jira.bars.group/browse/EDUKNDG-15346)
  PATCH Исправлена минимальная дата для валидатора поля RangedDateField и BirthDateField.
- [EDUSCHL-23422](https://jira.bars.group/browse/EDUSCHL-23422)
  PATCH Тип сообщения о предотвращении доступа к БД, по которой не проводистя миграция,
  с `warning` изменён на `debug`

### Удалено

- [EDUDEVOPS-28](https://jira.bars.group/browse/EDUDEVOPS-28)
  PATCH Удалены остатки поддержки Python2: директивы `__future__`, проверки `sys.version_info`, типы `unicode`, `basestring` и др.


## [3.13.0] - 2025-03-27

Убраны обращения к базам данных, по которым не производятся миграции

### Добавлено
- [EDUCLLG-8905](https://jira.bars.group/browse/EDUCLLG-8905)
  MINOR Добавлены базовые классы для обработчиков сигналов `before_handle_migrate_signal` и `after_handle_migrate_signal`,
  введено ограничение на обработчики этих сигналов

### Изменено
- [EDUCLLG-8905](https://jira.bars.group/browse/EDUCLLG-8905)
  MINOR Убраны обращения к базам данных, по которым не производятся миграции
- [EDUCLLG-8905](https://jira.bars.group/browse/EDUCLLG-8905)
  MINOR Убрана поддержка Python ниже 3.9


## [3.12.0] - 2025-03-11

Доработка справочника **"Потребность в адаптированной программе"** в соответствии с требованиями ЕФТТ.

### Добавлено

- [EDUSCHL-23273](https://jira.bars.group/browse/EDUSCHL-23273)
  MINOR В перечисление AdaptationType добавлен метод get_epgu_code позволяющий получить код ЕПГУ сопоставленный одному из кодов адаптированности.
   Не все коды перечисления имеют сопоставленный код ЕПГУ.
  MINOR Добавлены новые системные значения в справочник:
  - `213` – "Для слабослышащих и позднооглохших детей"
  - `214` – "Для детей с умственной отсталостью, нарушением интеллекта".

### Изменено

- [EDUSCHL-23273](https://jira.bars.group/browse/EDUSCHL-23273)
  PATCH Обновлены наименования существующих значений справочника в соответствии с требованиями ЕФТТ.


## [3.11.3] - 2025-03-06

Для класса DatetimeFilterCreator удалена минимальная дата, так как теперь она определена в ExtDateField (m3-ui).

### Удалено

- [EDUKNDG-15254](https://jira.bars.group/browse/EDUKNDG-15254)
  PATCH Для класса DatetimeFilterCreator удалена минимальная дата.


## [3.11.2] - 2025-02-21

Добавлен импорт `sentry_sdk` для улучшенной обработки ошибок и мониторинга.
Реализована логика переключения между `raven` и `sentry_sdk` для обеспечения совместимости с существующим кодом.
Для класса DatetimeFilterCreator добавлена минимальная дата (01.01.1917). Без ограничений падает ошибка 500.

### Добавлено

- [EDUKNDG-15254](https://jira.bars.group/browse/EDUKNDG-15254)
  PATCH Для класса DatetimeFilterCreator добавлена минимальная дата.

### Изменено

- [EDUDEVOPS-17](https://jira.bars.group/browse/EDUDEVOPS-17)
  PATCH Добавление поддержки `sentry_sdk` и реализация переключения между `raven` и `sentry_sdk`.


## [3.11.1] - 2025-02-04

Изменён тип поля options с django.contrib.postgres.fields.JSONField (поддержка до Django 4.0.)
на django.db.models.JSONField (поддержка с Django 3.1.0).

### Изменено

- [EDUKNDG-15190](https://jira.bars.group/browse/EDUKNDG-15190)
  PATCH Для модели RunningTask изменён тип поля options на django.db.models.JSONField.


## [3.11.0] - 2024-09-23

Добавлена реализация типа PhoneNumber для работы с форматом номеров телефонов.
Добавлена реализация поля моделей PhoneField с поддержкой типа PhoneNumber.

### Добавлено

- [EDUSCHL-22378](https://jira.bars.group/browse/EDUSCHL-22378)
  MINOR Реализация поля моделей Django содержащего номер телефона


## [3.10.1] - 2024-09-11

Изменения по ОКСМ.

### Добавлено

- [EDUCLLG-8338](https://jira.bars.group/browse/EDUCLLG-8338)
  PATCH Добавлен скрипт для обновления справочника ОКСМ. Добавлен столбец с буквенным кодов страны в пак ОКСМ.

### Исправлено

- [EDUCLLG-8338](https://jira.bars.group/browse/EDUCLLG-8338)
  PATCH Актуализирована информация в справочнике ОКСМ.


## [3.10.0] - 2024-08-26

Добавлен класс UniquePeriodicAsyncTask, отвечающий за уникальные периодические задачи

### Добавлено

- [EDUSCHL-22267](https://jira.bars.group/browse/EDUSCHL-22267)
  MINOR Добавлен класс UniquePeriodicAsyncTask, отвечающий за уникальные периодические задачи


## [3.9.10] - 2024-08-14

Исправлено создание атрибута state в методе run и дополнен метод on_failure у класса AsyncTask

### Исправлено

- [EDUSCHL-22322](https://jira.bars.group/browse/EDUSCHL-22322)
  PATCH Исправлено создание атрибута state в методе run и дополнен метод on_failure у класса AsyncTask


## [3.9.9] - 2024-06-28

Исправлен метод _get_objects у класса DataLoader для правильной работы с MPTT моделями.

### Исправлено

- [EDUSCHL-21992](https://jira.bars.group/browse/EDUSCHL-21992)
  PATCH Исправлен метод _get_objects у класса DataLoader для правильной работы с MPTT моделями.


## [3.9.8] - 2024-05-30

Исправление отображения элементов окна результатов асинхронных задач.

### Исправлено

- [EDUSCHL-21502](https://jira.bars.group/browse/EDUSCHL-21502)
  PATCH Исправление отображения элементов окна результатов асинхронных задач.


## [3.9.7] - 2024-05-14

Исправлена ошибка при открытии реестра "Логи запросов".

### Исправлено

- [EDUKNDG-12751](https://jira.bars.group/browse/EDUKNDG-12751)
  PATCH Исправлена ошибка при открытии реестра "Логи запросов".


## [3.9.6] - 2024-04-09

Исправлено отсутствие сообщения об ошибке в реестре "Асинхронные задачи".

### Исправлено

- [EDUCLLG-8346](https://jira.bars.group/browse/EDUCLLG-8346)
  PATCH Исправлено отсутствие сообщения об ошибке в реестре "Асинхронные задачи".


## [3.9.5] - 2024-04-09

Исправлены менедж команды партицирования.
Доработана команда apply_partitioning - добавлена возможность указания схемы для внешних таблиц в триггерных функциях
Добавлена поддержка Django 3.2.

### Добавлено

- [EDUKNDG-12751](https://jira.bars.group/browse/EDUKNDG-12751)
  MINOR Добавлена поддержка Django 3.2.

### Исправлено

- [EDUSCHL-21408] (https://jira.bars.group/browse/EDUSCHL-21408)
  MINOR Добавлен параеметр itersize при sql-запросах при партицировании и логирование при менедж-командах
  MINOR Добавлена передача схемы для внешних таблиц при партицировании


## [3.9.4] - 2024-03-19

"Конструктор отчетов".
В ColumnDescriptor добавлено свойство related_field_models который содержит связанные модели полей экземпляра.
В методе _check_to_exclude для устранения цикличности полей добавлена проверка чтобы связанная модель поля
не была в списке связанных моделей родителя.

### Исправлено

- [EDUSCHL-15016](https://jira.bars.group/browse/EDUSCHL-15016)
  PATCH Исправление цикличности, путём добавление проверки на родительское поле.


## [3.9.3] - 2024-03-12

Добавлена поддержка Django 3.1.

### Добавлено

- [EDUSCHL-18052](https://jira.bars.group/browse/EDUSCHL-18052)
  MINOR Поднять версию Django до 3.1.14


## [3.9.2] - 2024-03-06
Убрано указание конкретного css-класса для пункта меню асинхронных задач.

### Удалено

- [EDUCLLG-8227](https://jira.bars.group/browse/EDUCLLG-8227)
  MINOR Убрано указание конкретного css-класса для пункта меню асинхронных задач


## [3.9.1] - 2024-03-06

Добавлена возможность указывать иконку реестра асинхронных задач.

### Добавлено

- [EDUCLLG-8227](https://jira.bars.group/browse/EDUCLLG-8227)
  PATCH Добавлена возможность указывать иконку реестра асинхронных задач


## [3.9.0] - 2024-02-29

В contingent добавлена виртуальная модель IcaoVirtialModel для кодов ICAO.
В AuditLog в метод _transform_array_field добавлена проверка на тип данных
для возможности обработки уже приведенных к нужному типу данных.

### Добавлено

- [EDUSCHL-21513](https://jira.bars.group/browse/EDUSCHL-21513)
  MINOR Добавлена виртуальная модель IcaoVirtialModel для кодов ICAO.

### Исправлено

- [EDUSCHL-21513](https://jira.bars.group/browse/EDUSCHL-21513)
  PATCH Добавлена проверка в метод _transform_array_field модели AuditLog для возможности обработки уже преобразованных данных.


## [3.8.3] - 2024-02-09

Исправлена ошибка, из-за которой приложение
не запускалось из-за отсутствия `SECRET_KEY` при считывании настройки
во время построения `settings`. Ошибка возникала, если был осуществлен импорт модуля из
settings проекта, в котором происходит обращение к атрибутам `settings`).

### Изменено

- [EDUCLLG-8227](https://jira.bars.group/browse/EDUCLLG-8227)
  PATCH Спрятано обращение к настройкам в функцию, где она непосредственно нужна.


## [3.8.2] - 2024-02-05

Изменено регулярное выражение в HouseValidator.

### Изменено

- [EDUSCHL-21298](https://jira.bars.group/browse/EDUSCHL-21298)
  PATCH Изменено регулярное выражение в HouseValidator.


## [3.8.1] - 2024-02-02

Обработка полей HStore на возможные ошибки преобразования в словарь в методе _transform_fields модели AuditLog.

### Исправлено

- [EDUSCHL-21251](https://jira.bars.group/browse/EDUSCHL-21251)
  Обработка полей HStore на возможные ошибки преобразования в словарь.


## [3.8.0] - 2024-01-22

Добавлена поддержка Django 3.0.
Удален декоратор classproperty.

### Добавлено

- [EDUSCHL-18051](https://jira.bars.group/browse/EDUSCHL-18051)
  MINOR Добавлена поддержка Django 3.0.

### Удалено

- [EDUSCHL-18051](https://jira.bars.group/browse/EDUSCHL-18051)
  MINOR Удален декоратор classproperty.


## [3.7.2] - 2024-01-22

Исправление ошибки обновления состояния асинхронных задач.

### Исправлено

- [EDUSCHL-14950](https://jira.bars.group/browse/EDUSCHL-14950)
  PATCH Исправление ошибки обновления состояния асинхронных задач.


## [3.7.1] - 2024-01-17

В базовый класс асинхронных задач AsyncTask добавлен атрибут logging_in_db определяющий
будут или нет создаваться записи RunningTask в реестре асинхронных задач.

### Добавлено

- [EDUSCHL-14950](https://jira.bars.group/browse/EDUSCHL-14950)
  MINOR Добавлен атрибут logging_in_db в класс AsyncTask


## [3.7.0] - 2023-12-26

Произведен рефакторинг асинхронных задач в рамках которого добавлено новое приложение `async_task`.
Существующее приложение `async` (educommon.async_tasks) считать устаревшим и оно будет удалено в последующих версиях.
Удалена поддержка Python 3.6 и Django ниже версии 2.2.

В AuditLog добавлены свойства transformed_data и transformed_changes, возвращающие данные в формате,
соответствующем типам полей из логируемых моделей.

### Добавлено

- [EDUSCHL-21013](https://jira.bars.group/browse/EDUSCHL-21013)
  MINOR Рефакторинг асинхронных задач, добавлено приложение `async_task` (educommon.async_task).

- [EDUSCHL-20793](https://jira.bars.group/browse/EDUSCHL-20793)
  MINOR Типы получаемых из log_change.fields полей должны соответствовать типам полей из логируемых моделей.

### Изменено

- [EDUSCHL-21013](https://jira.bars.group/browse/EDUSCHL-21013)
  MINOR Удалена поддержка Python 3.6 и Django ниже версии 2.2.


## [3.6.1] - 2023-12-16

В EntitySaver добавлена конвертация объекта модели фиктивного внешнего ключа к его идентификатору.

### Добавлено

- [EDUSCHL-21067](https://jira.bars.group/browse/EDUSCHL-21067)
  PATCH Добавление функционала в EntitySaver для работы с фиктивными внешними ключами.


## [3.6.0] - 2023-12-05

### Изменено

Вынос общего функционала для regional_data_mart_integration.

- [EDUCLLG-7736](https://jira.bars.group/browse/EDUCLLG-7736)
  MINOR Вынесен функционал из ЭШ, необходимый для regional_data_mart_integration.


## [3.5.5] - 2023-12-04

В методе get_models_table_ids (audit_log/helpers.py) поправлена аннотация типа для обозначения
итерируемых объектов в целом, а не только List.

### Изменено

- [EDUSCHL-19576](https://jira.bars.group/browse/EDUSCHL-19576)
  PATCH Изменена аннотация типа параметра метода get_models_table_ids.


## [3.5.4] - 2023-11-30

В классе BaseEntity добавлен метод get_ignore_prefix_key_fields для указания ключей,
для которых добавление префикса должно быть проигнорировано.

### Добавлено

- [EDUSCHL-20961](https://jira.bars.group/browse/EDUSCHL-20961)
  PATCH В классе BaseEntity добавлен метод get_ignore_prefix_key_fields для указания ключей,
  для которых добавление префикса должно быть проигнорировано.


## [3.5.3] - 2023-11-09

Изменен порядок операций при вызове EntitySaver. Создание записей выполняется
  в последнюю очередь, что позволяет избежать нарушения ограничения уникальности при
  наличии записей в очередях на создание и обновление.

### Изменено

- [EDUSCHL-20724](https://jira.bars.group/browse/EDUSCHL-20724)
  MINOR Изменен порядок операций при вызове EntitySaver.


## [3.5.2] - 2023-11-01

Исправлена ошибка в случае указания связей по related_name через ключ 'only', в report_constructor_params.

### Исправлено

- [EDUCLLG-6894](https://jira.bars.group/browse/EDUCLLG-6894)
  PATCH ЭК. Ошибки в конструкторе отчетов.


## [3.5.1] - 2023-10-16

Дополнен справочник "Общероссийский классификатор стран мира" (ОКФС).

### Изменено

- [EDUSCHL-19646](https://jira.bars.group/browse/EDUSCHL-19646)
  PATCH Дополнен справочник "Общероссийский классификатор стран мира" (ОКФС).


## [3.5.0] - 2023-10-04

Дополнен справочник "Типы документов удостоверяющих личность".
Добавлены методы get_modes и get_split_by_modes в DatesSplitter.

### Добавлено

- [EDUSCHL-20350](https://jira.bars.group/browse/EDUSCHL-20350)
  MINOR Добавлены методы get_modes и get_split_by_modes в DatesSplitter.

### Изменено

- [EDUSCHL-19647](https://jira.bars.group/browse/EDUSCHL-19647)
  MINOR Дополнен справочник "Типы документов удостоверяющих личность".


## [3.4.0] - 2023-09-22

Добавление сигналов выполняемых до и после прогона миграций.

### Добавлено

- [EDUCLLG-7939](https://jira.bars.group/browse/EDUCLLG-7939)
  MINOR Добавление сигналов до и после выполнения миграций.


## [3.3.0] - 2023-09-07

Улучшение работы audit_log.

### Изменено

- [EDUSCHL-20382](https://jira.bars.group/browse/EDUSCHL-20382)
  MINOR Изменение способа определения перечня таблиц для которых необходимо
  установить триггер. Теперь триггеры создаются только для тех таблиц имена которых
  присутствуют в таблице audit.table_for_inserting с признаком logged = true;

- [EDUSCHL-20382](https://jira.bars.group/browse/EDUSCHL-20382)
  MINOR Удалена настройка SELECTIVE_TABLES_LOG_ON. Теперь по умолчанию триггеры
  создаются только для моделей у которых определен атрибут need_to_log = True.
  Для включения логирования всех моделей необходимо задать
  настройку USE_AUDIT_LOG_FOR_ALL_MODELS = True;

- [EDUSCHL-20382](https://jira.bars.group/browse/EDUSCHL-20382)
  MINOR Удален запуск очистки таблицы с логами при конфигурировании audit_log.
  Очистку можно произвести путём указания опционального параметра --clear_audit_log
  менедж-команды reinstall_audit_log;

- [EDUSCHL-20382](https://jira.bars.group/browse/EDUSCHL-20382)
  PATCH Избавление от блокировки при вызове функции audit.get_table_id при вставке
  записи лога по триггеру;

- [EDUSCHL-20382](https://jira.bars.group/browse/EDUSCHL-20382)
  MINOR Удален скрипт configure_selective_audit_log.sql.


## [3.2.2] - 2023-09-04

В класс DatesSplitter добавлен парамер split_by_quantity вместо split_by_days_count.

### Изменено

- [EDUSCHL-20302](https://jira.bars.group/browse/EDUSCHL-20302)
  PATCH В класс DatesSplitter добавлен парамер split_by_quantity вместо split_by_days_count.
        Теперь период можно разбивать на N недель/месяцев/лет.


## [3.2.1] - 2023-09-03

Добавлен класс DatesSplitter для работы с датами.

### Добавлено

- [EDUSCHL-20302](https://jira.bars.group/browse/EDUSCHL-20302)
  PATCH Добавлен класс DatesSplitter для работы с датами (см. документацию класса DatesSplitter)


## [3.2.0] - 2023-09-02

Внесены изменения в audit_log. Исправление ошибки в конструкторе отчёта

### Изменено

- [EDUSCHL-20365](https://jira.bars.group/browse/EDUSCHL-20365)
  MINOR Изменен метод обновления триггеров, а также способ очистки записей логов
  неотслеживаемых таблиц audit_log.

### Исправлено

- [EDUSCHL-20241](https://jira.bars.group/browse/EDUSCHL-20241)
  PATCH Исправлена ошибка получения данных из словаря в методе ReportTemplateWriter._is_filters_data_valid
  конструктора отчетов.


## [3.1.1] - 2023-08-30

Поднятие версии зависимости пакета m3-spyne-smev.

### Исправлено

- [EDUSCHL-19970](https://jira.bars.group/browse/EDUSCHL-19970)
  PATCH Поднятие версии зависимости пакета m3-spyne-smev


## [3.1.0] - 2023-08-16

Перенос и доработка логеров.

### Добавлено

- [EDUSCHL-18102](https://jira.bars.group/browse/EDUSCHL-18102)
  MINOR Добавление логеров rest_error и exception.


## [3.0.2] - 2023-08-15

Исправлено формирование исключений при вычислении хэша.

### Исправлено

- [EDUSCHL-20213](https://jira.bars.group/browse/EDUSCHL-20213)
  PATCH Исправлено формирование исключений при вычислении хэша.


## [3.0.1] - 2023-08-06

Исправление аннотации типов.

### Исправлено

- [EDUSCHL-20235](https://jira.bars.group/browse/EDUSCHL-20235)
  PATCH Исправление аннотации типов.


## [3.0.0] - 2023-07-23

Была проделана работа по переносу механизма логирования из проекта ЭШ для возможности использования на других проектах.
Это требуется для унификации основных механизмов для удобства их управления и улучшения. Добавлен каркас документации и
документация по настройке логирования.
Также была удалена поддержка Python 2. Работы выполнены не в полном объеме и будут завершены в рамках
[EDUDEVOPS-28](https://jira.bars.group/browse/EDUDEVOPS-28).

### Добавлено

- [EDUSCHL-19919](https://jira.bars.group/browse/EDUSCHL-19919)
  Добавлен сборщик документации Sphinx;

- [EDUSCHL-19919](https://jira.bars.group/browse/EDUSCHL-19919)
 Перенесен механизм логирования из ЭШ.

### Исправлено

- [EDUSCHL-19919](https://jira.bars.group/browse/EDUSCHL-19919)
  MAJOR Удалена поддержка Python 2.


## 2.20.0

- Перенос общих компонентов РВД из ЭШ
    - get_models_table_ids возвращает перечень id таблиц из AuditLog соответствующих указанным моделям;
    - сущности для реализации интеграций ГИС РУО, Сферум, РВД;
    - cached_function кэширует результат функции на указанное время для указанного набора параметров функции;
    - преобразователи str_or_empty, str_without_control_chars, uuid_or_none, int_or_none, decimal_or_none, float_or_none;
    - HashData вспомогательный класс для хеширования данных;
    - вспомогательные функции для работы с датами get_today_min_datetime, get_today_max_datetime,
      get_date_range_intersection, is_date_range_intersection, date_to_str, класс Week для работы с неделей;
    - make_chunks метод нарезки итерабельного объекта на части.

## 2.19.3

- Доработка audit_log
    - Исправлен подход к удалению логов для моделей, которые стали нелогируемыми.

## 2.19.2

- Доработка audit_log
    - Конфигурирование БД вынесено в отдельный метод educommon.audit_log.apps.AppConfig._configure_db,
      который срабатывает после команды migrate (по сигналу post_migrate).

## 2.19.1

- Исправление audit_log
    - Исправлена ошибка преобразования значения у поля типа FloatField
      восстанавливаемой модели в LogProxy;
    - Исправлена ошибка, когда pg_advisory_lock в educommon.utils.db.postgresql.Lock
      приводила к дедлокам. Изменено на pg_try_advisory_lock.

## 2.19.0

- Исправление audit_log
    - Исправлена ошибка при попытке удаления таблицы при наличии уже созданных
      логов по ней
    - Исправлена ошибка, когда для переменной PG_LOCK_ID брался хэш строки, что
      приводило к дедлокам и непредсказуемому поведению приложения, когда оно
      запускалось в нескольких экземплярах
    - Небольшой рефакторинг configure_selective_audit_log.sql

## 2.18.0

- Добавлена команда reinstall_audit_log для переустановки audit_log.

## 2.17.1

- Исправление audit_log.
    - Исправлена ошибка, возникающая при запуске миграции для дефолтной
      базы после проведения миграции для сервисной.
    - Исправлена ошибка, возникающая при запуске миграции для сервисной
      базы после проведения миграции для дефолтной.
    Теперь порядок запуска миграций для дефолтной/сервисной базы не важен.
    - Исправлена ошибка, возникающая при вызове метода bulk_create - добавлена
      обработка для версий Django ниже 2.22.

## 2.17.0

- Улучшение audit_log. Добавлена возможность выбора таблиц для логирования:
    - Добавлен необязательный параметр settings.SELECTIVE_TABLES_LOG_ON,
      который указывает нужно ли включить логирование только для указанных
      таблиц. При отключенном/отсутствующем параметре логируются все таблицы.
    - Добавлен миксин LogableModelMixin, который делает модель логируемой.

## 2.16.1

- Зафиксирована зависимость python-magic==0.4.15 для устранения проблем на ALT Linux

## 2.16.0

- Добавлена реализация асинхронной задачи с блокировкой повторного запуска

## 2.15.1

- **Конструктор отчетов**: Исправлена фильтрация по колонками типа `choices`.

## 2.15.0

- Улучшение. Поддержка распределения записей в больших таблицах
- Добавление. Команда удаления части данных
- Исправление. В секции не добавляются записи в последнюю миллисекунду периода

## 2.14.0

- У функции получения списка измененных моделей добавлен аргумент для
  исключения системных моделей

## 2.13.0

- Изменено перечисление "Формы реализации образовательной программы"
  RealizationForms:
    - Добавлена поддержка специфических значений для продкутов
    - Добавлены значения для продукта ЭК:
        - 5: С применением исключительно электронного обучения
        - 6: С применением исключительно дистанционных
          образовательных технологий
        - 7: Сетевая форма с использованием ресурсов иностранных организаций

- Добавлены новые коды в RealizationForms.WEBEDU_CODES, соответствующие
  видам форм образовательных программ для перечисления RealizationForms:

    - С применением исключительно электронного обучения
    - С применением исключительно дистанционных образовательных технологий


## 2.12.1

- Исправлен поиск связанных объектов. Добавлено отображение неблокирующих
  m2m связей при удалении объекта.

## 2.12.0

- Расширено перечисление "Вид адаптированности" AdaptationType, добавлено
  значение: 212 - для обучающихся с расстройствами аутистического спектра.

## 2.11.0

- Расширен валидатор номера дома HouseValidator - с 10 до 12 символов,
  добавлены символы `.`, `_`, `"`.

  **При обновлении на версию нужно проверить, что параметр `max_length`
  у полей модели, использующей валидатор, не меньше 12**
- Добавлен валидатор корпуса дома BuildingValidator

## 2.10.0

- Добавлена функция удаления разделов таблицы

## 2.9.1

- Расширен список поддерживаемых движков СУБД для использования
  партиционирования.
- Добавлен model view для ContingentModelDeleted.

## 2.9.0

- Добавлен индекс по полю method_name для модели SmevLog.
- Добавление в каталог LegalDelegateTypes (Тип законного представителя)
  дополнительного значения LEGAL_REPRESENTATIVE (Законный представитель)

## 2.8.0

- Добавлена модель и функционал для хранения данных об удалённых объектах
  моделей (используется для хранения параметров для следующей выгрузки в
  Контингент)

## 2.7.8

- **Фабрика метаклассов модифицирующих параметры полей модели**:
    - Исправлена модификация валидатора длины поля.

## 2.7.7

- **Конструктор отчетов**:
    - Исправлен возврат функции фильтрации данных методом
      _DataFilterer.get_filter_function,
      которые после правок в версии 1.26.10 работали только со строками
    - В метод получения данных по основной модели отчета (источнику данных)
      DataLoader._get_objects добавлено условие distinct,
      без которого после фитрации по связям "один ко многим" остаются дубли

## 2.7.6

- **Конструктор отчетов**:  Исправлена ошибка в случае
  указания полей связанных моделей через ключ 'only'
  в report_constructor_params.

## 2.7.5

- Исправлена орфографическая ошибка в сообщении об ошибке в
  валидаторе ИНН и КПП

## 2.7.4

- Добавлен отсутствующий "магический" комментарий с кодировкой,
  из-за отсутствия которого происходило падение на python 2

## 2.7.3

- Добавлен валидатор (минимальное значение)
  для поля time в модели PostgreSQLError.

## 2.7.2

- **Конструктор отчетов**: Исправлена ошибка в случае
  указания полей через ключ 'only' в report_constructor_params.

## 2.7.1

- Удален стандарный валидатор проверки длины для поля KPPField.

## 2.7.0

- В класс BaseIntervalMixin добавлены методы get_intersection_daterange_filter,
  возвращающий фильтр по пересекающимся диапазонам дат и get_model_options,
  возвращающий опции модели.
- Добавлены значения по Гражданству, которые приходят при запросе данных из КО.

## 2.6.1

- Исправлена работа колоночного фильтра "Результат"
  для значения по умолчанию "Успешно" в SmevLogPack.

## 2.6.0

- Добавлен колоночный фильтр поля "результ" в пак логов СМЭВ.
- Добавлен кастомный фильтр по полям типа TextField.
- Заменена иконка ListWindow в паке логов СМЭВ.

## 2.5.7

- Исправлена регулярка для валидатора типа документа.

## 2.5.6

- Исправлена проверка количества значений для фильтра "между" в ReportFilter.

## 2.5.5

- Добавлен unicode_literals из __future__ в файл с основными валидаторами
  для корректной работы регулярок с unicode.

## 2.5.4

- При парсинге xls если нет ошибок возвращался list(), а нужен set()

## 2.5.3

- Исправлена непредвиденная ошибка в окне редактирования шаблона КО в IE-11;

## 2.5.2

- При добавлении ошибки при парсинге xls листа остаются только уникальные.

## 2.5.1

- Валидаторы Серии и Номера документа: изменено регулярное выражение;
- Поля модели: добавлена переменная `__all__`.

## 2.5.0

- **get_related_instances_and_handlers**: Каскадное удаление для m2m-полей.

## 2.4.0

- Валидация полей:
    - Добавлены валидаторы персональных данных физического лица для:
         - ФИО;
         - даты (например, рождения);
         - дома;
         - серии и номера паспорта;
         - серии и номера остальных документов;
    - Добавлены вспомогательные функции для создания миграций с валидаторами по
      дате, в которых требуется динамически изменяющаяся дата. К примеру, когда
      дата рождения не должна быть больше текущей даты.
- Поля модели для персональных данных:
    - Добавлены поля для ФИО, СНИЛС, КПП, ИНН, ОГРН, серии и номера док-в
      (отдельно - паспорта), дат;
    - Некоторые (строковые) поля наследуют интерфейс `IMaskRegexField` и
      указывают маску ввода.

## 2.3.3

- **CascadeDeleleMixin**: Добавлены сигналы pre_cascade и post_cascade.

## 2.3.2

- **CascadeDeleleMixin**: Исправлена совместимость с второй версией Python.

## 2.3.1

- **BaseImportPack**: Исправлена проблема вызова метода `get_loaders`
  без параметров.

## 2.3.0

- **CascadeDeleleMixin**: Доработка алгоритма удаления связанных объектов.

## 2.2.6

- **FileMimeTypeValidator**: Исправлено получение mimetype для докуметов
  созданных в MS office (с расширением docx, xslx, pptx и т.д.).

## 2.2.5

- **RBAC**: Исправлена ошибка функции _get_group_title при доступе к группе,
  которой нет в rbac.groups.

- **RBAC JS**: Добавлена проверка на присутствие атрибута label у
  canBeAssignedField.

## 2.2.4

- **FileMimeTypeValidator**: Исправил ошибку валидации, при которой если уже
  валидировался файл, то его тип не определялся.

## 2.2.3

- **Конструктор отчетов**: Исправлена ошибка метода _is_row_nullable, из-за
  которой выполнение прерывалось при проверке сложносоставных столбцов на
  необходимость сортировки.

## 2.2.2

- **XLSLoader**: Исправлено написание ошибки для Импортера. Теперь указывается
  номер строки.

## 2.2.1

- **RBAC**: Возможность добавления аннотации типов для метода `get_rbac_rule_data`
- **Конструктор отчетов**: Добавлено человекочитаемое представление для столбцов,
  операторов, фильтров, и сортировки в конструкторе отчетов (report_constructor)
- Исправлена ошибка в шаблоне для отображения текста сообщения без
  экранирования символов html-тегов в колонке "Сообщение" в таблице
  перечисления связей при удалении объекта.

## 2.2.0

- **Конструктор отчетов**: Добавлена возможность подсчета количества и суммы
  значений в отчете.
- **Конструктор отчетов**: Исправлено формирование данных при использовании
  ``ArrayField``.

## 2.1.2

- Исправлена ошибка в конструкторе отчетов Excel, не позволяющая
  отсортировать массив, содержащий и обычные значения, и null (None).

## 2.1.1

- Исправление ошибки вызова super() у класса SingleErrorDecimalField.

## 2.1.0

- Добавлен валидатор SingleErrorDecimalValidator для поля
  SingleErrorDecimalField, и добавлено поле SingleErrorDecimalField.

## 2.0.4

- Исправлен баг при неуказанном классе загрузчика в наследниках
  importer.api.BaseImportPack

## 2.0.3

- Исправлена совместимость importer.api.BaseImportPack с Python3

## 2.0.2

- (Несовместима с Python3)
  Исправлена совместимость importer.api.BaseImportPack с Python3

## 2.0.1

- (Несовместима с Python3) Исправлено эпизодическое отображение
  ошибок встраивания прокси из предшествующей загрузки
  при использовании LayoutProxyLoader

## 2.0.0

- Изменения для поддержки Python 3.7.
- Удалены фактически не поддерживаемые south_migrations.

## 1.28.3

- **Конструктор отчетов**: Исправлена работа конструктора при работе с
  вложенными блоками, возникающими при обработке отношений многие-ко-многим.

## 1.28.2

- Добавлен механизм для комплексной валидации строк при дата-импорте.

## 1.28.1

- Исправлена работа конструктора отчетов с ArrayField, BooleanField.

## 1.28.0

- Добавлен валидатор ``FileMimeTypeValidator`` для FileField полей проверяющий
  mimtype файла.

## 1.27.1

- Исправлена ошибка в python3 TypeError: method expected 2 arguments, got 3

## 1.27.0

- Минимальная версия Django поднята до 1.11

## 1.26.16

- Исправлена ошибка приведения типов в XLSLoader.

## 1.26.15

- Исправлена ошибка при проверке необходимости игнорирования поля модели
- Добавлена возможность добавить в конструкторе вычисляемое поле связанной модели

## 1.26.14

- Добавлена возможность изменить базовый кварисет валидатора уникальности.

## 1.26.13

- **Логи СМЭВ**:

 * Добавлена проверка дат в окно параметров печати отчета
 * Печатная форма отчета изменена на Альбомную для того чтобы все столбцы
   умешались на одной странице

## 1.26.12

- Исправлена ошибка перекрытия окна с сообщением при вызове
  ApplicationLogicExeption, при использованиии CancelConfirmWindow.

## 1.26.11

- **Совместимость с Django2.0**: Для совместимости с django 2.0 доработаны:

  * У ``AuditLogMiddleware`` добавлено наследование от MiddlewareMixin для
    совместимостью с новым стилем middleware
  * В модели ``ResetPasswords`` у поля с типом ForeignKey
    добавлен атрибут on_delete

## 1.26.10

- **Конструктор отчетов**: Исправлена работа фильтров.

## 1.26.9

- Добавлен валидатор модели для полей, становящихся обязательными в рамках
  плагина.
- Добавлена возможность настраивать сообщение об ошибке для валидатора
  ``UnchangeableFieldValidator``.

## 1.26.8


- В дополнение к операции миграции ``AlterField`` с поддержкой других
  приложений добавлены операции ``AddField``, ``RemoveField`` и
  ``RenameField``.

## 1.26.7


- **Журнал изменений**: Исправлена ошибка, возникавшая при отображении строкового
  представления удаленого объекта модели, в которой есть поля типа
  ``FileField`` или ``ImageField``.
- **Журнал изменений**: Добавлена поддержка полей типа ``DateTimeField`` при
  отображении строкового представления объекта в журнале изменений.

## 1.26.6


- **Конструктор отчетов**:  Исправлена ошибка формирования отчета. Доработана
  функция проверки блока записей, добавлена проверка пустого множества.

## 1.26.5


- **Конструктор отчетов**:  Исправлена ошибка фильтрации коллонок для создания
  шаблона отчета.


## 1.26.4


- **Конструктор отчетов**:  Исправлена фильтрация коллонок для создания
  шаблона отчета.

## 1.26.3


- Добавлена возможность регистрации и перерегистрации представлений моделей,
  в зависимости от их приоритета.


## 1.26.2


- **Конструктор отчетов**:  Исправлена ошибка связаная с кодировками при
  записи в файл.

## 1.26.1


- **Конструктор отчетов**:  В конструктор отчетов исправлена ошибка объеденения блоков в строке

## 1.26.0


- Добавлена операция миграций ``AlterField`` для изменения параметров полей с
  поддержкой моделей других приложений.

## 1.25.1


- **Подержка django 2.2**: Добавлена подержка django 2.2.

## 1.25.0


- **validation**: В ModelValidationMixin добавлена возможность задавать
  классы-валидаторы для модели.
- **validators**: Добавлены валидаторы для моделей.

## 1.24.0


- **Конструктор отчетов**: вычисляемые поля.

## 1.24.0


- **Конструктор отчетов**: вычисляемые поля.

## 1.23.0


- **Конструктор отчетов**: Исправлено поведение редактора шаблонов так, чтобы
  в режиме ``read_only`` не были доступны кнопки редактирования шаблона.
- **Конструктор отчетов**: в редактор шаблонов отчетов добавлена поддержка
  двойного клика мышью для добавления/удаления столбцов в отчет и
  разворачивания/сворачивания разделов.
- **Конструктор отчетов**: добавлена поддержка полей логического типа. Ранее
  для таких полей в отчете отображались значения "0" и "1". После доработки
  отображаются "Нет" и "Да" соответственно.

## 1.22.1


- **educommon.importer.XLSReader**: Исправлена обработка ключей словаря
  конфигураций страниц, так что бы не возникала ошибка, когда их тип отличный
  от str.

## 1.22.0


- **django.db.utils**: Добавлен ``Lookup`` фильтрации текста по вхождению
  независимо от регистра, букв е/ё и наличия пробелов.

## 1.21.9


- **validators**: Исправлено сообщение валидатора ОКТМО.

## 1.21.8


- **extenders**: Исправлена ошибка добавления расширителей с приоритетом.

## 1.21.7


- **ws_log**: Исправлена ошибка логирования в ``BaseWsApplicationLogger``.

## 1.21.6


- **ws_log**: Исправлена ошибка при сохранение записи лога в Python3.
  При сохранении запрос/ответ в модели не приобразовывался из bytes в str. Это
  приводило к не правильному отображению запросов/ответов в логе.

## 1.21.5


- ``utils.ui``: Багфикс в ``DatetimeFilterCreator``, фильтрация осуществлялась
  по полю ``time``, а не по полю, имя которого указывалось в аргументе
  ``field_name``.

## 1.21.4


- **Конструктор отчетов**: Добавлено текстовое представление модели
  ReportTemplate.

## 1.21.3


- **importer**: в XLSLoader изменен текст ошибки при неправильном именовании
  листов в импортируемом файле.

## 1.21.2


- **Конструктор отчетов**: исправлено падение в реестре конструктора отчета
  при несуществующих полях в подотчетных моделях.

## 1.21.1


- **Построение отчета**: Метод ''SimpleReporter.make_report'' изменен
  для более удобного расширения.
- Обработано исключение, генерируемое дескрипторами при ``clean()`` модели
- Учтены связи ``OneToOneField`` при синхронизации данных с Контингентом.
- Внесены исправления в конструктор отчетов. Исправлена проблема извлечения
  полей из RelatedObject.

## 1.21.0


- Добавлен пакет **about**, реализующий базовый функционал приложения
  "Информация о системе".

## 1.20.9


- **Импорты**: Исправлена ошибка формирования логов при импорте.

## 1.20.8


- **Импорты**: Исправлено учитывание регистра названия листов при поиске
  загрузчиков и замалчивание ошибок при неправильном названии листов.

## 1.20.7


- **Конструктор отчетов**: Исправлен рекурсивный поиск исключаемых полей.

## 1.20.6


- Исправлено отображение лога в журнале изменений, пакет rbac,
  модель RolePermission

## 1.20.5


- Добавлено сохранение названия функции при обертывании в
  ``convert_validation_error_to``

## 1.20.4


- Добавлено предстваление для модели ``contingent_plugin.ContingentModelChanged``
- Доработано подключение плагина ``contingent_plugin``

## 1.20.3


- Исправлен баг при получении модели для проверки в RelationsCheckMixin.
  Ошибка возникала при извлечении модели из прокси над другим прокси.

## 1.20.2


- **RBAC**: Отключено отображение предупреждений об удалении зависимых объектов
  при удалении роли.

## 1.20.1


- Исправлена ошибка связаная с правилом удаление(on_delete) в поле task_type
  модели RunningTask.

## 1.20.0


- Добавлена поддержка django 2.0.

## 1.19.7


- Исправлена ошибка при открытии окна BaseMultiSelectWindow

## 1.19.6


- **RBAC**: багфикс в функции get_rbac_rule_data().

## 1.19.5


- **utils.plugins**: багфикс в модуле (проявлялся в Python 2).

## 1.19.4


- **Журнал изменений**: добавлена возможность отключения актуализации настроек
  журналирования.

## 1.19.3


- Добавлена возможность автоматичекой перезагрузки грида после подтверждения
  удаления всех зависимых объектов.

## 1.19.2


- Исправлена ошибка плагина ``contingent_plugin`` в функции
  ``observer.ContingentFieldsObserver#_has_changes``. При применении дата
  миграций плагином логируются изменения данных. При этом в перечне полей
  логирования находятся и те, которые существовали в модели не всегда.
  Устранено падение, если поля в исторической модели еще не существует.

## 1.19.1


- Добавлена возможность сохранения выбора при переходе между страницами
  BaseMultiSelectWindow

## 1.19.0


- Добавлен пакет **rest**, реализующий базовый функционал для создания
  rest-сервисов
- Исправлена работа ResultPermissionsAction для случая,
  когда у роли есть скрытые разрешения.

## 1.18.0


- Добавлен класс-примесь ``DeferredActionsMixin`` для выполнения отложенных
  действий перед/после сохранения/удаления объекта модели.

## 1.17.5


- Добавлена возможность расширять функции и методы встроенных типов

## 1.17.4


- Исправлено получение пака в ``get_pack()``
- Добавлена проверка типа расширяемой функции/метода

## 1.17.3


- **ws_log**: Добавлен новый тип источника взаимодействия "МФЦ".

## 1.17.2


- **ws_log**: Исправлена ошибка при логирование запросов в Python 3.

## 1.17.1


- **ws_log**: Добавлен новый тип источника взаимодействия "Барс-Образование".
- **delete_check**: Функции получения связанных объектов при удалении вынесены
  за DeleteCheck, исправлено формирование связей при использовании
  Django-коллектора.

## 1.17.0


- В ``ModelValidationMixin`` добавлена возможность выполнения операций
  сохранения с проверкой (``clean_and_save()``, ``objects.create()``) внутри
  транзакции. Такая необходимость возникает в т.ч. когда внутри
  ``full_clean()`` используется ``select_for_update()``.

## 1.16.3


- Добавлены новые параметры полей ввода имен, ОКПО, ОГРН, ОКВЭД, ОКОПФ,
  ОКФС, телефона, эоектронной почты и номера счета.

## 1.16.2


- **django.db.migration.operations**: добавлена поддержка "естественных"
  (natural) ключей в операции ``LoadFixture``.

## 1.16.1


- **delete_check**: Сбор неблокирующих связей при удалении объектов заменен на
  использование коллектора Django.
- **Интервальные модели**: оптимизирована проверка пересечения интервала
  с другими записями модели (параметр ``no_intersections_for``) при
  использовании внешних ключей.
- **Реестр асинхронных задач**: Исправлен некорректный порядок отображения
  результатов выполнения асинхронной задачи.

## 1.16.0


- Добавлено окно отображения связанных объектов с возможностью продолжить
  удаление объекта и его связей.

## 1.15.9


- **RBAC**: Багфикс в команде ``rbac show actions`` при запуске в Python 3.
- **RBAC**: В вывод команды ``rbac show actions`` добавлена подсветка имен
  разрешений и классов.

## 1.15.8


- **Интервальные модели**: Багфикс в метаклассе интервальной модели. Ошибка
  проявлялась в том, случае, когда на основе классов-примесей
  ``DateIntervalMixin`` и ``DateTimeIntervalMixin`` создавались классы-примеси.
  В метаклассе ``BaseIntervalMeta`` учитывались параметры только самого класса,
  но не его предков, в результате при сложном наследовании терялись параметры
  интервальной модели.
- Удалено использование pip API в связи с тем, что в версии 10 оно было
  закрыто.

## 1.15.7


- **Интервальные модели**: Багфикс в метаклассе интервальной модели, из-за
  которого нельзя было поменять параметры полей с границами интервала, если
  в классе модели использовался другой метакласс (конфликт с
  ``model_modifier_metaclass``).

## 1.15.6


- **Журнал изменений**: Удалена привязка к RBAC. Это мешало использовать журнал
  изменений в Системах без RBAC.

## 1.15.5


- **Конструктор отчетов**: Добавление проверки окрашивания в красный только
  листьевю
- **Журнал изменений**: багфикс в коде перенастройки подключения к сервисной
  БД из основной.

## 1.15.4


- Багфикс после добавления поддержки Python 3: исправлен расчет высоты текста
в ячейке

## 1.15.3


- Добавлен перехват ObjectDoesNotExist ошибок для моделей.
- Багфикс после добавления поддержки Python 3: исправлено разбиение слова на
  части для печатных форм.
- **Конструктор отчетов**: Исправление отображения отчетов с неактуальными
  колонками.
- **Конструктор отчетов**: Поле "Отображать данные по дочерним учреждениям"
  переименовано в поле "Отображать данные по дочерним организациям".

## 1.15.2


- Багфикс после добавления поддержки Python 3: добавлено принудительное
  приведение номера строки к строковому виду в key-функции сортировки логов.

## 1.15.1


- Багфикс после добавления поддержки Python 3: убран decode() для объектов str.

## 1.15.0


- Добавлен функционал расширителей классов (``educommon.utils.plugins``).

## 1.14.3


- **RBAC**: Багфикс в модели ``UserRole`` (непраивльно выполнялась проверка
  возможности назначения роли указанному типу пользователя).

## 1.14.2


- **RBAC**: Багфикс в окне редактирования роли: не отображались наименования
  разделов.
- Багфикс после добавления поддержки Python 3: при использовании директивы
  ``from __future__ import absolute_imports`` в Python 2 значение
  ``__package__`` содержит пустую строку вместо имени пакета.

## 1.14.1


- **ws_log**: Исправлена ошибка сортировки по столбцу "Код метода".

## 1.14.0


- Поддержка Python 3.

## 1.13.8


- **Реестр асинхронных задач**: Исправлена ошибка, возникающая при попытке
  использования ``retry`` у асинхронных задач.


## 1.13.7


- **Конструктор отчетов**: Исправлена ошибка, возникающая при формировании
  и редактировании отчетов из шаблонов, поля которых были исключены
  при помощи ``model.report_constructor_params`` (except, only, skip).


## 1.13.6


- **m3**: Доработана совместимость с Django >= 1.9

## 1.13.5


- **ws_log**: Добавлена возможность сортировки записей в реестре логов
  запросов СМЭВ (``educommon.ws_log.actions.SmevLogPack``)

## 1.13.4


- **django.db.migration.operations**: В ``LoadFixture`` и ``CorrectSequence``
  добавлены возможности принудительно загрузить фикстуры и
  скорректировать sequence для моделей
  (например, для моделей, у которых параметр managed=False).

## 1.13.3


- **Конструктор отчетов**: Исправлена ошибка, при которой некорректно
  выполнялась проверка ограничивающих параметров столбцов вложенных
  моделей источника.

## 1.13.2


- **django.db.utils**: Багфикс в ``model_modifier_metaclass`` (при изменении
  параметры ``max_length`` у поля ``CharField`` в соответствующем валидаторе
  поля значение оставалось равным исходному).

## 1.13.1


- **ws_log**: Исправлена ошибка при обработке события wsgi_exception.

## 1.13.0


- **ws_log**

  - Доработано логирование запросов к веб-сервисам.
  - Добавлен менеджер логгеров (``educommon.ws_log.utils.logger_manager``).
  - Добавлен класс-интерфейс для конфигурирования менеджера логгеров
    (``educommon.ws_log.IConfig``).
  - Добавлен логгер для уже существующих веб-сервисов
    (``educommon.ws_log.base.DefaultWsApplicationLogger``).

## 1.12.3


- **RBAC**: Багфикс проверки типа пользователя в модели ``UserRole``.

## 1.12.2


- **RBAC**: Реализована защита от удаления из всех ролей разрешения на
  редактирование роли.

## 1.12.1


- **RBAC**: Багфикс в миграции 0004: из-за того, что не был прописан менеджер
  по умолчанию, использование модели ``UserRole`` в миграциях приводило к
  ошибке, т.к. атрибута ``objects`` у этой модели не было.

## 1.12.0


- **RBAC**: Добавлена возможность назначения ролей определенному типу
  пользователей.

## 1.11.2

- ``utils.fonts``: Добавлен шрифт Calibri.

## 1.11.1


- ``utils.ui``: Добавлена возможность указывать callable-объекты для
  формирования вариантов выбора в фильтре ``educommon.utils.ui.ChoicesFilter``.

## 1.11.0


- **Конструктор отчетов**: Изменена логика обработки параметров моделей,
  теперь иерархия столбцов отчета формируется в зависимости от параметров
  источника данных.
- **Конструктор отчетов**: Добавлена возможность указывать вложенные поля в
  параметрах конструктора модели.

## 1.10.0


- Добавлен парсер для файлов лицензий (``educommon.utils.licence``).
- **RBAC**: Добавлена возможность сокрытия разрешений от пользователя.
- **RBAC**: В окно редактирования роли добавлен столбец "Зависимые разрешения".

## 1.9.1


- **Конструктор отчетов**: Добавлена проверка заполненности параметров
  сортировки отчета на клиенте.

## 1.9.0


- **Конструктор отчетов**: Минимальная версия *Django* поднята до *1.8*.
- **Конструктор отчетов**: Регистрация `lower` лукапа при подключении плагина.
- **Конструктор отчетов**: Исправлена работа фильтров "Равно одному из" и
  "Между".
- Добавлена возможность расширения списка зависимых объектов перед удалением
  записей в слушателе ``DeleteCheck``, через сигнал ``collect_implicit``.
- **Журнал веб-сервисов**: в окне печати и xls шаблоне изменено название поля
  с "Учреждение" на "Организация".
- Добавлены переменные "Константы" обозначающие некоторые элементы справочника
  образовательных организаций
- **RBAC**: Исправлена ошибка открытия списка ролей при наличии права только
  на просмотр.

## 1.8.3


- Исправлена ошибка в ``educommon.django.db.utils.model_modifier_metaclass``.
  Не было учтено, что некоторые атрибуты поля имеют дубликаты *(например,
  значение ``verbose_name`` дублируется также и в атрибуте ``_verbose_name``)*.
  В результате, если не продублировать значение в таких атрибутах, при
  формировании файла миграции переопределенные в ``model_modifier_metaclass``
  параметры полей не будут учтены.

## 1.8.2


- **RBAC**: Добавлена возможность указывать зависимости между разрешениями
  в виде callable-объекта (актуально для предотвращения кросс-импортов).

## 1.8.1


- **RBAC**: Добавлена поддержка классов конфигурации django-приложений в
  параметре ``INSTALLED_APPS``.

## 1.8.0


- **RBAC**: Добавлена возможность определять зависимости между разрешениями.
- **RBAC**: В окно редактирования роли добавлена возможность просмотра итоговых
  разрешений, предоставляемых ролью (с учетом зависимых разрешений и вложенных
  ролей).
- **RBAC**: Прописаны зависимости между разрешениями в следующих приложениях
  ``educommon.auth.rbac`` и ``educommon.audit_log``.
- **Утилиты**: добавлена функция ``patch_utf8_assertion_error``. Если её
  вызвать при инициализации проекта, то все исключения AssertionError
  с русскоязычными сообщениями будут отображаться корректно.

## 1.7.0


- **RBAC**: Добавлено отображение текстового описания разрешения в окне
  редактирования роли.

- Перенос шаблонного фильтра ``jsonify`` в ``educommon.utils.system_app``.

## 1.6.8


- **RBAC**: Доработка функции ``educommon.auth.rbac.utils.get_rbac_rule_data``.
  Добавлена поддержка метода ``get_rbac_rule_data`` в действиях (``Action``), а
  также поддержка аргумента ``action`` в методах ``get_rbac_rule_data``.

## 1.6.7


- **Утилиты**: Багфикс в функции ``educommon.utild.db.get_related_fields()``.

## 1.6.6


- **RBAC**: Багфикс в коде запуска обработчиков разрешений.

## 1.6.5


- **RBAC**: Доработана проверка на вложенность при удалении роли из роли.
- Вынесен шаблонный фильтр jsonify.

## 1.6.4


- Добавлен источник взаимодействия "концентратор" в реестр "Поставщики СМЭВ"

## 1.6.3


- **Утилиты**: исправлена ошибка в функции ``is_in_migration_command()``,
  допущенная в предыдущей версии ``educommon``.

## 1.6.2


- **Утилиты**: доработана функция ``is_in_migration_command()``. Ранее в
  версиях Django 1.7 она возвращала ``True`` только если вызов функции
  осуществлялся в рамках выполнения management-команды ``migrate``, команды
  ``makemigrations``, ``sqlmigrate`` и ``show_migrations`` не учитывались.
  Поддержка этих команд добавлена в функцию.

## 1.6.1


- **Конструктор отчетов**: в окне редактирования шаблона отчета на вкладке
  "Фильтры" столбец "Оператор" переименован на "Условие".

- **Конструктор отчетов**: доработка для совместимости с Celery 4.x.
  ``ConstructorConfig.async_task`` должен возвращать экземпляр класса, а в коде
  результат использовался как класс.

- Обновлены secure_media urlpatterns для Django 1.10.

## 1.6.0


- **Конструктор отчетов**: добавлена возможность переопределения наименований
  столбцов при настройке источников данных.

## 1.5.0


- **Журнал изменений**: добавлена проверка наличия в базах данных (основной и
  сервисной) необходимых расширений. При их отсутствии осуществляется попытка
  создания недостающих расширений: для основной БД --- ``postgres_fdw`` и
  ``hstore``, для сервисной --- ``hstore``.
- **Журнал изменений**: исправлена ошибка, возникающая при выполнении миграций
  на пустой БД.

## 1.4.0


- Конструктор отчетов: фильтрация и сортировка данных, багфиксы.
- Исправлена ошибка в зависимости от пакета ``m3-django-compat``, которая
  приводила к тому, что при установке зависимостей в соответствии со списком
  зависимостей проекта устанавливалась версия 1.3.0 несмотря на то, что другие
  пакеты требовали более высоких версий ``m3-django-compat``.

## 1.3.2


- Исправлена миграция изменения Поле "Адрес сервиса изменения статуса"
  в модели "Поставщики СМЭВ"


## 1.3.1


- Поле "Адрес сервиса изменения статуса" в модели "Поставщики СМЭВ"
  сделано необязательным.

## 1.2.0


- В educommon.importer.EnumCell добавлена возможность указывать значения,
  при которых ячейка считается пустой.

## 1.1.4


- Добавлены типы законного представителя ("Попечитель" и "Руководитель воспита-
  тельного, лечебного и иного учреждения, в котором ребенок находится на
  полном государственном обеспечении") в качестве доступных для выбора в
  справочниках значений в ЭДС.

## 1.1.3


- Исправление ошибки в функции ``educommon.ws_log.smev.applications.method_call``.
  Если дескриптор метода не найден(ResourceNotFound), при попытки получить
  из системы информацию по методу сервиса для логирования, падала ошибка.

## 1.1.2


- Исправление ошибки в функции ``educommon.utils.m3.db.get_related_fields``.
  Ошибка заключалась в том, что функция возвращала M2M-поля, указывая на то,
  что из них есть ссылки (внешний ключ) на указанную в первом аргументе функции
  модель. Но фактически такой ссылки нет --- есть ссылка из промежуточной
  таблицы. Это приводило к неправильному функционированию слушателя
  ``DeleteCheck``.

## 1.1.1


- При отсутствии прав на редактирование разрешений ролей грид в
  ``educommon.auth.rbac.ui.RoleEditWindow`` будет типа `ExtGridRowSelModel`,
  иначе `ExtGridCheckBoxSelModel`. Добавлен стиль для строк грида ролей
  которые не выбраны.

## 1.1.0


- Объявлены две константы для перечисления трудных жизненных ситуаций
  (``educommon.contingent.catalogs.DifficultSituations``).
- Добавлена совместимость ``educommon.django.db.partitioning`` c Django 1.4.
- Добавлен справочник "Тип документа, подтверждающего права".

## 1.0.12


- Исправлена 4-ая миграция модуля ``educommon.ws_log``, добавлено явное
  приведение типа, при изменении поля ``source``.

## 1.0.11


- Блокировка грида в ``educommon.auth.rbac.ui.RoleEditWindow``, если имеются
  права только на просмотр ролей. Скрытие кнопки сохранить.

## 1.0.10


- Исправление ошибки при фильтрации записей по полю "Объект" в Журнале
  изменений (``educommon.audit_log``).

## 1.0.9


- Перенос проверки наличия полей в моделях для
  ``contingent.contingent_plugin.observer.ContingentFieldsObserver``

## 1.0.8


- Исправил функцию проверки наличия SQL процедур, необходимых
  для проведения партиционирования.

## 1.0.7


- Исправлена ошибка UnicodeEncodeError при обработке
  ``spyne_smev.fault.ApiError``.

## 1.0.5


- Восстановлена загрузка фикстуры для модели типа асинхронных задач
  в django-миграциях.

## 1.0.4


- Секционирование таблиц PostgreSQL: Багфикс в ``partitioning.sql``.

## 1.0.3


- Секционирование таблиц PostgreSQL: Исправление ошибки в функции
  ``partitioning.get_sequence_for_field()``.

## 1.0.2


- Конструктор отчетов: переведение сборки в асинхронный режим работы.

## 1.0.1


- Конструктор отчетов: увеличение времени ожидания сборки.

  Сборка отчетов может занимать много времени, но при этом пока идет в
  синхронном режиме, поэтому таймаут ожидания ответа на HTTP-запрос
  сборки отчета увеличен до 30 минут.

## 1.0.0


- Изменен порядок нумерации версий, описание см. в README.rst.
- Реализация конструктора отчетов.
- Исправление ошибок в параметрах моделей с ``CascadeDeleleMixin``.

## 0.15.32


- Исправление ошибок в ``CascadeDeleteMixin``.

## 0.15.31


- Исправлены ошибки в механизме импорта. В лог теперь попадают сообщения
  об ошибках извлечения данных из xls. Если были ошибки при импорте без
  игнорирования ошибок, то даже корректные данные не загружаются.

## 0.15.30


- заменила None значения uftt_code в IdentityDocumentsTypes на значение 4
  (Другой документ, удостоверяющий личность )

## 0.15.29


- educommon.audit_log: Исправлена ошибка в параметрах фильтра колонки "Объект".

## 0.15.28


- Перенесен слушатель ``DeleteCheck``, собирающий и показывающий информацию о
  зависимых обьектах.
- Перенесен ``model_view`` , отображающий связи о зависимых объектах.
- Создана инфраструктура для тестирования паков.
- Созданы примеси к моделям и пакам для каскадного удаления обьектов.
- Тесты для примесей ``CascadeDeleleMixin`` и ``CascadeDeletePackMixin``.
- Добавлена совместимость management-команды ``rbac`` с версиями django<1.10.
- Перенесены функции ``get_field``, ``get_related_fields``,
  ``get_related_instances``, ``get_nested_attr``, ``local_template``.

## 0.15.27


- ``educommon.ws_log``: добавлен индекс для поля "Время СМЭВ запроса"
  (``ws_log_smevlog.time``).
- ``educommon.ws_log``: оптимизирован запрос на выборку записей.

## 0.15.26


- Исправлена ошибка pickle объекта модели партицированной таблицы

## 0.15.25


- ``educommon.auth.simple_auth``: добавлена возможность кастомизации алгоритма
  поиска учетной записи по email при восстановлении пароля. В ``educommon.ioc``
  добавлена возможность зарегистрировать функцию ``get_user_by_email(email)``,
  в которой реализован альтернативный алгоритм.

## 0.15.24


- Убрано сообщение «Файл пуст» при импорте.
- Исправлена ошибка при миграциии ``ws_log`` на всех версиях Django.

## 0.15.23


- Исправлена проблема с указанием высоты строки объединенных ячеек при
  использовании ``educommon.report.utils.adjust_row_height``.
- Добавлен шрифт Tahoma Regular.
- В метод ``BaseIntervalMixin.get_date_in_intervals_filter()`` добавлены
  аргументы ``include_lower_bounds`` и ``include_upper_bounds``, определяющие
  включение границ в интервалы.

## 0.15.22


- Исправлена ошибка невозможности ввода значения фильтров русскими символами в
  management-команде ``delete_objects``.

## 0.15.21


- Добавлена management-команда ``delete_objects`` для удаления объектов.
- В ``educommon.django.db.partitioning`` добавлены management-команды
  для осуществления секционирования и миграции данных из родительской
  таблицы в соответствующие секции.
- Добавлена функция ``reconfigure_object_tree_by_access`` для
  перенастройки древовидного грида в зависимости от прав доступа.
- RBAC: В окне редактирования роли исправлена сортировка списка разрешений.

## 0.15.20


- Добавлен журнал изменений

## 0.15.19


- Исправлена ошибка при миграции ``contingent_plugin`` на версиях Django выше
  1.9.0.

## 0.15.18


- Исправлена ошибка при которой невозможно изменить название файла отчета, если
  задан параметр ``title`` у пака для генерации отчета.

## 0.15.17


- Поддержка версий PostgreSQL<9.5 в коде партиционирования таблиц БД. Для
  установки изменений в БД нужно выполнить
  ``partitioning.init(database_alias, force=True)``. Изменение вышло также в
  версии 0.14.24.

## 0.15.16


- Поддержка табличных пространств в партиционированных таблицах. Новые разделы
  будут создаваться в том же табличном пространстве, в котором находится
  основная таблица, а не в табличном пространстве по умолчанию. Для установки
  изменений в БД нужно выполнить
  ``partitioning.init(database_alias, force=True)``.

## 0.15.15


- Исправление ошибки получения списка зависимых объектов в
  ``educommon.objectpack.actions.RelationsCheckMixin``.

## 0.15.14


- Исправление ошибок, допущенных в версии 0.15.10, в очередности параметров
  инициализации ``educommon.importer.proxy_import.ProxyLoader`` и пустому
  логу при загрузке строк в ``educommon.importer.proxy.MultiProxyLoader``,
  приводивших к проблемам с обратной совместимостью.

## 0.15.13


- Исправление ошибок модуля импортера для работы библиотеки с версиями
  m3-core ниже 2.2.5.

## 0.15.12


- К initial миграции contingent_plugin добавлен run_before со всеми
  приложениями из settings.PROJECT_APPS.

## 0.15.11


- Добавлена обработка критической ошибки импорта для предварительной проверки.

## 0.15.10


- Добавлен функционал предварительной проверки шаблона для операции импорта.

## 0.15.9


- Исправление ошибок в коде партиционирования таблиц БД, допущенных в версии
  0.14.21.

## 0.15.8


- Исправление ошибок, допущенных в версии 0.14.20/0.15.7, в коде
  ппартиционирования таблиц БД.

## 0.15.7


- Доработана печать Логов СМЭВ.
- Дополнительная оптимизация триггеров, обеспечивающих партиционирование таблиц
  БД.

## 0.15.6


- Исправлена ошибка ``educommon.importer.proxy_import.ProxyLoader``,
  в которой вызов метода ``load`` при наличии ошибок в импорте
  возвращал True.

## 0.15.5


- Оптимизация триггеров, обеспечивающих партиционирование таблиц БД (также
  в версии 0.14.19).

## 0.15.4


- Исправления в OriginalObjectMixin, исправляющие ошибку по внесению None
  в WeakValueDictionary.

## 0.15.3


- Исправления в OriginalObjectMixin, позволяющие без проблем накатывать
  миграции с загрузкой из фикстур.
- Добавлены константы для справочников "Образовательные программы", "Виды
  адаптированности", "Формы реализации образовательной программы".

## 0.15.2


- В ``educommon.report.utils`` добавлены функции ``cm_to_inch``,
  ``inch_to_cm``, ``get_cell_bounds``, ``get_cell_width`` и
  ``get_cell_height``.
- В функцию ``educommon.report.utils.adjust_row_height`` добавлена поддержка
  объединенных ячеек.

## 0.15.1


- Багфикс в базовом классе для роутеров БД ``ServiceDbRouterBase``.

## 0.15.0 (2016-09-15)


- Выполнен рефакторинг наблюдателя за изменениями в моделях (инструкции по
  обновлению см. в ``UPGRADE.rst``).
- Изменения для совместимости с Django 1.10.

## 0.14.25


- ``educommon.ws_log``: добавлен индекс для поля "Время СМЭВ запроса"
  (``ws_log_smevlog.time``).
- ``educommon.ws_log``: оптимизирован запрос на выборку записей.

## 0.14.24


- Поддержка версий PostgreSQL<9.5 в коде партиционирования таблиц БД. Для
  установки изменений в БД нужно выполнить
  ``partitioning.init(database_alias, force=True)``.

## 0.14.23


- Поддержка табличных пространств в партиционированных таблицах. Новые разделы
  будут создаваться в том же табличном пространстве, в котором находится
  основная таблица, а не в табличном пространстве по умолчанию. Для установки
  изменений в БД нужно выполнить
  ``partitioning.init(database_alias, force=True)``.

## 0.14.22


- Исправление ошибок в коде ппартиционирования таблиц БД, допущенных в версии
  0.14.21.

## 0.14.21


- Исправление ошибок, допущенных в версии 0.14.20, в коде ппартиционирования
  таблиц БД.

## 0.14.20


- Дополнительная оптимизация триггеров, обеспечивающих партиционирование таблиц
  БД.

## 0.14.19


- Оптимизация триггеров, обеспечивающих партиционирование таблиц БД.

## 0.14.18 (2016-09-14)


- Исправлена ошибка, когда при ошибке в xml не отображалось имя метода в
  логах СМЭВ
- Исправлена ошибка при определении сообщения о пересечении интервалов в RBAC
- simple_report заменен на m3-simple-report
- Убраны номера версий у termcolor и django-sendfile

## 0.14.17 (2016-08-26)


- Исправлены ошибки совместимости с django 1.4 в contingent_plugin

## 0.14.16 (2016-08-09)


- Добавлена модель для отслеживания измененных данных контингента
- Добавлена реализация паттерна observer для django models
- Добавлена функция для автоматического увеличения высоты строки в отчете,
  в зависимости от содержимого ячейки.

## 0.14.15 (2016-08-01)

- RBAC. Проверка на существование объекта RolePermission

## 0.14.14 (2016-07-29)


- Исправлено сообщение об ошибке уникальности в SmevProvider
- Исправлена ошибка миграции ws_log в south migrations

## 0.14.13 (2016-07-27)


- Переделано поле "Источник взаимодействия" в модели "Поставщики СМЭВ"
- Убрал запись в лог ФИО поставщика, т.к. это свойство специфично для каждого
  продукта.
- Добавил вызов метода update_log, который может быть определен в классах web-сервисов,
  чтобы производить с объектом-логом специфичные для продукта операции.

## 0.14.12 (2016-07-25)


- Фикс получения related_objects через m3-django-compat
  в ``objectpack.actions.RelationsCheckMixin``.
- Добавил возможность автоматически заполнять поле Учреждение в окне настройки
  печати логов СМЭВ.
- Исправление циклических импортов в ``utils.ui``.
- Убрано неявное поведение при инициализации RBAC.

## 0.14.11 (2016-07-20)


- В ``objectpack.actions.RelationsCheckMixin`` добавлена опциональная настройка
  для задания заголовков таблиц зависимых объектов.
- Багфикс в модуле ATCFS. Исправлен вывод отладочной информации при выполнении
  команды atcfs_migrate.
- Исправлена инициализация RBAC при прохождении миграций БД.

## 0.14.10 (2016-07-18)


- Добавлены константы для справочника "Типы документов удостоверяющих личность".

## 0.14.9 (2016-07-12)


- Добавлены новые поля в реестр логов СМЭВ, а так же их заполнение при логировании
  запросов к web-сервисам.
- Поле error в логах СМЭВ переименовано в result.
- Добавлена возможность печатать логи СМЭВ.
- Добавлен параметр для ввода адреса ``url_field_params``.

## 0.14.8 (2016-07-06)


- Изменения для совместимости с Django 1.9.

## 0.14.7 (2016-07-06)


- Добавлено новое значение для справочника "Трудная жизненная ситуация", также
  вынесены константы для справочника "Тип документа, удостоверяющего
  личность"
- Устранена несовместимость с Django 1.8.

## 0.14.6 (2016-06-30)


- Изменена генерация имен файлов для отчетов, теперь они включают в себя
  названия отчетов
- Добавлены новые поля в реестр "Поставщики СМЭВ"
- Базовый класс для роутеров моделей дополнен методом ``allow_migrate`` в
  целях совместимости с Django>=1.7.
- RBAC: Удалена зависимость от South (нужно для проектов с Django>=1.7).
- Добавлена поддержка миграций Django в приложениях ``simple_auth``, ``rbac`` и
  ``async``.
- Изменения для поддержки Django 1.7.

## 0.14.5 (2016-06-07)


- Справочник физкультурных групп пополнен новыми значениями.
- В ``m3.extensions.ui.BaseEditWinExtender`` добавлена поддержка маппинга
  ``ArrayField`` → ``ExtMultiSelectField``.
- RBAC: добавлено verbose_name модели RoleParent.

## 0.14.4 (2016-05-27)


- Добавлен реестр "Поставщики СМЭВ".

## 0.14.3 (2016-05-26)


- **ws_log**: Изменение в коде извлечения данных из ``METHOD_VERBOSE_NAMES``:
  значения ключей заменены на словари с ключами ``method_verbose_name``,
  ``interaction`` и ``protocol``.
- **ws_log**: Добавлено определение вида взаимодействия по протоколу.

## 0.14.2 (2016-05-19)


- Изменение async: добавлены поля описания задачи.
- Изменение async: в результат добавлено время выполнения задачи
  после её завершения.

## 0.14.1 (2016-05-08)


- Обновление пакета ``m3-django-compat`` версии 1.1.x.
- Декоратор ``nested_commit_on_success`` помечен как устаревший.
- ``nested_commit_on_success``, ``commit_on_success`` и ``commit_manually``
  заменены на ``m3_django_compat.atomic``.
- Базовый класс менеджеров моделей изменен с
  ``django.db.models.manager.Manager`` на ``m3_django_compat.Manager``.

## 0.14.0 (2016-05-07)


- Подключение пакета ``m3-django-compat``, реализующего инструменты обеспечения
  совместимости кода с версиями Django>=1.4.

## 0.13.8 (2016-05-12)

- ws_log: отключено логирование wsdl-запросов.
- ws_log: при возникновении ошибки указывается тип запроса "Не СМЭВ".

## 0.13.7 (2016-05-06)


- Багфикс фильтрации в реестре логирования вебсервисов.

## 0.13.6 (2016-04-27)


- Добавлена примесь ``DateTimeIntervalMixin``, аналог ``DateIntervalMixin``
  для дат со временем.

## 0.13.5 (2016-04-25)


- Багфикс в классе-примеси ``ModelProxyValidationMixin``.

## 0.13.4 (2016-04-13)


- Багфикс запуска приложений на django 1.9

## 0.13.3 (2016-04-07)


- Багфикс в журнале веб-сервисов (educommon.ws_log): Исправил вывод ошибки,
  когда после ошибки в методе web-сервиса, в лог записывалась ошибка валидации xml.

## 0.13.2 (2016-04-02)


- Багфикс в журнале веб-сервисов (educommon.ws_log): запись журнала не
  сохранялась(падала ошибка при сохранении), так как в модель логирования было
  добавлено обязательное поле direction, которое не заполнялось при сохранении.

## 0.13.1 (2016-04-01)


- Багфикс в журнале веб-сервисов (educommon.ws_log): запись журнала не
  сохранялась, если не был указан ответ веб-сервиса.

## 0.13.0 (2016-04-01)


- Добавлено поле Направление запроса в модель журнала запросов вебсервисов.
  Внимание! Поле обязательно для заполнения! После перехода на данную версию
  educommon необходимо при сохранении инстанса модели SmevLog указывать
  значение атрибута direction.

## 0.12.9 (2016-04-22)


- Исправлена примесь ``ModelProxyValidationMixin``:

  1. Lazy объекты принудительно преобразуются в строки для проверки вхождения
     в список ошибок.
  2. ``ModelProxyValidationMixin`` устанавливает верный атрибут, указывающий, что
     объект Django-модели прошел валидацию.

## 0.12.8 (2016-04-01)


- Оптимизация процесса инициализации подсистемы RBAC:

  1. Из-за неправильной подстановки значений по умолчанию для поля
     ``Permission.description`` (``None`` вместо ``u''``) при каждой
     инициализации подсистемы RBAC разрешения, у которых не было описания,
     обновлялись в БД, т.е. для каждого разрешения без описания выполнялся
     один ненужный UPDATE-запрос.
  2. При проверке наличия изменений в параметрах разрешений неоптимально
     загружалась информация из БД (по одной записи на каждое разрешение),
     что приводило к выполнению одного SELECT-запроса на каждое разрешение.

## 0.12.7 (2016-03-31)


- Багфиксы в кэширующем бэкенде RBAC:

  1. Сигналы ``post_save`` и ``post_delete`` срабатывали для всех моделей
     системы (нужно было учитывать только сигналы от моделей RBAC).
  2. Не обрабатывались изменения в M2M-модели, используемой для хранения
     разрешений ролей, т.к. Django не отправляет сигналы от автоматически
     созданных моделей. В результате изменение списка разрешений роли не
     приводило к перезагрузке кэша.

## 0.12.6 (2016-03-23)


- Багфиксы в параметрах сборки и установки пакета (теперь сборка и установка
  пакета не требует предварительной установки ``m3-builder``).

## 0.12.5 (2016-03-22)


- Подключение ``m3-builder`` как расширения ``setuptools``.

## 0.12.4 (2016-03-21)


- Журнал запросов СМЭВ.

## 0.12.3 (2016-03-17)


- Исправлена некорректная загрузка ролей пользователей с ограниченным сроком
  действия в кеширующем бэкенде для подсистемы RBAC (см. версию 0.11.6).

## 0.12.2 (2016-03-14)


- Багфикс в коде партиционирования таблиц БД. Ограничения (check constraints),
  накладываемые на разделы, должны содержать только константы, т.к. иначе не
  работает т.н. constraint exclusion и при запросе данных из таблицы
  просматриваются все разделы, а не те, которые удовлетворяют условию выборки
  (см. версию 0.6.7).

## 0.12.1 (2016-03-11)


- ``contingent.catalogs.IdentityDocumentsTypes`` обновлен перечнем типов
  документов, которые могут не иметь серии.

## 0.12.0 (2016-03-03)


- Переименование класса-примеси ``DeleteAfterSaveMixin`` на
  ``DeleteOnSaveMixin`` в связи с добавлением возможности удаления объектов
  *перед* сохранением.

## 0.11.6 (2015-03-17)


- Исправлена некорректная загрузка ролей пользователей с ограниченным сроком
  действия в кеширующем бэкенде для подсистемы RBAC.

## 0.11.5 (2015-03-16)


- Исправлена ошибка в setup.py, приводящая к невозможности установки версии
  0.11.4.

## 0.11.4 (2016-03-14)


- Багфикс в коде партиционирования таблиц БД. Ограничения (check constraints),
  накладываемые на разделы, должны содержать только константы, т.к. иначе не
  работает т.н. constraint exclusion и при запросе данных из таблицы
  просматриваются все разделы, а не те, которые удовлетворяют условию выборки
  (см. версию 0.6.7).

## 0.11.3 (2016-02-25)


- Исправлена ошибка при получение связанных записей Django 1.9

## 0.11.2 (2016-02-25)


- ATC FS: Отображение информации при недоступности ВФХ.

## 0.11.1 (2016-02-19)


- ATC FS: Багфиксы в коде обработки действий при недоступном сервере ВФХ.

## 0.11.0 (2016-02-10)


- Функции для объединения обработчиков правил RBAC логическими операциями НЕ, И,
  ИЛИ.
- Реализован кеширующий бэкенд для подсистемы RBAC.
- Добавлен модуль ``educommon.utils.version``, выполняющий сбор данных о билде
  проекта.

## 0.10.3 (2016-03-14)


- Багфикс в коде партиционирования таблиц БД. Ограничения (check constraints),
  накладываемые на разделы, должны содержать только константы, т.к. иначе не
  работает т.н. constraint exclusion и при запросе данных из таблицы
  просматриваются все разделы, а не те, которые удовлетворяют условию выборки
  (см. версию 0.6.7).

## 0.10.2 (2016-02-02)


- Доработка приложения для авторизации пользователей: реализован компонентный
  подход к формированию страницы входа в систему.

## 0.10.1 (2016-02-01)


- Багфикс в классе ``StringFieldsCleanerMixin`` (см. версию 0.9.6).

## 0.10.0 (2016-01-29)


Добавлена частичная поддержка Django 1.9 с полной обратной совместимостью:

- Метод ``educommon.importer.proxy.MultiProxyLoader.load_rows`` переписан
  с использованием ``transaction.atomc`` (``delay_in_situations`` он
  не поддерживает).
- Добавлен конфиг класс ``educommon.objectpack.apps.EduObjectPackConfig`` для
  избавления конфликта имен с приложением m3-objectpack.
- В менеджерах моделей, методу ``get_query_set`` добавлен
  его новый аналог - ``get_queryset``.

## 0.9.7 (2016-03-14)


- Багфикс в коде партиционирования таблиц БД. Ограничения (check constraints),
  накладываемые на разделы, должны содержать только константы, т.к. иначе не
  работает т.н. constraint exclusion и при запросе данных из таблицы
  просматриваются все разделы, а не те, которые удовлетворяют условию выборки
  (см. версию 0.6.7).

## 0.9.6 (2016-02-01)


- Багфикс в классе ``StringFieldsCleanerMixin``.

## 0.9.5 (2016-01-25)


- Режим раздельного вывода ошибок и предупреждений при импорте.

## 0.9.4 (2016-01-22)


- Багфикс в обработчике сигнала ``post_delete`` подсистемы RBAC.
- ATC FS: введено ограничение на длительность подключения к ВФХ.
- Доработка класса-примеси ``DateIntervalMixin``: в метод
  ``interval_intersected_error_message()`` передается дополнительный аргумент
  others для возможности формирования более информативных сообщений.

## 0.9.3 (2016-01-20)


- Багфикс в классе-примеси ``ModelProxyValidationMixin``.

## 0.9.2 (2016-01-20)


- Багфикс в классе-примеси ``ModelValidationMixin``.

## 0.9.1 (2016-01-19)


- Багфикс в классе-примеси ``ModelValidationMixin``.

## 0.9.0 (2016-01-15)


- Багфикс в пакете educommon.importer (Приведение дат к более точному типу).
- В классе-примеси для принудительной валидации моделей
  ``ModelValidationMixin`` добавлена поддержка сигналов ``pre_clean`` и
  ``post_clean``.
- Добавлен класс-примесь ``DeleteAfterSaveMixin`` для удаления объектов после
  сохранения модели.
- Добавлен класс-примесь ``StringFieldsCleanerMixin`` для удаления из строковых
  полей модели лишних пробелов.

## 0.8.5 (2015-12-21)


- Багфикс в пакете ``educommon.importer`` (конфликт имени ``ValidationError`` в
  ``proxy.py`` и ``XLSReader.py``).

## 0.8.4 (2015-12-17)


- В модуле ATCFS реализован механизм передачи в интерфейс ошибок в
  удобочитаемом виде.

## 0.8.3 (2015-12-14)


- В ``educommon.ioc`` добавлены 3 глобальных переменных для корректной работы
  с ``edureception``. Переменные содержат информацию о моделях справочников.

## 0.8.2 (2015-12-03)


- В модуле ATCFS удалена зависимость от пакета rfc6266.

## 0.8.1 (2015-12-02)


- Исправлена ошибка в базовом классе асинхронных задач.

## 0.8.0 (2015-11-30)


- Добавлены модели и базовый класс для асинхронных задач.

## 0.7.1 (2016-03-14)


- Багфикс в коде партиционирования таблиц БД. Ограничения (check constraints),
  накладываемые на разделы, должны содержать только константы, т.к. иначе не
  работает т.н. constraint exclusion и при запросе данных из таблицы
  просматриваются все разделы, а не те, которые удовлетворяют условию выборки
  (см. версию 0.6.7).

## 0.7.0 (2015-11-26)


- Добавлен справочник "Формы реализации образовательной программы".
- Добавлен класс-примесь ``ModelValidationMixin``, обеспечивающий валидацию
  данных в моделях перед их сохранением в БД.

## 0.6.11 (2016-04-16)


- Багфикс в коде партиционирования таблиц БД.

## 0.6.10 (2016-04-15)


- Багфикс в коде партиционирования таблиц БД.

## 0.6.9 (2016-04-15)


- Багфикс в коде партиционирования таблиц БД.

## 0.6.8 (2016-03-21)


- Багфикс в коде партиционирования таблиц БД.

## 0.6.7 (2016-03-14)


- Багфикс в коде партиционирования таблиц БД. Ограничения (check constraints),
  накладываемые на разделы, должны содержать только константы, т.к. иначе не
  работает т.н. constraint exclusion и при запросе данных из таблицы
  просматриваются все разделы, а не те, которые удовлетворяют условию выборки.

## 0.6.6 (2015-12-21)


- Багфикс в пакете educommon.importer (конфликт имени ValidationError в
  proxy.py и XLSReader.py). (back port по задаче EDUSCHL-3826)

## 0.6.7 (2016-03-14)


- Багфикс в коде партиционирования таблиц БД. Ограничения (check constraints),
  накладываемые на разделы, должны содержать только константы, т.к. иначе не
  работает т.н. constraint exclusion и при запросе данных из таблицы
  просматриваются все разделы, а не те, которые удовлетворяют условию выборки.

## 0.6.6 (2015-12-21)


- Багфикс в пакете educommon.importer (конфликт имени ValidationError в
  proxy.py и XLSReader.py). (back port по задаче EDUSCHL-3826)

## 0.6.5 (2015-11-23)


- Подправлен ``BaseSaveListener`` для возможности подписи нескольких слушателей
  на один тот же экшн.

## 0.6.4 (2015-11-10)


- Доработан модуль IoC-контейнера для работы плагина "Прием специалиста" в ЭДС.

## 0.6.3 (2015-11-09)


- Доработан справочник типов "Образовательная организация" для ЭК.
- Расширены значения, доступные в ЭК, справочника "Тип законного
  представителя".

## 0.6.2 (2015-10-19)


- Изменено поведение декоратора ``convert_validation_error_to`` - при
  формировании сообщения об ошибке названия полей остаются такими, как описаны
  в модели (убрана функция ``capitalize``).
- Добавлен модуль ``educommon.django.storages.atcfs``. Модуль позволяет
  использовать в качестве File Storage внешнее файловое хранилище ATCFS.

## 0.6.1 (2015-10-12)


- Исправлены значения справочника Группа здоровья (для лиц 18 лет и старше).
- Для справочника ОКОГУ создана виртуальная модель с дополнительным полем
  "Сокращенное наименование".

## 0.6.0 (2015-10-06)


- Добавлен справочник "Вид обучения для детей с ОВЗ".
- В справочник "Трудные жизненные ситуации" добавлена новая категория.
- Исправлен баг с пустыми наследниками ``BaseEnumerateProductSpecific``.


## 0.5.56 (2015-10-05)


- В классе ``HealthGroups`` добавлены атрибуты класса, что хранят значения
  специфичные для лиц до/после 18 лет.


## 0.5.55 (2015-10-02)


- В классе ``BaseEnumerateProductSpecific`` удалили все методы специфичной
  выборки по продукту, такие как ``get_specific_choices``, ``get_all_values``,
  ``get_webedu_choices``, ``get_kinder_choices``,  и т.д.
- Переименовали переменные содержащие, ограниченные в рамках продукта,
  идентификаторы справочников. Добавили новый метод ``set_category``, на вход
  которого необходимо передавать список идентификаторов, для ограничения
  справочника из продукта при старте системы.

## 0.5.54 (2015-09-30)


- Функции ``get_week_start`` и ``get_week_end`` в модуле
  ``educommon.utils.date``.

## 0.5.53 (2015-09-28)


- Поддержка пакета ``edureception`` в ``ioc`` (продуктовых моделей Специалиста,
  Кабинета и Посетителя приема).
- Константы номеров дней недели в модуле ``educommon.utils.date``.

## 0.5.52 (2015-09-25)


- В ``OksmVirtialModel`` добавлен атрибут с кодом РФ.

## 0.5.51 (2015-09-17)


- Добавил константы-значения в справочник "Формы образования".
- Удалил задублированный справочник "Группы здоровья".

## 0.5.50 (2015-09-17)


-Перенес класс-примесь для проверки связей записи.

## 0.5.49 (2015-09-15)


- Перенос справочников
- Изменение кодов для справочников с учетом новых требований.

## 0.5.48 (2015-09-10)


- Добавлена функция ``educommon.utils.is_ranges_intersected`` для проверки
  пересечения диапазонов значений.
- В класс-примесь ``DateIntervalMixin`` добавлен метод
  ``is_intersected_with`` для проверки пересечения интервалов.
- Багфикс в ``educommon.importer.proxy.CacheProxy``.

## 0.5.47 (2015-09-08)


- Исправлено значения в справочнике Типы документы удостоверяющие личность
- Убраны дублирующиеся записи.

## 0.5.46 (2015-09-04)


- Исправлена ошибка при загрузке данных справочника ОКСМ.

## 0.5.45 (2015-09-04)


- ``BaseEnumerateVirtualModel`` для справочников Контингента.
- Добавлен справочник ОКСМ.
- Добавлен метод получения значения по ``id`` из справочника "Типы документов
  удостоверяющих личность".

## 0.5.44 (2015-08-28)


- Валидаторы для КПП, ОКАТО, ОКТМО, ОКПО, ОГРН, ОКВЭД, ОКОПФ, ОКФС.


## 0.5.43 (2015-08-26)


- Добавлена возможность указать пустой список в ``model_fields`` класса
  ``BaseEditWinExtender``.

## 0.5.42 (2015-08-26)


- Задекорированы методы работы со справочником "Типы документов, удостоверяющих
  личность", декоратором ``classmethod``.


## 0.5.41 (2015-08-25)


- Добавлен справочник "Образовательная организация"


## 0.5.40 (2015-08-24)


- Добавлен справочник "Типы документов удостоверяющих личность"
- Добавлен справочник "Вид адаптированности"
- Добавлен справочник "Вид обучения при длительном лечении"

## 0.5.39 (2015-08-13)


- Доработка класса-примеси ``PackValidationMixin`` - учтена особенность
  ``SlavePack``.
- Функции для работы с паками: ``get_pack``, ``get_pack_id`` и
  ``get_id_value``.
- RBAC: Вспомогательные функции для работы с правилами.


## 0.5.38 (2015-08-11)


- Багфикс в классе-примеси к составным моделям ``ModelProxyValidationMixin``.

## 0.5.37 (2015-08-11)


- ``educommon.django.db.utils``: из ЭДО перенесена фабрика метаклассов,
  модифицирующих параметры полей модели.
- Откат багфикса в классе-примеси к составным моделям
  ``ModelProxyValidationMixin``.
- RBAC: Багфиксы в модели ``UserRole``.

## 0.5.36 (2015-08-10)


- Багфикс в классе-примеси к составным моделям ``ModelProxyValidationMixin``.

## 0.5.35 (2015-08-10)


- Обновил коды в ОКОГУ для сада.

## 0.5.34 (2015-08-10)


- RBAC: Добавлена возможность запрещать назначение роли пользователю.

## 0.5.33 (2015-08-07)


- Добавлены коды в ОКОПФ для сада.

## 0.5.32 (2015-08-05)


- RBAC: Багфиксы в окнах реестра "Роли".

## 0.5.31 (2015-08-05)


- RBAC: Багфикс в модели ``UserRole``.

## 0.5.30 (2015-08-05)


- Справочники контингента ОКОГУ и ОКОПФ переведены на
  ``BaseEnumerateProductSpecific`` для возможности определения специфичных
  наборов данных из справочников для конкретного продукта.

## 0.5.29 (2015-07-03)


- Для интервальной модели сделан менеджер ``ActualObjectsManager``,
  отбрасывающий объекты, в интервал которых не попадает текущая дата.

## 0.5.28 (2015-07-27)


- Подправлены значения справочника ОКОГУ контингента.

## 0.5.27 (2015-07-27)


- RBAC: Добавлена возможность использования групп разрешений без названия.

## 0.5.26 (2015-07-21)


- Справочник "Тип законного представителя" доработан для ЭДС
- Исправлены коды в нескольких справочнике ОКФС
- Багфикс в ``DateIntervalMixin``.

## 0.5.25 (2015-07-20)


- RBAC: У поля title модели ``Permission`` удалено ограничение уникальности
  значений.

## 0.5.24 (2015-07-17)


- В подсистеме управления доступом на основе ролей реализованы средства для
  управления ролями системы: окно для работы с иерархией ролей и окно
  редактирования параметров роли.

## 0.5.22 (2015-07-08)


- В подсистеме управления доступом на основе ролей добавлена возможность
  проверки наличия у пользователя прав доступа без учета правил (``Rules``).
  Актуально для включения/отключения элементов интерфейса и т.п.
- В management-команде ``rbac`` приложения ``educommon.auth.rbac`` добавлен
  параметр ``show actions``, позволяющий просматривать список экшенов системы
  с разбивкой по разрешениям.
- В класс-примесь для интервальных моделей ``DateIntervalMixin`` добавлен метод
  для проверки вхождения указанной даты в интервал.

## 0.5.21 (2015-07-08)


- Добавлен справочник "Тип законного представителя"
- Исправлены коды в нескольких справочниках

## 0.5.20 (2015-07-08)


- Багфикс в коде функций, обеспечивающих партиционирование таблиц в БД.

## 0.5.19 (2015-07-05)


- Багфикс в подсистеме управления доступом на основе ролей (RBAC).

## 0.5.18 (2015-07-03)


- Добавлен справочник "Трудные жизненные ситуации".

## 0.5.17 (2015-07-02)


- Типы образовательных программ для ЭК.
- Отдача ``media`` содержимого без проверки авторизации (папка ``public``).

## 0.5.15 (2015-06-26)


- Багфикс в классе-примеси ``DateintervalMixin``.

## 0.5.14 (2015-06-26)


- Добавлена подсистема авторизации на основе ролей (RBAC):
  ``educommon.auth.rbac``.

## 0.5.13 (2015-06-26)


- Добавлен модуль ``secure_media`` для контроля доступа к файлам по URL
  ``/media/``.

## 0.5.12 (2015-06-25)


- Добавлена возможность задекларировать дополнительный контекст при расширении
  интерфейсов плагинами.
- Добавлен биндинг компонента ``ExtCheckBox`` при расширении интерфейсов
  плагинами.


## 0.5.11 (2015-06-25)


- Установка параметров и работа со связанными сущностями при расширении
  интерфейсов плагинами.
- Исправлен биндинг компонента выбора из справочника при расширении интерфейсов
  плагинами.
- Обновлен справочник "Типы документов об образовании".

## 0.5.10 (2015-06-22)


- Базовые классы для расширения интерфейсов плагинами.
- Добавлена функция сбора данных с фильтрующих полей у грида с изменяющимся
  числом колонок.

## 0.5.9 (2015-06-17)


- Композитный провайдер с загрузкой зависимых подпровайдеров.

## 0.5.8 (2015-06-15)


- Добавлен компонент простой аутентификации через логин и пароль
  (``educommon.auth.simple_auth``).

## 0.5.7 (2015-06-15)


- Исправления для ``ModelProxyValidationMixin``.

## 0.5.6 (2015-06-11)


- Добавлен справочник "Типы документов об образовании".

## 0.5.5 (2015-06-10)


- Добавлен справочник "Образовательные программы".

## 0.5.4 (2015-06-08)


- Исправлена ошибка импорта пакета ``educommon.objectpack``.

## 0.5.3 (2015-06-08)


- Добавлен справочник "Статусы организаций".

## 0.5.2 (2015-06-04)


- Исправлена ошибка при не передаче контекста ``ProxyLoader``.
- Исправлена ошибка при генерации обработчика событий комбобокса.
  в фильтрующей панели ``FilterPanel``.

## 0.5.1 (2015-06-04)


- Исправлена ошибка импорта.

## 0.5.0 (2015-06-04)


- Реализация механизма импортов.
- Пак и интерфейсы ``BaseGridPack`` для работы с гридами с изменяющимся
  количество колонок.
- Справочники Контингента.
- Реализация отложенных действий: управление порядком выполнения
  обработчиков сигналов возбужденных в контексте некой операции,
  "завернутой" в транзакцию.

## 0.4.5 (2015-06-03)


- Багфикс в классе-примеси ``ModelProxyValidationMixin``.

## 0.4.4 (2015-06-02)


- Багфикс в классе-примеси ``ModelProxyValidationMixin``: устранена
  неправильная обработка значений в аргументе ``exclude`` метода
  ``full_clean``.

## 0.4.3 (2015-06-01)


- Багфикс в классе-примеси ``ModelProxyValidationMixin``: теперь ошибки
  валидации внешних ключей зависимых моделей пропускаются, т.к. модели
  создаются при сохранении составной модели.
- В декоратор ``convert_validation_error_to`` добавлена возможность обработки
  исключений, сгенерированных вне метода модели (см. аргумент ``model``
  декоратора).

## 0.4.2 (2015-05-30)


- Багфикс в классе-примеси ``ModelProxyValidationMixin``: некорректная
  обработка многоуровневой вложенности моделей в ``relations``.

## 0.4.1 (2015-05-28)


- Багфикс в классе-примеси ``ModelProxyValidationMixin``.

## 0.4.0 (2015-05-25)


- Добавлен декоратор ``educommon.m3.convert_validation_error_to``,
  предназначенный для форматирования ошибок валидации моделей Django,
  возникающих в декорируемой функции/методе.
- Добавлен класс-примесь ``educommon.m3.ModelProxyValidationMixin`` для
  составных прокси-моделей objectpack'а (``objectpack.models.ModelProxy``),
  добавляющий возможность валидации данных перед сохранением.
- Добавлен класс-примесь ``educommon.m3.PackValidationMixin``, добавляющий
  валидацию моделей к пакам из ``objectpack``.


## 0.3.3 (2015-05-13)


- Добавлены параметры полей ввода серии и номера документов.
  (``educommon.extjs.fields.input_params``).

## 0.3.2 (2015-04-21)


- Класс-построитель отчетов ``SimpleReporter`` на основе ``simple-report``.
- Пак ``CommonReportPack`` - теперь просто обертка для работы с m3
  (``educommon.report.actions``).


## 0.3.1 (2015-04-10)


- Доработка класса ``CommonReportPack``
  (``educommon.report.actions``).


## 0.3.0 (2015-04-01)


- Добавлены базовые классы для более удобного создания отчётов:
  провайдеры, билдеры, адаптеры  юниттесты
  (``educommon.report``).
- Новый класс ``CommonReportPack`` для создания отчётов (взамен
  ``SimpleReportPack``) (``educommon.report.actions``).


## 0.2.0 (2015-04-01)


- Добавлен модуль для партиционирования таблиц баз данных, находящихся под
  управлением СУБД PostgreSQL (``educommon.django.db.partitioning``).

## 0.1.4 (2015-02-09)


- Добавлен базовый класс роутера моделей Django для приложений, использующих
  сервисную БД (``educommon.django.db.routers.ServiceDbRouterBase``).

## 0.1.3 (2014-12-15)


- Добавлены параметры фильтрации для полей ввода СНИЛС и ИНН.

## 0.1.2 (2014-12-12)


- Добавлен валидатор для ИНН (Индивидуальный номер налогоплательщика).

## 0.1.1 (2014-12-11)


- Добавлена функция ``educommon.django.db.validators.validate_value()`` для
  проверки с помощью валидаторов значений переменных.
- Добавлена функция ``educommon.django.db.validators.simple.is_snils_valid()``
  для валидации СНИЛС.

## 0.1.0 (2014-12-11)


- Добавлен валидатор для СНИЛС (Страховой номер индивидуального лицевого
  счёта).
