import threading
import AutoPypline.auto_pipeline as auto


def parallel_executor(flows, graph):
    """
    Parallel execution of each flow in flows
    :param flows:
        Type: list
        List of flows to be executed (generated by flow_generator)
    :param graph:
        Type: Dict
        Graph Data Structure constructed using user config
    :return:
    """
    flow_0 = flows[0]
    commonality = dict()
    common_initial_flow = []
    for flow_i in flows[1:]:
        if not flows.index(flow_0) == flows.index(flow_i):
            commonality[str(flows.index(flow_0)) + '_' + str(flows.index(flow_i))] = []
        for i, j in zip(flow_0, flow_i):
            if i == j:
                commonality[str(flows.index(flow_0)) + '_' + str(flows.index(flow_i))].append(i)
        else:
            break

    if len(commonality):
        if max(map(len, list(commonality.values()))) >= 1:
            common_initial_flow = [i for i in list(commonality.values()) if len(i) ==
                                   max(map(len, list(commonality.values())))][0]
        if len(common_initial_flow):
            for node in common_initial_flow:
                if graph[node].node_executed:
                    continue
                else:
                    node_output = node_executor(node, graph)
                    if node_output is not None:
                        graph[node].outputs = node_output
                    graph[node].node_executed = True

    threads = []
    for flow in flows:
        threads.append(threading.Thread(target=single_flow_executor, args=(flow, graph)))

    for thread_i in threads:
        thread_i.start()

    for thread_i in threads:
        thread_i.join()

    return graph


def sequential_flow_executor(flows, graph):
    """
    Executes flow after flow in a sequential manner
    :param flows:
    :param graph:
    :return:
    """
    flow_0 = flows[0]
    commonality = dict()
    common_initial_flow = []
    for flow_i in flows[1:]:
        if not flows.index(flow_0) == flows.index(flow_i):
            commonality[str(flows.index(flow_0)) + '_' + str(flows.index(flow_i))] = []
        for i, j in zip(flow_0, flow_i):
            if i == j:
                commonality[str(flows.index(flow_0)) + '_' + str(flows.index(flow_i))].append(i)
        else:
            break

    if len(commonality):
        if max(map(len, list(commonality.values()))) >= 1:
            common_initial_flow = [i for i in list(commonality.values()) if len(i) ==
                                   max(map(len, list(commonality.values())))][0]
        if len(common_initial_flow):
            for node in common_initial_flow:
                if graph[node].node_executed:
                    continue
                else:
                    node_output = node_executor(node, graph)
                    graph[node].outputs = node_output
                    graph[node].node_executed = True
    for flow in flows:
        graph = single_flow_executor(flow, graph)
    return graph


def single_flow_executor(flow, graph):
    """
    Execution of provided flow node by node. Updates the double linked graph with each nodes output
    :param flow:
    :param graph:
    :return:
    """
    for node in flow:
        if graph[node].node_executed:
            continue
        else:
            node_output = node_executor(node, graph)
            if node_output is not None:
                if isinstance(node_output, list):
                    if len(node_output) <= 1:
                        node_output = node_output[0]
                graph[node].outputs = node_output
            graph[node].node_executed = True
    return graph


def node_executor(node_name, graph):
    """
    Given a node name, the function/class corresponding to the node is executed. Before execution,
    we check if all the predecessors outputs are computed.
    Either the entire output of predecessor may be given as input or a part of the output can also
    be provided.
    :param graph:
    :param node_name:
        Type: str
        Name of the node in the double linked graph whose output is required
    :return: Output of the function/class corresponding to node name
    """
    if graph[node_name].root or graph[node_name].independent:
        if graph[node_name].internal_graph is not None:
            internal_experiment = graph[node_name].internal_graph
            auto_pipe = auto.AutoPipeline(config=internal_experiment.get("control_flow"),
                                          generator_inputs=internal_experiment.get("generator_inputs"),
                                          store_output_as=internal_experiment.get("store_output_as", "List"))
            return auto_pipe()
        else:
            node_obj = graph[node_name].callable_object
            dynamic_params = graph[node_name].dynamic_params
            general_params = graph[node_name].params
            if general_params is None:
                if callable(node_obj):
                    if dynamic_params is None:
                        node_obj = node_obj()
                    else:
                        node_obj = node_obj(**dynamic_params)
                return node_obj
            else:
                if len(dynamic_params):
                    node_obj = node_obj(**general_params, **dynamic_params)
                else:
                    node_obj = node_obj(**general_params)
                return node_obj

    predecessors = graph[node_name].predecessors
    predecessors_outputs = dict()
    for predecessor_output_name, predecessor in predecessors.items():
        if len(predecessor.split('.')) == 1:
            if graph[predecessor].outputs is not None:
                predecessors_outputs[predecessor_output_name] =\
                    graph[predecessor].outputs
            else:
                predecessor_outputs = node_executor(predecessor, graph)
                predecessors_outputs[predecessor_output_name] = predecessor_outputs
        elif len(predecessor.split('.')) == 3:
            predecessor_node_name, _, output_name = predecessor.split('.')
            if graph[predecessor_node_name].outputs[output_name] is not None:
                predecessors_outputs[predecessor_output_name] = \
                    graph[predecessor_node_name].outputs[output_name]
            else:
                predecessor_outputs = node_executor(predecessor_node_name, graph)
                if isinstance(predecessor_outputs, dict):
                    predecessor_output = predecessor_outputs[output_name]
                    predecessors_outputs[predecessor_output_name] = predecessor_output
                else:
                    raise("Error caught at node execution for node %s. Error in predecessor output format of "
                          "node %s"
                          " Function/Factory expecting predecessor output to be of type "
                          "dictionary but got type : %s" % (node_name, predecessor_node_name,
                                                            type(predecessor_outputs)))

    if graph[node_name].internal_graph is not None:
        global_graph = dict()
        for node_name_i in list(graph.keys()):
            if graph[node_name_i].node_executed:
                global_graph[node_name_i] = graph[node_name_i]
        internal_experiment = graph[node_name].internal_graph
        auto_pipe = auto.AutoPipeline(config=internal_experiment.get("control_flow"),
                                      generator_inputs=internal_experiment.get("generator_inputs"),
                                      global_graph=global_graph,
                                      store_output_as=internal_experiment.get("store_output_as", "List"))
        return auto_pipe()

    else:
        node_obj = graph[node_name].callable_object
        dynamic_params = graph[node_name].dynamic_params
        general_params = graph[node_name].params
        if general_params is None:
            if callable(node_obj):
                if not len(dynamic_params):
                    node_obj = node_obj(**predecessors_outputs)
                else:
                    node_obj = node_obj(**dynamic_params, **predecessors_outputs)
            return node_obj
        else:
            if len(dynamic_params):
                node_obj = node_obj(**general_params, **dynamic_params, **predecessors_outputs)
            else:
                node_obj = node_obj(**general_params, **predecessors_outputs)
            return node_obj
