#!/usr/bin/env python

"""The setup script."""

from setuptools import setup, find_packages

with open('README.rst') as readme_file:
    readme = readme_file.read()

with open('HISTORY.rst') as history_file:
    history = history_file.read()

requirements = [
    'Click>=7.0',
    "jinja2",
    "PyYAML",
    "Rich",
    ]

test_requirements = [ ]

setup(
    author="Jaideep Sundaram",
    author_email='jai.python3@gmail.com',
    python_requires='>=3.10',
    classifiers=[
        'Development Status :: 5 - Production/Stable',
        'Intended Audience :: Developers',
        'Natural Language :: English',
        'Programming Language :: Python :: 3.10',
    ],
    description="Collection of Python tools for generating reports in various formats.",
    entry_points={
        'console_scripts': [
            'generate-report=report_generation_utils.generate_report:main',
        ],
    },
    install_requires=requirements,
    long_description=readme + '\n\n' + history,
    include_package_data=True,
    keywords='report_generation_utils',
    name='report_generation_utils',
    packages=find_packages(include=['report_generation_utils', 'report_generation_utils.*']),
    package_data={
        "report_generation_utils": [
            "conf/config.yaml",
            "templates/report_template_v1.txt",
            "templates/report_template.html",
            "templates/report_template_v1.html",
            "templates/report_template_v2.html",
        ]
    },
    test_suite='tests',
    tests_require=test_requirements,
    url='https://github.com/jai-python3/report-generation-utils',
    version='0.1.2',
    zip_safe=False,
)
