# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from ._enums import *

__all__ = [
    'ApplicationRuntimeEnvironmentArgs',
    'ApplicationSaveConfigurationArgs',
    'ApplicationTagsArgs',
    'StreamGroupDefaultApplicationArgs',
    'StreamGroupTagsArgs',
]

@pulumi.input_type
class ApplicationRuntimeEnvironmentArgs:
    def __init__(__self__, *,
                 type: pulumi.Input['ApplicationRuntimeEnvironmentType'],
                 version: pulumi.Input[str]):
        """
        Runtime environment is a combination of Windows compatibility layer and other graphics libraries used to run the application.
        :param pulumi.Input[str] version: Versioned container environment used to run customer game. Each runtime fixed version of the Windows
               compatibility layer to provide a stable game performance. Refer to Motif public docs to see which wine, mesa, vulkan
               versions are used in which Motif runtime environment version.
        """
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input['ApplicationRuntimeEnvironmentType']:
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input['ApplicationRuntimeEnvironmentType']):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def version(self) -> pulumi.Input[str]:
        """
        Versioned container environment used to run customer game. Each runtime fixed version of the Windows
        compatibility layer to provide a stable game performance. Refer to Motif public docs to see which wine, mesa, vulkan
        versions are used in which Motif runtime environment version.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: pulumi.Input[str]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class ApplicationSaveConfigurationArgs:
    def __init__(__self__, *,
                 file_locations: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 registry_locations: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Application save configuration
        :param pulumi.Input[Sequence[pulumi.Input[str]]] file_locations: A list of save file, registry key or log paths that are absolute paths that store game save files when the games
               are running on a Windows environment.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] registry_locations: A list of save file, registry key or log paths that are absolute paths that store game save files when the games
               are running on a Windows environment.
        """
        if file_locations is not None:
            pulumi.set(__self__, "file_locations", file_locations)
        if registry_locations is not None:
            pulumi.set(__self__, "registry_locations", registry_locations)

    @property
    @pulumi.getter(name="fileLocations")
    def file_locations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of save file, registry key or log paths that are absolute paths that store game save files when the games
        are running on a Windows environment.
        """
        return pulumi.get(self, "file_locations")

    @file_locations.setter
    def file_locations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "file_locations", value)

    @property
    @pulumi.getter(name="registryLocations")
    def registry_locations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of save file, registry key or log paths that are absolute paths that store game save files when the games
        are running on a Windows environment.
        """
        return pulumi.get(self, "registry_locations")

    @registry_locations.setter
    def registry_locations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "registry_locations", value)


@pulumi.input_type
class ApplicationTagsArgs:
    def __init__(__self__):
        """
        Common AWS tags for supporting resource tagging and tag-based resource authorization. The maximum number of tags is 50.
        """
        pass


@pulumi.input_type
class StreamGroupDefaultApplicationArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[str]] = None):
        """
        Information about default application running on the stream group.
        :param pulumi.Input[str] id: GameCast resource ID, base62 encoded.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        GameCast resource ID, base62 encoded.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)


@pulumi.input_type
class StreamGroupTagsArgs:
    def __init__(__self__):
        """
        Common AWS tags for supporting resource tagging and tag-based resource authorization. The maximum number of tags is 50.
        """
        pass


