# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['sshclick',
 'sshclick.cmds',
 'sshclick.cmds.group',
 'sshclick.cmds.host',
 'sshclick.sshc',
 'sshclick.sshc.host_styles']

package_data = \
{'': ['*']}

install_requires = \
['click>=8.1.3,<9.0.0', 'prettytable>=3.2.0,<4.0.0', 'rich>=12.5.1,<13.0.0']

entry_points = \
{'console_scripts': ['sshc = sshclick.main:cli']}

setup_kwargs = {
    'name': 'sshclick',
    'version': '0.4.4',
    'description': 'SSH Config manager',
    'long_description': '# SSH Click Config manager (sshclick)\n\nCheck this page on [GitHub](https://github.com/karlot/sshclick)\n\n## Links\n\n- [Intro](https://github.com/karlot/sshclick#intro)\n- [Why?](https://github.com/karlot/sshclick#why)\n- [What does it do](https://github.com/karlot/sshclick#what-does-it-do)\n  - [Installation procedure](https://github.com/karlot/sshclick#installation-procedure)\n  - [Upgrade procedure](https://github.com/karlot/sshclick#upgrade-procedure)\n  - [Uninstall procedure](https://github.com/karlot/sshclick#uninstall-procedure)\n- [SSH Config structure](https://github.com/karlot/sshclick#ssh-config-structure-and-important-note-about-comments)\n  - [Comment blocks and metadata](https://github.com/karlot/sshclick#comment-blocks-and-metadata-in-ssh-config)\n- [Example usage and features](https://github.com/karlot/sshclick#example-usage-and-features)\n  - [Group commands and options](https://github.com/karlot/sshclick#group-commands-and-options)\n  - [Host commands and options](https://github.com/karlot/sshclick#host-commands-and-options)\n  - [Output styling and user ENV variables](https://github.com/karlot/sshclick#output-styling-and-user-env-variables)\n- [Recorded demos](https://github.com/karlot/sshclick#recorded-demos)\n  - [sshc group operations](https://github.com/karlot/sshclick#demo-showing-some-sshc-group-operations)\n  - [sshc host operations](https://github.com/karlot/sshclick#demo-showing-some-sshc-host-operations)\n- [Author](https://github.com/karlot/sshclick#author)\n- [License](https://github.com/karlot/sshclick#license)\n\n\n## Intro\nTerminal based assisted management of your SSH config files.  \nBuilt out of boredom with managing messy and huge ssh_config files.  \n\nEARLY VERSION, backup your SSH config files before using!  \nSSHClick can be used with "show" and "list" commands for hosts, without modifying your SSH Config!  \n\n**Only commands that modify configuration will edit and rewrite/restructure your SSH Config file. In that case, any added comment or infos that are not in form that SSHClick understand will be discarded, and configuration will be re-formatted to match SSHClick style. See below details to understand how SSH Click would keep your config organized**\n\n## Why?\n\nWhat am I trying to solve with this tool?\n* I need something that works fast and great in terminal, and does not require complex setup.\n* Managing some other configuration files that renders to SSH config is extra step that I don\'t like.\n* SSH config is already feature-full with all options SSH client support, why inventing extra layer?\n* SSH config is the only config I need to backup.\n* I need quick way to search, group and visualize all hosts inside SSH configuration (especially since it can grow huge)\n\n\n## What does it do?\n\nSSHClick (sshc) is just a tool designed to work with existing SSH configuration files on your Linux/Windows/WSL terminal environment.  \nIt basically parses your SSH config, and can provide easy commands to list, filter, modify or view specific Host entries.\nTrough additional "magic" comments it can add abstractions such as "groups" and various information that is both readable in the configuration file, and can be parsed and printed while using the tool.\n\n\n### Installation procedure\n\nShould be straight forward...  \n\n1. **Check preconditions:**\n    - Currently only tested on Linux (Debian 10,11, Ubuntu 20.04,22.04), but should work on other systems as well\n    - Minimum python3.7 (tested up to 3.11 beta) & pip installed\n        - it is preferable to not use system python version, to install "custom" user python on linux, you can try using pyenv (https://github.com/pyenv/pyenv\n    - git installed\n\n2. **Install package:**\n    - from PyPI using pip\n        ```\n        pip install sshclick\n        ```\n\n    - (OR) from source using pip\n        ```sh\n        git clone https://github.com/karlot/sshclick\n        cd sshclick\n        pip install .\n        ```\n\n3. Use it as you like, `sshc` command should be available to access SSHClick application, see below chapter for basic [usage](https://github.com/karlot/sshclick#example-usage-and-features)\n\n4. Install shell autocompletion (_TAB-TAB auto-completes on commands, options, groups and hosts_)\n    * __Bash__ - Add this line to end of your `~/.profile` file:\n      ```sh\n      eval "$(_SSHC_COMPLETE=bash_source sshc)"\n      ```\n    * __Zsh__ - Add this line to end of your `~/.zshrc` file:\n      ```sh\n      eval "$(_SSHC_COMPLETE=zsh_source sshc)"\n      ```\n\n\n### Upgrade procedure\n\n* Upgrade from new PyPI release:  \n  ```sh\n  pip install --upgrade sshclick\n  ```\n\n* Upgrade from source:\n  Assuming installation is already done, and previous version is cloned in some local folder\n\n  ```sh\n  cd sshclick     # cd into existing previously cloned repo folder\n  git pull\n  pip install --upgrade .\n  ```\n\n\n### Uninstall procedure\nSimply run:\n```\npip uninstall sshclick\n```\n\nIn case you have installed from cloned source code, you can delete locally cloned repo.\n```sh\nrm -r sshclick\n```\n\n---\n\n## SSH Config structure, and important note about comments\n\nSSHClick when editing and writing to SSH config file must use specific style, and is internally using comments to "organize" configuration itself. This means comments outside of what sshclick is handling are unsupported and will be lost when SSHClick modifies a file.)\n\n\n### Comment blocks and metadata in SSH Config\n\nSSHClick uses comments to add extra information which it can use to add concept of grouping and extra information to hosts. Special "metadata" lines start with `#@` followed by some of meta-tags like `group`, `desc`, `info`. This are all considered group metadata tags, as they apply on the group level. Note that line separations above and below "group header" are added only for visual aid, they are ignored at parsing, but are included when modifying/generating SSH config file.  \n\nThis "headers" can be added manually also in SSH config, or sshclick can add them and move hosts under specific group, using `sshc` cli tool\n\nNormally start of the "GROUP HEADER" inside SSH Config would look like below.  \n- `#@group:` is KEY metadata tag, that during "parsing" defines that all hosts configured below this "tag" belong to this group\n- `#@desc:` is optional tag that adds "description" to defined group, and will display in usual group display commands\n- `#@info:` is optional tag that can appear multiple times, adding extra information lines tied to the group.\n\nAdditionally each "host" definition can have optional meta info:\n- `#@host:` is optional tag that can appear multiple times, that can hold some information about the host, this meta info when defined applies to next "host" definition that will appear. If this key is added after "host" keyword, it will be applied to next host, for that reason, keep this host meta info above the actual host definition.\n\nFollowing is sample how group header is rendered by SSHClick:\n```\n#-------------------------------------------------------------------------------\n#@group: <GROUP-NAME>       [MANDATORY]   <-- This line starts new group\n#@desc: <GROUP-DESCRIPTION> [OPTIONAL, SINGLE]\n#@info: <GROUP-INFO-LINES>  [OPTIONAL,MULTIPLE]\n#-------------------------------------------------------------------------------\nHost ...    <-- this hosts definitions are part of the defined group\n    param1 value1\n    param2 value2\n\n#@host: <HOST-INFO-LINES>  [OPTIONAL,MULTIPLE] <-- Adds info to following host\nHost ...\n\n<ANOTHER GROUP HEADER>\n```\n\nIf there are no groups defined, then all hosts are considered to be part of "default" group. SSHClick can be used to move hosts between groups and handle keeping SSH config "tidy" and with consistent format.\n\n\n## Example usage and features\n\nSSHClick is deploying `sshc` cli tool that allows interacting with your SSH Config file and perform various organization,listing, displaying and modification of SSH Group/Host configuration parameters.  \n`sshc` comes with pre-built lots of help options so each level of commands provide `--help` options to provide you info what commands and options are available at which command level.  \n\nFor example to check version, type: `sshc --version`  \n_Sample output:_\n```console\n$ sshc --version\nSSHClick (sshc) - Version: 0.4.1\n```\n\nIf you run `sshc` command alone, or adding `-h` or `--help` option, it will show help what else must be added to the command...  \n_Example:_\n```console\n$ sshc --help\nUsage: sshc [OPTIONS] COMMAND [ARGS]...\n\n  SSHClick - SSH Config manager\n\n  Note: As this is early alpha, backup your SSH config files before this\n  software, as you might accidentally lose some configuration\n\nOptions:\n  --sshconfig PATH  Config file, default is ~/.ssh/config\n  --stdout          Send changed SSH config to STDOUT instead to original file\n  --version         Show current version\n  -h, --help        Show this message and exit.\n\nCommands:\n  group  Manage groups\n  host   Manage hosts\n```\n\nMain sub-commands are for separate control of:  \n- Groups (via `sshc group` command)\n  - Allows operation of groups inside SSH config\n- Hosts (via `sshc host` command)\n  - Allows operation of hosts inside SSH config\n\n### `group` commands and options\n\nTo manage "groups" type `sshc group --help` to see options.  \n_example:_\n```console\n$ sshc group --help\nUsage: sshc group [OPTIONS] COMMAND [ARGS]...\n\n  Manage groups\n\nOptions:\n  -h, --help  Show this message and exit.\n\nCommands:\n  create  Create new group\n  delete  Delete group\n  list    Lists all groups\n  set     Change group parameters\n  show    Shows group details\n```\n\n### `host` commands and options\n\nTo manage "groups" type `sshc host --help` to see options.  \n_example:_\n```console\n$ sshc host --help\nUsage: sshc host [OPTIONS] COMMAND [ARGS]...\n\n  Manage hosts\n\nOptions:\n  -h, --help  Show this message and exit.\n\nCommands:\n  create  Create new host configuration\n  delete  Delete host from configuration\n  list    List hosts\n  set     Changes/sets host configuration parameters\n  show    Display info for host\n  test    Test SSH host connection\n```\n\n### Output styling and user ENV variables\n\n`sshc host show` can display host output is several formats, you can specify it with `sshc host show <host> --style <style>`  \nAvailable styles are:\n\n| Style              | Description                                       |\n|--------------------|---------------------------------------------------|\n| `panels` (default) | Display data in several panels                    |\n| `card`             | Add data to single "card"                         |\n| `simple`           | Simple output with minimal decorations            |\n| `table`            | Flat table with 3 columns                         |\n| `table2`           | Nested table with separated host SSH params       |\n| `json`             | JSON output, useful for binding with other tools |\n\nIf you want to have some style statically set for your shell, you can export ENV variable with `export SSHC_HOST_STYLE=table`, and add it to `.profile` or `.bashrc` or `.zshrc`, so its set when shell session is starting, to set "default" style to that one.\n\nIn case user do not line "fancy" colors in output, you can set ENV variable to disable all color outputs with `export NO_COLOR=1`. If you want it permanently you can add it to startup "rc" files as well.\n\n\n> NOTE! When sending output into non-terminal such as to file, SSHClick will recognize that and will remove all ANSI Escape characters (colors and stuff...) so that output is captured in clear way.\n\n\n## Recorded demos\n\nFollowing demos will use this config sample file as input (located in ~/.ssh/config):\n\n```\n#<<<<< SSH Config file managed by sshclick >>>>>\n\n#-------------------------------------------------------------------------------\n#@group: network\n#@desc: Network devices in my lab\n#@info: user=\'admin\' password=\'password\'\n#@info: Not really, but for demo its ok :)\n#-------------------------------------------------------------------------------\nHost net-switch1\n    hostname 10.1.1.1\n\nHost net-switch2\n    hostname 10.1.1.2\n\nHost net-switch3\n    hostname 10.1.1.3\n\nHost net-*\n    user admin\n\n\n#-------------------------------------------------------------------------------\n#@group: jumphost\n#@desc: Edge-server / SSH bastion\n#@info: Used for jump-proxy from intnet to internal lab servers\n#-------------------------------------------------------------------------------\nHost jumper1\n    hostname 123.123.123.123\n    user master\n    port 1234\n\n\n#-------------------------------------------------------------------------------\n#@group: lab-servers\n#@desc: Testing/Support servers\n#@info: Some [red]important[/] detail here!\n#@info: We can have color markups in descriptions and info lines\n#-------------------------------------------------------------------------------\nHost lab-serv1\n    hostname 10.10.0.1\n    user admin\n\nHost lab-serv2\n    hostname 10.16.141\n\nHost lab-*\n    user user123\n    proxyjump jumper1\n\nHost server-behind-lab\n    hostname 10.30.0.1\n    user testuser\n    port 1234\n    proxyjump lab-serv1\n\n```\n\n### Demo showing some `sshc group` operations:\n[![asciicast](https://asciinema.org/a/BQoVXv2HSeIvTyATeKUBGfr89.svg)](https://asciinema.org/a/BQoVXv2HSeIvTyATeKUBGfr89)\n\n\n### Demo showing some `sshc host` operations:\n[![asciicast](https://asciinema.org/a/wzLefl49CRErBoFwC6ir96FFA.svg)](https://asciinema.org/a/wzLefl49CRErBoFwC6ir96FFA)\n\n\n### Demo displaying "end-to-end" tunnel visualization in graph\n[![asciicast](https://asciinema.org/a/I4O2bfDiRAN7xEGdTB1S9rChE.svg)](https://asciinema.org/a/I4O2bfDiRAN7xEGdTB1S9rChE)\n\n\n## Author\n\nKarlo Tisaj  \nemail: karlot@gmail.com  \ngithub: https://github.com/karlot\n\n\n## License\n\n[MIT License](LICENSE)\n\n\n',
    'author': 'Karlo Tisaj',
    'author_email': 'karlot@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/karlot/sshclick',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
