"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import builtins
import google.protobuf.descriptor
import google.protobuf.internal.enum_type_wrapper
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _CameraState:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _CameraStateEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_CameraState.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    UNALLOCATED: _CameraState.ValueType  # 0
    """/ camera is not allocated or the state is unknown"""
    VUFORIA: _CameraState.ValueType  # 1
    """/ camera is used for image target tracking by Vuforia"""
    WEB_RTC: _CameraState.ValueType  # 2
    """/ camera is used by remote communication with WebRTC"""
    SPECTATOR_VIEW: _CameraState.ValueType  # 3
    """/ camera is used by the spectator view to track the QR code for device coupling"""

class CameraState(_CameraState, metaclass=_CameraStateEnumTypeWrapper):
    """*
    This message represents the camera state mostly associated with Unity as only one service may use the system's camera at a time.
    @author: Alexander Neumann <alneuman@techfak.uni-bielefeld.de>
    """

UNALLOCATED: CameraState.ValueType  # 0
"""/ camera is not allocated or the state is unknown"""
VUFORIA: CameraState.ValueType  # 1
"""/ camera is used for image target tracking by Vuforia"""
WEB_RTC: CameraState.ValueType  # 2
"""/ camera is used by remote communication with WebRTC"""
SPECTATOR_VIEW: CameraState.ValueType  # 3
"""/ camera is used by the spectator view to track the QR code for device coupling"""
global___CameraState = CameraState

class _CameraTrigger:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _CameraTriggerEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_CameraTrigger.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    RELEASE: _CameraTrigger.ValueType  # 0
    """/ release the camera"""
    ACQUIRE_VUFORIA: _CameraTrigger.ValueType  # 1
    """/ request acquisition for image target tracking"""
    ACQUIRE_WEB_RTC: _CameraTrigger.ValueType  # 2
    """/ request acquisition for remote communication"""
    ACQUIRE_SPECTATOR_VIEW: _CameraTrigger.ValueType  # 3
    """/ request acquisition for spectator view coupling"""

class CameraTrigger(_CameraTrigger, metaclass=_CameraTriggerEnumTypeWrapper):
    """*
    This message represents the EVENT or REQUEST to acquire the camera.
    Whether the camera can be acquired depends on its current state. 
    @author: Alexander Neumann <alneuman@techfak.uni-bielefeld.de>
    """

RELEASE: CameraTrigger.ValueType  # 0
"""/ release the camera"""
ACQUIRE_VUFORIA: CameraTrigger.ValueType  # 1
"""/ request acquisition for image target tracking"""
ACQUIRE_WEB_RTC: CameraTrigger.ValueType  # 2
"""/ request acquisition for remote communication"""
ACQUIRE_SPECTATOR_VIEW: CameraTrigger.ValueType  # 3
"""/ request acquisition for spectator view coupling"""
global___CameraTrigger = CameraTrigger
