"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import avikom.assistance.scene_pb2
import avikom.assistance.task_pb2
import avikom.generic.key_value_pair_pb2
import avikom.generic.user_pb2
import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _IssueStatus:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _IssueStatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_IssueStatus.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    ISSUE_UNKNOWN: _IssueStatus.ValueType  # 0
    """/ default; should not be set explicitely"""
    ISSUE_OPEN: _IssueStatus.ValueType  # 1
    """/ issue needs to be resolved"""
    ISSUE_ASSIGNED: _IssueStatus.ValueType  # 5
    """/ issue has been assigned to a user"""
    ISSUE_ACTIVE: _IssueStatus.ValueType  # 7
    """/ issue is currently resolved by a user"""
    ISSUE_CLOSED: _IssueStatus.ValueType  # 10
    """/ issue has been resolved"""
    ISSUE_REJECTED: _IssueStatus.ValueType  # 11
    """/ issue cannot be resolved or has been declined"""

class IssueStatus(_IssueStatus, metaclass=_IssueStatusEnumTypeWrapper):
    """*
    The status of an issue. Can be used to find unresolved tasks and filter issue lists.
    @author Alexander Neumann <alneuman@techfak.uni-bielefeld.de>
    """

ISSUE_UNKNOWN: IssueStatus.ValueType  # 0
"""/ default; should not be set explicitely"""
ISSUE_OPEN: IssueStatus.ValueType  # 1
"""/ issue needs to be resolved"""
ISSUE_ASSIGNED: IssueStatus.ValueType  # 5
"""/ issue has been assigned to a user"""
ISSUE_ACTIVE: IssueStatus.ValueType  # 7
"""/ issue is currently resolved by a user"""
ISSUE_CLOSED: IssueStatus.ValueType  # 10
"""/ issue has been resolved"""
ISSUE_REJECTED: IssueStatus.ValueType  # 11
"""/ issue cannot be resolved or has been declined"""
global___IssueStatus = IssueStatus

@typing_extensions.final
class Issue(google.protobuf.message.Message):
    """*
    An message that contains informations about (postponed) tasks and their state.
    @author Alexander Neumann <alneuman@techfak.uni-bielefeld.de>
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    ISSUER_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    SCENE_FIELD_NUMBER: builtins.int
    TASK_FIELD_NUMBER: builtins.int
    INCLUDE_FIELD_NUMBER: builtins.int
    EXCLUDE_FIELD_NUMBER: builtins.int
    PARAMETERS_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    id: builtins.str
    """/ id of a task; must be set for creation!"""
    @property
    def issuer(self) -> avikom.generic.user_pb2.User:
        """/ who issued the task"""
    description: builtins.str
    """/ an optional text message"""
    @property
    def scene(self) -> avikom.assistance.scene_pb2.Scene:
        """/ location where the task needs to be conducted"""
    @property
    def task(self) -> avikom.assistance.task_pb2.Task:
        """/ the task to be done"""
    @property
    def include(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[avikom.generic.user_pb2.User]:
        """/ users that are eligible for that task"""
    @property
    def exclude(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[avikom.generic.user_pb2.User]:
        """/ users that should not be eligible for that issue; only considered when include is empty"""
    @property
    def parameters(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[avikom.generic.key_value_pair_pb2.KeyValuePair]:
        """/ this is passed to camunda"""
    status: global___IssueStatus.ValueType
    """/ status of the issue"""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        issuer: avikom.generic.user_pb2.User | None = ...,
        description: builtins.str = ...,
        scene: avikom.assistance.scene_pb2.Scene | None = ...,
        task: avikom.assistance.task_pb2.Task | None = ...,
        include: collections.abc.Iterable[avikom.generic.user_pb2.User] | None = ...,
        exclude: collections.abc.Iterable[avikom.generic.user_pb2.User] | None = ...,
        parameters: collections.abc.Iterable[avikom.generic.key_value_pair_pb2.KeyValuePair] | None = ...,
        status: global___IssueStatus.ValueType = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["issuer", b"issuer", "scene", b"scene", "task", b"task"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["description", b"description", "exclude", b"exclude", "id", b"id", "include", b"include", "issuer", b"issuer", "parameters", b"parameters", "scene", b"scene", "status", b"status", "task", b"task"]) -> None: ...

global___Issue = Issue

@typing_extensions.final
class IssueList(google.protobuf.message.Message):
    """*
    A collection of `Issue` objects.
    @author Alexander Neumann <alneuman@techfak.uni-bielefeld.de>
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ISSUES_FIELD_NUMBER: builtins.int
    @property
    def issues(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Issue]: ...
    def __init__(
        self,
        *,
        issues: collections.abc.Iterable[global___Issue] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["issues", b"issues"]) -> None: ...

global___IssueList = IssueList
