# This is autogenerated code. Do not modify this file directly
from __future__ import annotations

import sys
from typing import TYPE_CHECKING

import pytest

from resonate.errors import ResonateStoreError

if TYPE_CHECKING:
    from resonate.models.store import Store


def test_case_0_transition_from_init_to_pending_via_create(store: Store) -> None:
    promise_record = store.promises.create(
        id="id0",
        ikey=None,
        strict=True,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    assert promise_record.state == "PENDING"
    assert promise_record.id == "id0"
    assert promise_record.ikey_for_create is None
    assert promise_record.ikey_for_complete is None


def test_case_1_transition_from_init_to_pending_via_create(store: Store) -> None:
    promise_record = store.promises.create(
        id="id1",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    assert promise_record.state == "PENDING"
    assert promise_record.id == "id1"
    assert promise_record.ikey_for_create is None
    assert promise_record.ikey_for_complete is None


def test_case_2_transition_from_init_to_pending_via_create(store: Store) -> None:
    promise_record = store.promises.create(
        id="id2",
        ikey="ikc",
        strict=True,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    assert promise_record.state == "PENDING"
    assert promise_record.id == "id2"
    assert promise_record.ikey_for_create == "ikc"
    assert promise_record.ikey_for_complete is None


def test_case_3_transition_from_init_to_pending_via_create(store: Store) -> None:
    promise_record = store.promises.create(
        id="id3",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    assert promise_record.state == "PENDING"
    assert promise_record.id == "id3"
    assert promise_record.ikey_for_create == "ikc"
    assert promise_record.ikey_for_complete is None


def test_case_4_transition_from_init_to_init_via_resolve(store: Store) -> None:
    with pytest.raises(ResonateStoreError):
        store.promises.resolve(id="id4", ikey=None, strict=True, headers=None, data=None)


def test_case_5_transition_from_init_to_init_via_resolve(store: Store) -> None:
    with pytest.raises(ResonateStoreError):
        store.promises.resolve(id="id5", ikey=None, strict=False, headers=None, data=None)


def test_case_6_transition_from_init_to_init_via_resolve(store: Store) -> None:
    with pytest.raises(ResonateStoreError):
        store.promises.resolve(id="id6", ikey="iku", strict=True, headers=None, data=None)


def test_case_7_transition_from_init_to_init_via_resolve(store: Store) -> None:
    with pytest.raises(ResonateStoreError):
        store.promises.resolve(id="id7", ikey="iku", strict=False, headers=None, data=None)


def test_case_8_transition_from_init_to_init_via_reject(store: Store) -> None:
    with pytest.raises(ResonateStoreError):
        store.promises.reject(id="id8", ikey=None, strict=True, headers=None, data=None)


def test_case_9_transition_from_init_to_init_via_reject(store: Store) -> None:
    with pytest.raises(ResonateStoreError):
        store.promises.reject(id="id9", ikey=None, strict=False, headers=None, data=None)


def test_case_10_transition_from_init_to_init_via_reject(store: Store) -> None:
    with pytest.raises(ResonateStoreError):
        store.promises.reject(id="id10", ikey="iku", strict=True, headers=None, data=None)


def test_case_11_transition_from_init_to_init_via_reject(store: Store) -> None:
    with pytest.raises(ResonateStoreError):
        store.promises.reject(id="id11", ikey="iku", strict=False, headers=None, data=None)


def test_case_12_transition_from_init_to_init_via_cancel(store: Store) -> None:
    with pytest.raises(ResonateStoreError):
        store.promises.cancel(id="id12", ikey=None, strict=True, headers=None, data=None)


def test_case_13_transition_from_init_to_init_via_cancel(store: Store) -> None:
    with pytest.raises(ResonateStoreError):
        store.promises.cancel(id="id13", ikey=None, strict=False, headers=None, data=None)


def test_case_14_transition_from_init_to_init_via_cancel(store: Store) -> None:
    with pytest.raises(ResonateStoreError):
        store.promises.cancel(id="id14", ikey="iku", strict=True, headers=None, data=None)


def test_case_15_transition_from_init_to_init_via_cancel(store: Store) -> None:
    with pytest.raises(ResonateStoreError):
        store.promises.cancel(id="id15", ikey="iku", strict=False, headers=None, data=None)


def test_case_16_transition_from_pending_to_pending_via_create(store: Store) -> None:
    store.promises.create(
        id="id16",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    with pytest.raises(ResonateStoreError):
        store.promises.create(
            id="id16",
            ikey=None,
            strict=True,
            headers=None,
            data=None,
            timeout=sys.maxsize,
            tags=None,
        )


def test_case_17_transition_from_pending_to_pending_via_create(store: Store) -> None:
    store.promises.create(
        id="id17",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    with pytest.raises(ResonateStoreError):
        store.promises.create(
            id="id17",
            ikey=None,
            strict=False,
            headers=None,
            data=None,
            timeout=sys.maxsize,
            tags=None,
        )


def test_case_18_transition_from_pending_to_pending_via_create(store: Store) -> None:
    store.promises.create(
        id="id18",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    with pytest.raises(ResonateStoreError):
        store.promises.create(
            id="id18",
            ikey="ikc",
            strict=True,
            headers=None,
            data=None,
            timeout=sys.maxsize,
            tags=None,
        )


def test_case_19_transition_from_pending_to_pending_via_create(store: Store) -> None:
    store.promises.create(
        id="id19",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    with pytest.raises(ResonateStoreError):
        store.promises.create(
            id="id19",
            ikey="ikc",
            strict=False,
            headers=None,
            data=None,
            timeout=sys.maxsize,
            tags=None,
        )


def test_case_20_transition_from_pending_to_resolved_via_resolve(store: Store) -> None:
    store.promises.create(
        id="id20",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    promise_record = store.promises.resolve(id="id20", ikey=None, strict=True, headers=None, data=None)
    assert promise_record.state == "RESOLVED"
    assert promise_record.id == "id20"
    assert promise_record.ikey_for_create is None
    assert promise_record.ikey_for_complete is None


def test_case_21_transition_from_pending_to_resolved_via_resolve(store: Store) -> None:
    store.promises.create(
        id="id21",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    promise_record = store.promises.resolve(id="id21", ikey=None, strict=False, headers=None, data=None)
    assert promise_record.state == "RESOLVED"
    assert promise_record.id == "id21"
    assert promise_record.ikey_for_create is None
    assert promise_record.ikey_for_complete is None


def test_case_22_transition_from_pending_to_resolved_via_resolve(store: Store) -> None:
    store.promises.create(
        id="id22",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    promise_record = store.promises.resolve(id="id22", ikey="iku", strict=True, headers=None, data=None)
    assert promise_record.state == "RESOLVED"
    assert promise_record.id == "id22"
    assert promise_record.ikey_for_create is None
    assert promise_record.ikey_for_complete == "iku"


def test_case_23_transition_from_pending_to_resolved_via_resolve(store: Store) -> None:
    store.promises.create(
        id="id23",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    promise_record = store.promises.resolve(id="id23", ikey="iku", strict=False, headers=None, data=None)
    assert promise_record.state == "RESOLVED"
    assert promise_record.id == "id23"
    assert promise_record.ikey_for_create is None
    assert promise_record.ikey_for_complete == "iku"


def test_case_24_transition_from_pending_to_rejected_via_reject(store: Store) -> None:
    store.promises.create(
        id="id24",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    promise_record = store.promises.reject(id="id24", ikey=None, strict=True, headers=None, data=None)
    assert promise_record.state == "REJECTED"
    assert promise_record.id == "id24"
    assert promise_record.ikey_for_create is None
    assert promise_record.ikey_for_complete is None


def test_case_25_transition_from_pending_to_rejected_via_reject(store: Store) -> None:
    store.promises.create(
        id="id25",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    promise_record = store.promises.reject(id="id25", ikey=None, strict=False, headers=None, data=None)
    assert promise_record.state == "REJECTED"
    assert promise_record.id == "id25"
    assert promise_record.ikey_for_create is None
    assert promise_record.ikey_for_complete is None


def test_case_26_transition_from_pending_to_rejected_via_reject(store: Store) -> None:
    store.promises.create(
        id="id26",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    promise_record = store.promises.reject(id="id26", ikey="iku", strict=True, headers=None, data=None)
    assert promise_record.state == "REJECTED"
    assert promise_record.id == "id26"
    assert promise_record.ikey_for_create is None
    assert promise_record.ikey_for_complete == "iku"


def test_case_27_transition_from_pending_to_rejected_via_reject(store: Store) -> None:
    store.promises.create(
        id="id27",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    promise_record = store.promises.reject(id="id27", ikey="iku", strict=False, headers=None, data=None)
    assert promise_record.state == "REJECTED"
    assert promise_record.id == "id27"
    assert promise_record.ikey_for_create is None
    assert promise_record.ikey_for_complete == "iku"


def test_case_28_transition_from_pending_to_canceled_via_cancel(store: Store) -> None:
    store.promises.create(
        id="id28",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    promise_record = store.promises.cancel(id="id28", ikey=None, strict=True, headers=None, data=None)
    assert promise_record.state == "REJECTED_CANCELED"
    assert promise_record.id == "id28"
    assert promise_record.ikey_for_create is None
    assert promise_record.ikey_for_complete is None


def test_case_29_transition_from_pending_to_canceled_via_cancel(store: Store) -> None:
    store.promises.create(
        id="id29",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    promise_record = store.promises.cancel(id="id29", ikey=None, strict=False, headers=None, data=None)
    assert promise_record.state == "REJECTED_CANCELED"
    assert promise_record.id == "id29"
    assert promise_record.ikey_for_create is None
    assert promise_record.ikey_for_complete is None


def test_case_30_transition_from_pending_to_canceled_via_cancel(store: Store) -> None:
    store.promises.create(
        id="id30",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    promise_record = store.promises.cancel(id="id30", ikey="iku", strict=True, headers=None, data=None)
    assert promise_record.state == "REJECTED_CANCELED"
    assert promise_record.id == "id30"
    assert promise_record.ikey_for_create is None
    assert promise_record.ikey_for_complete == "iku"


def test_case_31_transition_from_pending_to_canceled_via_cancel(store: Store) -> None:
    store.promises.create(
        id="id31",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    promise_record = store.promises.cancel(id="id31", ikey="iku", strict=False, headers=None, data=None)
    assert promise_record.state == "REJECTED_CANCELED"
    assert promise_record.id == "id31"
    assert promise_record.ikey_for_create is None
    assert promise_record.ikey_for_complete == "iku"


def test_case_32_transition_from_pending_to_pending_via_create(store: Store) -> None:
    store.promises.create(
        id="id32",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    with pytest.raises(ResonateStoreError):
        store.promises.create(
            id="id32",
            ikey=None,
            strict=True,
            headers=None,
            data=None,
            timeout=sys.maxsize,
            tags=None,
        )


def test_case_33_transition_from_pending_to_pending_via_create(store: Store) -> None:
    store.promises.create(
        id="id33",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    with pytest.raises(ResonateStoreError):
        store.promises.create(
            id="id33",
            ikey=None,
            strict=False,
            headers=None,
            data=None,
            timeout=sys.maxsize,
            tags=None,
        )


def test_case_34_transition_from_pending_to_pending_via_create(store: Store) -> None:
    store.promises.create(
        id="id34",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    promise_record = store.promises.create(
        id="id34",
        ikey="ikc",
        strict=True,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    assert promise_record.state == "PENDING"
    assert promise_record.id == "id34"
    assert promise_record.ikey_for_create == "ikc"
    assert promise_record.ikey_for_complete is None


def test_case_35_transition_from_pending_to_pending_via_create(store: Store) -> None:
    store.promises.create(
        id="id35",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    promise_record = store.promises.create(
        id="id35",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    assert promise_record.state == "PENDING"
    assert promise_record.id == "id35"
    assert promise_record.ikey_for_create == "ikc"
    assert promise_record.ikey_for_complete is None


def test_case_36_transition_from_pending_to_pending_via_create(store: Store) -> None:
    store.promises.create(
        id="id36",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    with pytest.raises(ResonateStoreError):
        store.promises.create(
            id="id36",
            ikey="ikc*",
            strict=True,
            headers=None,
            data=None,
            timeout=sys.maxsize,
            tags=None,
        )


def test_case_37_transition_from_pending_to_pending_via_create(store: Store) -> None:
    store.promises.create(
        id="id37",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    with pytest.raises(ResonateStoreError):
        store.promises.create(
            id="id37",
            ikey="ikc*",
            strict=False,
            headers=None,
            data=None,
            timeout=sys.maxsize,
            tags=None,
        )


def test_case_38_transition_from_pending_to_resolved_via_resolve(store: Store) -> None:
    store.promises.create(
        id="id38",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    promise_record = store.promises.resolve(id="id38", ikey=None, strict=True, headers=None, data=None)
    assert promise_record.state == "RESOLVED"
    assert promise_record.id == "id38"
    assert promise_record.ikey_for_create == "ikc"
    assert promise_record.ikey_for_complete is None


def test_case_39_transition_from_pending_to_resolved_via_resolve(store: Store) -> None:
    store.promises.create(
        id="id39",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    promise_record = store.promises.resolve(id="id39", ikey=None, strict=False, headers=None, data=None)
    assert promise_record.state == "RESOLVED"
    assert promise_record.id == "id39"
    assert promise_record.ikey_for_create == "ikc"
    assert promise_record.ikey_for_complete is None


def test_case_40_transition_from_pending_to_resolved_via_resolve(store: Store) -> None:
    store.promises.create(
        id="id40",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    promise_record = store.promises.resolve(id="id40", ikey="iku", strict=True, headers=None, data=None)
    assert promise_record.state == "RESOLVED"
    assert promise_record.id == "id40"
    assert promise_record.ikey_for_create == "ikc"
    assert promise_record.ikey_for_complete == "iku"


def test_case_41_transition_from_pending_to_resolved_via_resolve(store: Store) -> None:
    store.promises.create(
        id="id41",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    promise_record = store.promises.resolve(id="id41", ikey="iku", strict=False, headers=None, data=None)
    assert promise_record.state == "RESOLVED"
    assert promise_record.id == "id41"
    assert promise_record.ikey_for_create == "ikc"
    assert promise_record.ikey_for_complete == "iku"


def test_case_42_transition_from_pending_to_rejected_via_reject(store: Store) -> None:
    store.promises.create(
        id="id42",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    promise_record = store.promises.reject(id="id42", ikey=None, strict=True, headers=None, data=None)
    assert promise_record.state == "REJECTED"
    assert promise_record.id == "id42"
    assert promise_record.ikey_for_create == "ikc"
    assert promise_record.ikey_for_complete is None


def test_case_43_transition_from_pending_to_rejected_via_reject(store: Store) -> None:
    store.promises.create(
        id="id43",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    promise_record = store.promises.reject(id="id43", ikey=None, strict=False, headers=None, data=None)
    assert promise_record.state == "REJECTED"
    assert promise_record.id == "id43"
    assert promise_record.ikey_for_create == "ikc"
    assert promise_record.ikey_for_complete is None


def test_case_44_transition_from_pending_to_rejected_via_reject(store: Store) -> None:
    store.promises.create(
        id="id44",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    promise_record = store.promises.reject(id="id44", ikey="iku", strict=True, headers=None, data=None)
    assert promise_record.state == "REJECTED"
    assert promise_record.id == "id44"
    assert promise_record.ikey_for_create == "ikc"
    assert promise_record.ikey_for_complete == "iku"


def test_case_45_transition_from_pending_to_rejected_via_reject(store: Store) -> None:
    store.promises.create(
        id="id45",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    promise_record = store.promises.reject(id="id45", ikey="iku", strict=False, headers=None, data=None)
    assert promise_record.state == "REJECTED"
    assert promise_record.id == "id45"
    assert promise_record.ikey_for_create == "ikc"
    assert promise_record.ikey_for_complete == "iku"


def test_case_46_transition_from_pending_to_canceled_via_cancel(store: Store) -> None:
    store.promises.create(
        id="id46",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    promise_record = store.promises.cancel(id="id46", ikey=None, strict=True, headers=None, data=None)
    assert promise_record.state == "REJECTED_CANCELED"
    assert promise_record.id == "id46"
    assert promise_record.ikey_for_create == "ikc"
    assert promise_record.ikey_for_complete is None


def test_case_47_transition_from_pending_to_canceled_via_cancel(store: Store) -> None:
    store.promises.create(
        id="id47",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    promise_record = store.promises.cancel(id="id47", ikey=None, strict=False, headers=None, data=None)
    assert promise_record.state == "REJECTED_CANCELED"
    assert promise_record.id == "id47"
    assert promise_record.ikey_for_create == "ikc"
    assert promise_record.ikey_for_complete is None


def test_case_48_transition_from_pending_to_canceled_via_cancel(store: Store) -> None:
    store.promises.create(
        id="id48",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    promise_record = store.promises.cancel(id="id48", ikey="iku", strict=True, headers=None, data=None)
    assert promise_record.state == "REJECTED_CANCELED"
    assert promise_record.id == "id48"
    assert promise_record.ikey_for_create == "ikc"
    assert promise_record.ikey_for_complete == "iku"


def test_case_49_transition_from_pending_to_canceled_via_cancel(store: Store) -> None:
    store.promises.create(
        id="id49",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    promise_record = store.promises.cancel(id="id49", ikey="iku", strict=False, headers=None, data=None)
    assert promise_record.state == "REJECTED_CANCELED"
    assert promise_record.id == "id49"
    assert promise_record.ikey_for_create == "ikc"
    assert promise_record.ikey_for_complete == "iku"


def test_case_50_transition_from_resolved_to_resolved_via_create(store: Store) -> None:
    store.promises.create(
        id="id50",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.resolve(id="id50", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.create(
            id="id50",
            ikey=None,
            strict=True,
            headers=None,
            data=None,
            timeout=sys.maxsize,
            tags=None,
        )


def test_case_51_transition_from_resolved_to_resolved_via_create(store: Store) -> None:
    store.promises.create(
        id="id51",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.resolve(id="id51", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.create(
            id="id51",
            ikey=None,
            strict=False,
            headers=None,
            data=None,
            timeout=sys.maxsize,
            tags=None,
        )


def test_case_52_transition_from_resolved_to_resolved_via_create(store: Store) -> None:
    store.promises.create(
        id="id52",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.resolve(id="id52", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.create(
            id="id52",
            ikey="ikc",
            strict=True,
            headers=None,
            data=None,
            timeout=sys.maxsize,
            tags=None,
        )


def test_case_53_transition_from_resolved_to_resolved_via_create(store: Store) -> None:
    store.promises.create(
        id="id53",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.resolve(id="id53", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.create(
            id="id53",
            ikey="ikc",
            strict=False,
            headers=None,
            data=None,
            timeout=sys.maxsize,
            tags=None,
        )


def test_case_54_transition_from_resolved_to_resolved_via_resolve(
    store: Store,
) -> None:
    store.promises.create(
        id="id54",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.resolve(id="id54", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.resolve(id="id54", ikey=None, strict=True, headers=None, data=None)


def test_case_55_transition_from_resolved_to_resolved_via_resolve(
    store: Store,
) -> None:
    store.promises.create(
        id="id55",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.resolve(id="id55", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.resolve(id="id55", ikey=None, strict=False, headers=None, data=None)


def test_case_56_transition_from_resolved_to_resolved_via_resolve(
    store: Store,
) -> None:
    store.promises.create(
        id="id56",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.resolve(id="id56", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.resolve(id="id56", ikey="iku", strict=True, headers=None, data=None)


def test_case_57_transition_from_resolved_to_resolved_via_resolve(
    store: Store,
) -> None:
    store.promises.create(
        id="id57",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.resolve(id="id57", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.resolve(id="id57", ikey="iku", strict=False, headers=None, data=None)


def test_case_58_transition_from_resolved_to_resolved_via_reject(store: Store) -> None:
    store.promises.create(
        id="id58",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.resolve(id="id58", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.reject(id="id58", ikey=None, strict=True, headers=None, data=None)


def test_case_59_transition_from_resolved_to_resolved_via_reject(store: Store) -> None:
    store.promises.create(
        id="id59",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.resolve(id="id59", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.reject(id="id59", ikey=None, strict=False, headers=None, data=None)


def test_case_60_transition_from_resolved_to_resolved_via_reject(store: Store) -> None:
    store.promises.create(
        id="id60",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.resolve(id="id60", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.reject(id="id60", ikey="iku", strict=True, headers=None, data=None)


def test_case_61_transition_from_resolved_to_resolved_via_reject(store: Store) -> None:
    store.promises.create(
        id="id61",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.resolve(id="id61", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.reject(id="id61", ikey="iku", strict=False, headers=None, data=None)


def test_case_62_transition_from_resolved_to_resolved_via_cancel(store: Store) -> None:
    store.promises.create(
        id="id62",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.resolve(id="id62", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.cancel(id="id62", ikey=None, strict=True, headers=None, data=None)


def test_case_63_transition_from_resolved_to_resolved_via_cancel(store: Store) -> None:
    store.promises.create(
        id="id63",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.resolve(id="id63", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.cancel(id="id63", ikey=None, strict=False, headers=None, data=None)


def test_case_64_transition_from_resolved_to_resolved_via_cancel(store: Store) -> None:
    store.promises.create(
        id="id64",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.resolve(id="id64", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.cancel(id="id64", ikey="iku", strict=True, headers=None, data=None)


def test_case_65_transition_from_resolved_to_resolved_via_cancel(store: Store) -> None:
    store.promises.create(
        id="id65",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.resolve(id="id65", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.cancel(id="id65", ikey="iku", strict=False, headers=None, data=None)


def test_case_66_transition_from_resolved_to_resolved_via_create(store: Store) -> None:
    store.promises.create(
        id="id66",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.resolve(id="id66", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.create(
            id="id66",
            ikey=None,
            strict=True,
            headers=None,
            data=None,
            timeout=sys.maxsize,
            tags=None,
        )


def test_case_67_transition_from_resolved_to_resolved_via_create(store: Store) -> None:
    store.promises.create(
        id="id67",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.resolve(id="id67", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.create(
            id="id67",
            ikey=None,
            strict=False,
            headers=None,
            data=None,
            timeout=sys.maxsize,
            tags=None,
        )


def test_case_68_transition_from_resolved_to_resolved_via_create(store: Store) -> None:
    store.promises.create(
        id="id68",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.resolve(id="id68", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.create(
            id="id68",
            ikey="ikc",
            strict=True,
            headers=None,
            data=None,
            timeout=sys.maxsize,
            tags=None,
        )


def test_case_69_transition_from_resolved_to_resolved_via_create(store: Store) -> None:
    store.promises.create(
        id="id69",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.resolve(id="id69", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.create(
            id="id69",
            ikey="ikc",
            strict=False,
            headers=None,
            data=None,
            timeout=sys.maxsize,
            tags=None,
        )


def test_case_70_transition_from_resolved_to_resolved_via_resolve(
    store: Store,
) -> None:
    store.promises.create(
        id="id70",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.resolve(id="id70", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.resolve(id="id70", ikey=None, strict=True, headers=None, data=None)


def test_case_71_transition_from_resolved_to_resolved_via_resolve(
    store: Store,
) -> None:
    store.promises.create(
        id="id71",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.resolve(id="id71", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.resolve(id="id71", ikey=None, strict=False, headers=None, data=None)


def test_case_72_transition_from_resolved_to_resolved_via_resolve(
    store: Store,
) -> None:
    store.promises.create(
        id="id72",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.resolve(id="id72", ikey="iku", strict=False, headers=None, data=None)
    promise_record = store.promises.resolve(id="id72", ikey="iku", strict=True, headers=None, data=None)
    assert promise_record.state == "RESOLVED"
    assert promise_record.id == "id72"
    assert promise_record.ikey_for_create is None
    assert promise_record.ikey_for_complete == "iku"


def test_case_73_transition_from_resolved_to_resolved_via_resolve(
    store: Store,
) -> None:
    store.promises.create(
        id="id73",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.resolve(id="id73", ikey="iku", strict=False, headers=None, data=None)
    promise_record = store.promises.resolve(id="id73", ikey="iku", strict=False, headers=None, data=None)
    assert promise_record.state == "RESOLVED"
    assert promise_record.id == "id73"
    assert promise_record.ikey_for_create is None
    assert promise_record.ikey_for_complete == "iku"


def test_case_74_transition_from_resolved_to_resolved_via_resolve(
    store: Store,
) -> None:
    store.promises.create(
        id="id74",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.resolve(id="id74", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.resolve(id="id74", ikey="iku*", strict=True, headers=None, data=None)


def test_case_75_transition_from_resolved_to_resolved_via_resolve(
    store: Store,
) -> None:
    store.promises.create(
        id="id75",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.resolve(id="id75", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.resolve(id="id75", ikey="iku*", strict=False, headers=None, data=None)


def test_case_76_transition_from_resolved_to_resolved_via_reject(store: Store) -> None:
    store.promises.create(
        id="id76",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.resolve(id="id76", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.reject(id="id76", ikey=None, strict=True, headers=None, data=None)


def test_case_77_transition_from_resolved_to_resolved_via_reject(store: Store) -> None:
    store.promises.create(
        id="id77",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.resolve(id="id77", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.reject(id="id77", ikey=None, strict=False, headers=None, data=None)


def test_case_78_transition_from_resolved_to_resolved_via_reject(store: Store) -> None:
    store.promises.create(
        id="id78",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.resolve(id="id78", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.reject(id="id78", ikey="iku", strict=True, headers=None, data=None)


def test_case_79_transition_from_resolved_to_resolved_via_reject(store: Store) -> None:
    store.promises.create(
        id="id79",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.resolve(id="id79", ikey="iku", strict=False, headers=None, data=None)
    promise_record = store.promises.reject(id="id79", ikey="iku", strict=False, headers=None, data=None)
    assert promise_record.state == "RESOLVED"
    assert promise_record.id == "id79"
    assert promise_record.ikey_for_create is None
    assert promise_record.ikey_for_complete == "iku"


def test_case_80_transition_from_resolved_to_resolved_via_reject(store: Store) -> None:
    store.promises.create(
        id="id80",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.resolve(id="id80", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.reject(id="id80", ikey="iku*", strict=True, headers=None, data=None)


def test_case_81_transition_from_resolved_to_resolved_via_reject(store: Store) -> None:
    store.promises.create(
        id="id81",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.resolve(id="id81", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.reject(id="id81", ikey="iku*", strict=False, headers=None, data=None)


def test_case_82_transition_from_resolved_to_resolved_via_cancel(store: Store) -> None:
    store.promises.create(
        id="id82",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.resolve(id="id82", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.cancel(id="id82", ikey=None, strict=True, headers=None, data=None)


def test_case_83_transition_from_resolved_to_resolved_via_cancel(store: Store) -> None:
    store.promises.create(
        id="id83",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.resolve(id="id83", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.cancel(id="id83", ikey=None, strict=False, headers=None, data=None)


def test_case_84_transition_from_resolved_to_resolved_via_cancel(store: Store) -> None:
    store.promises.create(
        id="id84",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.resolve(id="id84", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.cancel(id="id84", ikey="iku", strict=True, headers=None, data=None)


def test_case_85_transition_from_resolved_to_resolved_via_cancel(store: Store) -> None:
    store.promises.create(
        id="id85",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.resolve(id="id85", ikey="iku", strict=False, headers=None, data=None)
    promise_record = store.promises.cancel(id="id85", ikey="iku", strict=False, headers=None, data=None)
    assert promise_record.state == "RESOLVED"
    assert promise_record.id == "id85"
    assert promise_record.ikey_for_create is None
    assert promise_record.ikey_for_complete == "iku"


def test_case_86_transition_from_resolved_to_resolved_via_cancel(store: Store) -> None:
    store.promises.create(
        id="id86",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.resolve(id="id86", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.cancel(id="id86", ikey="iku*", strict=True, headers=None, data=None)


def test_case_87_transition_from_resolved_to_resolved_via_cancel(store: Store) -> None:
    store.promises.create(
        id="id87",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.resolve(id="id87", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.cancel(id="id87", ikey="iku*", strict=False, headers=None, data=None)


def test_case_88_transition_from_resolved_to_resolved_via_create(store: Store) -> None:
    store.promises.create(
        id="id88",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.resolve(id="id88", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.create(
            id="id88",
            ikey=None,
            strict=True,
            headers=None,
            data=None,
            timeout=sys.maxsize,
            tags=None,
        )


def test_case_89_transition_from_resolved_to_resolved_via_create(store: Store) -> None:
    store.promises.create(
        id="id89",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.resolve(id="id89", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.create(
            id="id89",
            ikey=None,
            strict=False,
            headers=None,
            data=None,
            timeout=sys.maxsize,
            tags=None,
        )


def test_case_90_transition_from_resolved_to_resolved_via_create(store: Store) -> None:
    store.promises.create(
        id="id90",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.resolve(id="id90", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.create(
            id="id90",
            ikey="ikc",
            strict=True,
            headers=None,
            data=None,
            timeout=sys.maxsize,
            tags=None,
        )


def test_case_91_transition_from_resolved_to_resolved_via_create(store: Store) -> None:
    store.promises.create(
        id="id91",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.resolve(id="id91", ikey=None, strict=False, headers=None, data=None)
    promise_record = store.promises.create(
        id="id91",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    assert promise_record.state == "RESOLVED"
    assert promise_record.id == "id91"
    assert promise_record.ikey_for_create == "ikc"
    assert promise_record.ikey_for_complete is None


def test_case_92_transition_from_resolved_to_resolved_via_create(store: Store) -> None:
    store.promises.create(
        id="id92",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.resolve(id="id92", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.create(
            id="id92",
            ikey="ikc*",
            strict=True,
            headers=None,
            data=None,
            timeout=sys.maxsize,
            tags=None,
        )


def test_case_93_transition_from_resolved_to_resolved_via_create(store: Store) -> None:
    store.promises.create(
        id="id93",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.resolve(id="id93", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.create(
            id="id93",
            ikey="ikc*",
            strict=False,
            headers=None,
            data=None,
            timeout=sys.maxsize,
            tags=None,
        )


def test_case_94_transition_from_resolved_to_resolved_via_resolve(
    store: Store,
) -> None:
    store.promises.create(
        id="id94",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.resolve(id="id94", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.resolve(id="id94", ikey=None, strict=True, headers=None, data=None)


def test_case_95_transition_from_resolved_to_resolved_via_resolve(
    store: Store,
) -> None:
    store.promises.create(
        id="id95",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.resolve(id="id95", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.resolve(id="id95", ikey=None, strict=False, headers=None, data=None)


def test_case_96_transition_from_resolved_to_resolved_via_resolve(
    store: Store,
) -> None:
    store.promises.create(
        id="id96",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.resolve(id="id96", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.resolve(id="id96", ikey="iku", strict=True, headers=None, data=None)


def test_case_97_transition_from_resolved_to_resolved_via_resolve(
    store: Store,
) -> None:
    store.promises.create(
        id="id97",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.resolve(id="id97", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.resolve(id="id97", ikey="iku", strict=False, headers=None, data=None)


def test_case_98_transition_from_resolved_to_resolved_via_reject(store: Store) -> None:
    store.promises.create(
        id="id98",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.resolve(id="id98", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.reject(id="id98", ikey=None, strict=True, headers=None, data=None)


def test_case_99_transition_from_resolved_to_resolved_via_reject(store: Store) -> None:
    store.promises.create(
        id="id99",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.resolve(id="id99", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.reject(id="id99", ikey=None, strict=False, headers=None, data=None)


def test_case_100_transition_from_resolved_to_resolved_via_reject(
    store: Store,
) -> None:
    store.promises.create(
        id="id100",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.resolve(id="id100", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.reject(id="id100", ikey="iku", strict=True, headers=None, data=None)


def test_case_101_transition_from_resolved_to_resolved_via_reject(
    store: Store,
) -> None:
    store.promises.create(
        id="id101",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.resolve(id="id101", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.reject(id="id101", ikey="iku", strict=False, headers=None, data=None)


def test_case_102_transition_from_resolved_to_resolved_via_cancel(
    store: Store,
) -> None:
    store.promises.create(
        id="id102",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.resolve(id="id102", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.cancel(id="id102", ikey=None, strict=True, headers=None, data=None)


def test_case_103_transition_from_resolved_to_resolved_via_cancel(
    store: Store,
) -> None:
    store.promises.create(
        id="id103",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.resolve(id="id103", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.cancel(id="id103", ikey=None, strict=False, headers=None, data=None)


def test_case_104_transition_from_resolved_to_resolved_via_cancel(
    store: Store,
) -> None:
    store.promises.create(
        id="id104",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.resolve(id="id104", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.cancel(id="id104", ikey="iku", strict=True, headers=None, data=None)


def test_case_105_transition_from_resolved_to_resolved_via_cancel(
    store: Store,
) -> None:
    store.promises.create(
        id="id105",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.resolve(id="id105", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.cancel(id="id105", ikey="iku", strict=False, headers=None, data=None)


def test_case_106_transition_from_resolved_to_resolved_via_create(
    store: Store,
) -> None:
    store.promises.create(
        id="id106",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.resolve(id="id106", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.create(
            id="id106",
            ikey=None,
            strict=True,
            headers=None,
            data=None,
            timeout=sys.maxsize,
            tags=None,
        )


def test_case_107_transition_from_resolved_to_resolved_via_create(
    store: Store,
) -> None:
    store.promises.create(
        id="id107",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.resolve(id="id107", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.create(
            id="id107",
            ikey=None,
            strict=False,
            headers=None,
            data=None,
            timeout=sys.maxsize,
            tags=None,
        )


def test_case_108_transition_from_resolved_to_resolved_via_create(
    store: Store,
) -> None:
    store.promises.create(
        id="id108",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.resolve(id="id108", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.create(
            id="id108",
            ikey="ikc",
            strict=True,
            headers=None,
            data=None,
            timeout=sys.maxsize,
            tags=None,
        )


def test_case_109_transition_from_resolved_to_resolved_via_create(
    store: Store,
) -> None:
    store.promises.create(
        id="id109",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.resolve(id="id109", ikey="iku", strict=False, headers=None, data=None)
    promise_record = store.promises.create(
        id="id109",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    assert promise_record.state == "RESOLVED"
    assert promise_record.id == "id109"
    assert promise_record.ikey_for_create == "ikc"
    assert promise_record.ikey_for_complete == "iku"


def test_case_110_transition_from_resolved_to_resolved_via_create(
    store: Store,
) -> None:
    store.promises.create(
        id="id110",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.resolve(id="id110", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.create(
            id="id110",
            ikey="ikc*",
            strict=True,
            headers=None,
            data=None,
            timeout=sys.maxsize,
            tags=None,
        )


def test_case_111_transition_from_resolved_to_resolved_via_create(
    store: Store,
) -> None:
    store.promises.create(
        id="id111",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.resolve(id="id111", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.create(
            id="id111",
            ikey="ikc*",
            strict=False,
            headers=None,
            data=None,
            timeout=sys.maxsize,
            tags=None,
        )


def test_case_112_transition_from_resolved_to_resolved_via_resolve(
    store: Store,
) -> None:
    store.promises.create(
        id="id112",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.resolve(id="id112", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.resolve(id="id112", ikey=None, strict=True, headers=None, data=None)


def test_case_113_transition_from_resolved_to_resolved_via_resolve(
    store: Store,
) -> None:
    store.promises.create(
        id="id113",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.resolve(id="id113", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.resolve(id="id113", ikey=None, strict=False, headers=None, data=None)


def test_case_114_transition_from_resolved_to_resolved_via_resolve(
    store: Store,
) -> None:
    store.promises.create(
        id="id114",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.resolve(id="id114", ikey="iku", strict=False, headers=None, data=None)
    promise_record = store.promises.resolve(id="id114", ikey="iku", strict=True, headers=None, data=None)
    assert promise_record.state == "RESOLVED"
    assert promise_record.id == "id114"
    assert promise_record.ikey_for_create == "ikc"
    assert promise_record.ikey_for_complete == "iku"


def test_case_115_transition_from_resolved_to_resolved_via_resolve(
    store: Store,
) -> None:
    store.promises.create(
        id="id115",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.resolve(id="id115", ikey="iku", strict=False, headers=None, data=None)
    promise_record = store.promises.resolve(id="id115", ikey="iku", strict=False, headers=None, data=None)
    assert promise_record.state == "RESOLVED"
    assert promise_record.id == "id115"
    assert promise_record.ikey_for_create == "ikc"
    assert promise_record.ikey_for_complete == "iku"


def test_case_116_transition_from_resolved_to_resolved_via_resolve(
    store: Store,
) -> None:
    store.promises.create(
        id="id116",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.resolve(id="id116", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.resolve(id="id116", ikey="iku*", strict=True, headers=None, data=None)


def test_case_117_transition_from_resolved_to_resolved_via_resolve(
    store: Store,
) -> None:
    store.promises.create(
        id="id117",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.resolve(id="id117", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.resolve(id="id117", ikey="iku*", strict=False, headers=None, data=None)


def test_case_118_transition_from_resolved_to_resolved_via_reject(
    store: Store,
) -> None:
    store.promises.create(
        id="id118",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.resolve(id="id118", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.reject(id="id118", ikey=None, strict=True, headers=None, data=None)


def test_case_119_transition_from_resolved_to_resolved_via_reject(
    store: Store,
) -> None:
    store.promises.create(
        id="id119",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.resolve(id="id119", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.reject(id="id119", ikey=None, strict=False, headers=None, data=None)


def test_case_120_transition_from_resolved_to_resolved_via_reject(
    store: Store,
) -> None:
    store.promises.create(
        id="id120",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.resolve(id="id120", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.reject(id="id120", ikey="iku", strict=True, headers=None, data=None)


def test_case_121_transition_from_resolved_to_resolved_via_reject(
    store: Store,
) -> None:
    store.promises.create(
        id="id121",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.resolve(id="id121", ikey="iku", strict=False, headers=None, data=None)
    promise_record = store.promises.reject(id="id121", ikey="iku", strict=False, headers=None, data=None)
    assert promise_record.state == "RESOLVED"
    assert promise_record.id == "id121"
    assert promise_record.ikey_for_create == "ikc"
    assert promise_record.ikey_for_complete == "iku"


def test_case_122_transition_from_resolved_to_resolved_via_reject(
    store: Store,
) -> None:
    store.promises.create(
        id="id122",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.resolve(id="id122", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.reject(id="id122", ikey="iku*", strict=True, headers=None, data=None)


def test_case_123_transition_from_resolved_to_resolved_via_reject(
    store: Store,
) -> None:
    store.promises.create(
        id="id123",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.resolve(id="id123", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.reject(id="id123", ikey="iku*", strict=False, headers=None, data=None)


def test_case_124_transition_from_resolved_to_resolved_via_cancel(
    store: Store,
) -> None:
    store.promises.create(
        id="id124",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.resolve(id="id124", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.cancel(id="id124", ikey=None, strict=True, headers=None, data=None)


def test_case_125_transition_from_resolved_to_resolved_via_cancel(
    store: Store,
) -> None:
    store.promises.create(
        id="id125",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.resolve(id="id125", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.cancel(id="id125", ikey=None, strict=False, headers=None, data=None)


def test_case_126_transition_from_resolved_to_resolved_via_cancel(
    store: Store,
) -> None:
    store.promises.create(
        id="id126",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.resolve(id="id126", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.cancel(id="id126", ikey="iku", strict=True, headers=None, data=None)


def test_case_127_transition_from_resolved_to_resolved_via_cancel(
    store: Store,
) -> None:
    store.promises.create(
        id="id127",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.resolve(id="id127", ikey="iku", strict=False, headers=None, data=None)
    promise_record = store.promises.cancel(id="id127", ikey="iku", strict=False, headers=None, data=None)
    assert promise_record.state == "RESOLVED"
    assert promise_record.id == "id127"
    assert promise_record.ikey_for_create == "ikc"
    assert promise_record.ikey_for_complete == "iku"


def test_case_128_transition_from_resolved_to_resolved_via_cancel(
    store: Store,
) -> None:
    store.promises.create(
        id="id128",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.resolve(id="id128", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.cancel(id="id128", ikey="iku*", strict=True, headers=None, data=None)


def test_case_129_transition_from_resolved_to_resolved_via_cancel(
    store: Store,
) -> None:
    store.promises.create(
        id="id129",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.resolve(id="id129", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.cancel(id="id129", ikey="iku*", strict=False, headers=None, data=None)


def test_case_130_transition_from_rejected_to_rejected_via_create(
    store: Store,
) -> None:
    store.promises.create(
        id="id130",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.reject(id="id130", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.create(
            id="id130",
            ikey=None,
            strict=True,
            headers=None,
            data=None,
            timeout=sys.maxsize,
            tags=None,
        )


def test_case_131_transition_from_rejected_to_rejected_via_create(
    store: Store,
) -> None:
    store.promises.create(
        id="id131",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.reject(id="id131", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.create(
            id="id131",
            ikey=None,
            strict=False,
            headers=None,
            data=None,
            timeout=sys.maxsize,
            tags=None,
        )


def test_case_132_transition_from_rejected_to_rejected_via_create(
    store: Store,
) -> None:
    store.promises.create(
        id="id132",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.reject(id="id132", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.create(
            id="id132",
            ikey="ikc",
            strict=True,
            headers=None,
            data=None,
            timeout=sys.maxsize,
            tags=None,
        )


def test_case_133_transition_from_rejected_to_rejected_via_create(
    store: Store,
) -> None:
    store.promises.create(
        id="id133",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.reject(id="id133", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.create(
            id="id133",
            ikey="ikc",
            strict=False,
            headers=None,
            data=None,
            timeout=sys.maxsize,
            tags=None,
        )


def test_case_134_transition_from_rejected_to_rejected_via_resolve(
    store: Store,
) -> None:
    store.promises.create(
        id="id134",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.reject(id="id134", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.resolve(id="id134", ikey=None, strict=True, headers=None, data=None)


def test_case_135_transition_from_rejected_to_rejected_via_resolve(
    store: Store,
) -> None:
    store.promises.create(
        id="id135",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.reject(id="id135", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.resolve(id="id135", ikey=None, strict=False, headers=None, data=None)


def test_case_136_transition_from_rejected_to_rejected_via_resolve(
    store: Store,
) -> None:
    store.promises.create(
        id="id136",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.reject(id="id136", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.resolve(id="id136", ikey="iku", strict=True, headers=None, data=None)


def test_case_137_transition_from_rejected_to_rejected_via_resolve(
    store: Store,
) -> None:
    store.promises.create(
        id="id137",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.reject(id="id137", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.resolve(id="id137", ikey="iku", strict=False, headers=None, data=None)


def test_case_138_transition_from_rejected_to_rejected_via_reject(
    store: Store,
) -> None:
    store.promises.create(
        id="id138",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.reject(id="id138", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.reject(id="id138", ikey=None, strict=True, headers=None, data=None)


def test_case_139_transition_from_rejected_to_rejected_via_reject(
    store: Store,
) -> None:
    store.promises.create(
        id="id139",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.reject(id="id139", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.reject(id="id139", ikey=None, strict=False, headers=None, data=None)


def test_case_140_transition_from_rejected_to_rejected_via_reject(
    store: Store,
) -> None:
    store.promises.create(
        id="id140",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.reject(id="id140", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.reject(id="id140", ikey="iku", strict=True, headers=None, data=None)


def test_case_141_transition_from_rejected_to_rejected_via_reject(
    store: Store,
) -> None:
    store.promises.create(
        id="id141",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.reject(id="id141", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.reject(id="id141", ikey="iku", strict=False, headers=None, data=None)


def test_case_142_transition_from_rejected_to_rejected_via_cancel(
    store: Store,
) -> None:
    store.promises.create(
        id="id142",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.reject(id="id142", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.cancel(id="id142", ikey=None, strict=True, headers=None, data=None)


def test_case_143_transition_from_rejected_to_rejected_via_cancel(
    store: Store,
) -> None:
    store.promises.create(
        id="id143",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.reject(id="id143", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.cancel(id="id143", ikey=None, strict=False, headers=None, data=None)


def test_case_144_transition_from_rejected_to_rejected_via_cancel(
    store: Store,
) -> None:
    store.promises.create(
        id="id144",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.reject(id="id144", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.cancel(id="id144", ikey="iku", strict=True, headers=None, data=None)


def test_case_145_transition_from_rejected_to_rejected_via_cancel(
    store: Store,
) -> None:
    store.promises.create(
        id="id145",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.reject(id="id145", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.cancel(id="id145", ikey="iku", strict=False, headers=None, data=None)


def test_case_146_transition_from_rejected_to_rejected_via_create(
    store: Store,
) -> None:
    store.promises.create(
        id="id146",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.reject(id="id146", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.create(
            id="id146",
            ikey=None,
            strict=True,
            headers=None,
            data=None,
            timeout=sys.maxsize,
            tags=None,
        )


def test_case_147_transition_from_rejected_to_rejected_via_create(
    store: Store,
) -> None:
    store.promises.create(
        id="id147",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.reject(id="id147", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.create(
            id="id147",
            ikey=None,
            strict=False,
            headers=None,
            data=None,
            timeout=sys.maxsize,
            tags=None,
        )


def test_case_148_transition_from_rejected_to_rejected_via_create(
    store: Store,
) -> None:
    store.promises.create(
        id="id148",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.reject(id="id148", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.create(
            id="id148",
            ikey="ikc",
            strict=True,
            headers=None,
            data=None,
            timeout=sys.maxsize,
            tags=None,
        )


def test_case_149_transition_from_rejected_to_rejected_via_create(
    store: Store,
) -> None:
    store.promises.create(
        id="id149",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.reject(id="id149", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.create(
            id="id149",
            ikey="ikc",
            strict=False,
            headers=None,
            data=None,
            timeout=sys.maxsize,
            tags=None,
        )


def test_case_150_transition_from_rejected_to_rejected_via_resolve(
    store: Store,
) -> None:
    store.promises.create(
        id="id150",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.reject(id="id150", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.resolve(id="id150", ikey=None, strict=True, headers=None, data=None)


def test_case_151_transition_from_rejected_to_rejected_via_resolve(
    store: Store,
) -> None:
    store.promises.create(
        id="id151",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.reject(id="id151", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.resolve(id="id151", ikey=None, strict=False, headers=None, data=None)


def test_case_152_transition_from_rejected_to_rejected_via_resolve(
    store: Store,
) -> None:
    store.promises.create(
        id="id152",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.reject(id="id152", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.resolve(id="id152", ikey="iku", strict=True, headers=None, data=None)


def test_case_153_transition_from_rejected_to_rejected_via_resolve(
    store: Store,
) -> None:
    store.promises.create(
        id="id153",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.reject(id="id153", ikey="iku", strict=False, headers=None, data=None)
    promise_record = store.promises.resolve(id="id153", ikey="iku", strict=False, headers=None, data=None)
    assert promise_record.state == "REJECTED"
    assert promise_record.id == "id153"
    assert promise_record.ikey_for_create is None
    assert promise_record.ikey_for_complete == "iku"


def test_case_154_transition_from_rejected_to_rejected_via_resolve(
    store: Store,
) -> None:
    store.promises.create(
        id="id154",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.reject(id="id154", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.resolve(id="id154", ikey="iku*", strict=True, headers=None, data=None)


def test_case_155_transition_from_rejected_to_rejected_via_resolve(
    store: Store,
) -> None:
    store.promises.create(
        id="id155",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.reject(id="id155", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.resolve(id="id155", ikey="iku*", strict=False, headers=None, data=None)


def test_case_156_transition_from_rejected_to_rejected_via_reject(
    store: Store,
) -> None:
    store.promises.create(
        id="id156",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.reject(id="id156", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.reject(id="id156", ikey=None, strict=True, headers=None, data=None)


def test_case_157_transition_from_rejected_to_rejected_via_reject(
    store: Store,
) -> None:
    store.promises.create(
        id="id157",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.reject(id="id157", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.reject(id="id157", ikey=None, strict=False, headers=None, data=None)


def test_case_158_transition_from_rejected_to_rejected_via_reject(
    store: Store,
) -> None:
    store.promises.create(
        id="id158",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.reject(id="id158", ikey="iku", strict=False, headers=None, data=None)
    promise_record = store.promises.reject(id="id158", ikey="iku", strict=True, headers=None, data=None)
    assert promise_record.state == "REJECTED"
    assert promise_record.id == "id158"
    assert promise_record.ikey_for_create is None
    assert promise_record.ikey_for_complete == "iku"


def test_case_159_transition_from_rejected_to_rejected_via_reject(
    store: Store,
) -> None:
    store.promises.create(
        id="id159",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.reject(id="id159", ikey="iku", strict=False, headers=None, data=None)
    promise_record = store.promises.reject(id="id159", ikey="iku", strict=False, headers=None, data=None)
    assert promise_record.state == "REJECTED"
    assert promise_record.id == "id159"
    assert promise_record.ikey_for_create is None
    assert promise_record.ikey_for_complete == "iku"


def test_case_160_transition_from_rejected_to_rejected_via_reject(
    store: Store,
) -> None:
    store.promises.create(
        id="id160",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.reject(id="id160", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.reject(id="id160", ikey="iku*", strict=True, headers=None, data=None)


def test_case_161_transition_from_rejected_to_rejected_via_reject(
    store: Store,
) -> None:
    store.promises.create(
        id="id161",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.reject(id="id161", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.reject(id="id161", ikey="iku*", strict=False, headers=None, data=None)


def test_case_162_transition_from_rejected_to_rejected_via_cancel(
    store: Store,
) -> None:
    store.promises.create(
        id="id162",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.reject(id="id162", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.cancel(id="id162", ikey=None, strict=True, headers=None, data=None)


def test_case_163_transition_from_rejected_to_rejected_via_cancel(
    store: Store,
) -> None:
    store.promises.create(
        id="id163",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.reject(id="id163", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.cancel(id="id163", ikey=None, strict=False, headers=None, data=None)


def test_case_164_transition_from_rejected_to_rejected_via_cancel(
    store: Store,
) -> None:
    store.promises.create(
        id="id164",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.reject(id="id164", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.cancel(id="id164", ikey="iku", strict=True, headers=None, data=None)


def test_case_165_transition_from_rejected_to_rejected_via_cancel(
    store: Store,
) -> None:
    store.promises.create(
        id="id165",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.reject(id="id165", ikey="iku", strict=False, headers=None, data=None)
    promise_record = store.promises.cancel(id="id165", ikey="iku", strict=False, headers=None, data=None)
    assert promise_record.state == "REJECTED"
    assert promise_record.id == "id165"
    assert promise_record.ikey_for_create is None
    assert promise_record.ikey_for_complete == "iku"


def test_case_166_transition_from_rejected_to_rejected_via_cancel(
    store: Store,
) -> None:
    store.promises.create(
        id="id166",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.reject(id="id166", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.cancel(id="id166", ikey="iku*", strict=True, headers=None, data=None)


def test_case_167_transition_from_rejected_to_rejected_via_cancel(
    store: Store,
) -> None:
    store.promises.create(
        id="id167",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.reject(id="id167", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.cancel(id="id167", ikey="iku*", strict=False, headers=None, data=None)


def test_case_168_transition_from_rejected_to_rejected_via_create(
    store: Store,
) -> None:
    store.promises.create(
        id="id168",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.reject(id="id168", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.create(
            id="id168",
            ikey=None,
            strict=True,
            headers=None,
            data=None,
            timeout=sys.maxsize,
            tags=None,
        )


def test_case_169_transition_from_rejected_to_rejected_via_create(
    store: Store,
) -> None:
    store.promises.create(
        id="id169",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.reject(id="id169", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.create(
            id="id169",
            ikey=None,
            strict=False,
            headers=None,
            data=None,
            timeout=sys.maxsize,
            tags=None,
        )


def test_case_170_transition_from_rejected_to_rejected_via_create(
    store: Store,
) -> None:
    store.promises.create(
        id="id170",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.reject(id="id170", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.create(
            id="id170",
            ikey="ikc",
            strict=True,
            headers=None,
            data=None,
            timeout=sys.maxsize,
            tags=None,
        )


def test_case_171_transition_from_rejected_to_rejected_via_create(
    store: Store,
) -> None:
    store.promises.create(
        id="id171",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.reject(id="id171", ikey=None, strict=False, headers=None, data=None)
    promise_record = store.promises.create(
        id="id171",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    assert promise_record.state == "REJECTED"
    assert promise_record.id == "id171"
    assert promise_record.ikey_for_create == "ikc"
    assert promise_record.ikey_for_complete is None


def test_case_172_transition_from_rejected_to_rejected_via_create(
    store: Store,
) -> None:
    store.promises.create(
        id="id172",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.reject(id="id172", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.create(
            id="id172",
            ikey="ikc*",
            strict=True,
            headers=None,
            data=None,
            timeout=sys.maxsize,
            tags=None,
        )


def test_case_173_transition_from_rejected_to_rejected_via_create(
    store: Store,
) -> None:
    store.promises.create(
        id="id173",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.reject(id="id173", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.create(
            id="id173",
            ikey="ikc*",
            strict=False,
            headers=None,
            data=None,
            timeout=sys.maxsize,
            tags=None,
        )


def test_case_174_transition_from_rejected_to_rejected_via_resolve(
    store: Store,
) -> None:
    store.promises.create(
        id="id174",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.reject(id="id174", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.resolve(id="id174", ikey=None, strict=True, headers=None, data=None)


def test_case_175_transition_from_rejected_to_rejected_via_resolve(
    store: Store,
) -> None:
    store.promises.create(
        id="id175",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.reject(id="id175", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.resolve(id="id175", ikey=None, strict=False, headers=None, data=None)


def test_case_176_transition_from_rejected_to_rejected_via_resolve(
    store: Store,
) -> None:
    store.promises.create(
        id="id176",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.reject(id="id176", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.resolve(id="id176", ikey="iku", strict=True, headers=None, data=None)


def test_case_177_transition_from_rejected_to_rejected_via_resolve(
    store: Store,
) -> None:
    store.promises.create(
        id="id177",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.reject(id="id177", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.resolve(id="id177", ikey="iku", strict=False, headers=None, data=None)


def test_case_178_transition_from_rejected_to_rejected_via_reject(
    store: Store,
) -> None:
    store.promises.create(
        id="id178",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.reject(id="id178", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.reject(id="id178", ikey=None, strict=True, headers=None, data=None)


def test_case_179_transition_from_rejected_to_rejected_via_reject(
    store: Store,
) -> None:
    store.promises.create(
        id="id179",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.reject(id="id179", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.reject(id="id179", ikey=None, strict=False, headers=None, data=None)


def test_case_180_transition_from_rejected_to_rejected_via_reject(
    store: Store,
) -> None:
    store.promises.create(
        id="id180",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.reject(id="id180", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.reject(id="id180", ikey="iku", strict=True, headers=None, data=None)


def test_case_181_transition_from_rejected_to_rejected_via_reject(
    store: Store,
) -> None:
    store.promises.create(
        id="id181",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.reject(id="id181", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.reject(id="id181", ikey="iku", strict=False, headers=None, data=None)


def test_case_182_transition_from_rejected_to_rejected_via_cancel(
    store: Store,
) -> None:
    store.promises.create(
        id="id182",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.reject(id="id182", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.cancel(id="id182", ikey=None, strict=True, headers=None, data=None)


def test_case_183_transition_from_rejected_to_rejected_via_cancel(
    store: Store,
) -> None:
    store.promises.create(
        id="id183",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.reject(id="id183", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.cancel(id="id183", ikey=None, strict=False, headers=None, data=None)


def test_case_184_transition_from_rejected_to_rejected_via_cancel(
    store: Store,
) -> None:
    store.promises.create(
        id="id184",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.reject(id="id184", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.cancel(id="id184", ikey="iku", strict=True, headers=None, data=None)


def test_case_185_transition_from_rejected_to_rejected_via_cancel(
    store: Store,
) -> None:
    store.promises.create(
        id="id185",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.reject(id="id185", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.cancel(id="id185", ikey="iku", strict=False, headers=None, data=None)


def test_case_186_transition_from_rejected_to_rejected_via_create(
    store: Store,
) -> None:
    store.promises.create(
        id="id186",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.reject(id="id186", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.create(
            id="id186",
            ikey=None,
            strict=True,
            headers=None,
            data=None,
            timeout=sys.maxsize,
            tags=None,
        )


def test_case_187_transition_from_rejected_to_rejected_via_create(
    store: Store,
) -> None:
    store.promises.create(
        id="id187",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.reject(id="id187", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.create(
            id="id187",
            ikey=None,
            strict=False,
            headers=None,
            data=None,
            timeout=sys.maxsize,
            tags=None,
        )


def test_case_188_transition_from_rejected_to_rejected_via_create(
    store: Store,
) -> None:
    store.promises.create(
        id="id188",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.reject(id="id188", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.create(
            id="id188",
            ikey="ikc",
            strict=True,
            headers=None,
            data=None,
            timeout=sys.maxsize,
            tags=None,
        )


def test_case_189_transition_from_rejected_to_rejected_via_create(
    store: Store,
) -> None:
    store.promises.create(
        id="id189",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.reject(id="id189", ikey="iku", strict=False, headers=None, data=None)
    promise_record = store.promises.create(
        id="id189",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    assert promise_record.state == "REJECTED"
    assert promise_record.id == "id189"
    assert promise_record.ikey_for_create == "ikc"
    assert promise_record.ikey_for_complete == "iku"


def test_case_190_transition_from_rejected_to_rejected_via_create(
    store: Store,
) -> None:
    store.promises.create(
        id="id190",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.reject(id="id190", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.create(
            id="id190",
            ikey="ikc*",
            strict=True,
            headers=None,
            data=None,
            timeout=sys.maxsize,
            tags=None,
        )


def test_case_191_transition_from_rejected_to_rejected_via_create(
    store: Store,
) -> None:
    store.promises.create(
        id="id191",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.reject(id="id191", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.create(
            id="id191",
            ikey="ikc*",
            strict=False,
            headers=None,
            data=None,
            timeout=sys.maxsize,
            tags=None,
        )


def test_case_192_transition_from_rejected_to_rejected_via_resolve(
    store: Store,
) -> None:
    store.promises.create(
        id="id192",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.reject(id="id192", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.resolve(id="id192", ikey=None, strict=True, headers=None, data=None)


def test_case_193_transition_from_rejected_to_rejected_via_resolve(
    store: Store,
) -> None:
    store.promises.create(
        id="id193",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.reject(id="id193", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.resolve(id="id193", ikey=None, strict=False, headers=None, data=None)


def test_case_194_transition_from_rejected_to_rejected_via_resolve(
    store: Store,
) -> None:
    store.promises.create(
        id="id194",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.reject(id="id194", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.resolve(id="id194", ikey="iku", strict=True, headers=None, data=None)


def test_case_195_transition_from_rejected_to_rejected_via_resolve(
    store: Store,
) -> None:
    store.promises.create(
        id="id195",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.reject(id="id195", ikey="iku", strict=False, headers=None, data=None)
    promise_record = store.promises.resolve(id="id195", ikey="iku", strict=False, headers=None, data=None)
    assert promise_record.state == "REJECTED"
    assert promise_record.id == "id195"
    assert promise_record.ikey_for_create == "ikc"
    assert promise_record.ikey_for_complete == "iku"


def test_case_196_transition_from_rejected_to_rejected_via_resolve(
    store: Store,
) -> None:
    store.promises.create(
        id="id196",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.reject(id="id196", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.resolve(id="id196", ikey="iku*", strict=True, headers=None, data=None)


def test_case_197_transition_from_rejected_to_rejected_via_resolve(
    store: Store,
) -> None:
    store.promises.create(
        id="id197",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.reject(id="id197", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.resolve(id="id197", ikey="iku*", strict=False, headers=None, data=None)


def test_case_198_transition_from_rejected_to_rejected_via_reject(
    store: Store,
) -> None:
    store.promises.create(
        id="id198",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.reject(id="id198", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.reject(id="id198", ikey=None, strict=True, headers=None, data=None)


def test_case_199_transition_from_rejected_to_rejected_via_reject(
    store: Store,
) -> None:
    store.promises.create(
        id="id199",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.reject(id="id199", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.reject(id="id199", ikey=None, strict=False, headers=None, data=None)


def test_case_200_transition_from_rejected_to_rejected_via_reject(
    store: Store,
) -> None:
    store.promises.create(
        id="id200",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.reject(id="id200", ikey="iku", strict=False, headers=None, data=None)
    promise_record = store.promises.reject(id="id200", ikey="iku", strict=True, headers=None, data=None)
    assert promise_record.state == "REJECTED"
    assert promise_record.id == "id200"
    assert promise_record.ikey_for_create == "ikc"
    assert promise_record.ikey_for_complete == "iku"


def test_case_201_transition_from_rejected_to_rejected_via_reject(
    store: Store,
) -> None:
    store.promises.create(
        id="id201",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.reject(id="id201", ikey="iku", strict=False, headers=None, data=None)
    promise_record = store.promises.reject(id="id201", ikey="iku", strict=False, headers=None, data=None)
    assert promise_record.state == "REJECTED"
    assert promise_record.id == "id201"
    assert promise_record.ikey_for_create == "ikc"
    assert promise_record.ikey_for_complete == "iku"


def test_case_202_transition_from_rejected_to_rejected_via_reject(
    store: Store,
) -> None:
    store.promises.create(
        id="id202",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.reject(id="id202", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.reject(id="id202", ikey="iku*", strict=True, headers=None, data=None)


def test_case_203_transition_from_rejected_to_rejected_via_reject(
    store: Store,
) -> None:
    store.promises.create(
        id="id203",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.reject(id="id203", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.reject(id="id203", ikey="iku*", strict=False, headers=None, data=None)


def test_case_204_transition_from_rejected_to_rejected_via_cancel(
    store: Store,
) -> None:
    store.promises.create(
        id="id204",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.reject(id="id204", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.cancel(id="id204", ikey=None, strict=True, headers=None, data=None)


def test_case_205_transition_from_rejected_to_rejected_via_cancel(
    store: Store,
) -> None:
    store.promises.create(
        id="id205",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.reject(id="id205", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.cancel(id="id205", ikey=None, strict=False, headers=None, data=None)


def test_case_206_transition_from_rejected_to_rejected_via_cancel(
    store: Store,
) -> None:
    store.promises.create(
        id="id206",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.reject(id="id206", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.cancel(id="id206", ikey="iku", strict=True, headers=None, data=None)


def test_case_207_transition_from_rejected_to_rejected_via_cancel(
    store: Store,
) -> None:
    store.promises.create(
        id="id207",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.reject(id="id207", ikey="iku", strict=False, headers=None, data=None)
    promise_record = store.promises.cancel(id="id207", ikey="iku", strict=False, headers=None, data=None)
    assert promise_record.state == "REJECTED"
    assert promise_record.id == "id207"
    assert promise_record.ikey_for_create == "ikc"
    assert promise_record.ikey_for_complete == "iku"


def test_case_208_transition_from_rejected_to_rejected_via_cancel(
    store: Store,
) -> None:
    store.promises.create(
        id="id208",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.reject(id="id208", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.cancel(id="id208", ikey="iku*", strict=True, headers=None, data=None)


def test_case_209_transition_from_rejected_to_rejected_via_cancel(
    store: Store,
) -> None:
    store.promises.create(
        id="id209",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.reject(id="id209", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.cancel(id="id209", ikey="iku*", strict=False, headers=None, data=None)


def test_case_210_transition_from_canceled_to_canceled_via_create(
    store: Store,
) -> None:
    store.promises.create(
        id="id210",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.cancel(id="id210", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.create(
            id="id210",
            ikey=None,
            strict=True,
            headers=None,
            data=None,
            timeout=sys.maxsize,
            tags=None,
        )


def test_case_211_transition_from_canceled_to_canceled_via_create(
    store: Store,
) -> None:
    store.promises.create(
        id="id211",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.cancel(id="id211", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.create(
            id="id211",
            ikey=None,
            strict=False,
            headers=None,
            data=None,
            timeout=sys.maxsize,
            tags=None,
        )


def test_case_212_transition_from_canceled_to_canceled_via_create(
    store: Store,
) -> None:
    store.promises.create(
        id="id212",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.cancel(id="id212", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.create(
            id="id212",
            ikey="ikc",
            strict=True,
            headers=None,
            data=None,
            timeout=sys.maxsize,
            tags=None,
        )


def test_case_213_transition_from_canceled_to_canceled_via_create(
    store: Store,
) -> None:
    store.promises.create(
        id="id213",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.cancel(id="id213", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.create(
            id="id213",
            ikey="ikc",
            strict=False,
            headers=None,
            data=None,
            timeout=sys.maxsize,
            tags=None,
        )


def test_case_214_transition_from_canceled_to_canceled_via_resolve(
    store: Store,
) -> None:
    store.promises.create(
        id="id214",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.cancel(id="id214", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.resolve(id="id214", ikey=None, strict=True, headers=None, data=None)


def test_case_215_transition_from_canceled_to_canceled_via_resolve(
    store: Store,
) -> None:
    store.promises.create(
        id="id215",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.cancel(id="id215", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.resolve(id="id215", ikey=None, strict=False, headers=None, data=None)


def test_case_216_transition_from_canceled_to_canceled_via_resolve(
    store: Store,
) -> None:
    store.promises.create(
        id="id216",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.cancel(id="id216", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.resolve(id="id216", ikey="iku", strict=True, headers=None, data=None)


def test_case_217_transition_from_canceled_to_canceled_via_resolve(
    store: Store,
) -> None:
    store.promises.create(
        id="id217",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.cancel(id="id217", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.resolve(id="id217", ikey="iku", strict=False, headers=None, data=None)


def test_case_218_transition_from_canceled_to_canceled_via_reject(
    store: Store,
) -> None:
    store.promises.create(
        id="id218",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.cancel(id="id218", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.reject(id="id218", ikey=None, strict=True, headers=None, data=None)


def test_case_219_transition_from_canceled_to_canceled_via_reject(
    store: Store,
) -> None:
    store.promises.create(
        id="id219",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.cancel(id="id219", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.reject(id="id219", ikey=None, strict=False, headers=None, data=None)


def test_case_220_transition_from_canceled_to_canceled_via_reject(
    store: Store,
) -> None:
    store.promises.create(
        id="id220",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.cancel(id="id220", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.reject(id="id220", ikey="iku", strict=True, headers=None, data=None)


def test_case_221_transition_from_canceled_to_canceled_via_reject(
    store: Store,
) -> None:
    store.promises.create(
        id="id221",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.cancel(id="id221", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.reject(id="id221", ikey="iku", strict=False, headers=None, data=None)


def test_case_222_transition_from_canceled_to_canceled_via_cancel(
    store: Store,
) -> None:
    store.promises.create(
        id="id222",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.cancel(id="id222", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.cancel(id="id222", ikey=None, strict=True, headers=None, data=None)


def test_case_223_transition_from_canceled_to_canceled_via_cancel(
    store: Store,
) -> None:
    store.promises.create(
        id="id223",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.cancel(id="id223", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.cancel(id="id223", ikey=None, strict=False, headers=None, data=None)


def test_case_224_transition_from_canceled_to_canceled_via_cancel(
    store: Store,
) -> None:
    store.promises.create(
        id="id224",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.cancel(id="id224", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.cancel(id="id224", ikey="iku", strict=True, headers=None, data=None)


def test_case_225_transition_from_canceled_to_canceled_via_cancel(
    store: Store,
) -> None:
    store.promises.create(
        id="id225",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.cancel(id="id225", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.cancel(id="id225", ikey="iku", strict=False, headers=None, data=None)


def test_case_226_transition_from_canceled_to_canceled_via_create(
    store: Store,
) -> None:
    store.promises.create(
        id="id226",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.cancel(id="id226", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.create(
            id="id226",
            ikey=None,
            strict=True,
            headers=None,
            data=None,
            timeout=sys.maxsize,
            tags=None,
        )


def test_case_227_transition_from_canceled_to_canceled_via_create(
    store: Store,
) -> None:
    store.promises.create(
        id="id227",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.cancel(id="id227", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.create(
            id="id227",
            ikey=None,
            strict=False,
            headers=None,
            data=None,
            timeout=sys.maxsize,
            tags=None,
        )


def test_case_228_transition_from_canceled_to_canceled_via_create(
    store: Store,
) -> None:
    store.promises.create(
        id="id228",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.cancel(id="id228", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.create(
            id="id228",
            ikey="ikc",
            strict=True,
            headers=None,
            data=None,
            timeout=sys.maxsize,
            tags=None,
        )


def test_case_229_transition_from_canceled_to_canceled_via_create(
    store: Store,
) -> None:
    store.promises.create(
        id="id229",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.cancel(id="id229", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.create(
            id="id229",
            ikey="ikc",
            strict=False,
            headers=None,
            data=None,
            timeout=sys.maxsize,
            tags=None,
        )


def test_case_230_transition_from_canceled_to_canceled_via_resolve(
    store: Store,
) -> None:
    store.promises.create(
        id="id230",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.cancel(id="id230", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.resolve(id="id230", ikey=None, strict=True, headers=None, data=None)


def test_case_231_transition_from_canceled_to_canceled_via_resolve(
    store: Store,
) -> None:
    store.promises.create(
        id="id231",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.cancel(id="id231", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.resolve(id="id231", ikey=None, strict=False, headers=None, data=None)


def test_case_232_transition_from_canceled_to_canceled_via_resolve(
    store: Store,
) -> None:
    store.promises.create(
        id="id232",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.cancel(id="id232", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.resolve(id="id232", ikey="iku", strict=True, headers=None, data=None)


def test_case_233_transition_from_canceled_to_canceled_via_resolve(
    store: Store,
) -> None:
    store.promises.create(
        id="id233",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.cancel(id="id233", ikey="iku", strict=False, headers=None, data=None)
    promise_record = store.promises.resolve(id="id233", ikey="iku", strict=False, headers=None, data=None)
    assert promise_record.state == "REJECTED_CANCELED"
    assert promise_record.id == "id233"
    assert promise_record.ikey_for_create is None
    assert promise_record.ikey_for_complete == "iku"


def test_case_234_transition_from_canceled_to_canceled_via_resolve(
    store: Store,
) -> None:
    store.promises.create(
        id="id234",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.cancel(id="id234", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.resolve(id="id234", ikey="iku*", strict=True, headers=None, data=None)


def test_case_235_transition_from_canceled_to_canceled_via_resolve(
    store: Store,
) -> None:
    store.promises.create(
        id="id235",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.cancel(id="id235", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.resolve(id="id235", ikey="iku*", strict=False, headers=None, data=None)


def test_case_236_transition_from_canceled_to_canceled_via_reject(
    store: Store,
) -> None:
    store.promises.create(
        id="id236",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.cancel(id="id236", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.reject(id="id236", ikey=None, strict=True, headers=None, data=None)


def test_case_237_transition_from_canceled_to_canceled_via_reject(
    store: Store,
) -> None:
    store.promises.create(
        id="id237",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.cancel(id="id237", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.reject(id="id237", ikey=None, strict=False, headers=None, data=None)


def test_case_238_transition_from_canceled_to_canceled_via_reject(
    store: Store,
) -> None:
    store.promises.create(
        id="id238",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.cancel(id="id238", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.reject(id="id238", ikey="iku", strict=True, headers=None, data=None)


def test_case_239_transition_from_canceled_to_canceled_via_reject(
    store: Store,
) -> None:
    store.promises.create(
        id="id239",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.cancel(id="id239", ikey="iku", strict=False, headers=None, data=None)
    promise_record = store.promises.reject(id="id239", ikey="iku", strict=False, headers=None, data=None)
    assert promise_record.state == "REJECTED_CANCELED"
    assert promise_record.id == "id239"
    assert promise_record.ikey_for_create is None
    assert promise_record.ikey_for_complete == "iku"


def test_case_240_transition_from_canceled_to_canceled_via_reject(
    store: Store,
) -> None:
    store.promises.create(
        id="id240",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.cancel(id="id240", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.reject(id="id240", ikey="iku*", strict=True, headers=None, data=None)


def test_case_241_transition_from_canceled_to_canceled_via_reject(
    store: Store,
) -> None:
    store.promises.create(
        id="id241",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.cancel(id="id241", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.reject(id="id241", ikey="iku*", strict=False, headers=None, data=None)


def test_case_242_transition_from_canceled_to_canceled_via_cancel(
    store: Store,
) -> None:
    store.promises.create(
        id="id242",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.cancel(id="id242", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.cancel(id="id242", ikey=None, strict=True, headers=None, data=None)


def test_case_243_transition_from_canceled_to_canceled_via_cancel(
    store: Store,
) -> None:
    store.promises.create(
        id="id243",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.cancel(id="id243", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.cancel(id="id243", ikey=None, strict=False, headers=None, data=None)


def test_case_244_transition_from_canceled_to_canceled_via_cancel(
    store: Store,
) -> None:
    store.promises.create(
        id="id244",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.cancel(id="id244", ikey="iku", strict=False, headers=None, data=None)
    promise_record = store.promises.cancel(id="id244", ikey="iku", strict=True, headers=None, data=None)
    assert promise_record.state == "REJECTED_CANCELED"
    assert promise_record.id == "id244"
    assert promise_record.ikey_for_create is None
    assert promise_record.ikey_for_complete == "iku"


def test_case_245_transition_from_canceled_to_canceled_via_cancel(
    store: Store,
) -> None:
    store.promises.create(
        id="id245",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.cancel(id="id245", ikey="iku", strict=False, headers=None, data=None)
    promise_record = store.promises.cancel(id="id245", ikey="iku", strict=False, headers=None, data=None)
    assert promise_record.state == "REJECTED_CANCELED"
    assert promise_record.id == "id245"
    assert promise_record.ikey_for_create is None
    assert promise_record.ikey_for_complete == "iku"


def test_case_246_transition_from_canceled_to_canceled_via_cancel(
    store: Store,
) -> None:
    store.promises.create(
        id="id246",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.cancel(id="id246", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.cancel(id="id246", ikey="iku*", strict=True, headers=None, data=None)


def test_case_247_transition_from_canceled_to_canceled_via_cancel(
    store: Store,
) -> None:
    store.promises.create(
        id="id247",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.cancel(id="id247", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.cancel(id="id247", ikey="iku*", strict=False, headers=None, data=None)


def test_case_248_transition_from_canceled_to_canceled_via_create(
    store: Store,
) -> None:
    store.promises.create(
        id="id248",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.cancel(id="id248", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.create(
            id="id248",
            ikey=None,
            strict=True,
            headers=None,
            data=None,
            timeout=sys.maxsize,
            tags=None,
        )


def test_case_249_transition_from_canceled_to_canceled_via_create(
    store: Store,
) -> None:
    store.promises.create(
        id="id249",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.cancel(id="id249", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.create(
            id="id249",
            ikey=None,
            strict=False,
            headers=None,
            data=None,
            timeout=sys.maxsize,
            tags=None,
        )


def test_case_250_transition_from_canceled_to_canceled_via_create(
    store: Store,
) -> None:
    store.promises.create(
        id="id250",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.cancel(id="id250", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.create(
            id="id250",
            ikey="ikc",
            strict=True,
            headers=None,
            data=None,
            timeout=sys.maxsize,
            tags=None,
        )


def test_case_251_transition_from_canceled_to_canceled_via_create(
    store: Store,
) -> None:
    store.promises.create(
        id="id251",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.cancel(id="id251", ikey=None, strict=False, headers=None, data=None)
    promise_record = store.promises.create(
        id="id251",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    assert promise_record.state == "REJECTED_CANCELED"
    assert promise_record.id == "id251"
    assert promise_record.ikey_for_create == "ikc"
    assert promise_record.ikey_for_complete is None


def test_case_252_transition_from_canceled_to_canceled_via_create(
    store: Store,
) -> None:
    store.promises.create(
        id="id252",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.cancel(id="id252", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.create(
            id="id252",
            ikey="ikc*",
            strict=True,
            headers=None,
            data=None,
            timeout=sys.maxsize,
            tags=None,
        )


def test_case_253_transition_from_canceled_to_canceled_via_create(
    store: Store,
) -> None:
    store.promises.create(
        id="id253",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.cancel(id="id253", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.create(
            id="id253",
            ikey="ikc*",
            strict=False,
            headers=None,
            data=None,
            timeout=sys.maxsize,
            tags=None,
        )


def test_case_254_transition_from_canceled_to_canceled_via_resolve(
    store: Store,
) -> None:
    store.promises.create(
        id="id254",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.cancel(id="id254", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.resolve(id="id254", ikey=None, strict=True, headers=None, data=None)


def test_case_255_transition_from_canceled_to_canceled_via_resolve(
    store: Store,
) -> None:
    store.promises.create(
        id="id255",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.cancel(id="id255", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.resolve(id="id255", ikey=None, strict=False, headers=None, data=None)


def test_case_256_transition_from_canceled_to_canceled_via_resolve(
    store: Store,
) -> None:
    store.promises.create(
        id="id256",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.cancel(id="id256", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.resolve(id="id256", ikey="iku", strict=True, headers=None, data=None)


def test_case_257_transition_from_canceled_to_canceled_via_resolve(
    store: Store,
) -> None:
    store.promises.create(
        id="id257",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.cancel(id="id257", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.resolve(id="id257", ikey="iku", strict=False, headers=None, data=None)


def test_case_258_transition_from_canceled_to_canceled_via_reject(
    store: Store,
) -> None:
    store.promises.create(
        id="id258",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.cancel(id="id258", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.reject(id="id258", ikey=None, strict=True, headers=None, data=None)


def test_case_259_transition_from_canceled_to_canceled_via_reject(
    store: Store,
) -> None:
    store.promises.create(
        id="id259",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.cancel(id="id259", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.reject(id="id259", ikey=None, strict=False, headers=None, data=None)


def test_case_260_transition_from_canceled_to_canceled_via_reject(
    store: Store,
) -> None:
    store.promises.create(
        id="id260",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.cancel(id="id260", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.reject(id="id260", ikey="iku", strict=True, headers=None, data=None)


def test_case_261_transition_from_canceled_to_canceled_via_reject(
    store: Store,
) -> None:
    store.promises.create(
        id="id261",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.cancel(id="id261", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.reject(id="id261", ikey="iku", strict=False, headers=None, data=None)


def test_case_262_transition_from_canceled_to_canceled_via_cancel(
    store: Store,
) -> None:
    store.promises.create(
        id="id262",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.cancel(id="id262", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.cancel(id="id262", ikey=None, strict=True, headers=None, data=None)


def test_case_263_transition_from_canceled_to_canceled_via_cancel(
    store: Store,
) -> None:
    store.promises.create(
        id="id263",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.cancel(id="id263", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.cancel(id="id263", ikey=None, strict=False, headers=None, data=None)


def test_case_264_transition_from_canceled_to_canceled_via_cancel(
    store: Store,
) -> None:
    store.promises.create(
        id="id264",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.cancel(id="id264", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.cancel(id="id264", ikey="iku", strict=True, headers=None, data=None)


def test_case_265_transition_from_canceled_to_canceled_via_cancel(
    store: Store,
) -> None:
    store.promises.create(
        id="id265",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.cancel(id="id265", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.cancel(id="id265", ikey="iku", strict=False, headers=None, data=None)


def test_case_266_transition_from_canceled_to_canceled_via_create(
    store: Store,
) -> None:
    store.promises.create(
        id="id266",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.cancel(id="id266", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.create(
            id="id266",
            ikey=None,
            strict=True,
            headers=None,
            data=None,
            timeout=sys.maxsize,
            tags=None,
        )


def test_case_267_transition_from_canceled_to_canceled_via_create(
    store: Store,
) -> None:
    store.promises.create(
        id="id267",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.cancel(id="id267", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.create(
            id="id267",
            ikey=None,
            strict=False,
            headers=None,
            data=None,
            timeout=sys.maxsize,
            tags=None,
        )


def test_case_268_transition_from_canceled_to_canceled_via_create(
    store: Store,
) -> None:
    store.promises.create(
        id="id268",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.cancel(id="id268", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.create(
            id="id268",
            ikey="ikc",
            strict=True,
            headers=None,
            data=None,
            timeout=sys.maxsize,
            tags=None,
        )


def test_case_269_transition_from_canceled_to_canceled_via_create(
    store: Store,
) -> None:
    store.promises.create(
        id="id269",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.cancel(id="id269", ikey="iku", strict=False, headers=None, data=None)
    promise_record = store.promises.create(
        id="id269",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    assert promise_record.state == "REJECTED_CANCELED"
    assert promise_record.id == "id269"
    assert promise_record.ikey_for_create == "ikc"
    assert promise_record.ikey_for_complete == "iku"


def test_case_270_transition_from_canceled_to_canceled_via_create(
    store: Store,
) -> None:
    store.promises.create(
        id="id270",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.cancel(id="id270", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.create(
            id="id270",
            ikey="ikc*",
            strict=True,
            headers=None,
            data=None,
            timeout=sys.maxsize,
            tags=None,
        )


def test_case_271_transition_from_canceled_to_canceled_via_create(
    store: Store,
) -> None:
    store.promises.create(
        id="id271",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.cancel(id="id271", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.create(
            id="id271",
            ikey="ikc*",
            strict=False,
            headers=None,
            data=None,
            timeout=sys.maxsize,
            tags=None,
        )


def test_case_272_transition_from_canceled_to_canceled_via_resolve(
    store: Store,
) -> None:
    store.promises.create(
        id="id272",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.cancel(id="id272", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.resolve(id="id272", ikey=None, strict=True, headers=None, data=None)


def test_case_273_transition_from_canceled_to_canceled_via_resolve(
    store: Store,
) -> None:
    store.promises.create(
        id="id273",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.cancel(id="id273", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.resolve(id="id273", ikey=None, strict=False, headers=None, data=None)


def test_case_274_transition_from_canceled_to_canceled_via_resolve(
    store: Store,
) -> None:
    store.promises.create(
        id="id274",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.cancel(id="id274", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.resolve(id="id274", ikey="iku", strict=True, headers=None, data=None)


def test_case_275_transition_from_canceled_to_canceled_via_resolve(
    store: Store,
) -> None:
    store.promises.create(
        id="id275",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.cancel(id="id275", ikey="iku", strict=False, headers=None, data=None)
    promise_record = store.promises.resolve(id="id275", ikey="iku", strict=False, headers=None, data=None)
    assert promise_record.state == "REJECTED_CANCELED"
    assert promise_record.id == "id275"
    assert promise_record.ikey_for_create == "ikc"
    assert promise_record.ikey_for_complete == "iku"


def test_case_276_transition_from_canceled_to_canceled_via_resolve(
    store: Store,
) -> None:
    store.promises.create(
        id="id276",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.cancel(id="id276", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.resolve(id="id276", ikey="iku*", strict=True, headers=None, data=None)


def test_case_277_transition_from_canceled_to_canceled_via_resolve(
    store: Store,
) -> None:
    store.promises.create(
        id="id277",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.cancel(id="id277", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.resolve(id="id277", ikey="iku*", strict=False, headers=None, data=None)


def test_case_278_transition_from_canceled_to_canceled_via_reject(
    store: Store,
) -> None:
    store.promises.create(
        id="id278",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.cancel(id="id278", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.reject(id="id278", ikey=None, strict=True, headers=None, data=None)


def test_case_279_transition_from_canceled_to_canceled_via_reject(
    store: Store,
) -> None:
    store.promises.create(
        id="id279",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.cancel(id="id279", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.reject(id="id279", ikey=None, strict=False, headers=None, data=None)


def test_case_280_transition_from_canceled_to_canceled_via_reject(
    store: Store,
) -> None:
    store.promises.create(
        id="id280",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.cancel(id="id280", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.reject(id="id280", ikey="iku", strict=True, headers=None, data=None)


def test_case_281_transition_from_canceled_to_canceled_via_reject(
    store: Store,
) -> None:
    store.promises.create(
        id="id281",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.cancel(id="id281", ikey="iku", strict=False, headers=None, data=None)
    promise_record = store.promises.reject(id="id281", ikey="iku", strict=False, headers=None, data=None)
    assert promise_record.state == "REJECTED_CANCELED"
    assert promise_record.id == "id281"
    assert promise_record.ikey_for_create == "ikc"
    assert promise_record.ikey_for_complete == "iku"


def test_case_282_transition_from_canceled_to_canceled_via_reject(
    store: Store,
) -> None:
    store.promises.create(
        id="id282",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.cancel(id="id282", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.reject(id="id282", ikey="iku*", strict=True, headers=None, data=None)


def test_case_283_transition_from_canceled_to_canceled_via_reject(
    store: Store,
) -> None:
    store.promises.create(
        id="id283",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.cancel(id="id283", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.reject(id="id283", ikey="iku*", strict=False, headers=None, data=None)


def test_case_284_transition_from_canceled_to_canceled_via_cancel(
    store: Store,
) -> None:
    store.promises.create(
        id="id284",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.cancel(id="id284", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.cancel(id="id284", ikey=None, strict=True, headers=None, data=None)


def test_case_285_transition_from_canceled_to_canceled_via_cancel(
    store: Store,
) -> None:
    store.promises.create(
        id="id285",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.cancel(id="id285", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.cancel(id="id285", ikey=None, strict=False, headers=None, data=None)


def test_case_286_transition_from_canceled_to_canceled_via_cancel(
    store: Store,
) -> None:
    store.promises.create(
        id="id286",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.cancel(id="id286", ikey="iku", strict=False, headers=None, data=None)
    promise_record = store.promises.cancel(id="id286", ikey="iku", strict=True, headers=None, data=None)
    assert promise_record.state == "REJECTED_CANCELED"
    assert promise_record.id == "id286"
    assert promise_record.ikey_for_create == "ikc"
    assert promise_record.ikey_for_complete == "iku"


def test_case_287_transition_from_canceled_to_canceled_via_cancel(
    store: Store,
) -> None:
    store.promises.create(
        id="id287",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.cancel(id="id287", ikey="iku", strict=False, headers=None, data=None)
    promise_record = store.promises.cancel(id="id287", ikey="iku", strict=False, headers=None, data=None)
    assert promise_record.state == "REJECTED_CANCELED"
    assert promise_record.id == "id287"
    assert promise_record.ikey_for_create == "ikc"
    assert promise_record.ikey_for_complete == "iku"


def test_case_288_transition_from_canceled_to_canceled_via_cancel(
    store: Store,
) -> None:
    store.promises.create(
        id="id288",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.cancel(id="id288", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.cancel(id="id288", ikey="iku*", strict=True, headers=None, data=None)


def test_case_289_transition_from_canceled_to_canceled_via_cancel(
    store: Store,
) -> None:
    store.promises.create(
        id="id289",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.promises.cancel(id="id289", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(ResonateStoreError):
        store.promises.cancel(id="id289", ikey="iku*", strict=False, headers=None, data=None)


def test_case_290_transition_from_timedout_to_timedout_via_create(
    store: Store,
) -> None:
    store.promises.create(
        id="id290",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=0,
        tags=None,
    )
    with pytest.raises(ResonateStoreError):
        store.promises.create(
            id="id290",
            ikey=None,
            strict=True,
            headers=None,
            data=None,
            timeout=0,
            tags=None,
        )


def test_case_291_transition_from_timedout_to_timedout_via_create(
    store: Store,
) -> None:
    store.promises.create(
        id="id291",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=0,
        tags=None,
    )
    with pytest.raises(ResonateStoreError):
        store.promises.create(
            id="id291",
            ikey=None,
            strict=False,
            headers=None,
            data=None,
            timeout=0,
            tags=None,
        )


def test_case_292_transition_from_timedout_to_timedout_via_create(
    store: Store,
) -> None:
    store.promises.create(
        id="id292",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=0,
        tags=None,
    )
    with pytest.raises(ResonateStoreError):
        store.promises.create(
            id="id292",
            ikey="ikc",
            strict=True,
            headers=None,
            data=None,
            timeout=0,
            tags=None,
        )


def test_case_293_transition_from_timedout_to_timedout_via_create(
    store: Store,
) -> None:
    store.promises.create(
        id="id293",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=0,
        tags=None,
    )
    with pytest.raises(ResonateStoreError):
        store.promises.create(
            id="id293",
            ikey="ikc",
            strict=False,
            headers=None,
            data=None,
            timeout=0,
            tags=None,
        )


def test_case_294_transition_from_timedout_to_timedout_via_resolve(
    store: Store,
) -> None:
    store.promises.create(
        id="id294",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=0,
        tags=None,
    )
    with pytest.raises(ResonateStoreError):
        store.promises.resolve(id="id294", ikey=None, strict=True, headers=None, data=None)


def test_case_295_transition_from_timedout_to_timedout_via_resolve(
    store: Store,
) -> None:
    store.promises.create(
        id="id295",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=0,
        tags=None,
    )
    promise_record = store.promises.resolve(id="id295", ikey=None, strict=False, headers=None, data=None)
    assert promise_record.state == "REJECTED_TIMEDOUT"
    assert promise_record.id == "id295"
    assert promise_record.ikey_for_create is None
    assert promise_record.ikey_for_complete is None


def test_case_296_transition_from_timedout_to_timedout_via_resolve(
    store: Store,
) -> None:
    store.promises.create(
        id="id296",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=0,
        tags=None,
    )
    with pytest.raises(ResonateStoreError):
        store.promises.resolve(id="id296", ikey="iku", strict=True, headers=None, data=None)


def test_case_297_transition_from_timedout_to_timedout_via_resolve(
    store: Store,
) -> None:
    store.promises.create(
        id="id297",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=0,
        tags=None,
    )
    promise_record = store.promises.resolve(id="id297", ikey="iku", strict=False, headers=None, data=None)
    assert promise_record.state == "REJECTED_TIMEDOUT"
    assert promise_record.id == "id297"
    assert promise_record.ikey_for_create is None
    assert promise_record.ikey_for_complete is None


def test_case_298_transition_from_timedout_to_timedout_via_reject(
    store: Store,
) -> None:
    store.promises.create(
        id="id298",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=0,
        tags=None,
    )
    with pytest.raises(ResonateStoreError):
        store.promises.reject(id="id298", ikey=None, strict=True, headers=None, data=None)


def test_case_299_transition_from_timedout_to_timedout_via_reject(
    store: Store,
) -> None:
    store.promises.create(
        id="id299",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=0,
        tags=None,
    )
    promise_record = store.promises.reject(id="id299", ikey=None, strict=False, headers=None, data=None)
    assert promise_record.state == "REJECTED_TIMEDOUT"
    assert promise_record.id == "id299"
    assert promise_record.ikey_for_create is None
    assert promise_record.ikey_for_complete is None


def test_case_300_transition_from_timedout_to_timedout_via_reject(
    store: Store,
) -> None:
    store.promises.create(
        id="id300",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=0,
        tags=None,
    )
    with pytest.raises(ResonateStoreError):
        store.promises.reject(id="id300", ikey="iku", strict=True, headers=None, data=None)


def test_case_301_transition_from_timedout_to_timedout_via_reject(
    store: Store,
) -> None:
    store.promises.create(
        id="id301",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=0,
        tags=None,
    )
    promise_record = store.promises.reject(id="id301", ikey="iku", strict=False, headers=None, data=None)
    assert promise_record.state == "REJECTED_TIMEDOUT"
    assert promise_record.id == "id301"
    assert promise_record.ikey_for_create is None
    assert promise_record.ikey_for_complete is None


def test_case_302_transition_from_timedout_to_timedout_via_cancel(
    store: Store,
) -> None:
    store.promises.create(
        id="id302",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=0,
        tags=None,
    )
    with pytest.raises(ResonateStoreError):
        store.promises.cancel(id="id302", ikey=None, strict=True, headers=None, data=None)


def test_case_303_transition_from_timedout_to_timedout_via_cancel(
    store: Store,
) -> None:
    store.promises.create(
        id="id303",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=0,
        tags=None,
    )
    promise_record = store.promises.cancel(id="id303", ikey=None, strict=False, headers=None, data=None)
    assert promise_record.state == "REJECTED_TIMEDOUT"
    assert promise_record.id == "id303"
    assert promise_record.ikey_for_create is None
    assert promise_record.ikey_for_complete is None


def test_case_304_transition_from_timedout_to_timedout_via_cancel(
    store: Store,
) -> None:
    store.promises.create(
        id="id304",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=0,
        tags=None,
    )
    with pytest.raises(ResonateStoreError):
        store.promises.cancel(id="id304", ikey="iku", strict=True, headers=None, data=None)


def test_case_305_transition_from_timedout_to_timedout_via_cancel(
    store: Store,
) -> None:
    store.promises.create(
        id="id305",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=0,
        tags=None,
    )
    promise_record = store.promises.cancel(id="id305", ikey="iku", strict=False, headers=None, data=None)
    assert promise_record.state == "REJECTED_TIMEDOUT"
    assert promise_record.id == "id305"
    assert promise_record.ikey_for_create is None
    assert promise_record.ikey_for_complete is None


def test_case_306_transition_from_timedout_to_timedout_via_create(
    store: Store,
) -> None:
    store.promises.create(
        id="id306",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=0,
        tags=None,
    )
    with pytest.raises(ResonateStoreError):
        store.promises.create(
            id="id306",
            ikey=None,
            strict=True,
            headers=None,
            data=None,
            timeout=0,
            tags=None,
        )


def test_case_307_transition_from_timedout_to_timedout_via_create(
    store: Store,
) -> None:
    store.promises.create(
        id="id307",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=0,
        tags=None,
    )
    with pytest.raises(ResonateStoreError):
        store.promises.create(
            id="id307",
            ikey=None,
            strict=False,
            headers=None,
            data=None,
            timeout=0,
            tags=None,
        )


def test_case_308_transition_from_timedout_to_timedout_via_create(
    store: Store,
) -> None:
    store.promises.create(
        id="id308",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=0,
        tags=None,
    )
    with pytest.raises(ResonateStoreError):
        store.promises.create(
            id="id308",
            ikey="ikc",
            strict=True,
            headers=None,
            data=None,
            timeout=0,
            tags=None,
        )


def test_case_309_transition_from_timedout_to_timedout_via_create(
    store: Store,
) -> None:
    store.promises.create(
        id="id309",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=0,
        tags=None,
    )
    promise_record = store.promises.create(
        id="id309",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=0,
        tags=None,
    )
    assert promise_record.state == "REJECTED_TIMEDOUT"
    assert promise_record.id == "id309"
    assert promise_record.ikey_for_create == "ikc"
    assert promise_record.ikey_for_complete is None


def test_case_310_transition_from_timedout_to_timedout_via_create(
    store: Store,
) -> None:
    store.promises.create(
        id="id310",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=0,
        tags=None,
    )
    with pytest.raises(ResonateStoreError):
        store.promises.create(
            id="id310",
            ikey="ikc*",
            strict=True,
            headers=None,
            data=None,
            timeout=0,
            tags=None,
        )


def test_case_311_transition_from_timedout_to_timedout_via_create(
    store: Store,
) -> None:
    store.promises.create(
        id="id311",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=0,
        tags=None,
    )
    with pytest.raises(ResonateStoreError):
        store.promises.create(
            id="id311",
            ikey="ikc*",
            strict=False,
            headers=None,
            data=None,
            timeout=0,
            tags=None,
        )


def test_case_312_transition_from_timedout_to_timedout_via_resolve(
    store: Store,
) -> None:
    store.promises.create(
        id="id312",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=0,
        tags=None,
    )
    with pytest.raises(ResonateStoreError):
        store.promises.resolve(id="id312", ikey=None, strict=True, headers=None, data=None)


def test_case_313_transition_from_timedout_to_timedout_via_resolve(
    store: Store,
) -> None:
    store.promises.create(
        id="id313",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=0,
        tags=None,
    )
    promise_record = store.promises.resolve(id="id313", ikey=None, strict=False, headers=None, data=None)
    assert promise_record.state == "REJECTED_TIMEDOUT"
    assert promise_record.id == "id313"
    assert promise_record.ikey_for_create == "ikc"
    assert promise_record.ikey_for_complete is None


def test_case_314_transition_from_timedout_to_timedout_via_resolve(
    store: Store,
) -> None:
    store.promises.create(
        id="id314",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=0,
        tags=None,
    )
    with pytest.raises(ResonateStoreError):
        store.promises.resolve(id="id314", ikey="iku", strict=True, headers=None, data=None)


def test_case_315_transition_from_timedout_to_timedout_via_resolve(
    store: Store,
) -> None:
    store.promises.create(
        id="id315",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=0,
        tags=None,
    )
    promise_record = store.promises.resolve(id="id315", ikey="iku", strict=False, headers=None, data=None)
    assert promise_record.state == "REJECTED_TIMEDOUT"
    assert promise_record.id == "id315"
    assert promise_record.ikey_for_create == "ikc"
    assert promise_record.ikey_for_complete is None


def test_case_316_transition_from_timedout_to_timedout_via_reject(
    store: Store,
) -> None:
    store.promises.create(
        id="id316",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=0,
        tags=None,
    )
    with pytest.raises(ResonateStoreError):
        store.promises.reject(id="id316", ikey=None, strict=True, headers=None, data=None)


def test_case_317_transition_from_timedout_to_timedout_via_reject(
    store: Store,
) -> None:
    store.promises.create(
        id="id317",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=0,
        tags=None,
    )
    promise_record = store.promises.reject(id="id317", ikey=None, strict=False, headers=None, data=None)
    assert promise_record.state == "REJECTED_TIMEDOUT"
    assert promise_record.id == "id317"
    assert promise_record.ikey_for_create == "ikc"
    assert promise_record.ikey_for_complete is None


def test_case_318_transition_from_timedout_to_timedout_via_reject(
    store: Store,
) -> None:
    store.promises.create(
        id="id318",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=0,
        tags=None,
    )
    with pytest.raises(ResonateStoreError):
        store.promises.reject(id="id318", ikey="iku", strict=True, headers=None, data=None)


def test_case_319_transition_from_timedout_to_timedout_via_reject(
    store: Store,
) -> None:
    store.promises.create(
        id="id319",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=0,
        tags=None,
    )
    promise_record = store.promises.reject(id="id319", ikey="iku", strict=False, headers=None, data=None)
    assert promise_record.state == "REJECTED_TIMEDOUT"
    assert promise_record.id == "id319"
    assert promise_record.ikey_for_create == "ikc"
    assert promise_record.ikey_for_complete is None


def test_case_320_transition_from_timedout_to_timedout_via_cancel(
    store: Store,
) -> None:
    store.promises.create(
        id="id320",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=0,
        tags=None,
    )
    with pytest.raises(ResonateStoreError):
        store.promises.cancel(id="id320", ikey=None, strict=True, headers=None, data=None)


def test_case_321_transition_from_timedout_to_timedout_via_cancel(
    store: Store,
) -> None:
    store.promises.create(
        id="id321",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=0,
        tags=None,
    )
    promise_record = store.promises.cancel(id="id321", ikey=None, strict=False, headers=None, data=None)
    assert promise_record.state == "REJECTED_TIMEDOUT"
    assert promise_record.id == "id321"
    assert promise_record.ikey_for_create == "ikc"
    assert promise_record.ikey_for_complete is None


def test_case_322_transition_from_timedout_to_timedout_via_cancel(
    store: Store,
) -> None:
    store.promises.create(
        id="id322",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=0,
        tags=None,
    )
    with pytest.raises(ResonateStoreError):
        store.promises.cancel(id="id322", ikey="iku", strict=True, headers=None, data=None)


def test_case_323_transition_from_timedout_to_timedout_via_cancel(
    store: Store,
) -> None:
    store.promises.create(
        id="id323",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=0,
        tags=None,
    )
    promise_record = store.promises.cancel(id="id323", ikey="iku", strict=False, headers=None, data=None)
    assert promise_record.state == "REJECTED_TIMEDOUT"
    assert promise_record.id == "id323"
    assert promise_record.ikey_for_create == "ikc"
    assert promise_record.ikey_for_complete is None
