from __future__ import annotations

from typing import TYPE_CHECKING, Protocol, runtime_checkable

if TYPE_CHECKING:
    from resonate.models.message import Mesg


@runtime_checkable
class MessageSource(Protocol):
    @property
    def unicast(self) -> str: ...
    @property
    def anycast(self) -> str: ...

    def start(self) -> None: ...
    def stop(self) -> None: ...
    def next(self) -> Mesg | None: ...
    def enqueue(self, mesg: Mesg) -> None: ...
