<p align="center">
   <img height="170"src="https://raw.githubusercontent.com/resonatehq/resonate/main/docs/img/echo.png">
</p>

<h1 align="center">Resonate Python SDK</h1>

<div align="center">

[![ci](https://github.com/resonatehq/resonate-sdk-py/actions/workflows/ci.yml/badge.svg)](https://github.com/resonatehq/resonate-sdk-py/actions/workflows/ci.yml)
[![codecov](https://codecov.io/gh/resonatehq/resonate-sdk-py/graph/badge.svg?token=61GYC3DXID)](https://codecov.io/gh/resonatehq/resonate-sdk-py)
[![dst](https://github.com/resonatehq/resonate-sdk-py/actions/workflows/dst.yml/badge.svg)](https://github.com/resonatehq/resonate-sdk-py/actions/workflows/dst.yml)
[![License](https://img.shields.io/badge/License-Apache_2.0-blue.svg)](https://opensource.org/licenses/Apache-2.0)

</div>

## About this component

The Resonate Python SDK enables you to build reliable and scalable applications when paired with at least one [Resonate Server](https://github.com/resonatehq/resonate).

- [Contribute to the Resonate Python SDK](./CONTRIBUTING.md)
- [License](./LICENSE)

## Directory

- [Get started with Resonate](https://docs.resonatehq.io/get-started)
  - [Try an example application](https://github.com/resonatehq-examples)
- [Join the community](https://resonatehq.io/discord)
  - [Subscribe to Resonate HQ](https://journal.resonatehq.io/subscribe)
  - [Follow on Twitter / X](https://twitter.com/resonatehqio)
  - [Follow on LinkedIn](https://www.linkedin.com/company/resonatehqio)
  - [Subscribe on YouTube](https://www.youtube.com/@resonatehqio)

## Distributed Async Await

Resonate implements the Distributed Async Await specification — [Learn more](https://www.distributed-async-await.io/)

## Why Resonate

Because developing distributed applications should be a delightful experience — [Learn more](https://docs.resonatehq.io/evaluate/why-resonate)

## Available SDKs

Add reliablity and scalability to the language you love.

|                                                      Language                                                       | Source Code                                   | Package                                              | Developer docs                                        |
| :-----------------------------------------------------------------------------------------------------------------: | --------------------------------------------- | ---------------------------------------------------- | ----------------------------------------------------- |
|  <img alt="py sdk" src="https://upload.wikimedia.org/wikipedia/commons/c/c3/Python-logo-notext.svg" width="40px"/>  | https://github.com/resonatehq/resonate-sdk-py | [pypi](https://pypi.org/project/resonate-sdk/)       | [docs](https://docs.resonatehq.io/develop/python)     |
| <img alt="ts sdk" src="https://upload.wikimedia.org/wikipedia/commons/4/4c/Typescript_logo_2020.svg" width="40px"/> | https://github.com/resonatehq/resonate-sdk-ts | [npm](https://www.npmjs.com/package/@resonatehq/sdk) | [docs](https://docs.resonatehq.io/develop/typescript) |
