#
# MIT License
#
# Copyright (c) 2023 nbiotcloud
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in all
# copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# SOFTWARE.
#
"""Data Model."""


class Datamodel:
    # pylint: disable=too-few-public-methods

    """
    Datamodel.

    A simple container for all data attributes.
    Add attributes on your needs. That's it.

    >>> Datamodel()
    Datamodel()
    >>> Datamodel(abc='def', item=4)
    Datamodel(abc='def', item=4)
    >>> datamodel = Datamodel(abc='def')
    >>> datamodel
    Datamodel(abc='def')
    >>> datamodel.item=4
    >>> datamodel
    Datamodel(abc='def', item=4)
    """

    def __init__(self, **kwargs):
        """Datamodel."""
        self.__dict__.update(kwargs)

    def __repr__(self):
        kwargs = ", ".join(f"{key}={value!r}" for key, value in self.__dict__.items())
        return f"{self.__class__.__name__}({kwargs})"

    def __eq__(self, other):
        if self.__class__ == other.__class__:
            return self.__dict__ == other.__dict__
        return NotImplemented
