"""Module to hold lengthy sets/dictionaries used to check user inputs in tidyhome.py"""

states = {
    "AL",
    "AK",
    "AZ",
    "AR",
    "CA",
    "CO",
    "CT",
    "DE",
    "DC",
    "FL",
    "GA",
    "HI",
    "ID",
    "IL",
    "IN",
    "IA",
    "KS",
    "KY",
    "LA",
    "ME",
    "MD",
    "MA",
    "MI",
    "MN",
    "MS",
    "MO",
    "MT",
    "NE",
    "NV",
    "NH",
    "NJ",
    "NM",
    "NY",
    "NC",
    "ND",
    "OH",
    "OK",
    "OR",
    "PA",
    "RI",
    "SC",
    "SD",
    "TN",
    "TX",
    "UT",
    "VT",
    "VA",
    "WA",
    "WV",
    "WI",
    "WY",
    "AS",
    "GU",
    "MP",
    "PR",
    "VI",
    "UM",
    "FM",
    "MH",
    "PW",
}

# Maps values from the 'Race' enum class to a string that the HMDA API accepts.
# For example, races[Race.ASIAN.value] would return the string "Asian" (since Race.ASIAN.value == 0, it is mapped onto the string "Asian").
races = {
    0 : "Asian",
    1 : "Native Hawaiian or Other Pacific Islander",
    2 : "Free Form Text Only",
    3 : "Race Not Available",
    4 : "American Indian or Alaska Native", 
    5 : "Black or African American", 
    6 : "2 or more minority races", 
    7 : "White", 
    8 : "Joint"   
}