# -*- coding: utf-8 -*-
"""MX Localmail class file."""

import os
import sys


class Localmail(object):
    """Localmail class."""

    def __init__(self, update):
        """Initialize a class instance."""
        self.update = update
        self.mx = update.mx
        self.verbose = update.mx.verbose

        # define the name of the localmail alias file
        self.aliasfile = 'aliases.localmail'

        # define the path to the localmail puppet file
        self.puppetfile = '%s/%s%s' % (
            self.mx.aliases_puppetdir,
            self.aliasfile,
            self.mx.extension,
        )

        # get program name
        self.program = os.path.basename(sys.argv[0])

        # bitsdb monogo collection
        self.collection = {}

    def generate(self):
        """Return the contents of the puppetfile."""
        # define header
        output = '# This file is autogenerated by the bits-mx %s script.\n' % (
            self.program
        )
        output += '# Do not make local modifications to this file.\n'

        # get autoreplies
        aliases = self.get_aliases()

        # localmail aliase
        output += '\n# Localmail aliases\n'
        output += '\n'.join(aliases)

        return output

    def get_aliases(self):
        """Return localmail aliases."""
        aliases = []
        for dn in sorted(self.update.localmail):
            entry = self.update.localmail[dn]
            uid = entry['uid'][0]
            aliases.append(
                "%s: %s@localmail.broadinstitute.org" % (
                    uid,
                    uid,
                )
            )
            self.collection[uid] = entry
            self.collection[uid]['username'] = uid
        self.update_collection()
        return aliases

    def update_collection(self):
        """Update the MongoDB collection."""
        m = self.update.auth.mongo()
        m.update_collection('localmail_aliases', self.collection)
