# -*- coding: utf-8 -*-
"""MX Groups class file."""

import os
import sys


class Groups(object):
    """Groups class."""

    def __init__(self, update):
        """Initialize a class instance."""
        self.update = update
        self.mx = update.mx
        self.verbose = update.mx.verbose

        # define the name of the groups transport file
        # self.transportdest = 'aspmx.l.google.com'
        self.transportdest = 'ASPMX.L.GOOGLE.com'
        self.transportfile = 'transport.groups'

        # define the path to the gnarwl puppet file
        self.puppetfile = '%s/%s%s' % (
            self.mx.transports_puppetdir,
            self.transportfile,
            self.mx.extension,
        )

        # get program name
        self.program = os.path.basename(sys.argv[0])

    def generate(self):
        """Return the contents of the puppetfile."""
        output = ''
        # define header
        output = '# This file is autogenerated by the bits-mx %s script.\n' % (
            self.program
        )
        output += '# Do not make local modifications to this file.\n'

        # get autoreplies
        groups_transports = self.get_groups_transports()

        # users without a forward
        output += '\n# Google Groups transports\n'
        output += '\n'.join(groups_transports)

        return output

    def get_groups_transports(self):
        """Return People transports."""
        groups = []

        for email in self.update.groups:
            # get group name
            name = email.replace('@broadinstitute.org', '')
            name = name.replace('-', r'\-')

            # skip groups that don't use broadinstitute.org email
            if '@' not in name:
                groups.append(name)

            # get group
            group = self.update.groups[email]

            # check aliases
            if 'aliases' in group and group['aliases']:
                for alias in group['aliases']:
                    alias = alias.replace('@broadinstitute.org', '')
                    alias = alias.replace('-', r'\-')
                    # skip aliases that don't use broadinstitute.org email
                    if '@' not in alias:
                        groups.append(alias)

        transports = []
        for group in sorted(groups):
            # add broadinstitute.org transport
            transports.append('/^%s(\\+.*)?@broadinstitute\\.org/\tsmtp:[%s]' % (
                group,
                self.transportdest,
            ))
        return transports
