# tamil-nlp-package
It is a repository for Tamil NLP packages as pip installable

## steps for installation and dependencies
Install and update using pip:
```bash
pip install tamil_nlp_package_test
```

## Tamil Sentence Tokenizer Example
```python
from tamil_nlp_package_test import tamil_tokenizer as tt

input_text = "ஒவ்வொருவருக்கும் கல்வி கற்பதற்கான உரிமையுண்டு. குறைந்தது ெதாடக்க அடிப்படைக் கட்டங்களிலாவது கல்வி இலவசமானதாயிருத்தல் வேண்டும். தொடக்கக் கல்வி கட்டாயப்படுத்தல் வேண்டும். தொழில் நுட்பக் கல்வியும் உயர் தொழிற் கல்வியும் பொதுவாகப் பெறப்படத்தக்கனவாயிருத்தல் வேண்டும். உயர் கல்வியானது யாவருக்கும் திறமையடிப்படையின் மீது சமமான முறையில் கிடைக்கக் கூடியதாக்கப்படுதலும் வேண்டும். கல்வியானது மனிதனின் ஆளுமையை முழுதாக விருத்தி ெசய்யுமுகமாகவும் மனிதவுரிமைகளுக்கும் அடிப்படைச் சுதந்திரங்களுக்குமான மரியாதையை வலுப்படு்த்துமுகமாகவும் ஆற்றப்படுத்தப்படல் வேண்டும். அது சகல நாடுகளுக்கிடையேயும், இன அல்லத மதக் குழுவினருக்கிைடயேயும் மன ஒத்திசைவு, பொறுதியுணர்வு, தோழமை, ஆகியவற்றை மேம்படுத்துதல் வேண்டுமென்பதுடன், சமாதானத்தைப் பேணுவதற்காக ஐக்கிய நாடுகள் சபையின் முயற்சிகளை மேற்கொண்டு செல்லுவதற்குதவவும் வேண்டும்."
output = tt.tokenize(input_text)
print(output)
```

### Output
```text
ஒவ்வொருவருக்கும் கல்வி கற்பதற்கான உரிமையுண்டு.
குறைந்தது ெதாடக்க அடிப்படைக் கட்டங்களிலாவது கல்வி இலவசமானதாயிருத்தல் வேண்டும்.
தொடக்கக் கல்வி கட்டாயப்படுத்தல் வேண்டும்.
தொழில் நுட்பக் கல்வியும் உயர் தொழிற் கல்வியும் பொதுவாகப் பெறப்படத்தக்கனவாயிருத்தல் வேண்டும்.
```

## Tamil Word Tokenizer Example
### input file - sample.txt
```text
ஒவ்வொருவருக்கும் கல்வி கற்பதற்கான உரிமையுண்டு.
குறைந்தது ெதாடக்க அடிப்படைக் கட்டங்களிலாவது கல்வி இலவசமானதாயிருத்தல் வேண்டும்.
தொடக்கக் கல்வி கட்டாயப்படுத்தல் வேண்டும்.
தொழில் நுட்பக் கல்வியும் உயர் தொழிற் கல்வியும் பொதுவாகப் பெறப்படத்தக்கனவாயிருத்தல் வேண்டும்.
```

```python
from tamil_nlp_package_test import word_tokenizer as wt

lang = 'tam' # tam - Tamil, Hindi - hin ...
input_file_name = 'sample.txt' # input filename as string.
output_file_name = 'output' # output filename as string.
output = wt.tokenize(lang, input_file_name, output_file_name)

# It'll return a result in a text file as output_file_name.
```

### output file - output.txt
```text
# Sent_id = 1
# text = தொடக்கக் கல்வி கட்டாயப்படுத்தல் வேண்டும்.
# transliteration =  toṭakkak kalwi kaṭṭāyappaṭuttal wēṇṭum.
# url = ஒவ்வொருவருக்கும் கல்வி கற்பதற்கான உரிமையுண்டு.	குறைந்தது ெதாடக்க அடிப்படைக் கட்டங்களிலாவது கல்வி இலவசமானதாயிருத்தல் வேண்டும்.
# wtok =தொடக்கக் கல்வி கட்டாயப்படுத்தல் வேண்டும் .

# Sent_id = 2
# text = தொழில் நுட்பக் கல்வியும் உயர் தொழிற் கல்வியும் பொதுவாகப் பெறப்படத்தக்கனவாயிருத்தல் வேண்டும்.# transliteration =  toẓil nuṭpak kalwiyum uyar toẓiṟ kalwiyum potuwākap peṟappaṭattakkaṉawāyiruttal wēṇṭum.# url = ஒவ்வொருவருக்கும் கல்வி கற்பதற்கான உரிமையுண்டு.	குறைந்தது ெதாடக்க அடிப்படைக் கட்டங்களிலாவது கல்வி இலவசமானதாயிருத்தல் வேண்டும்.
# wtok =தொழில் நுட்பக் கல்வியும் உயர் தொழிற் கல்வியும் பொதுவாகப் பெறப்படத்தக்கனவாயிருத்தல் வேண்டும் .
```