import { Construct } from 'constructs';
import { IIntegration } from '../common/integration';
import { HttpRouteIntegrationConfig } from '../http';
import { WebSocketRouteIntegrationConfig } from '../websocket';
declare type IntegrationConfig = HttpRouteIntegrationConfig | WebSocketRouteIntegrationConfig;
export declare class IntegrationCache {
    private integrations;
    getIntegration(scope: Construct, config: IntegrationConfig): {
        configHash: string;
        integration: IIntegration;
    };
    saveIntegration(scope: Construct, config: IntegrationConfig, integration: IIntegration): void;
    private integrationConfigHash;
}
export {};
