# codat-commerce

<!-- Start SDK Installation -->
## SDK Installation

```bash
pip install codat-commerce
```
<!-- End SDK Installation -->

## SDK Example Usage
<!-- Start SDK Example Usage -->
```python
import codat
from codat.models import operations, shared

s = codat.Codat(
    security=shared.Security(
        auth_header="YOUR_API_KEY_HERE",
    ),
)


req = operations.GetCompanyInfoRequest(
    company_id="8a210b68-6988-11ed-a1eb-0242ac120002",
    connection_id="2e9d2c44-f675-40ba-8049-353bfcb5e171",
)
    
res = s.company_info.get_company_info(req)

if res.company_info is not None:
    # handle response
```
<!-- End SDK Example Usage -->

<!-- Start SDK Available Operations -->
## Available Resources and Operations


### company_info

* `get_company_info` - Get company info

### customers

* `list_customers` - List customers

### disputes

* `list_disputes` - List disputes

### locations

* `list_locations` - List locations

### orders

* `list_orders` - List orders

### payments

* `list_payment_methods` - List payment methods
* `list_payments` - List payments

### products

* `list_product_categories` - List product categories
* `list_products` - List products

### tax_components

* `get_tax_components` - List tax components

### transactions

* `list_transactions` - List transactions
<!-- End SDK Available Operations -->

### SDK Generated by [Speakeasy](https://docs.speakeasyapi.dev/docs/using-speakeasy/client-sdks)
