# Numerical ideal Fermi gas

[![Documentation Status](https://readthedocs.org/projects/ifg-py/badge/?version=latest)](https://ifg-py.readthedocs.io/en/latest/?badge=latest)
[![tests](https://github.com/alekseik1/ifg-py/workflows/tests/badge.svg?branch=master)](https://github.com/alekseik1/ifg-py/actions?query=workflow%3A%22tests%22)
[![examples](https://github.com/alekseik1/ifg-py/workflows/examples/badge.svg?branch=master)](https://github.com/alekseik1/ifg-py/actions?query=workflow%3A%22examples%22)
[![CodeQL](https://github.com/alekseik1/ifg-py/workflows/CodeQL/badge.svg?branch=master)](https://github.com/alekseik1/ifg-py/actions?query=workflow%3A%22CodeQL%22)
[![build and deploy](https://github.com/alekseik1/ifg-py/workflows/build%20and%20deploy/badge.svg?branch=master)](https://github.com/alekseik1/ifg-py/actions)
[![codecov](https://codecov.io/gh/alekseik1/ifg-py/branch/master/graph/badge.svg?token=45T6I5O81G)](https://codecov.io/gh/alekseik1/ifg-py)

## Getting started
```bash
pip install ifg
```

## Functionality
The module can calculate some properties (like pressure, entropy) for ideal Fermi gas model.

See [API reference](https://ifg-py.readthedocs.io/en/latest/) for more information


## Examples
See `examples/` folder for plots and code examples.

## Acknowledgements
- [Library for Fermi integrals](https://pypi.org/project/fdint/)


## Reporting bugs
Use *Issues* to report any errors or bugs.
