/* File: f90brownianmodule.c
 * This file is auto-generated with f2py (version:1.20.3).
 * f2py is a Fortran to Python Interface Generator (FPIG), Second Edition,
 * written by Pearu Peterson <pearu@cens.ioc.ee>.
 * Generation date: Tue Sep 28 00:21:00 2021
 * Do not edit this file directly unless you know what you are doing!!!
 */

#ifdef __cplusplus
extern "C" {
#endif

/*********************** See f2py2e/cfuncs.py: includes ***********************/
#include "Python.h"
#include <stdarg.h>
#include "fortranobject.h"
/*need_includes0*/

/**************** See f2py2e/rules.py: mod_rules['modulebody'] ****************/
static PyObject *f90brownian_error;
static PyObject *f90brownian_module;

/*********************** See f2py2e/cfuncs.py: typedefs ***********************/
/*need_typedefs*/

/****************** See f2py2e/cfuncs.py: typedefs_generated ******************/
/*need_typedefs_generated*/

/********************** See f2py2e/cfuncs.py: cppmacros **********************/
#define rank(var) var ## _Rank
#define shape(var,dim) var ## _Dims[dim]
#define old_rank(var) (PyArray_NDIM((PyArrayObject *)(capi_ ## var ## _tmp)))
#define old_shape(var,dim) PyArray_DIM(((PyArrayObject *)(capi_ ## var ## _tmp)),dim)
#define fshape(var,dim) shape(var,rank(var)-dim-1)
#define len(var) shape(var,0)
#define flen(var) fshape(var,0)
#define old_size(var) PyArray_SIZE((PyArrayObject *)(capi_ ## var ## _tmp))
/* #define index(i) capi_i ## i */
#define slen(var) capi_ ## var ## _len
#define size(var, ...) f2py_size((PyArrayObject *)(capi_ ## var ## _tmp), ## __VA_ARGS__, -1)

#ifdef DEBUGCFUNCS
#define CFUNCSMESS(mess) fprintf(stderr,"debug-capi:"mess);
#define CFUNCSMESSPY(mess,obj) CFUNCSMESS(mess) \
    PyObject_Print((PyObject *)obj,stderr,Py_PRINT_RAW);\
    fprintf(stderr,"\n");
#else
#define CFUNCSMESS(mess)
#define CFUNCSMESSPY(mess,obj)
#endif

#ifndef max
#define max(a,b) ((a > b) ? (a) : (b))
#endif
#ifndef min
#define min(a,b) ((a < b) ? (a) : (b))
#endif
#ifndef MAX
#define MAX(a,b) ((a > b) ? (a) : (b))
#endif
#ifndef MIN
#define MIN(a,b) ((a < b) ? (a) : (b))
#endif

#if defined(PREPEND_FORTRAN)
#if defined(NO_APPEND_FORTRAN)
#if defined(UPPERCASE_FORTRAN)
#define F_FUNC(f,F) _##F
#else
#define F_FUNC(f,F) _##f
#endif
#else
#if defined(UPPERCASE_FORTRAN)
#define F_FUNC(f,F) _##F##_
#else
#define F_FUNC(f,F) _##f##_
#endif
#endif
#else
#if defined(NO_APPEND_FORTRAN)
#if defined(UPPERCASE_FORTRAN)
#define F_FUNC(f,F) F
#else
#define F_FUNC(f,F) f
#endif
#else
#if defined(UPPERCASE_FORTRAN)
#define F_FUNC(f,F) F##_
#else
#define F_FUNC(f,F) f##_
#endif
#endif
#endif
#if defined(UNDERSCORE_G77)
#define F_FUNC_US(f,F) F_FUNC(f##_,F##_)
#else
#define F_FUNC_US(f,F) F_FUNC(f,F)
#endif


/************************ See f2py2e/cfuncs.py: cfuncs ************************/
static int
double_from_pyobj(double* v, PyObject *obj, const char *errmess)
{
    PyObject* tmp = NULL;
    if (PyFloat_Check(obj)) {
        *v = PyFloat_AsDouble(obj);
        return !(*v == -1.0 && PyErr_Occurred());
    }

    tmp = PyNumber_Float(obj);
    if (tmp) {
        *v = PyFloat_AsDouble(tmp);
        Py_DECREF(tmp);
        return !(*v == -1.0 && PyErr_Occurred());
    }
    if (PyComplex_Check(obj))
        tmp = PyObject_GetAttrString(obj,"real");
    else if (PyBytes_Check(obj) || PyUnicode_Check(obj))
        /*pass*/;
    else if (PySequence_Check(obj))
        tmp = PySequence_GetItem(obj,0);
    if (tmp) {
        PyErr_Clear();
        if (double_from_pyobj(v,tmp,errmess)) {Py_DECREF(tmp); return 1;}
        Py_DECREF(tmp);
    }
    {
        PyObject* err = PyErr_Occurred();
        if (err==NULL) err = f90brownian_error;
        PyErr_SetString(err,errmess);
    }
    return 0;
}

static int f2py_size(PyArrayObject* var, ...)
{
  npy_int sz = 0;
  npy_int dim;
  npy_int rank;
  va_list argp;
  va_start(argp, var);
  dim = va_arg(argp, npy_int);
  if (dim==-1)
    {
      sz = PyArray_SIZE(var);
    }
  else
    {
      rank = PyArray_NDIM(var);
      if (dim>=1 && dim<=rank)
        sz = PyArray_DIM(var, dim-1);
      else
        fprintf(stderr, "f2py_size: 2nd argument value=%d fails to satisfy 1<=value<=%d. Result will be 0.\n", dim, rank);
    }
  va_end(argp);
  return sz;
}

static int
float_from_pyobj(float* v, PyObject *obj, const char *errmess)
{
    double d=0.0;
    if (double_from_pyobj(&d,obj,errmess)) {
        *v = (float)d;
        return 1;
    }
    return 0;
}

static int
int_from_pyobj(int* v, PyObject *obj, const char *errmess)
{
    PyObject* tmp = NULL;

    if (PyLong_Check(obj)) {
        *v = Npy__PyLong_AsInt(obj);
        return !(*v == -1 && PyErr_Occurred());
    }

    tmp = PyNumber_Long(obj);
    if (tmp) {
        *v = Npy__PyLong_AsInt(tmp);
        Py_DECREF(tmp);
        return !(*v == -1 && PyErr_Occurred());
    }

    if (PyComplex_Check(obj))
        tmp = PyObject_GetAttrString(obj,"real");
    else if (PyBytes_Check(obj) || PyUnicode_Check(obj))
        /*pass*/;
    else if (PySequence_Check(obj))
        tmp = PySequence_GetItem(obj, 0);
    if (tmp) {
        PyErr_Clear();
        if (int_from_pyobj(v, tmp, errmess)) {
            Py_DECREF(tmp);
            return 1;
        }
        Py_DECREF(tmp);
    }
    {
        PyObject* err = PyErr_Occurred();
        if (err == NULL) {
            err = f90brownian_error;
        }
        PyErr_SetString(err, errmess);
    }
    return 0;
}


/********************* See f2py2e/cfuncs.py: userincludes *********************/
/*need_userincludes*/

/********************* See f2py2e/capi_rules.py: usercode *********************/


/* See f2py2e/rules.py */
/*eof externroutines*/

/******************** See f2py2e/capi_rules.py: usercode1 ********************/


/******************* See f2py2e/cb_rules.py: buildcallback *******************/
/*need_callbacks*/

/*********************** See f2py2e/rules.py: buildapi ***********************/

/******************************* symmatd2eigen *******************************/
static char doc_f2py_rout_f90brownian_f90brownian_symmatd2eigen[] = "\
eigenvalues,eigenvectors = symmatd2eigen(symmat)\n\nWrapper for ``symmatd2eigen``.\
\n\nParameters\n----------\n"
"symmat : input rank-2 array('f') with bounds (2,2)\n"
"\nReturns\n-------\n"
"eigenvalues : rank-1 array('f') with bounds (2)\n"
"eigenvectors : rank-2 array('f') with bounds (2,2)";
/*  */
static PyObject *f2py_rout_f90brownian_f90brownian_symmatd2eigen(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(float*,float*,float*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  float *symmat = NULL;
  npy_intp symmat_Dims[2] = {-1, -1};
  const int symmat_Rank = 2;
  PyArrayObject *capi_symmat_tmp = NULL;
  int capi_symmat_intent = 0;
  PyObject *symmat_capi = Py_None;
  float *eigenvalues = NULL;
  npy_intp eigenvalues_Dims[1] = {-1};
  const int eigenvalues_Rank = 1;
  PyArrayObject *capi_eigenvalues_tmp = NULL;
  int capi_eigenvalues_intent = 0;
  float *eigenvectors = NULL;
  npy_intp eigenvectors_Dims[2] = {-1, -1};
  const int eigenvectors_Rank = 2;
  PyArrayObject *capi_eigenvectors_tmp = NULL;
  int capi_eigenvectors_intent = 0;
    static char *capi_kwlist[] = {"symmat",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "O|:f90brownian.f90brownian.symmatd2eigen",\
        capi_kwlist,&symmat_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable symmat */
  symmat_Dims[0]=2,symmat_Dims[1]=2;
  capi_symmat_intent |= F2PY_INTENT_IN;
  capi_symmat_tmp = array_from_pyobj(NPY_FLOAT,symmat_Dims,symmat_Rank,capi_symmat_intent,symmat_capi);
  if (capi_symmat_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : f90brownian_error,"failed in converting 1st argument `symmat' of f90brownian.f90brownian.symmatd2eigen to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    symmat = (float *)(PyArray_DATA(capi_symmat_tmp));

  /* Processing variable eigenvalues */
  eigenvalues_Dims[0]=2;
  capi_eigenvalues_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_eigenvalues_tmp = array_from_pyobj(NPY_FLOAT,eigenvalues_Dims,eigenvalues_Rank,capi_eigenvalues_intent,Py_None);
  if (capi_eigenvalues_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : f90brownian_error,"failed in converting hidden `eigenvalues' of f90brownian.f90brownian.symmatd2eigen to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    eigenvalues = (float *)(PyArray_DATA(capi_eigenvalues_tmp));

  /* Processing variable eigenvectors */
  eigenvectors_Dims[0]=2,eigenvectors_Dims[1]=2;
  capi_eigenvectors_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_eigenvectors_tmp = array_from_pyobj(NPY_FLOAT,eigenvectors_Dims,eigenvectors_Rank,capi_eigenvectors_intent,Py_None);
  if (capi_eigenvectors_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : f90brownian_error,"failed in converting hidden `eigenvectors' of f90brownian.f90brownian.symmatd2eigen to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    eigenvectors = (float *)(PyArray_DATA(capi_eigenvectors_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(symmat,eigenvalues,eigenvectors);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("NN",capi_eigenvalues_tmp,capi_eigenvectors_tmp);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  }  /*if (capi_eigenvectors_tmp == NULL) ... else of eigenvectors*/
  /* End of cleaning variable eigenvectors */
  }  /*if (capi_eigenvalues_tmp == NULL) ... else of eigenvalues*/
  /* End of cleaning variable eigenvalues */
  if((PyObject *)capi_symmat_tmp!=symmat_capi) {
    Py_XDECREF(capi_symmat_tmp); }
  }  /*if (capi_symmat_tmp == NULL) ... else of symmat*/
  /* End of cleaning variable symmat */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/**************************** end of symmatd2eigen ****************************/

/********************************* inv_errfcn *********************************/
static char doc_f2py_rout_f90brownian_f90brownian_inv_errfcn[] = "\
z = inv_errfcn(x)\n\nWrapper for ``inv_errfcn``.\
\n\nParameters\n----------\n"
"x : input float\n"
"\nReturns\n-------\n"
"z : float";
/* #declfortranroutine# */
static PyObject *f2py_rout_f90brownian_f90brownian_inv_errfcn(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(float*,float*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  float inv_errfcn = 0;
  float x = 0;
  PyObject *x_capi = Py_None;
    static char *capi_kwlist[] = {"x",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "O|:f90brownian.f90brownian.inv_errfcn",\
        capi_kwlist,&x_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable x */
    f2py_success = float_from_pyobj(&x,x_capi,"f90brownian.f90brownian.inv_errfcn() 1st argument (x) can't be converted to float");
  if (f2py_success) {
  /* Processing variable inv_errfcn */
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
  (*f2py_func)(&inv_errfcn,&x);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("f",inv_errfcn);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  /* End of cleaning variable inv_errfcn */
  } /*if (f2py_success) of x*/
  /* End of cleaning variable x */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/***************************** end of inv_errfcn *****************************/

/***************************** normaldistsampling *****************************/
static char doc_f2py_rout_f90brownian_f90brownian_normaldistsampling[] = "\
z = normaldistsampling()\n\nWrapper for ``normaldistsampling``.\
\n\nReturns\n-------\n"
"z : float";
/* #declfortranroutine# */
static PyObject *f2py_rout_f90brownian_f90brownian_normaldistsampling(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(float*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  float normaldistsampling = 0;
    static char *capi_kwlist[] = {NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "|:f90brownian.f90brownian.normaldistsampling",\
        capi_kwlist))
        return NULL;
/*frompyobj*/
  /* Processing variable normaldistsampling */
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
  (*f2py_func)(&normaldistsampling);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("f",normaldistsampling);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  /* End of cleaning variable normaldistsampling */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/************************* end of normaldistsampling *************************/

/**************************** normal2ddistsampling ****************************/
static char doc_f2py_rout_f90brownian_f90brownian_normal2ddistsampling[] = "\
zvec = normal2ddistsampling(rho)\n\nWrapper for ``normal2ddistsampling``.\
\n\nParameters\n----------\n"
"rho : input rank-2 array('f') with bounds (2,2)\n"
"\nReturns\n-------\n"
"zvec : rank-1 array('f') with bounds (2) and normal2ddistsampling storage";
/* #declfortranroutine# */
static PyObject *f2py_rout_f90brownian_f90brownian_normal2ddistsampling(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(float*,float*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  float *normal2ddistsampling = NULL;
  npy_intp normal2ddistsampling_Dims[1] = {-1};
  const int normal2ddistsampling_Rank = 1;
  PyArrayObject *capi_normal2ddistsampling_tmp = NULL;
  int capi_normal2ddistsampling_intent = 0;
  float *rho = NULL;
  npy_intp rho_Dims[2] = {-1, -1};
  const int rho_Rank = 2;
  PyArrayObject *capi_rho_tmp = NULL;
  int capi_rho_intent = 0;
  PyObject *rho_capi = Py_None;
    static char *capi_kwlist[] = {"rho",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "O|:f90brownian.f90brownian.normal2ddistsampling",\
        capi_kwlist,&rho_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable rho */
  rho_Dims[0]=2,rho_Dims[1]=2;
  capi_rho_intent |= F2PY_INTENT_IN;
  capi_rho_tmp = array_from_pyobj(NPY_FLOAT,rho_Dims,rho_Rank,capi_rho_intent,rho_capi);
  if (capi_rho_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : f90brownian_error,"failed in converting 1st argument `rho' of f90brownian.f90brownian.normal2ddistsampling to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    rho = (float *)(PyArray_DATA(capi_rho_tmp));

  /* Processing variable normal2ddistsampling */
  normal2ddistsampling_Dims[0]=2;
  capi_normal2ddistsampling_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_normal2ddistsampling_tmp = array_from_pyobj(NPY_FLOAT,normal2ddistsampling_Dims,normal2ddistsampling_Rank,capi_normal2ddistsampling_intent,Py_None);
  if (capi_normal2ddistsampling_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : f90brownian_error,"failed in converting hidden `normal2ddistsampling' of f90brownian.f90brownian.normal2ddistsampling to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    normal2ddistsampling = (float *)(PyArray_DATA(capi_normal2ddistsampling_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
  (*f2py_func)(normal2ddistsampling,rho);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("N",capi_normal2ddistsampling_tmp);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  }  /*if (capi_normal2ddistsampling_tmp == NULL) ... else of normal2ddistsampling*/
  /* End of cleaning variable normal2ddistsampling */
  if((PyObject *)capi_rho_tmp!=rho_capi) {
    Py_XDECREF(capi_rho_tmp); }
  }  /*if (capi_rho_tmp == NULL) ... else of rho*/
  /* End of cleaning variable rho */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/************************ end of normal2ddistsampling ************************/

/************************** initialize_random_seeds **************************/
static char doc_f2py_rout_f90brownian_f90brownian_initialize_random_seeds[] = "\
initialize_random_seeds()\n\nWrapper for ``initialize_random_seeds``.\
\n";
/*  */
static PyObject *f2py_rout_f90brownian_f90brownian_initialize_random_seeds(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(void)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

    static char *capi_kwlist[] = {NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "|:f90brownian.f90brownian.initialize_random_seeds",\
        capi_kwlist))
        return NULL;
/*frompyobj*/
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)();
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/*********************** end of initialize_random_seeds ***********************/

/************************* lognormal_price_simulation *************************/
static char doc_f2py_rout_f90brownian_f90brownian_lognormal_price_simulation[] = "\
s = lognormal_price_simulation(logs0,r,sigma,dt,nbsteps,nbsimulations)\n\nWrapper for ``lognormal_price_simulation``.\
\n\nParameters\n----------\n"
"logs0 : input float\n"
"r : input float\n"
"sigma : input float\n"
"dt : input float\n"
"nbsteps : input int\n"
"nbsimulations : input int\n"
"\nReturns\n-------\n"
"s : rank-2 array('f') with bounds (nbsimulations,nbsteps) and lognormal_price_simulation storage";
/* #declfortranroutine# */
static PyObject *f2py_rout_f90brownian_f90brownian_lognormal_price_simulation(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(float*,float*,float*,float*,float*,int*,int*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  float *lognormal_price_simulation = NULL;
  npy_intp lognormal_price_simulation_Dims[2] = {-1, -1};
  const int lognormal_price_simulation_Rank = 2;
  PyArrayObject *capi_lognormal_price_simulation_tmp = NULL;
  int capi_lognormal_price_simulation_intent = 0;
  float logs0 = 0;
  PyObject *logs0_capi = Py_None;
  float r = 0;
  PyObject *r_capi = Py_None;
  float sigma = 0;
  PyObject *sigma_capi = Py_None;
  float dt = 0;
  PyObject *dt_capi = Py_None;
  int nbsteps = 0;
  PyObject *nbsteps_capi = Py_None;
  int nbsimulations = 0;
  PyObject *nbsimulations_capi = Py_None;
    static char *capi_kwlist[] = {"logs0","r","sigma","dt","nbsteps","nbsimulations",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OOOOOO|:f90brownian.f90brownian.lognormal_price_simulation",\
        capi_kwlist,&logs0_capi,&r_capi,&sigma_capi,&dt_capi,&nbsteps_capi,&nbsimulations_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable logs0 */
    f2py_success = float_from_pyobj(&logs0,logs0_capi,"f90brownian.f90brownian.lognormal_price_simulation() 1st argument (logs0) can't be converted to float");
  if (f2py_success) {
  /* Processing variable r */
    f2py_success = float_from_pyobj(&r,r_capi,"f90brownian.f90brownian.lognormal_price_simulation() 2nd argument (r) can't be converted to float");
  if (f2py_success) {
  /* Processing variable sigma */
    f2py_success = float_from_pyobj(&sigma,sigma_capi,"f90brownian.f90brownian.lognormal_price_simulation() 3rd argument (sigma) can't be converted to float");
  if (f2py_success) {
  /* Processing variable dt */
    f2py_success = float_from_pyobj(&dt,dt_capi,"f90brownian.f90brownian.lognormal_price_simulation() 4th argument (dt) can't be converted to float");
  if (f2py_success) {
  /* Processing variable nbsteps */
    f2py_success = int_from_pyobj(&nbsteps,nbsteps_capi,"f90brownian.f90brownian.lognormal_price_simulation() 5th argument (nbsteps) can't be converted to int");
  if (f2py_success) {
  /* Processing variable nbsimulations */
    f2py_success = int_from_pyobj(&nbsimulations,nbsimulations_capi,"f90brownian.f90brownian.lognormal_price_simulation() 6th argument (nbsimulations) can't be converted to int");
  if (f2py_success) {
  /* Processing variable lognormal_price_simulation */
  lognormal_price_simulation_Dims[0]=nbsimulations,lognormal_price_simulation_Dims[1]=nbsteps;
  capi_lognormal_price_simulation_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_lognormal_price_simulation_tmp = array_from_pyobj(NPY_FLOAT,lognormal_price_simulation_Dims,lognormal_price_simulation_Rank,capi_lognormal_price_simulation_intent,Py_None);
  if (capi_lognormal_price_simulation_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : f90brownian_error,"failed in converting hidden `lognormal_price_simulation' of f90brownian.f90brownian.lognormal_price_simulation to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    lognormal_price_simulation = (float *)(PyArray_DATA(capi_lognormal_price_simulation_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
  (*f2py_func)(lognormal_price_simulation,&logs0,&r,&sigma,&dt,&nbsteps,&nbsimulations);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("N",capi_lognormal_price_simulation_tmp);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  }  /*if (capi_lognormal_price_simulation_tmp == NULL) ... else of lognormal_price_simulation*/
  /* End of cleaning variable lognormal_price_simulation */
  } /*if (f2py_success) of nbsimulations*/
  /* End of cleaning variable nbsimulations */
  } /*if (f2py_success) of nbsteps*/
  /* End of cleaning variable nbsteps */
  } /*if (f2py_success) of dt*/
  /* End of cleaning variable dt */
  } /*if (f2py_success) of sigma*/
  /* End of cleaning variable sigma */
  } /*if (f2py_success) of r*/
  /* End of cleaning variable r */
  } /*if (f2py_success) of logs0*/
  /* End of cleaning variable logs0 */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/********************* end of lognormal_price_simulation *********************/

/********************** squareroot_diffusion_simulation **********************/
static char doc_f2py_rout_f90brownian_f90brownian_squareroot_diffusion_simulation[] = "\
xarray = squareroot_diffusion_simulation(x0,theta,kappa,sigma,dt,nbsteps,nbsimulations)\n\nWrapper for ``squareroot_diffusion_simulation``.\
\n\nParameters\n----------\n"
"x0 : input float\n"
"theta : input float\n"
"kappa : input float\n"
"sigma : input float\n"
"dt : input float\n"
"nbsteps : input int\n"
"nbsimulations : input int\n"
"\nReturns\n-------\n"
"xarray : rank-2 array('f') with bounds (nbsimulations,nbsteps) and squareroot_diffusion_simulation storage";
/* #declfortranroutine# */
static PyObject *f2py_rout_f90brownian_f90brownian_squareroot_diffusion_simulation(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(float*,float*,float*,float*,float*,float*,int*,int*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  float *squareroot_diffusion_simulation = NULL;
  npy_intp squareroot_diffusion_simulation_Dims[2] = {-1, -1};
  const int squareroot_diffusion_simulation_Rank = 2;
  PyArrayObject *capi_squareroot_diffusion_simulation_tmp = NULL;
  int capi_squareroot_diffusion_simulation_intent = 0;
  float x0 = 0;
  PyObject *x0_capi = Py_None;
  float theta = 0;
  PyObject *theta_capi = Py_None;
  float kappa = 0;
  PyObject *kappa_capi = Py_None;
  float sigma = 0;
  PyObject *sigma_capi = Py_None;
  float dt = 0;
  PyObject *dt_capi = Py_None;
  int nbsteps = 0;
  PyObject *nbsteps_capi = Py_None;
  int nbsimulations = 0;
  PyObject *nbsimulations_capi = Py_None;
    static char *capi_kwlist[] = {"x0","theta","kappa","sigma","dt","nbsteps","nbsimulations",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OOOOOOO|:f90brownian.f90brownian.squareroot_diffusion_simulation",\
        capi_kwlist,&x0_capi,&theta_capi,&kappa_capi,&sigma_capi,&dt_capi,&nbsteps_capi,&nbsimulations_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable x0 */
    f2py_success = float_from_pyobj(&x0,x0_capi,"f90brownian.f90brownian.squareroot_diffusion_simulation() 1st argument (x0) can't be converted to float");
  if (f2py_success) {
  /* Processing variable theta */
    f2py_success = float_from_pyobj(&theta,theta_capi,"f90brownian.f90brownian.squareroot_diffusion_simulation() 2nd argument (theta) can't be converted to float");
  if (f2py_success) {
  /* Processing variable kappa */
    f2py_success = float_from_pyobj(&kappa,kappa_capi,"f90brownian.f90brownian.squareroot_diffusion_simulation() 3rd argument (kappa) can't be converted to float");
  if (f2py_success) {
  /* Processing variable sigma */
    f2py_success = float_from_pyobj(&sigma,sigma_capi,"f90brownian.f90brownian.squareroot_diffusion_simulation() 4th argument (sigma) can't be converted to float");
  if (f2py_success) {
  /* Processing variable dt */
    f2py_success = float_from_pyobj(&dt,dt_capi,"f90brownian.f90brownian.squareroot_diffusion_simulation() 5th argument (dt) can't be converted to float");
  if (f2py_success) {
  /* Processing variable nbsteps */
    f2py_success = int_from_pyobj(&nbsteps,nbsteps_capi,"f90brownian.f90brownian.squareroot_diffusion_simulation() 6th argument (nbsteps) can't be converted to int");
  if (f2py_success) {
  /* Processing variable nbsimulations */
    f2py_success = int_from_pyobj(&nbsimulations,nbsimulations_capi,"f90brownian.f90brownian.squareroot_diffusion_simulation() 7th argument (nbsimulations) can't be converted to int");
  if (f2py_success) {
  /* Processing variable squareroot_diffusion_simulation */
  squareroot_diffusion_simulation_Dims[0]=nbsimulations,squareroot_diffusion_simulation_Dims[1]=nbsteps;
  capi_squareroot_diffusion_simulation_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_squareroot_diffusion_simulation_tmp = array_from_pyobj(NPY_FLOAT,squareroot_diffusion_simulation_Dims,squareroot_diffusion_simulation_Rank,capi_squareroot_diffusion_simulation_intent,Py_None);
  if (capi_squareroot_diffusion_simulation_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : f90brownian_error,"failed in converting hidden `squareroot_diffusion_simulation' of f90brownian.f90brownian.squareroot_diffusion_simulation to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    squareroot_diffusion_simulation = (float *)(PyArray_DATA(capi_squareroot_diffusion_simulation_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
  (*f2py_func)(squareroot_diffusion_simulation,&x0,&theta,&kappa,&sigma,&dt,&nbsteps,&nbsimulations);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("N",capi_squareroot_diffusion_simulation_tmp);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  }  /*if (capi_squareroot_diffusion_simulation_tmp == NULL) ... else of squareroot_diffusion_simulation*/
  /* End of cleaning variable squareroot_diffusion_simulation */
  } /*if (f2py_success) of nbsimulations*/
  /* End of cleaning variable nbsimulations */
  } /*if (f2py_success) of nbsteps*/
  /* End of cleaning variable nbsteps */
  } /*if (f2py_success) of dt*/
  /* End of cleaning variable dt */
  } /*if (f2py_success) of sigma*/
  /* End of cleaning variable sigma */
  } /*if (f2py_success) of kappa*/
  /* End of cleaning variable kappa */
  } /*if (f2py_success) of theta*/
  /* End of cleaning variable theta */
  } /*if (f2py_success) of x0*/
  /* End of cleaning variable x0 */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/******************* end of squareroot_diffusion_simulation *******************/

/************************** heston_price_simulation **************************/
static char doc_f2py_rout_f90brownian_f90brownian_heston_price_simulation[] = "\
s,v = heston_price_simulation(logs0,r,v0,theta,kappa,sigma_v,rho,dt,nbsteps,nbsimulations)\n\nWrapper for ``heston_price_simulation``.\
\n\nParameters\n----------\n"
"logs0 : input float\n"
"r : input float\n"
"v0 : input float\n"
"theta : input float\n"
"kappa : input float\n"
"sigma_v : input float\n"
"rho : input float\n"
"dt : input float\n"
"nbsteps : input int\n"
"nbsimulations : input int\n"
"\nReturns\n-------\n"
"s : rank-2 array('f') with bounds (nbsimulations,nbsteps)\n"
"v : rank-2 array('f') with bounds (nbsimulations,nbsteps)";
/*  */
static PyObject *f2py_rout_f90brownian_f90brownian_heston_price_simulation(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(float*,float*,float*,float*,float*,float*,float*,float*,int*,int*,float*,float*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  float logs0 = 0;
  PyObject *logs0_capi = Py_None;
  float r = 0;
  PyObject *r_capi = Py_None;
  float v0 = 0;
  PyObject *v0_capi = Py_None;
  float theta = 0;
  PyObject *theta_capi = Py_None;
  float kappa = 0;
  PyObject *kappa_capi = Py_None;
  float sigma_v = 0;
  PyObject *sigma_v_capi = Py_None;
  float rho = 0;
  PyObject *rho_capi = Py_None;
  float dt = 0;
  PyObject *dt_capi = Py_None;
  int nbsteps = 0;
  PyObject *nbsteps_capi = Py_None;
  int nbsimulations = 0;
  PyObject *nbsimulations_capi = Py_None;
  float *s = NULL;
  npy_intp s_Dims[2] = {-1, -1};
  const int s_Rank = 2;
  PyArrayObject *capi_s_tmp = NULL;
  int capi_s_intent = 0;
  float *v = NULL;
  npy_intp v_Dims[2] = {-1, -1};
  const int v_Rank = 2;
  PyArrayObject *capi_v_tmp = NULL;
  int capi_v_intent = 0;
    static char *capi_kwlist[] = {"logs0","r","v0","theta","kappa","sigma_v","rho","dt","nbsteps","nbsimulations",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OOOOOOOOOO|:f90brownian.f90brownian.heston_price_simulation",\
        capi_kwlist,&logs0_capi,&r_capi,&v0_capi,&theta_capi,&kappa_capi,&sigma_v_capi,&rho_capi,&dt_capi,&nbsteps_capi,&nbsimulations_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable logs0 */
    f2py_success = float_from_pyobj(&logs0,logs0_capi,"f90brownian.f90brownian.heston_price_simulation() 1st argument (logs0) can't be converted to float");
  if (f2py_success) {
  /* Processing variable r */
    f2py_success = float_from_pyobj(&r,r_capi,"f90brownian.f90brownian.heston_price_simulation() 2nd argument (r) can't be converted to float");
  if (f2py_success) {
  /* Processing variable v0 */
    f2py_success = float_from_pyobj(&v0,v0_capi,"f90brownian.f90brownian.heston_price_simulation() 3rd argument (v0) can't be converted to float");
  if (f2py_success) {
  /* Processing variable theta */
    f2py_success = float_from_pyobj(&theta,theta_capi,"f90brownian.f90brownian.heston_price_simulation() 4th argument (theta) can't be converted to float");
  if (f2py_success) {
  /* Processing variable kappa */
    f2py_success = float_from_pyobj(&kappa,kappa_capi,"f90brownian.f90brownian.heston_price_simulation() 5th argument (kappa) can't be converted to float");
  if (f2py_success) {
  /* Processing variable sigma_v */
    f2py_success = float_from_pyobj(&sigma_v,sigma_v_capi,"f90brownian.f90brownian.heston_price_simulation() 6th argument (sigma_v) can't be converted to float");
  if (f2py_success) {
  /* Processing variable rho */
    f2py_success = float_from_pyobj(&rho,rho_capi,"f90brownian.f90brownian.heston_price_simulation() 7th argument (rho) can't be converted to float");
  if (f2py_success) {
  /* Processing variable dt */
    f2py_success = float_from_pyobj(&dt,dt_capi,"f90brownian.f90brownian.heston_price_simulation() 8th argument (dt) can't be converted to float");
  if (f2py_success) {
  /* Processing variable nbsteps */
    f2py_success = int_from_pyobj(&nbsteps,nbsteps_capi,"f90brownian.f90brownian.heston_price_simulation() 9th argument (nbsteps) can't be converted to int");
  if (f2py_success) {
  /* Processing variable nbsimulations */
    f2py_success = int_from_pyobj(&nbsimulations,nbsimulations_capi,"f90brownian.f90brownian.heston_price_simulation() 10th argument (nbsimulations) can't be converted to int");
  if (f2py_success) {
  /* Processing variable s */
  s_Dims[0]=nbsimulations,s_Dims[1]=nbsteps;
  capi_s_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_s_tmp = array_from_pyobj(NPY_FLOAT,s_Dims,s_Rank,capi_s_intent,Py_None);
  if (capi_s_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : f90brownian_error,"failed in converting hidden `s' of f90brownian.f90brownian.heston_price_simulation to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    s = (float *)(PyArray_DATA(capi_s_tmp));

  /* Processing variable v */
  v_Dims[0]=nbsimulations,v_Dims[1]=nbsteps;
  capi_v_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_v_tmp = array_from_pyobj(NPY_FLOAT,v_Dims,v_Rank,capi_v_intent,Py_None);
  if (capi_v_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : f90brownian_error,"failed in converting hidden `v' of f90brownian.f90brownian.heston_price_simulation to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    v = (float *)(PyArray_DATA(capi_v_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&logs0,&r,&v0,&theta,&kappa,&sigma_v,&rho,&dt,&nbsteps,&nbsimulations,s,v);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("NN",capi_s_tmp,capi_v_tmp);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  }  /*if (capi_v_tmp == NULL) ... else of v*/
  /* End of cleaning variable v */
  }  /*if (capi_s_tmp == NULL) ... else of s*/
  /* End of cleaning variable s */
  } /*if (f2py_success) of nbsimulations*/
  /* End of cleaning variable nbsimulations */
  } /*if (f2py_success) of nbsteps*/
  /* End of cleaning variable nbsteps */
  } /*if (f2py_success) of dt*/
  /* End of cleaning variable dt */
  } /*if (f2py_success) of rho*/
  /* End of cleaning variable rho */
  } /*if (f2py_success) of sigma_v*/
  /* End of cleaning variable sigma_v */
  } /*if (f2py_success) of kappa*/
  /* End of cleaning variable kappa */
  } /*if (f2py_success) of theta*/
  /* End of cleaning variable theta */
  } /*if (f2py_success) of v0*/
  /* End of cleaning variable v0 */
  } /*if (f2py_success) of r*/
  /* End of cleaning variable r */
  } /*if (f2py_success) of logs0*/
  /* End of cleaning variable logs0 */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/*********************** end of heston_price_simulation ***********************/
/*eof body*/

/******************* See f2py2e/f90mod_rules.py: buildhooks *******************/

static FortranDataDef f2py_f90brownian_def[] = {
  {"symmatd2eigen",-1,{{-1}},0,NULL,(void *)f2py_rout_f90brownian_f90brownian_symmatd2eigen,doc_f2py_rout_f90brownian_f90brownian_symmatd2eigen},
  {"inv_errfcn",-1,{{-1}},0,NULL,(void *)f2py_rout_f90brownian_f90brownian_inv_errfcn,doc_f2py_rout_f90brownian_f90brownian_inv_errfcn},
  {"normaldistsampling",-1,{{-1}},0,NULL,(void *)f2py_rout_f90brownian_f90brownian_normaldistsampling,doc_f2py_rout_f90brownian_f90brownian_normaldistsampling},
  {"normal2ddistsampling",-1,{{-1}},0,NULL,(void *)f2py_rout_f90brownian_f90brownian_normal2ddistsampling,doc_f2py_rout_f90brownian_f90brownian_normal2ddistsampling},
  {"initialize_random_seeds",-1,{{-1}},0,NULL,(void *)f2py_rout_f90brownian_f90brownian_initialize_random_seeds,doc_f2py_rout_f90brownian_f90brownian_initialize_random_seeds},
  {"lognormal_price_simulation",-1,{{-1}},0,NULL,(void *)f2py_rout_f90brownian_f90brownian_lognormal_price_simulation,doc_f2py_rout_f90brownian_f90brownian_lognormal_price_simulation},
  {"squareroot_diffusion_simulation",-1,{{-1}},0,NULL,(void *)f2py_rout_f90brownian_f90brownian_squareroot_diffusion_simulation,doc_f2py_rout_f90brownian_f90brownian_squareroot_diffusion_simulation},
  {"heston_price_simulation",-1,{{-1}},0,NULL,(void *)f2py_rout_f90brownian_f90brownian_heston_price_simulation,doc_f2py_rout_f90brownian_f90brownian_heston_price_simulation},
  {NULL}
};

static void f2py_setup_f90brownian(char *symmatd2eigen,char *inv_errfcn,char *normaldistsampling,char *normal2ddistsampling,char *initialize_random_seeds,char *lognormal_price_simulation,char *squareroot_diffusion_simulation,char *heston_price_simulation) {
  int i_f2py=0;
  f2py_f90brownian_def[i_f2py++].data = symmatd2eigen;
  f2py_f90brownian_def[i_f2py++].data = inv_errfcn;
  f2py_f90brownian_def[i_f2py++].data = normaldistsampling;
  f2py_f90brownian_def[i_f2py++].data = normal2ddistsampling;
  f2py_f90brownian_def[i_f2py++].data = initialize_random_seeds;
  f2py_f90brownian_def[i_f2py++].data = lognormal_price_simulation;
  f2py_f90brownian_def[i_f2py++].data = squareroot_diffusion_simulation;
  f2py_f90brownian_def[i_f2py++].data = heston_price_simulation;
}
extern void F_FUNC(f2pyinitf90brownian,F2PYINITF90BROWNIAN)(void (*)(char *,char *,char *,char *,char *,char *,char *,char *));
static void f2py_init_f90brownian(void) {
  F_FUNC(f2pyinitf90brownian,F2PYINITF90BROWNIAN)(f2py_setup_f90brownian);
}

/*need_f90modhooks*/

/************** See f2py2e/rules.py: module_rules['modulebody'] **************/

/******************* See f2py2e/common_rules.py: buildhooks *******************/

/*need_commonhooks*/

/**************************** See f2py2e/rules.py ****************************/

static FortranDataDef f2py_routine_defs[] = {

/*eof routine_defs*/
  {NULL}
};

static PyMethodDef f2py_module_methods[] = {

  {NULL,NULL}
};

static struct PyModuleDef moduledef = {
  PyModuleDef_HEAD_INIT,
  "f90brownian",
  NULL,
  -1,
  f2py_module_methods,
  NULL,
  NULL,
  NULL,
  NULL
};

PyMODINIT_FUNC PyInit_f90brownian(void) {
  int i;
  PyObject *m,*d, *s, *tmp;
  m = f90brownian_module = PyModule_Create(&moduledef);
  Py_SET_TYPE(&PyFortran_Type, &PyType_Type);
  import_array();
  if (PyErr_Occurred())
    {PyErr_SetString(PyExc_ImportError, "can't initialize module f90brownian (failed to import numpy)"); return m;}
  d = PyModule_GetDict(m);
  s = PyUnicode_FromString("1.20.3");
  PyDict_SetItemString(d, "__version__", s);
  Py_DECREF(s);
  s = PyUnicode_FromString(
    "This module 'f90brownian' is auto-generated with f2py (version:1.20.3).\nFunctions:\n"
"Fortran 90/95 modules:\n""  f90brownian --- symmatd2eigen(),inv_errfcn(),normaldistsampling(),normal2ddistsampling(),initialize_random_seeds(),lognormal_price_simulation(),squareroot_diffusion_simulation(),heston_price_simulation()"".");
  PyDict_SetItemString(d, "__doc__", s);
  Py_DECREF(s);
  s = PyUnicode_FromString("1.20.3");
  PyDict_SetItemString(d, "__f2py_numpy_version__", s);
  Py_DECREF(s);
  f90brownian_error = PyErr_NewException ("f90brownian.error", NULL, NULL);
  /*
   * Store the error object inside the dict, so that it could get deallocated.
   * (in practice, this is a module, so it likely will not and cannot.)
   */
  PyDict_SetItemString(d, "_f90brownian_error", f90brownian_error);
  Py_DECREF(f90brownian_error);
  for(i=0;f2py_routine_defs[i].name!=NULL;i++) {
    tmp = PyFortranObject_NewAsAttr(&f2py_routine_defs[i]);
    PyDict_SetItemString(d, f2py_routine_defs[i].name, tmp);
    Py_DECREF(tmp);
  }








/*eof initf2pywraphooks*/
  PyDict_SetItemString(d, "f90brownian", PyFortranObject_New(f2py_f90brownian_def,f2py_init_f90brownian));
/*eof initf90modhooks*/

/*eof initcommonhooks*/


#ifdef F2PY_REPORT_ATEXIT
  if (! PyErr_Occurred())
    on_exit(f2py_report_on_exit,(void*)"f90brownian");
#endif
  return m;
}
#ifdef __cplusplus
}
#endif
