from dataclasses import dataclass

class TAG:

    def __init__(self, name, autoGenerated=False, protectedData=False, id=None, createdAt=None, updatedAt=None):
        self.name = name
        self.autoGenerated = autoGenerated
        self.id = id
        self.createdAt = createdAt
        self.updatedAt = updatedAt
        self.protectedData = protectedData

    def __eq__(self, other):
        return self.name == other.name

    def __repr__(self):
        return f"TAG({self.__dict__})"


class AssetTag:

    def __init__(self, name, assetId, autoTagged=False, protectedData=False, id=None, tagId=None):
        self.name = name
        self.autoTagged = autoTagged
        self.protectedData = protectedData
        self.assetId = assetId
        self.tagId = tagId
        self.id = id

    def __eq__(self, other):
        return self.name == other.name

    def __repr__(self):
        return f"AssetTag({self.__dict__})"


class Watch:

    def __init__(self, assetId, userId, id, createdAt, updatedAt):
        self.assetId = assetId
        self.userId = userId
        self.id = id
        self.createdAt = createdAt
        self.updatedAt = updatedAt

    def __eq__(self, other):
        return self.id == other.id

    def __repr__(self):
        return f"WatchAsset({self.__dict__})"


class AssetActivity:

    def __init__(self, commentCount, downVoteCount, upVoteCount, downvoted=False, upvoted=False):
        self.commentCount = commentCount
        self.downVoteCount = downVoteCount
        self.upVoteCount = upVoteCount
        self.upvoted = upvoted
        self.downvoted = downvoted

    def __repr__(self):
        return f"AssetActivity({self.__dict__})"


class AssetComment:
    def __init__(self, comment, createdAt, updatedAt, userName):
        self.userName = userName
        self.updatedAt = updatedAt
        self.createdAt = createdAt
        self.comment = comment

    def __repr__(self):
        return f"AssetComment({self.__dict__})"


class AssetLabel:

    def __init__(self, key, value):
        self.value = value
        self.key = key

    def __eq__(self, other):
        return self.key == other.key and self.value == other.value

    def __repr__(self):
        return f"AssetLabel({self.__dict__})"

@dataclass
class CustomAssetMetadata:
    """
    Description:
        Custom Asset metadata item
        :param key: (String) key
        :param value: (String) value of custom metadata
    """
    key: str
    value: str


class User:

    def __init__(self, id, name, createdAt, updatedAt):
        self.updatedAt = updatedAt
        self.createdAt = createdAt
        self.name = name
        self.id = id

    def __eq__(self, other):
        return self.id == other.id

    def __repr__(self):
        return f"TorchUser({self.__dict__})"


class APIKeys:

    def __init__(self, accessKey, id, secretKey, updatedAt=None, createdAt=None):
        self.accessKey = accessKey
        self.secretKey = secretKey
        self.updatedAt = updatedAt
        self.createdAt = createdAt
        self.id = id

    def __eq__(self, other):
        return self.accessKey == other.accessKey

    def __repr__(self):
        return f"API-KEYS({self.__dict__})"


class ClassificationConfig:

    def __init__(self, name, description, value, defaultValue, classificationType, classification, enabled=False,
                 protectedData=False, id=None, **kwargs):
        self.name = name
        self.description = description
        self.value = value
        self.defaultValue = defaultValue
        self.classificationType = classificationType
        self.classification = classification
        self.enabled = enabled
        self.protectedData = protectedData
        self.id = id

    def __eq__(self, other):
        return self.id == other.id

    def __repr__(self):
        return f"Classification-config({self.__dict__})"
