# Generated by Django 2.1 on 2018-10-01 19:11

from django.db import migrations


def fill_action_item_fk(apps, schema_editor):
    """Re-save instances to update action_item FK.
    """
    app_label = 'edc_action_item'
    models = ['Reference']
    ActionItem = apps.get_model('edc_action_item', 'ActionItem')
    for model in models:
        model_cls = apps.get_model(app_label, model)
        for obj in model_cls.objects.all():
            action_item = ActionItem.objects.get(
                action_identifier=obj.action_identifier)
            obj.action_item = action_item
            obj.save_base(update_fields=['action_item'])


class Migration(migrations.Migration):

    dependencies = [
        ('edc_action_item', '0010_auto_20181001_2103'),
    ]

    operations = [migrations.RunPython(fill_action_item_fk)]
