import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface TopicConfig extends cdktf.TerraformMetaArguments {
    /**
    * A local path to the avatar image to upload. **Note**: not available for imported resources.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/topic#avatar Topic#avatar}
    */
    readonly avatar?: string;
    /**
    * The hash of the avatar image. Use `filesha256("path/to/avatar.png")` whenever possible. **Note**: this is used to trigger an update of the avatar. If it's not given, but an avatar is given, the avatar will be updated each time.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/topic#avatar_hash Topic#avatar_hash}
    */
    readonly avatarHash?: string;
    /**
    * A text describing the topic.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/topic#description Topic#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/topic#id Topic#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The topic's name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/topic#name Topic#name}
    */
    readonly name: string;
    /**
    * Empty the topics fields instead of deleting it.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/topic#soft_destroy Topic#soft_destroy}
    */
    readonly softDestroy?: boolean | cdktf.IResolvable;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/gitlab/r/topic gitlab_topic}
*/
export declare class Topic extends cdktf.TerraformResource {
    static readonly tfResourceType = "gitlab_topic";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/gitlab/r/topic gitlab_topic} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options TopicConfig
    */
    constructor(scope: Construct, id: string, config: TopicConfig);
    private _avatar?;
    get avatar(): string;
    set avatar(value: string);
    resetAvatar(): void;
    get avatarInput(): string | undefined;
    private _avatarHash?;
    get avatarHash(): string;
    set avatarHash(value: string);
    resetAvatarHash(): void;
    get avatarHashInput(): string | undefined;
    get avatarUrl(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _softDestroy?;
    get softDestroy(): boolean | cdktf.IResolvable;
    set softDestroy(value: boolean | cdktf.IResolvable);
    resetSoftDestroy(): void;
    get softDestroyInput(): boolean | cdktf.IResolvable | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
