/*
 * Decompiled with CFR 0.152.
 */
package py5.core;

import com.jogamp.newt.Window;
import com.jogamp.newt.event.KeyListener;
import com.jogamp.newt.event.MouseListener;
import com.jogamp.newt.event.WindowListener;
import com.jogamp.newt.opengl.GLWindow;
import java.util.HashSet;
import java.util.Set;
import processing.awt.PSurfaceAWT;
import processing.core.PApplet;
import processing.event.MouseEvent;
import py5.core.Py5GraphicsHelper;
import py5.core.Py5Methods;

public class Py5Applet
extends PApplet {
    protected Py5Methods py5Methods;
    protected Set<String> py5RegisteredEvents;
    protected boolean success = false;
    public static final char CODED = '\uffff';
    public static final String HIDDEN = "py5.core.graphics.HiddenPy5GraphicsJava2D";

    public void usePy5Methods(Py5Methods py5Methods) {
        this.py5Methods = py5Methods;
        this.py5RegisteredEvents = new HashSet<String>();
        for (String f : py5Methods.get_function_list()) {
            this.py5RegisteredEvents.add(f);
        }
        this.success = true;
    }

    public boolean getSuccess() {
        return this.success;
    }

    public void settings() {
        if (this.success) {
            if (this.py5RegisteredEvents.contains("settings")) {
                this.success = this.py5Methods.run_method("settings", new Object[0]);
            } else {
                super.settings();
            }
        }
    }

    public void setup() {
        if (this.success) {
            if (this.py5RegisteredEvents.contains("setup")) {
                this.success = this.py5Methods.run_method("setup", new Object[0]);
            } else {
                super.setup();
            }
        }
    }

    public void draw() {
        if (this.success) {
            if (this.py5RegisteredEvents.contains("draw")) {
                this.success = this.py5Methods.run_method("draw", new Object[0]);
            } else {
                super.draw();
            }
        }
    }

    public void preDraw() {
        if (this.success && this.py5RegisteredEvents.contains("pre_draw")) {
            this.success = this.py5Methods.run_method("pre_draw", new Object[0]);
        }
    }

    public void postDraw() {
        if (this.success && this.py5RegisteredEvents.contains("post_draw")) {
            this.success = this.py5Methods.run_method("post_draw", new Object[0]);
        }
    }

    public void mousePressed() {
        if (this.success && this.py5RegisteredEvents.contains("mouse_pressed")) {
            this.success = this.py5Methods.run_method("mouse_pressed", new Object[0]);
        }
    }

    public void mouseReleased() {
        if (this.success && this.py5RegisteredEvents.contains("mouse_released")) {
            this.success = this.py5Methods.run_method("mouse_released", new Object[0]);
        }
    }

    public void mouseClicked() {
        if (this.success && this.py5RegisteredEvents.contains("mouse_clicked")) {
            this.success = this.py5Methods.run_method("mouse_clicked", new Object[0]);
        }
    }

    public void mouseDragged() {
        if (this.success && this.py5RegisteredEvents.contains("mouse_dragged")) {
            this.success = this.py5Methods.run_method("mouse_dragged", new Object[0]);
        }
    }

    public void mouseMoved() {
        if (this.success && this.py5RegisteredEvents.contains("mouse_moved")) {
            this.success = this.py5Methods.run_method("mouse_moved", new Object[0]);
        }
    }

    public void mouseEntered() {
        if (this.success && this.py5RegisteredEvents.contains("mouse_entered")) {
            this.success = this.py5Methods.run_method("mouse_entered", new Object[0]);
        }
    }

    public void mouseExited() {
        if (this.success && this.py5RegisteredEvents.contains("mouse_exited")) {
            this.success = this.py5Methods.run_method("mouse_exited", new Object[0]);
        }
    }

    public void mouseWheel(MouseEvent event) {
        if (this.success && this.py5RegisteredEvents.contains("mouse_wheel")) {
            this.success = this.py5Methods.run_method("mouse_wheel", event);
        }
    }

    public void keyPressed() {
        if (this.success && this.py5RegisteredEvents.contains("key_pressed")) {
            this.success = this.py5Methods.run_method("key_pressed", new Object[0]);
        }
    }

    public void keyReleased() {
        if (this.success && this.py5RegisteredEvents.contains("key_released")) {
            this.success = this.py5Methods.run_method("key_released", new Object[0]);
        }
    }

    public void keyTyped() {
        if (this.success && this.py5RegisteredEvents.contains("key_typed")) {
            this.success = this.py5Methods.run_method("key_typed", new Object[0]);
        }
    }

    public void exitActual() {
        GLWindow window;
        if (this.py5RegisteredEvents.contains("exiting")) {
            this.py5Methods.run_method("exiting", new Object[0]);
        }
        this.py5Methods.shutdown();
        Object nativeWindow = this.surface.getNative();
        if (nativeWindow instanceof GLWindow) {
            window = (GLWindow)nativeWindow;
            for (int i = 0; i < window.getGLEventListenerCount(); ++i) {
                window.disposeGLEventListener(window.getGLEventListener(i), true);
            }
        }
        if (nativeWindow instanceof Window) {
            window = (Window)nativeWindow;
            for (WindowListener windowListener : window.getWindowListeners()) {
                window.removeWindowListener(windowListener);
            }
            for (WindowListener windowListener : window.getKeyListeners()) {
                window.removeKeyListener((KeyListener)windowListener);
            }
            for (WindowListener windowListener : window.getMouseListeners()) {
                window.removeMouseListener((MouseListener)windowListener);
            }
            window.destroy();
        } else if (nativeWindow instanceof PSurfaceAWT.SmoothCanvas) {
            window = (PSurfaceAWT.SmoothCanvas)nativeWindow;
            window.getFrame().dispose();
        } else {
            this.surface.setVisible(false);
        }
    }

    public float getFrameRate() {
        return this.frameRate;
    }

    public boolean isKeyPressed() {
        return this.keyPressed;
    }

    public boolean isMousePressed() {
        return this.mousePressed;
    }

    public void points(float[][] coordinates) {
        if (this.recorder != null) {
            Py5GraphicsHelper.points(this.recorder, coordinates);
        }
        Py5GraphicsHelper.points(this.g, coordinates);
    }

    public void lines(float[][] coordinates) {
        if (this.recorder != null) {
            Py5GraphicsHelper.lines(this.recorder, coordinates);
        }
        Py5GraphicsHelper.lines(this.g, coordinates);
    }

    public void vertices(float[][] coordinates) {
        if (this.recorder != null) {
            Py5GraphicsHelper.vertices(this.recorder, coordinates);
        }
        Py5GraphicsHelper.vertices(this.g, coordinates);
    }

    public void bezierVertices(float[][] coordinates) {
        if (this.recorder != null) {
            Py5GraphicsHelper.bezierVertices(this.recorder, coordinates);
        }
        Py5GraphicsHelper.bezierVertices(this.g, coordinates);
    }

    public void curveVertices(float[][] coordinates) {
        if (this.recorder != null) {
            Py5GraphicsHelper.curveVertices(this.recorder, coordinates);
        }
        Py5GraphicsHelper.curveVertices(this.g, coordinates);
    }

    public void quadraticVertices(float[][] coordinates) {
        if (this.recorder != null) {
            Py5GraphicsHelper.quadraticVertices(this.recorder, coordinates);
        }
        Py5GraphicsHelper.quadraticVertices(this.g, coordinates);
    }
}

