/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools;

import com.sas.beans.Introspector;
import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.EventSetDescriptor;
import java.beans.MethodDescriptor;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.Method;

public class Introspect {
    boolean useSASIntrospector = true;
    Class theClass = null;
    String indent = "";

    void indent() {
        this.indent = this.indent + "  ";
    }

    void dedent() {
        this.indent = this.indent.substring(2);
    }

    public static void main(String[] argv) {
        boolean useSAS = false;
        for (int argc = 0; argc < argv.length; ++argc) {
            if ("-sas".equals(argv[argc])) {
                useSAS = true;
                continue;
            }
            if ("-beans".equals(argv[argc])) {
                useSAS = false;
                continue;
            }
            System.out.println("Introspecting : " + argv[argc]);
            new Introspect(argv[argc], useSAS).introspect();
        }
    }

    public Introspect(String className, boolean useSASIntrospector) {
        try {
            this.useSASIntrospector = useSASIntrospector;
            this.theClass = Class.forName(className);
        }
        catch (Exception e) {
            System.out.println("Introspect(String, boolean) exception:" + e.getMessage());
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
    }

    void introspect() {
        try {
            BeanInfo beanInfo;
            if (this.useSASIntrospector) {
                System.out.println("use com.sas.beans.Introspector");
                beanInfo = Introspector.getBeanInfo(this.theClass);
            } else {
                System.out.println("use java.beans.Introspector");
                beanInfo = java.beans.Introspector.getBeanInfo(this.theClass);
            }
            this.print(beanInfo);
        }
        catch (Exception e) {
            System.out.println("introspect() exception:" + e.getMessage());
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void print(BeanInfo info) {
        try {
            this.print(info.getBeanDescriptor());
            this.indent();
            PropertyDescriptor[] pda = info.getPropertyDescriptors();
            for (int i = 0; i < pda.length; ++i) {
                this.print(pda[i]);
            }
            EventSetDescriptor[] esds = info.getEventSetDescriptors();
            for (int i = 0; i < esds.length; ++i) {
                this.print(esds[i]);
            }
        }
        catch (Exception e) {
            System.out.println("print(BeanInfo) exception:" + e.getMessage());
            System.err.println(e);
        }
        finally {
            this.dedent();
        }
    }

    void print(BeanDescriptor bd) {
        this.print("bean: ", bd.getBeanClass());
        this.print("customizer: ", bd.getCustomizerClass());
    }

    void print(EventSetDescriptor esd) {
        this.print("listener type: ", esd.getListenerType());
        this.indent();
        this.print(esd.getAddListenerMethod());
        this.print(esd.getListenerMethodDescriptors());
        this.print(esd.getListenerMethods());
        this.print(esd.getRemoveListenerMethod());
        System.out.println(this.indent + "is in default event set: " + esd.isInDefaultEventSet());
        System.out.println(this.indent + "is Unicast: " + esd.isUnicast());
        this.dedent();
    }

    void print(Method[] methods) {
        this.indent();
        for (int i = 0; i < methods.length; ++i) {
            this.print(methods[i]);
        }
        this.dedent();
    }

    void print(MethodDescriptor[] methods) {
        this.indent();
        for (int i = 0; i < methods.length; ++i) {
            this.print(methods[i]);
        }
        this.dedent();
    }

    void print(Method method) {
        System.out.println(this.indent + "method " + method);
    }

    void print(MethodDescriptor method) {
        this.print(method.getMethod());
    }

    void print(String label, Class aClass) {
        System.out.println(this.indent + label + aClass);
    }

    void print(PropertyDescriptor pd) {
        String name = pd.getName();
        Class<?> type = pd.getPropertyType();
        Method readMethod = pd.getReadMethod();
        Method writeMethod = pd.getWriteMethod();
        PropertyEditor pe = null;
        if (type != null) {
            pe = PropertyEditorManager.findEditor(type);
        }
        Class<?> propertyEditor = pe == null ? null : pe.getClass();
        String bound = pd.isBound() ? "bound " : "unbound ";
        String constrained = pd.isConstrained() ? "constrained " : "unconstrained ";
        System.out.println(this.indent + "Property  : " + bound + constrained + type + " " + name);
        System.out.println(this.indent + "   Read   : " + readMethod);
        System.out.println(this.indent + "   Write  : " + writeMethod);
        System.out.println(this.indent + "   Editor : " + (propertyEditor == null ? "none" : propertyEditor.getName()));
        System.out.println(this.indent + "   Hidden : " + pd.isHidden());
        System.out.println(this.indent + "   Expert : " + pd.isExpert());
    }
}

