/*
 * Decompiled with CFR 0.152.
 */
package com.sas.text;

import com.sas.codepolicy.SASScope;
import com.sas.text.FormatDescription;
import com.sas.text.SASFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

@SASScope
abstract class TableEntry
implements FormatDescription {
    private ResourceBundle formatResource;
    private ResourceBundle NLformatResource;
    private ResourceBundle NLdatetimeResource;
    private Locale locale;
    private Locale formatLocale;
    protected String format;
    protected String className;
    protected int minWidth;
    protected int maxWidth;
    protected int defaultWidth;
    protected boolean isUniform = false;
    private static final String DESCRIPTION = ".description";
    private static final String NA = "na";

    protected TableEntry() {
    }

    protected TableEntry(String format, String className) {
        if (Character.isDigit(format.charAt(format.length() - 1))) {
            throw new RuntimeException("ERROR: The format name " + format + " ends in a number, which is invalid");
        }
        this.format = format;
        this.className = className;
        this.minWidth = 1;
        this.maxWidth = 200;
        this.defaultWidth = -1;
        this.formatLocale = Locale.getDefault();
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    public void setDefaultWidth(int width) {
        this.defaultWidth = width;
    }

    @Override
    public int getDefaultWidth() {
        return this.defaultWidth;
    }

    public void setMaxWidth(int width) {
        this.maxWidth = width;
    }

    @Override
    public int getMaxWidth() {
        return this.maxWidth;
    }

    public void setMinWidth(int width) {
        this.minWidth = width;
    }

    @Override
    public int getMinWidth() {
        return this.minWidth;
    }

    @Override
    public String getDescription() {
        return this.getDescription(Locale.getDefault());
    }

    @Override
    public String getDescription(Locale locale) {
        String formatNames = this.getBaseFormatName();
        String descriptions = null;
        if (this.locale == null || !this.locale.equals(locale)) {
            try {
                this.locale = locale;
                this.formatResource = ResourceBundle.getBundle(SASFormat.class.getName(), locale);
            }
            catch (MissingResourceException mre) {
                this.locale = null;
                this.formatResource = null;
            }
        }
        if (this.formatResource != null) {
            try {
                descriptions = this.formatResource.getString(formatNames.toLowerCase() + DESCRIPTION);
            }
            catch (MissingResourceException mre) {
                descriptions = this.formatResource.getString("na.description");
            }
        }
        return descriptions;
    }

    public void setFormatLocale(Locale locale) {
        this.formatLocale = locale;
    }

    public Locale getFormatLocale() {
        return this.formatLocale;
    }

    public String getString(String key) {
        String resourceString = null;
        if (this.NLformatResource == null) {
            try {
                this.NLformatResource = ResourceBundle.getBundle("com/sas/text/locale/NLFormat", this.formatLocale);
            }
            catch (MissingResourceException mre) {
                this.NLformatResource = null;
            }
        }
        if (this.NLformatResource != null) {
            try {
                resourceString = this.NLformatResource.getString(key);
            }
            catch (MissingResourceException mre) {
                System.out.println("Resource Key " + key + " not found.");
            }
        }
        return resourceString;
    }

    public String getDatetimeString(String key) {
        String resourceString = null;
        if (this.NLdatetimeResource == null) {
            try {
                this.NLdatetimeResource = ResourceBundle.getBundle("com/sas/text/locale/NLDateTime", this.formatLocale);
            }
            catch (MissingResourceException mre) {
                this.NLdatetimeResource = null;
            }
        }
        if (this.NLdatetimeResource != null) {
            try {
                resourceString = this.NLdatetimeResource.getString(key);
            }
            catch (MissingResourceException mre) {
                System.out.println("Datetime Resource Key " + key + " not found.");
            }
        }
        return resourceString;
    }

    boolean isUniform() {
        return this.isUniform;
    }

    void setUniform(boolean uniform) {
        this.isUniform = uniform;
    }
}

