/*
 * Decompiled with CFR 0.152.
 */
package com.sas;

import com.sas.RB;
import com.sas.codepolicy.SASScope;
import com.sas.util.LocalizableString;
import com.sas.util.Strings;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Locale;

@SASScope
public final class SpecialValues
implements Comparable,
Serializable {
    private static final long serialVersionUID = -9096700714683482005L;
    public static final String RB_KEY = "SpecialValues.";
    private static HashMap nameLookup = new HashMap(3);
    private static SpecialValues[] ordinalLookup = new SpecialValues[3];
    public static final SpecialValues OTHER = new SpecialValues("-OTHER-", "other.txt", Locale.getDefault(), 0);
    public static final SpecialValues ALL = new SpecialValues("-ALL-", "all.txt", Locale.getDefault(), 1);
    public static final SpecialValues NONE = new SpecialValues("-NONE-", "none.txt", Locale.getDefault(), 2);
    private final String key;
    private String name;
    private LocalizableString label;
    private final int ordinal;

    private SpecialValues(String name, String key, Locale locale, int position) {
        this.name = name;
        this.ordinal = position;
        this.key = RB_KEY + key;
        SpecialValues.ordinalLookup[position] = this;
        this.label = new LocalizableString();
        String printName = RB.getStringResource(this.key, locale);
        this.label.setText(printName, locale);
        nameLookup.put(name, this);
    }

    public int compareTo(Object arg) {
        if (arg instanceof SpecialValues) {
            return this.ordinal - ((SpecialValues)arg).ordinal;
        }
        return -1;
    }

    public String toString() {
        return this.toString(Locale.getDefault());
    }

    public String toString(Locale locale) {
        if (this.label.isTextSet(locale)) {
            return this.label.getText(locale);
        }
        String ret = RB.getStringResource(this.key, locale);
        this.label.setText(ret, locale);
        return ret;
    }

    public String getName() {
        return this.name;
    }

    public static SpecialValues valueOf(String label, Locale locale) {
        for (int i = 0; i < ordinalLookup.length; ++i) {
            SpecialValues sv = ordinalLookup[i];
            if (!Strings.equal(label, sv.toString(locale), false, false)) continue;
            return sv;
        }
        return null;
    }

    public static SpecialValues valueOf(String name) {
        return (SpecialValues)nameLookup.get(name);
    }

    public static String toDisplayString(SpecialValues input, Locale locale) {
        String retVal = null;
        if (null != input) {
            if (input.equals(ALL)) {
                retVal = RB.getStringResource("SpecialValues.formatted.all.txt", locale);
            } else if (input.equals(OTHER)) {
                retVal = RB.getStringResource("SpecialValues.formatted.other.txt", locale);
            }
        }
        return retVal;
    }

    protected Object readResolve() throws ObjectStreamException {
        if (this.ordinal == 0) {
            return OTHER;
        }
        if (this.ordinal == 1) {
            return ALL;
        }
        if (this.ordinal == 2) {
            return NONE;
        }
        return null;
    }
}

