"""Default ComfyUI models configuration"""

COMFYUI_MODELS_CONFIG = {
    "version": "2024.1",
    "default_extensions": [
        ".ckpt",
        ".pt",
        ".pth",
        ".pt2",
        ".bin",
        ".safetensors",
        ".pkl",
        ".sft",
    ],
    "standard_directories": [
        "audio_encoders",
        "checkpoints",
        "clip",
        "clip_vision",
        "configs",
        "controlnet",
        "diffusers",
        "diffusion_models",
        "embeddings",
        "gligen",
        "hypernetworks",
        "loras",
        "model_patches",
        "photomaker",
        "style_models",
        "text_encoders",
        "unet",
        "upscale_models",
        "vae",
        "vae_approx",
    ],
    "directory_overrides": {"configs": {"extensions": [".yaml", ".yml", ".json"]}},
    "node_directory_mappings": {
        "CheckpointLoaderSimple": ["checkpoints"],
        "CheckpointLoader": ["checkpoints", "configs"],
        "unCLIPCheckpointLoader": ["checkpoints"],
        "ImageOnlyCheckpointLoader": ["checkpoints"],
        "VAELoader": ["vae", "vae_approx"],
        "LoraLoader": ["loras"],
        "LoraLoaderModelOnly": ["loras"],
        "CLIPLoader": ["clip"],
        "DualCLIPLoader": ["clip"],
        "TripleCLIPLoader": ["clip"],
        "QuadrupleCLIPLoader": ["clip"],
        "UNETLoader": ["diffusion_models"],
        "CLIPVisionLoader": ["clip_vision"],
        "ControlNetLoader": ["controlnet"],
        "DiffControlNetLoader": ["controlnet"],
        "StyleModelLoader": ["style_models"],
        "UpscaleModelLoader": ["upscale_models"],
        "GLIGENLoader": ["gligen"],
        "HypernetworkLoader": ["hypernetworks"],
        "PhotoMakerLoader": ["photomaker"],
        "DiffusersLoader": ["diffusers"],
    },
    "node_widget_indices": {"CheckpointLoader": 1},
}
