"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.InstanceType = exports.InstanceSize = exports.InstanceArchitecture = exports.InstanceClass = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * What class and generation of instance to use
 *
 * We have both symbolic and concrete enums for every type.
 *
 * The first are for people that want to specify by purpose,
 * the second one are for people who already know exactly what
 * 'R4' means.
 */
var InstanceClass;
(function (InstanceClass) {
    /**
     * Standard instances, 3rd generation
     */
    InstanceClass["STANDARD3"] = "m3";
    /**
     * Standard instances, 3rd generation
     */
    InstanceClass["M3"] = "m3";
    /**
     * Standard instances, 4th generation
     */
    InstanceClass["STANDARD4"] = "m4";
    /**
     * Standard instances, 4th generation
     */
    InstanceClass["M4"] = "m4";
    /**
     * Standard instances, 5th generation
     */
    InstanceClass["STANDARD5"] = "m5";
    /**
     * Standard instances, 5th generation
     */
    InstanceClass["M5"] = "m5";
    /**
     * Standard instances with local NVME drive, 5th generation
     */
    InstanceClass["STANDARD5_NVME_DRIVE"] = "m5d";
    /**
     * Standard instances with local NVME drive, 5th generation
     */
    InstanceClass["M5D"] = "m5d";
    /**
     * Standard instances based on AMD EPYC, 5th generation
     */
    InstanceClass["STANDARD5_AMD"] = "m5a";
    /**
     * Standard instances based on AMD EPYC, 5th generation
     */
    InstanceClass["M5A"] = "m5a";
    /**
     * Standard instances based on AMD EPYC with local NVME drive, 5th generation
     */
    InstanceClass["STANDARD5_AMD_NVME_DRIVE"] = "m5ad";
    /**
     * Standard instances based on AMD EPYC with local NVME drive, 5th generation
     */
    InstanceClass["M5AD"] = "m5ad";
    /**
     * Standard instances for high performance computing, 5th generation
     */
    InstanceClass["STANDARD5_HIGH_PERFORMANCE"] = "m5n";
    /**
     * Standard instances for high performance computing, 5th generation
     */
    InstanceClass["M5N"] = "m5n";
    /**
     * Standard instances with local NVME drive for high performance computing, 5th generation
     */
    InstanceClass["STANDARD5_NVME_DRIVE_HIGH_PERFORMANCE"] = "m5dn";
    /**
     * Standard instances with local NVME drive for high performance computing, 5th generation
     */
    InstanceClass["M5DN"] = "m5dn";
    /**
     * Standard instances with high memory and compute capacity based on Intel Xeon Scalable (Cascade Lake) processors, 5nd generation
     */
    InstanceClass["STANDARD5_HIGH_COMPUTE"] = "m5zn";
    /**
     * Standard instances with high memory and compute capacity based on Intel Xeon Scalable (Cascade Lake) processors, 5nd generation
     */
    InstanceClass["M5ZN"] = "m5zn";
    /**
     * Memory optimized instances, 3rd generation
     */
    InstanceClass["MEMORY3"] = "r3";
    /**
     * Memory optimized instances, 3rd generation
     */
    InstanceClass["R3"] = "r3";
    /**
     * Memory optimized instances, 4th generation
     */
    InstanceClass["MEMORY4"] = "r4";
    /**
     * Memory optimized instances, 4th generation
     */
    InstanceClass["R4"] = "r4";
    /**
     * Memory optimized instances, 5th generation
     */
    InstanceClass["MEMORY5"] = "r5";
    /**
     * Memory optimized instances, 5th generation
     */
    InstanceClass["R5"] = "r5";
    /**
     * Memory optimized instances, 6th generation with Intel Xeon Scalable processors (3rd generation processors code named Ice Lake)
     */
    InstanceClass["MEMORY6_INTEL"] = "r6i";
    /**
     * Memory optimized instances, 6th generation with Intel Xeon Scalable processors (3rd generation processors code named Ice Lake)
     */
    InstanceClass["R6I"] = "r6i";
    /**
     * Memory optimized instances for high performance computing, 5th generation
     */
    InstanceClass["MEMORY5_HIGH_PERFORMANCE"] = "r5n";
    /**
     * Memory optimized instances for high performance computing, 5th generation
     */
    InstanceClass["R5N"] = "r5n";
    /**
     * Memory optimized instances with local NVME drive, 5th generation
     */
    InstanceClass["MEMORY5_NVME_DRIVE"] = "r5d";
    /**
     * Memory optimized instances with local NVME drive, 5th generation
     */
    InstanceClass["R5D"] = "r5d";
    /**
     * Memory optimized instances with local NVME drive for high performance computing, 5th generation
     */
    InstanceClass["MEMORY5_NVME_DRIVE_HIGH_PERFORMANCE"] = "r5dn";
    /**
     * Memory optimized instances with local NVME drive for high performance computing, 5th generation
     */
    InstanceClass["R5DN"] = "r5dn";
    /**
     * Memory optimized instances based on AMD EPYC, 5th generation
     */
    InstanceClass["MEMORY5_AMD"] = "r5a";
    /**
     * Memory optimized instances based on AMD EPYC, 5th generation
     */
    InstanceClass["R5A"] = "r5a";
    /**
     * Memory optimized instances based on AMD EPYC with local NVME drive, 5th generation
     */
    InstanceClass["MEMORY5_AMD_NVME_DRIVE"] = "r5ad";
    /**
     * High memory instances (6TB) based on Intel Xeon Platinum 8176M (Skylake) processors, 1st generation
     */
    InstanceClass["HIGH_MEMORY_6TB_1"] = "u-6tb1";
    /**
     * High memory instances (6TB) based on Intel Xeon Platinum 8176M (Skylake) processors, 1st generation
     */
    InstanceClass["U_6TB1"] = "u-6tb1";
    /**
     * High memory instances (9TB) based on Intel Xeon Platinum 8176M (Skylake) processors, 1st generation
     */
    InstanceClass["HIGH_MEMORY_9TB_1"] = "u-9tb1";
    /**
     * High memory instances (9TB) based on Intel Xeon Platinum 8176M (Skylake) processors, 1st generation
     */
    InstanceClass["U_9TB1"] = "u-9tb1";
    /**
     * High memory instances (12TB) based on Intel Xeon Platinum 8176M (Skylake) processors, 1st generation
     */
    InstanceClass["HIGH_MEMORY_12TB_1"] = "u-12tb1";
    /**
     * High memory instances (12TB) based on Intel Xeon Platinum 8176M (Skylake) processors, 1st generation
     */
    InstanceClass["U_12TB1"] = "u-12tb1";
    /**
     * High memory instances (18TB) based on Intel Xeon Scalable (Cascade Lake) processors, 1st generation
     */
    InstanceClass["HIGH_MEMORY_18TB_1"] = "u-18tb1";
    /**
     * High memory instances (18TB) based on Intel Xeon Scalable (Cascade Lake) processors, 1st generation
     */
    InstanceClass["U_18TB1"] = "u-18tb1";
    /**
     * High memory instances (24TB) based on Intel Xeon Scalable (Cascade Lake) processors, 1st generation
     */
    InstanceClass["HIGH_MEMORY_24TB_1"] = "u-24tb1";
    /**
     * High memory instances (24TB) based on Intel Xeon Scalable (Cascade Lake) processors, 1st generation
     */
    InstanceClass["U_24TB1"] = "u-24tb1";
    /**
     * Memory optimized instances based on AMD EPYC with local NVME drive, 5th generation
     */
    InstanceClass["R5AD"] = "r5ad";
    /**
     * Memory optimized instances that are also EBS-optimized, 5th generation
     */
    InstanceClass["MEMORY5_EBS_OPTIMIZED"] = "r5b";
    /**
     * Memory optimized instances that are also EBS-optimized, 5th generation
     */
    InstanceClass["R5B"] = "r5b";
    /**
     * Memory optimized instances, 6th generation with Graviton2 processors
     */
    InstanceClass["MEMORY6_GRAVITON"] = "r6g";
    /**
     * Memory optimized instances, 6th generation with Graviton2 processors
     */
    InstanceClass["R6G"] = "r6g";
    /**
     * Memory optimized instances, 6th generation with Graviton2 processors and local NVME drive
     */
    InstanceClass["MEMORY6_GRAVITON2_NVME_DRIVE"] = "r6gd";
    /**
     * Memory optimized instances, 6th generation with Graviton2 processors and local NVME drive
     */
    InstanceClass["R6GD"] = "r6gd";
    /**
     * Compute optimized instances, 3rd generation
     */
    InstanceClass["COMPUTE3"] = "c3";
    /**
     * Compute optimized instances, 3rd generation
     */
    InstanceClass["C3"] = "c3";
    /**
     * Compute optimized instances, 4th generation
     */
    InstanceClass["COMPUTE4"] = "c4";
    /**
     * Compute optimized instances, 4th generation
     */
    InstanceClass["C4"] = "c4";
    /**
     * Compute optimized instances, 5th generation
     */
    InstanceClass["COMPUTE5"] = "c5";
    /**
     * Compute optimized instances, 5th generation
     */
    InstanceClass["C5"] = "c5";
    /**
     * Compute optimized instances with local NVME drive, 5th generation
     */
    InstanceClass["COMPUTE5_NVME_DRIVE"] = "c5d";
    /**
     * Compute optimized instances with local NVME drive, 5th generation
     */
    InstanceClass["C5D"] = "c5d";
    /**
     * Compute optimized instances based on AMD EPYC, 5th generation
     */
    InstanceClass["COMPUTE5_AMD"] = "c5a";
    /**
     * Compute optimized instances based on AMD EPYC, 5th generation
     */
    InstanceClass["C5A"] = "c5a";
    /**
     * Compute optimized instances with local NVME drive based on AMD EPYC, 5th generation
     */
    InstanceClass["COMPUTE5_AMD_NVME_DRIVE"] = "c5ad";
    /**
     * Compute optimized instances with local NVME drive based on AMD EPYC, 5th generation
     */
    InstanceClass["C5AD"] = "c5ad";
    /**
     * Compute optimized instances for high performance computing, 5th generation
     */
    InstanceClass["COMPUTE5_HIGH_PERFORMANCE"] = "c5n";
    /**
     * Compute optimized instances for high performance computing, 5th generation
     */
    InstanceClass["C5N"] = "c5n";
    /**
     * Compute optimized instances, 6th generation
     */
    InstanceClass["COMPUTE6_INTEL"] = "c6i";
    /**
    * Compute optimized instances, 6th generation
    */
    InstanceClass["C6I"] = "c6i";
    /**
    * Compute optimized instances based on AMD EPYC (codename Milan), 6th generation
    */
    InstanceClass["COMPUTE6_AMD"] = "c6a";
    /**
    * Compute optimized instances based on AMD EPYC (codename Milan), 6th generation
    */
    InstanceClass["C6A"] = "c6a";
    /**
     * Compute optimized instances for high performance computing, 6th generation with Graviton2 processors
     */
    InstanceClass["COMPUTE6_GRAVITON2"] = "c6g";
    /**
     * Compute optimized instances for high performance computing, 6th generation with Graviton2 processors
     */
    InstanceClass["C6G"] = "c6g";
    /**
     * Compute optimized instances for high performance computing, 6th generation with Graviton2 processors
     * and local NVME drive
     */
    InstanceClass["COMPUTE6_GRAVITON2_NVME_DRIVE"] = "c6gd";
    /**
     * Compute optimized instances for high performance computing, 6th generation with Graviton2 processors
     * and local NVME drive
     */
    InstanceClass["C6GD"] = "c6gd";
    /**
     * Compute optimized instances for high performance computing, 6th generation with Graviton2 processors
     * and high network bandwidth capabilities
     */
    InstanceClass["COMPUTE6_GRAVITON2_HIGH_NETWORK_BANDWITH"] = "c6gn";
    /**
     * Compute optimized instances for high performance computing, 6th generation with Graviton2 processors
     * and high network bandwidth capabilities
     */
    InstanceClass["C6GN"] = "c6gn";
    /**
     * Storage-optimized instances, 2nd generation
     */
    InstanceClass["STORAGE2"] = "d2";
    /**
     * Storage-optimized instances, 2nd generation
     */
    InstanceClass["D2"] = "d2";
    /**
     * Storage-optimized instances, 3rd generation
     */
    InstanceClass["STORAGE3"] = "d3";
    /**
     * Storage-optimized instances, 3rd generation
     */
    InstanceClass["D3"] = "d3";
    /**
    * Storage-optimized instances, 3rd generation
    */
    InstanceClass["STORAGE3_ENHANCED_NETWORK"] = "d3en";
    /**
    * Storage-optimized instances, 3rd generation
    */
    InstanceClass["D3EN"] = "d3en";
    /**
     * Storage/compute balanced instances, 1st generation
     */
    InstanceClass["STORAGE_COMPUTE_1"] = "h1";
    /**
     * Storage/compute balanced instances, 1st generation
     */
    InstanceClass["H1"] = "h1";
    /**
     * I/O-optimized instances, 3rd generation
     */
    InstanceClass["IO3"] = "i3";
    /**
     * I/O-optimized instances, 3rd generation
     */
    InstanceClass["I3"] = "i3";
    /**
     * I/O-optimized instances with local NVME drive, 3rd generation
     */
    InstanceClass["IO3_DENSE_NVME_DRIVE"] = "i3en";
    /**
     * I/O-optimized instances with local NVME drive, 3rd generation
     */
    InstanceClass["I3EN"] = "i3en";
    /**
     * Storage optimized instances powered by Graviton2 processor, 4th generation
     */
    InstanceClass["STORAGE4_GRAVITON_NETWORK_OPTIMIZED"] = "im4gn";
    /**
     * Storage optimized instances powered by Graviton2 processor, 4th generation
     */
    InstanceClass["IM4GN"] = "im4gn";
    /**
     * Storage optimized instances powered by Graviton2 processor, 4th generation
     */
    InstanceClass["STORAGE4_GRAVITON_NETWORK_STORAGE_OPTIMIZED"] = "is4gen";
    /**
     * Storage optimized instances powered by Graviton2 processor, 4th generation
     */
    InstanceClass["IS4GEN"] = "is4gen";
    /**
     * Burstable instances, 2nd generation
     */
    InstanceClass["BURSTABLE2"] = "t2";
    /**
     * Burstable instances, 2nd generation
     */
    InstanceClass["T2"] = "t2";
    /**
     * Burstable instances, 3rd generation
     */
    InstanceClass["BURSTABLE3"] = "t3";
    /**
     * Burstable instances, 3rd generation
     */
    InstanceClass["T3"] = "t3";
    /**
     * Burstable instances based on AMD EPYC, 3rd generation
     */
    InstanceClass["BURSTABLE3_AMD"] = "t3a";
    /**
     * Burstable instances based on AMD EPYC, 3rd generation
     */
    InstanceClass["T3A"] = "t3a";
    /**
     * Burstable instances, 4th generation with Graviton2 processors
     */
    InstanceClass["BURSTABLE4_GRAVITON"] = "t4g";
    /**
     * Burstable instances, 4th generation with Graviton2 processors
     */
    InstanceClass["T4G"] = "t4g";
    /**
     * Memory-intensive instances, 1st generation
     */
    InstanceClass["MEMORY_INTENSIVE_1"] = "x1";
    /**
     * Memory-intensive instances, 1st generation
     */
    InstanceClass["X1"] = "x1";
    /**
     * Memory-intensive instances, extended, 1st generation
     */
    InstanceClass["MEMORY_INTENSIVE_1_EXTENDED"] = "x1e";
    /**
     * Memory-intensive instances, 1st generation
     */
    InstanceClass["X1E"] = "x1e";
    /**
     * Memory-intensive instances, 2nd generation with Graviton2 processors
     *
     * This instance type can be used only in RDS. It is not supported in EC2.
     */
    InstanceClass["MEMORY_INTENSIVE_2_GRAVITON2"] = "x2g";
    /**
     * Memory-intensive instances, 2nd generation with Graviton2 processors
     *
     * This instance type can be used only in RDS. It is not supported in EC2.
     */
    InstanceClass["X2G"] = "x2g";
    /**
     * Memory-intensive instances, 2nd generation with Graviton2 processors and local NVME drive
     */
    InstanceClass["MEMORY_INTENSIVE_2_GRAVITON2_NVME_DRIVE"] = "x2gd";
    /**
     * Memory-intensive instances, 2nd generation with Graviton2 processors and local NVME drive
     */
    InstanceClass["X2GD"] = "x2gd";
    /**
     * Memory-intensive instances with higher network bandwith, local NVME drive, and extended memory. Intel Xeon Scalable (Ice Lake) processors
     */
    InstanceClass["MEMORY_INTENSIVE_2_XT_INTEL"] = "x2iedn";
    /**
     *  Memory-intensive instances with higher network bandwith, local NVME drive, and extended memory. Intel Xeon Scalable (Ice Lake) processors
     */
    InstanceClass["X2IEDN"] = "x2iedn";
    /**
     * Memory-intensive instances with higher network bandwith and local NVME drive, Intel Xeon Scalable (Ice Lake) processors
     */
    InstanceClass["MEMORY_INTENSIVE_2_INTEL"] = "x2idn";
    /**
     * Memory-intensive instances with higher network bandwith and local NVME drive, Intel Xeon Scalable (Ice Lake) processors
     */
    InstanceClass["X2IDN"] = "x2idn";
    /**
     * Memory-intensive instances with higher network bandwith and single-threaded performance, Intel Xeon Scalable (Cascade Lake) processors
     */
    InstanceClass["MEMORY_INTENSIVE_2_XTZ_INTEL"] = "x2iezn";
    /**
     * Memory-intensive instances with higher network bandwith and single-threaded performance, Intel Xeon Scalable (Cascade Lake) processors
     */
    InstanceClass["X2IEZN"] = "x2iezn";
    /**
     * Instances with customizable hardware acceleration, 1st generation
     */
    InstanceClass["FPGA1"] = "f1";
    /**
     * Instances with customizable hardware acceleration, 1st generation
     */
    InstanceClass["F1"] = "f1";
    /**
     * Graphics-optimized instances, 3rd generation
     */
    InstanceClass["GRAPHICS3"] = "g3";
    /**
     * Graphics-optimized instances, 3rd generation
     */
    InstanceClass["G3"] = "g3";
    /**
     * Graphics-optimized instances with NVME drive for high performance computing, 4th generation
     */
    InstanceClass["GRAPHICS4_NVME_DRIVE_HIGH_PERFORMANCE"] = "g4dn";
    /**
     * Graphics-optimized instances with NVME drive for high performance computing, 4th generation
     */
    InstanceClass["G4DN"] = "g4dn";
    /**
     * Graphics-optimized instances based on AMD EPYC And Radeon Pro GPU (NAVI) with local NVME drive, 4th generation
     */
    InstanceClass["GRAPHICS4_AMD_NVME_DRIVE"] = "g4ad";
    /**
     * Graphics-optimized instances based on AMD EPYC And Radeon Pro GPU (NAVI) with local NVME drive, 4th generation
     */
    InstanceClass["G4AD"] = "g4ad";
    /**
     * Graphics-optimized instances, 5th generation
     */
    InstanceClass["GRAPHICS5"] = "g5";
    /**
     * Graphics-optimized instances, 5th generation
     */
    InstanceClass["G5"] = "g5";
    /**
     * Graphics-optimized instances powered by AWS Graviton2 Processors and NVIDIA T4G Tensor Core GPUs, 5th generation
     */
    InstanceClass["GRAPHICS5_GRAVITON2"] = "g5g";
    /**
    * Graphics-optimized instances powered by AWS Graviton2 Processors and NVIDIA T4G Tensor Core GPUs, 5th generation
    */
    InstanceClass["G5G"] = "g5g";
    /**
     * Parallel-processing optimized instances, 2nd generation
     */
    InstanceClass["PARALLEL2"] = "p2";
    /**
     * Parallel-processing optimized instances, 2nd generation
     */
    InstanceClass["P2"] = "p2";
    /**
     * Parallel-processing optimized instances, 3nd generation
     */
    InstanceClass["PARALLEL3"] = "p3";
    /**
     * Parallel-processing optimized instances, 3rd generation
     */
    InstanceClass["P3"] = "p3";
    /**
     * Parallel-processing optimized instances, 4th generation
     */
    InstanceClass["PARALLEL4"] = "p4d";
    /**
     * Parallel-processing optimized instances, 4th generation
     */
    InstanceClass["P4D"] = "p4d";
    /**
     * Arm processor based instances, 1st generation
     */
    InstanceClass["ARM1"] = "a1";
    /**
     * Arm processor based instances, 1st generation
     */
    InstanceClass["A1"] = "a1";
    /**
     * Arm processor based instances, 2nd generation
     */
    InstanceClass["STANDARD6_GRAVITON"] = "m6g";
    /**
     * Arm processor based instances, 2nd generation
     */
    InstanceClass["M6G"] = "m6g";
    /**
     * Standard instances based on Intel (Ice Lake), 6th generation.
     */
    InstanceClass["STANDARD6_INTEL"] = "m6i";
    /**
     * Standard instances based on Intel (Ice Lake), 6th generation.
     */
    InstanceClass["M6I"] = "m6i";
    /**
     * Standard instances based on 3rd Gen AMD EPYC processors, 6th generation.
     */
    InstanceClass["STANDARD6_AMD"] = "m6a";
    /**
    * Standard instances based on 3rd Gen AMD EPYC processors, 6th generation.
    */
    InstanceClass["M6A"] = "m6a";
    /**
     * Standard instances, 6th generation with Graviton2 processors and local NVME drive
     */
    InstanceClass["STANDARD6_GRAVITON2_NVME_DRIVE"] = "m6gd";
    /**
     * Standard instances, 6th generation with Graviton2 processors and local NVME drive
     */
    InstanceClass["M6GD"] = "m6gd";
    /**
     * High memory and compute capacity instances, 1st generation
     */
    InstanceClass["HIGH_COMPUTE_MEMORY1"] = "z1d";
    /**
     * High memory and compute capacity instances, 1st generation
     */
    InstanceClass["Z1D"] = "z1d";
    /**
     * Inferentia Chips based instances for machine learning inference applications, 1st generation
     */
    InstanceClass["INFERENCE1"] = "inf1";
    /**
     * Inferentia Chips based instances for machine learning inference applications, 1st generation
     */
    InstanceClass["INF1"] = "inf1";
    /**
     * Macintosh instances built on Apple Mac mini computers, 1st generation with Intel procesors
     */
    InstanceClass["MACINTOSH1_INTEL"] = "mac1";
    /**
     * Macintosh instances built on Apple Mac mini computers, 1st generation with Intel procesors
     */
    InstanceClass["MAC1"] = "mac1";
    /**
     * Multi-stream video transcoding instances for resolutions up to 4K UHD, 1st generation
     */
    InstanceClass["VIDEO_TRANSCODING1"] = "vt1";
    /**
     * Multi-stream video transcoding instances for resolutions up to 4K UHD, 1st generation
     */
    InstanceClass["VT1"] = "vt1";
    /**
     * High performance computing based on AMD EPYC, 6th generation
     */
    InstanceClass["HIGH_PERFORMANCE_COMPUTING6_AMD"] = "hpc6a";
    /**
     * High performance computing based on AMD EPYC, 6th generation
     */
    InstanceClass["HPC6A"] = "hpc6a";
})(InstanceClass = exports.InstanceClass || (exports.InstanceClass = {}));
/**
 * Identifies an instance's CPU architecture
 */
var InstanceArchitecture;
(function (InstanceArchitecture) {
    /**
     * ARM64 architecture
     */
    InstanceArchitecture["ARM_64"] = "arm64";
    /**
     * x86-64 architecture
     */
    InstanceArchitecture["X86_64"] = "x86_64";
})(InstanceArchitecture = exports.InstanceArchitecture || (exports.InstanceArchitecture = {}));
/**
 * What size of instance to use
 */
var InstanceSize;
(function (InstanceSize) {
    /**
     * Instance size NANO (nano)
     */
    InstanceSize["NANO"] = "nano";
    /**
     * Instance size MICRO (micro)
     */
    InstanceSize["MICRO"] = "micro";
    /**
     * Instance size SMALL (small)
     */
    InstanceSize["SMALL"] = "small";
    /**
     * Instance size MEDIUM (medium)
     */
    InstanceSize["MEDIUM"] = "medium";
    /**
     * Instance size LARGE (large)
     */
    InstanceSize["LARGE"] = "large";
    /**
     * Instance size XLARGE (xlarge)
     */
    InstanceSize["XLARGE"] = "xlarge";
    /**
     * Instance size XLARGE2 (2xlarge)
     */
    InstanceSize["XLARGE2"] = "2xlarge";
    /**
     * Instance size XLARGE3 (3xlarge)
     */
    InstanceSize["XLARGE3"] = "3xlarge";
    /**
     * Instance size XLARGE4 (4xlarge)
     */
    InstanceSize["XLARGE4"] = "4xlarge";
    /**
     * Instance size XLARGE6 (6xlarge)
     */
    InstanceSize["XLARGE6"] = "6xlarge";
    /**
     * Instance size XLARGE8 (8xlarge)
     */
    InstanceSize["XLARGE8"] = "8xlarge";
    /**
     * Instance size XLARGE9 (9xlarge)
     */
    InstanceSize["XLARGE9"] = "9xlarge";
    /**
     * Instance size XLARGE10 (10xlarge)
     */
    InstanceSize["XLARGE10"] = "10xlarge";
    /**
     * Instance size XLARGE12 (12xlarge)
     */
    InstanceSize["XLARGE12"] = "12xlarge";
    /**
     * Instance size XLARGE16 (16xlarge)
     */
    InstanceSize["XLARGE16"] = "16xlarge";
    /**
     * Instance size XLARGE18 (18xlarge)
     */
    InstanceSize["XLARGE18"] = "18xlarge";
    /**
     * Instance size XLARGE24 (24xlarge)
     */
    InstanceSize["XLARGE24"] = "24xlarge";
    /**
     * Instance size XLARGE32 (32xlarge)
     */
    InstanceSize["XLARGE32"] = "32xlarge";
    /**
     * Instance size XLARGE48 (48xlarge)
     */
    InstanceSize["XLARGE48"] = "48xlarge";
    /**
     * Instance size XLARGE56 (56xlarge)
     */
    InstanceSize["XLARGE56"] = "56xlarge";
    /**
     * Instance size XLARGE56 (112xlarge)
     */
    InstanceSize["XLARGE112"] = "112xlarge";
    /**
     * Instance size METAL (metal)
     */
    InstanceSize["METAL"] = "metal";
})(InstanceSize = exports.InstanceSize || (exports.InstanceSize = {}));
/**
 * Instance type for EC2 instances
 *
 * This class takes a literal string, good if you already
 * know the identifier of the type you want.
 */
class InstanceType {
    constructor(instanceTypeIdentifier) {
        this.instanceTypeIdentifier = instanceTypeIdentifier;
    }
    /**
     * Instance type for EC2 instances
     *
     * This class takes a combination of a class and size.
     *
     * Be aware that not all combinations of class and size are available, and not all
     * classes are available in all regions.
     */
    static of(instanceClass, instanceSize) {
        jsiiDeprecationWarnings._aws_cdk_aws_ec2_InstanceClass(instanceClass);
        jsiiDeprecationWarnings._aws_cdk_aws_ec2_InstanceSize(instanceSize);
        return new InstanceType(`${instanceClass}.${instanceSize}`);
    }
    /**
     * Return the instance type as a dotted string
     */
    toString() {
        return this.instanceTypeIdentifier;
    }
    /**
     * The instance's CPU architecture
     */
    get architecture() {
        // capture the family, generation, capabilities, and size portions of the instance type id
        const instanceTypeComponents = this.instanceTypeIdentifier.match(/^([a-z]+)(\d{1,2})([a-z]*)\.([a-z0-9]+)$/);
        if (instanceTypeComponents == null) {
            throw new Error('Malformed instance type identifier');
        }
        const family = instanceTypeComponents[1];
        const capabilities = instanceTypeComponents[3];
        // Instance family `a` are first-gen Graviton instances
        // Capability `g` indicates the instance is Graviton2 powered
        if (family === 'a' || capabilities.includes('g')) {
            return InstanceArchitecture.ARM_64;
        }
        return InstanceArchitecture.X86_64;
    }
}
exports.InstanceType = InstanceType;
_a = JSII_RTTI_SYMBOL_1;
InstanceType[_a] = { fqn: "@aws-cdk/aws-ec2.InstanceType", version: "1.151.0" };
//# sourceMappingURL=data:application/json;base64,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