import * as cdk from '@aws-cdk/core';
import * as cfn_parse from '@aws-cdk/core/lib/cfn-parse';
/**
 * Properties for defining a `AWS::Athena::DataCatalog`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-datacatalog.html
 * @external
 */
export interface CfnDataCatalogProps {
    /**
     * `AWS::Athena::DataCatalog.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-datacatalog.html#cfn-athena-datacatalog-name
     * @external
     */
    readonly name: string;
    /**
     * `AWS::Athena::DataCatalog.Type`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-datacatalog.html#cfn-athena-datacatalog-type
     * @external
     */
    readonly type: string;
    /**
     * `AWS::Athena::DataCatalog.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-datacatalog.html#cfn-athena-datacatalog-description
     * @external
     */
    readonly description?: string;
    /**
     * `AWS::Athena::DataCatalog.Parameters`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-datacatalog.html#cfn-athena-datacatalog-parameters
     * @external
     */
    readonly parameters?: {
        [key: string]: (string);
    } | cdk.IResolvable;
    /**
     * `AWS::Athena::DataCatalog.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-datacatalog.html#cfn-athena-datacatalog-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::Athena::DataCatalog`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-datacatalog.html
 * @external
 * @cloudformationResource AWS::Athena::DataCatalog
 */
export declare class CfnDataCatalog extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Athena::DataCatalog";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnDataCatalog;
    /**
     * `AWS::Athena::DataCatalog.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-datacatalog.html#cfn-athena-datacatalog-name
     * @external
     */
    name: string;
    /**
     * `AWS::Athena::DataCatalog.Type`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-datacatalog.html#cfn-athena-datacatalog-type
     * @external
     */
    type: string;
    /**
     * `AWS::Athena::DataCatalog.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-datacatalog.html#cfn-athena-datacatalog-description
     * @external
     */
    description: string | undefined;
    /**
     * `AWS::Athena::DataCatalog.Parameters`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-datacatalog.html#cfn-athena-datacatalog-parameters
     * @external
     */
    parameters: {
        [key: string]: (string);
    } | cdk.IResolvable | undefined;
    /**
     * `AWS::Athena::DataCatalog.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-datacatalog.html#cfn-athena-datacatalog-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::Athena::DataCatalog`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnDataCatalogProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::Athena::NamedQuery`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-namedquery.html
 * @external
 */
export interface CfnNamedQueryProps {
    /**
     * `AWS::Athena::NamedQuery.Database`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-namedquery.html#cfn-athena-namedquery-database
     * @external
     */
    readonly database: string;
    /**
     * `AWS::Athena::NamedQuery.QueryString`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-namedquery.html#cfn-athena-namedquery-querystring
     * @external
     */
    readonly queryString: string;
    /**
     * `AWS::Athena::NamedQuery.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-namedquery.html#cfn-athena-namedquery-description
     * @external
     */
    readonly description?: string;
    /**
     * `AWS::Athena::NamedQuery.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-namedquery.html#cfn-athena-namedquery-name
     * @external
     */
    readonly name?: string;
    /**
     * `AWS::Athena::NamedQuery.WorkGroup`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-namedquery.html#cfn-athena-namedquery-workgroup
     * @external
     */
    readonly workGroup?: string;
}
/**
 * A CloudFormation `AWS::Athena::NamedQuery`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-namedquery.html
 * @external
 * @cloudformationResource AWS::Athena::NamedQuery
 */
export declare class CfnNamedQuery extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Athena::NamedQuery";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnNamedQuery;
    /**
     * @external
     * @cloudformationAttribute NamedQueryId
     */
    readonly attrNamedQueryId: string;
    /**
     * `AWS::Athena::NamedQuery.Database`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-namedquery.html#cfn-athena-namedquery-database
     * @external
     */
    database: string;
    /**
     * `AWS::Athena::NamedQuery.QueryString`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-namedquery.html#cfn-athena-namedquery-querystring
     * @external
     */
    queryString: string;
    /**
     * `AWS::Athena::NamedQuery.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-namedquery.html#cfn-athena-namedquery-description
     * @external
     */
    description: string | undefined;
    /**
     * `AWS::Athena::NamedQuery.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-namedquery.html#cfn-athena-namedquery-name
     * @external
     */
    name: string | undefined;
    /**
     * `AWS::Athena::NamedQuery.WorkGroup`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-namedquery.html#cfn-athena-namedquery-workgroup
     * @external
     */
    workGroup: string | undefined;
    /**
     * Create a new `AWS::Athena::NamedQuery`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnNamedQueryProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::Athena::WorkGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-workgroup.html
 * @external
 */
export interface CfnWorkGroupProps {
    /**
     * `AWS::Athena::WorkGroup.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-workgroup.html#cfn-athena-workgroup-name
     * @external
     */
    readonly name: string;
    /**
     * `AWS::Athena::WorkGroup.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-workgroup.html#cfn-athena-workgroup-description
     * @external
     */
    readonly description?: string;
    /**
     * `AWS::Athena::WorkGroup.RecursiveDeleteOption`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-workgroup.html#cfn-athena-workgroup-recursivedeleteoption
     * @external
     */
    readonly recursiveDeleteOption?: boolean | cdk.IResolvable;
    /**
     * `AWS::Athena::WorkGroup.State`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-workgroup.html#cfn-athena-workgroup-state
     * @external
     */
    readonly state?: string;
    /**
     * `AWS::Athena::WorkGroup.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-workgroup.html#cfn-athena-workgroup-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::Athena::WorkGroup.WorkGroupConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-workgroup.html#cfn-athena-workgroup-workgroupconfiguration
     * @external
     */
    readonly workGroupConfiguration?: CfnWorkGroup.WorkGroupConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::Athena::WorkGroup.WorkGroupConfigurationUpdates`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-workgroup.html#cfn-athena-workgroup-workgroupconfigurationupdates
     * @external
     */
    readonly workGroupConfigurationUpdates?: CfnWorkGroup.WorkGroupConfigurationUpdatesProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::Athena::WorkGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-workgroup.html
 * @external
 * @cloudformationResource AWS::Athena::WorkGroup
 */
export declare class CfnWorkGroup extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Athena::WorkGroup";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnWorkGroup;
    /**
     * @external
     * @cloudformationAttribute CreationTime
     */
    readonly attrCreationTime: string;
    /**
     * `AWS::Athena::WorkGroup.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-workgroup.html#cfn-athena-workgroup-name
     * @external
     */
    name: string;
    /**
     * `AWS::Athena::WorkGroup.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-workgroup.html#cfn-athena-workgroup-description
     * @external
     */
    description: string | undefined;
    /**
     * `AWS::Athena::WorkGroup.RecursiveDeleteOption`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-workgroup.html#cfn-athena-workgroup-recursivedeleteoption
     * @external
     */
    recursiveDeleteOption: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::Athena::WorkGroup.State`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-workgroup.html#cfn-athena-workgroup-state
     * @external
     */
    state: string | undefined;
    /**
     * `AWS::Athena::WorkGroup.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-workgroup.html#cfn-athena-workgroup-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::Athena::WorkGroup.WorkGroupConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-workgroup.html#cfn-athena-workgroup-workgroupconfiguration
     * @external
     */
    workGroupConfiguration: CfnWorkGroup.WorkGroupConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Athena::WorkGroup.WorkGroupConfigurationUpdates`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-workgroup.html#cfn-athena-workgroup-workgroupconfigurationupdates
     * @external
     */
    workGroupConfigurationUpdates: CfnWorkGroup.WorkGroupConfigurationUpdatesProperty | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::Athena::WorkGroup`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnWorkGroupProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Athena::WorkGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-workgroup.html
 * @external
 * @cloudformationResource AWS::Athena::WorkGroup
 */
export declare namespace CfnWorkGroup {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-encryptionconfiguration.html
     * @external
     */
    interface EncryptionConfigurationProperty {
        /**
         * `CfnWorkGroup.EncryptionConfigurationProperty.EncryptionOption`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-encryptionconfiguration.html#cfn-athena-workgroup-encryptionconfiguration-encryptionoption
         * @external
         */
        readonly encryptionOption: string;
        /**
         * `CfnWorkGroup.EncryptionConfigurationProperty.KmsKey`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-encryptionconfiguration.html#cfn-athena-workgroup-encryptionconfiguration-kmskey
         * @external
         */
        readonly kmsKey?: string;
    }
}
/**
 * A CloudFormation `AWS::Athena::WorkGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-workgroup.html
 * @external
 * @cloudformationResource AWS::Athena::WorkGroup
 */
export declare namespace CfnWorkGroup {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-resultconfiguration.html
     * @external
     */
    interface ResultConfigurationProperty {
        /**
         * `CfnWorkGroup.ResultConfigurationProperty.EncryptionConfiguration`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-resultconfiguration.html#cfn-athena-workgroup-resultconfiguration-encryptionconfiguration
         * @external
         */
        readonly encryptionConfiguration?: CfnWorkGroup.EncryptionConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnWorkGroup.ResultConfigurationProperty.OutputLocation`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-resultconfiguration.html#cfn-athena-workgroup-resultconfiguration-outputlocation
         * @external
         */
        readonly outputLocation?: string;
    }
}
/**
 * A CloudFormation `AWS::Athena::WorkGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-workgroup.html
 * @external
 * @cloudformationResource AWS::Athena::WorkGroup
 */
export declare namespace CfnWorkGroup {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-resultconfigurationupdates.html
     * @external
     */
    interface ResultConfigurationUpdatesProperty {
        /**
         * `CfnWorkGroup.ResultConfigurationUpdatesProperty.EncryptionConfiguration`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-resultconfigurationupdates.html#cfn-athena-workgroup-resultconfigurationupdates-encryptionconfiguration
         * @external
         */
        readonly encryptionConfiguration?: CfnWorkGroup.EncryptionConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnWorkGroup.ResultConfigurationUpdatesProperty.OutputLocation`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-resultconfigurationupdates.html#cfn-athena-workgroup-resultconfigurationupdates-outputlocation
         * @external
         */
        readonly outputLocation?: string;
        /**
         * `CfnWorkGroup.ResultConfigurationUpdatesProperty.RemoveEncryptionConfiguration`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-resultconfigurationupdates.html#cfn-athena-workgroup-resultconfigurationupdates-removeencryptionconfiguration
         * @external
         */
        readonly removeEncryptionConfiguration?: boolean | cdk.IResolvable;
        /**
         * `CfnWorkGroup.ResultConfigurationUpdatesProperty.RemoveOutputLocation`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-resultconfigurationupdates.html#cfn-athena-workgroup-resultconfigurationupdates-removeoutputlocation
         * @external
         */
        readonly removeOutputLocation?: boolean | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Athena::WorkGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-workgroup.html
 * @external
 * @cloudformationResource AWS::Athena::WorkGroup
 */
export declare namespace CfnWorkGroup {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-workgroupconfiguration.html
     * @external
     */
    interface WorkGroupConfigurationProperty {
        /**
         * `CfnWorkGroup.WorkGroupConfigurationProperty.BytesScannedCutoffPerQuery`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-workgroupconfiguration.html#cfn-athena-workgroup-workgroupconfiguration-bytesscannedcutoffperquery
         * @external
         */
        readonly bytesScannedCutoffPerQuery?: number;
        /**
         * `CfnWorkGroup.WorkGroupConfigurationProperty.EnforceWorkGroupConfiguration`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-workgroupconfiguration.html#cfn-athena-workgroup-workgroupconfiguration-enforceworkgroupconfiguration
         * @external
         */
        readonly enforceWorkGroupConfiguration?: boolean | cdk.IResolvable;
        /**
         * `CfnWorkGroup.WorkGroupConfigurationProperty.PublishCloudWatchMetricsEnabled`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-workgroupconfiguration.html#cfn-athena-workgroup-workgroupconfiguration-publishcloudwatchmetricsenabled
         * @external
         */
        readonly publishCloudWatchMetricsEnabled?: boolean | cdk.IResolvable;
        /**
         * `CfnWorkGroup.WorkGroupConfigurationProperty.RequesterPaysEnabled`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-workgroupconfiguration.html#cfn-athena-workgroup-workgroupconfiguration-requesterpaysenabled
         * @external
         */
        readonly requesterPaysEnabled?: boolean | cdk.IResolvable;
        /**
         * `CfnWorkGroup.WorkGroupConfigurationProperty.ResultConfiguration`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-workgroupconfiguration.html#cfn-athena-workgroup-workgroupconfiguration-resultconfiguration
         * @external
         */
        readonly resultConfiguration?: CfnWorkGroup.ResultConfigurationProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Athena::WorkGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-workgroup.html
 * @external
 * @cloudformationResource AWS::Athena::WorkGroup
 */
export declare namespace CfnWorkGroup {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-workgroupconfigurationupdates.html
     * @external
     */
    interface WorkGroupConfigurationUpdatesProperty {
        /**
         * `CfnWorkGroup.WorkGroupConfigurationUpdatesProperty.BytesScannedCutoffPerQuery`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-workgroupconfigurationupdates.html#cfn-athena-workgroup-workgroupconfigurationupdates-bytesscannedcutoffperquery
         * @external
         */
        readonly bytesScannedCutoffPerQuery?: number;
        /**
         * `CfnWorkGroup.WorkGroupConfigurationUpdatesProperty.EnforceWorkGroupConfiguration`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-workgroupconfigurationupdates.html#cfn-athena-workgroup-workgroupconfigurationupdates-enforceworkgroupconfiguration
         * @external
         */
        readonly enforceWorkGroupConfiguration?: boolean | cdk.IResolvable;
        /**
         * `CfnWorkGroup.WorkGroupConfigurationUpdatesProperty.PublishCloudWatchMetricsEnabled`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-workgroupconfigurationupdates.html#cfn-athena-workgroup-workgroupconfigurationupdates-publishcloudwatchmetricsenabled
         * @external
         */
        readonly publishCloudWatchMetricsEnabled?: boolean | cdk.IResolvable;
        /**
         * `CfnWorkGroup.WorkGroupConfigurationUpdatesProperty.RemoveBytesScannedCutoffPerQuery`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-workgroupconfigurationupdates.html#cfn-athena-workgroup-workgroupconfigurationupdates-removebytesscannedcutoffperquery
         * @external
         */
        readonly removeBytesScannedCutoffPerQuery?: boolean | cdk.IResolvable;
        /**
         * `CfnWorkGroup.WorkGroupConfigurationUpdatesProperty.RequesterPaysEnabled`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-workgroupconfigurationupdates.html#cfn-athena-workgroup-workgroupconfigurationupdates-requesterpaysenabled
         * @external
         */
        readonly requesterPaysEnabled?: boolean | cdk.IResolvable;
        /**
         * `CfnWorkGroup.WorkGroupConfigurationUpdatesProperty.ResultConfigurationUpdates`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-workgroupconfigurationupdates.html#cfn-athena-workgroup-workgroupconfigurationupdates-resultconfigurationupdates
         * @external
         */
        readonly resultConfigurationUpdates?: CfnWorkGroup.ResultConfigurationUpdatesProperty | cdk.IResolvable;
    }
}
